/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.spi.v2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.api.services.translate.Translate;
import com.google.api.services.translate.model.DetectionsListResponse;
import com.google.api.services.translate.model.DetectionsResourceItems;
import com.google.api.services.translate.model.LanguagesListResponse;
import com.google.api.services.translate.model.LanguagesResource;
import com.google.api.services.translate.model.TranslationsListResponse;
import com.google.api.services.translate.model.TranslationsResource;
import com.google.cloud.ServiceOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.translate.TranslateException;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.spi.v2.TranslateRpc;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class HttpTranslateRpc
implements TranslateRpc {
    private final TranslateOptions options;
    private final Translate translate;

    public HttpTranslateRpc(TranslateOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer((ServiceOptions)options);
        this.options = options;
        this.translate = new Translate.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.getHost()).setApplicationName(options.getApplicationName()).build();
    }

    private static TranslateException translate(IOException exception) {
        return new TranslateException(exception);
    }

    private GenericUrl buildTargetUrl(String path) {
        GenericUrl genericUrl = new GenericUrl(this.translate.getBaseUrl() + "v2/" + path);
        if (this.options.getApiKey() != null) {
            genericUrl.put("key", (Object)this.options.getApiKey());
        }
        return genericUrl;
    }

    @Override
    public List<List<DetectionsResourceItems>> detect(List<String> texts) {
        try {
            ImmutableMap content = ImmutableMap.of((Object)"q", texts);
            HttpRequest httpRequest = this.translate.getRequestFactory().buildPostRequest(this.buildTargetUrl("detect"), (HttpContent)new JsonHttpContent(this.translate.getJsonFactory(), (Object)content)).setParser((ObjectParser)this.translate.getObjectParser());
            List detections = ((DetectionsListResponse)httpRequest.execute().parseAs(DetectionsListResponse.class)).getDetections();
            return detections != null ? detections : ImmutableList.of();
        }
        catch (IOException ex) {
            throw HttpTranslateRpc.translate(ex);
        }
    }

    @Override
    public List<LanguagesResource> listSupportedLanguages(Map<TranslateRpc.Option, ?> optionMap) {
        try {
            ImmutableMap content = ImmutableMap.of((Object)"target", (Object)MoreObjects.firstNonNull((Object)TranslateRpc.Option.TARGET_LANGUAGE.getString(optionMap), (Object)this.options.getTargetLanguage()));
            HttpRequest httpRequest = this.translate.getRequestFactory().buildPostRequest(this.buildTargetUrl("languages"), (HttpContent)new JsonHttpContent(this.translate.getJsonFactory(), (Object)content)).setParser((ObjectParser)this.translate.getObjectParser());
            List languages = ((LanguagesListResponse)httpRequest.execute().parseAs(LanguagesListResponse.class)).getLanguages();
            return languages != null ? languages : ImmutableList.of();
        }
        catch (IOException ex) {
            throw HttpTranslateRpc.translate(ex);
        }
    }

    @Override
    public List<TranslationsResource> translate(List<String> texts, Map<TranslateRpc.Option, ?> optionMap) {
        try {
            String targetLanguage = (String)MoreObjects.firstNonNull((Object)TranslateRpc.Option.TARGET_LANGUAGE.getString(optionMap), (Object)this.options.getTargetLanguage());
            final String sourceLanguage = TranslateRpc.Option.SOURCE_LANGUAGE.getString(optionMap);
            List translations = ((TranslationsListResponse)this.translate.translations().list(texts, targetLanguage).setSource(sourceLanguage).setKey(this.options.getApiKey()).set("model", (Object)TranslateRpc.Option.MODEL.getString(optionMap)).setFormat(TranslateRpc.Option.FORMAT.getString(optionMap)).execute()).getTranslations();
            return Lists.transform((List)(translations != null ? translations : ImmutableList.of()), (Function)new Function<TranslationsResource, TranslationsResource>(){

                public TranslationsResource apply(TranslationsResource translationsResource) {
                    if (translationsResource.getDetectedSourceLanguage() == null) {
                        translationsResource.setDetectedSourceLanguage(sourceLanguage);
                    }
                    return translationsResource;
                }
            });
        }
        catch (IOException ex) {
            throw HttpTranslateRpc.translate(ex);
        }
    }
}

