/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.api.services.translate.model.LanguagesResource;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public class Language
implements Serializable {
    private static final long serialVersionUID = 5205240279371907020L;
    static final Function<LanguagesResource, Language> FROM_PB_FUNCTION = new Function<LanguagesResource, Language>(){

        public Language apply(LanguagesResource languagePb) {
            return Language.fromPb(languagePb);
        }
    };
    private final String code;
    private final String name;

    private Language(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String code() {
        return this.code;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("name", (Object)this.name).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.code, this.name);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Language.class)) {
            return false;
        }
        Language other = (Language)obj;
        return Objects.equals(this.code, other.code) && Objects.equals(this.name, other.name);
    }

    static Language fromPb(LanguagesResource languagePb) {
        return new Language(languagePb.getLanguage(), languagePb.getName());
    }
}

