/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.testing;

import com.google.api.gax.core.RetrySettings;
import com.google.cloud.HttpTransportOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.translate.TranslateOptions;
import org.joda.time.Duration;

public class RemoteTranslateHelper {
    private final TranslateOptions options;

    private RemoteTranslateHelper(TranslateOptions options) {
        this.options = options;
    }

    public TranslateOptions getOptions() {
        return this.options;
    }

    public static RemoteTranslateHelper create(String apiKey) {
        HttpTransportOptions transportOptions = TranslateOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        TranslateOptions translateOptions = ((TranslateOptions.Builder)TranslateOptions.newBuilder().setApiKey(apiKey).setRetrySettings(RemoteTranslateHelper.retryParams())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteTranslateHelper(translateOptions);
    }

    public static RemoteTranslateHelper create() {
        HttpTransportOptions transportOptions = TranslateOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        TranslateOptions translateOption = ((TranslateOptions.Builder)TranslateOptions.newBuilder().setRetrySettings(RemoteTranslateHelper.retryParams())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteTranslateHelper(translateOption);
    }

    private static RetrySettings retryParams() {
        return RetrySettings.newBuilder().setMaxAttempts(10).setMaxRetryDelay(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)120000L)).setInitialRetryDelay(Duration.millis((long)250L)).setRetryDelayMultiplier(1.0).setInitialRpcTimeout(Duration.millis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)120000L)).build();
    }
}

