/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.trace.v2.stub.GrpcTraceServiceCallableFactory;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.cloud.trace.v2.stub.TraceServiceStubSettings;
import com.google.devtools.cloudtrace.v2.BatchWriteSpansRequest;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTraceServiceStub
extends TraceServiceStub {
    private static final MethodDescriptor<BatchWriteSpansRequest, Empty> batchWriteSpansMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudtrace.v2.TraceService/BatchWriteSpans").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchWriteSpansRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<Span, Span> createSpanMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudtrace.v2.TraceService/CreateSpan").setRequestMarshaller(ProtoUtils.marshaller((Message)Span.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Span.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<BatchWriteSpansRequest, Empty> batchWriteSpansCallable;
    private final UnaryCallable<Span, Span> createSpanCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTraceServiceStub create(TraceServiceStubSettings settings) throws IOException {
        return new GrpcTraceServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTraceServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTraceServiceStub(TraceServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTraceServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTraceServiceStub(TraceServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTraceServiceStub(TraceServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTraceServiceCallableFactory());
    }

    protected GrpcTraceServiceStub(TraceServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings batchWriteSpansTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchWriteSpansMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createSpanTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSpanMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.batchWriteSpansCallable = callableFactory.createUnaryCallable(batchWriteSpansTransportSettings, settings.batchWriteSpansSettings(), clientContext);
        this.createSpanCallable = callableFactory.createUnaryCallable(createSpanTransportSettings, settings.createSpanSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<BatchWriteSpansRequest, Empty> batchWriteSpansCallable() {
        return this.batchWriteSpansCallable;
    }

    @Override
    public UnaryCallable<Span, Span> createSpanCallable() {
        return this.createSpanCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

