/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.trace.v1.TraceServiceClient;
import com.google.cloud.trace.v1.stub.GrpcTraceServiceStub;
import com.google.cloud.trace.v1.stub.TraceServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TraceServiceStubSettings
extends StubSettings<TraceServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/trace.append").add((Object)"https://www.googleapis.com/auth/trace.readonly").build();
    private final PagedCallSettings<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings;
    private final UnaryCallSettings<GetTraceRequest, Trace> getTraceSettings;
    private final UnaryCallSettings<PatchTracesRequest, Empty> patchTracesSettings;
    private static final PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace> LIST_TRACES_PAGE_STR_DESC = new PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace>(){

        public String emptyToken() {
            return "";
        }

        public ListTracesRequest injectToken(ListTracesRequest payload, String token) {
            return ListTracesRequest.newBuilder((ListTracesRequest)payload).setPageToken(token).build();
        }

        public ListTracesRequest injectPageSize(ListTracesRequest payload, int pageSize) {
            return ListTracesRequest.newBuilder((ListTracesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTracesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTracesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Trace> extractResources(ListTracesResponse payload) {
            return payload.getTracesList() == null ? ImmutableList.of() : payload.getTracesList();
        }
    };
    private static final PagedListResponseFactory<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> LIST_TRACES_PAGE_STR_FACT = new PagedListResponseFactory<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse>(){

        public ApiFuture<TraceServiceClient.ListTracesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTracesRequest, ListTracesResponse> callable, ListTracesRequest request, ApiCallContext context, ApiFuture<ListTracesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRACES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TraceServiceClient.ListTracesPagedResponse.createAsync((PageContext<ListTracesRequest, ListTracesResponse, Trace>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings() {
        return this.listTracesSettings;
    }

    public UnaryCallSettings<GetTraceRequest, Trace> getTraceSettings() {
        return this.getTraceSettings;
    }

    public UnaryCallSettings<PatchTracesRequest, Empty> patchTracesSettings() {
        return this.patchTracesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TraceServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTraceServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudtrace.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TraceServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TraceServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TraceServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listTracesSettings = settingsBuilder.listTracesSettings().build();
        this.getTraceSettings = settingsBuilder.getTraceSettings().build();
        this.patchTracesSettings = settingsBuilder.patchTracesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TraceServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings;
        private final UnaryCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings;
        private final UnaryCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listTracesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRACES_PAGE_STR_FACT);
            this.getTraceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchTracesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTracesSettings, this.getTraceSettings, this.patchTracesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TraceServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listTracesSettings = settings.listTracesSettings.toBuilder();
            this.getTraceSettings = settings.getTraceSettings.toBuilder();
            this.patchTracesSettings = settings.patchTracesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTracesSettings, this.getTraceSettings, this.patchTracesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TraceServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TraceServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TraceServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TraceServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTraceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings() {
            return this.listTracesSettings;
        }

        public UnaryCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings() {
            return this.getTraceSettings;
        }

        public UnaryCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings() {
            return this.patchTracesSettings;
        }

        public TraceServiceStubSettings build() throws IOException {
            return new TraceServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)45000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)45000L)).setTotalTimeout(Duration.ofMillis((long)45000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

