/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.spi.v1;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ApiCallSettings;
import com.google.api.gax.grpc.PageStreamingCallSettings;
import com.google.api.gax.grpc.PageStreamingDescriptor;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.TraceServiceGrpc;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class TraceServiceSettings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "cloudtrace.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/trace.append").add((Object)"https://www.googleapis.com/auth/trace.readonly").build();
    public static final ConnectionSettings DEFAULT_CONNECTION_SETTINGS = ConnectionSettings.newBuilder().setServiceAddress("cloudtrace.googleapis.com").setPort(443).provideCredentialsWith(DEFAULT_SERVICE_SCOPES).build();
    private final SimpleCallSettings<PatchTracesRequest, Empty> patchTracesSettings;
    private final SimpleCallSettings<GetTraceRequest, Trace> getTraceSettings;
    private final PageStreamingCallSettings<ListTracesRequest, ListTracesResponse, Trace> listTracesSettings;
    private static PageStreamingDescriptor<ListTracesRequest, ListTracesResponse, Trace> LIST_TRACES_PAGE_STR_DESC = new PageStreamingDescriptor<ListTracesRequest, ListTracesResponse, Trace>(){

        public Object emptyToken() {
            return "";
        }

        public ListTracesRequest injectToken(ListTracesRequest payload, Object token) {
            return ListTracesRequest.newBuilder((ListTracesRequest)payload).setPageToken((String)token).build();
        }

        public Object extractNextToken(ListTracesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Trace> extractResources(ListTracesResponse payload) {
            return payload.getTracesList();
        }
    };

    public SimpleCallSettings<PatchTracesRequest, Empty> patchTracesSettings() {
        return this.patchTracesSettings;
    }

    public SimpleCallSettings<GetTraceRequest, Trace> getTraceSettings() {
        return this.getTraceSettings;
    }

    public PageStreamingCallSettings<ListTracesRequest, ListTracesResponse, Trace> listTracesSettings() {
        return this.listTracesSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TraceServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.patchTracesSettings = settingsBuilder.patchTracesSettings().build();
        this.getTraceSettings = settingsBuilder.getTraceSettings().build();
        this.listTracesSettings = settingsBuilder.listTracesSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<ApiCallSettings.Builder> methodSettingsBuilders;
        private SimpleCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings;
        private SimpleCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings;
        private PageStreamingCallSettings.Builder<ListTracesRequest, ListTracesResponse, Trace> listTracesSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(DEFAULT_CONNECTION_SETTINGS);
            this.patchTracesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)TraceServiceGrpc.METHOD_PATCH_TRACES);
            this.getTraceSettings = SimpleCallSettings.newBuilder((MethodDescriptor)TraceServiceGrpc.METHOD_GET_TRACE);
            this.listTracesSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)TraceServiceGrpc.METHOD_LIST_TRACES, (PageStreamingDescriptor)LIST_TRACES_PAGE_STR_DESC);
            this.methodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.patchTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTraceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(TraceServiceSettings settings) {
            super((ServiceApiSettings)settings);
            this.patchTracesSettings = settings.patchTracesSettings.toBuilder();
            this.getTraceSettings = settings.getTraceSettings.toBuilder();
            this.listTracesSettings = settings.listTracesSettings.toBuilder();
            this.methodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
        }

        protected ConnectionSettings getDefaultConnectionSettings() {
            return DEFAULT_CONNECTION_SETTINGS;
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(ApiCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.methodSettingsBuilders, apiCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings() {
            return this.patchTracesSettings;
        }

        public SimpleCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings() {
            return this.getTraceSettings;
        }

        public PageStreamingCallSettings.Builder<ListTracesRequest, ListTracesResponse, Trace> listTracesSettings() {
            return this.listTracesSettings;
        }

        public TraceServiceSettings build() throws IOException {
            return new TraceServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

