/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.GrpcTransportProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.trace.v1.PagedResponseWrappers;
import com.google.cloud.trace.v1.stub.GrpcTraceServiceStub;
import com.google.cloud.trace.v1.stub.TraceServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.protobuf.Empty;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TraceServiceSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/trace.append").add((Object)"https://www.googleapis.com/auth/trace.readonly").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/trace/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final SimpleCallSettings<PatchTracesRequest, Empty> patchTracesSettings;
    private final SimpleCallSettings<GetTraceRequest, Trace> getTraceSettings;
    private final PagedCallSettings<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings;
    private static final PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace> LIST_TRACES_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> LIST_TRACES_PAGE_STR_FACT;

    public SimpleCallSettings<PatchTracesRequest, Empty> patchTracesSettings() {
        return this.patchTracesSettings;
    }

    public SimpleCallSettings<GetTraceRequest, Trace> getTraceSettings() {
        return this.getTraceSettings;
    }

    public PagedCallSettings<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings() {
        return this.listTracesSettings;
    }

    public TraceServiceStub createStub() throws IOException {
        if (this.getTransportProvider().getTransportName().equals(GrpcTransport.getGrpcTransportName())) {
            return GrpcTraceServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudtrace.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultGrpcChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(TraceServiceSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, TraceServiceSettings.getGapicVersion());
    }

    public static GrpcTransportProvider.Builder defaultGrpcTransportProviderBuilder() {
        return GrpcTransportProvider.newBuilder().setChannelProvider((ChannelProvider)TraceServiceSettings.defaultGrpcChannelProviderBuilder().build());
    }

    public static TransportProvider defaultTransportProvider() {
        return TraceServiceSettings.defaultGrpcTransportProviderBuilder().build();
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(TraceServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    @Deprecated
    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    @Deprecated
    public static Builder defaultBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TraceServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getTransportProvider(), settingsBuilder.getCredentialsProvider(), settingsBuilder.getClock());
        this.patchTracesSettings = settingsBuilder.patchTracesSettings().build();
        this.getTraceSettings = settingsBuilder.getTraceSettings().build();
        this.listTracesSettings = settingsBuilder.listTracesSettings().build();
    }

    static {
        LIST_TRACES_PAGE_STR_DESC = new PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace>(){

            public String emptyToken() {
                return TraceServiceSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListTracesRequest injectToken(ListTracesRequest payload, String token) {
                return ListTracesRequest.newBuilder((ListTracesRequest)payload).setPageToken(token).build();
            }

            public ListTracesRequest injectPageSize(ListTracesRequest payload, int pageSize) {
                throw new UnsupportedOperationException("page size is not supported by this API method");
            }

            public Integer extractPageSize(ListTracesRequest payload) {
                throw new UnsupportedOperationException("page size is not supported by this API method");
            }

            public String extractNextToken(ListTracesResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<Trace> extractResources(ListTracesResponse payload) {
                return payload.getTracesList();
            }
        };
        LIST_TRACES_PAGE_STR_FACT = new PagedListResponseFactory<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListTracesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTracesRequest, ListTracesResponse> callable, ListTracesRequest request, ApiCallContext context, ApiFuture<ListTracesResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRACES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListTracesPagedResponse.createAsync((PageContext<ListTracesRequest, ListTracesResponse, Trace>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings;
        private final SimpleCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings;
        private final PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.patchTracesSettings = SimpleCallSettings.newBuilder();
            this.getTraceSettings = SimpleCallSettings.newBuilder();
            this.listTracesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRACES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportProvider(TraceServiceSettings.defaultTransportProvider());
            builder.setCredentialsProvider((CredentialsProvider)TraceServiceSettings.defaultCredentialsProviderBuilder().build());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.patchTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTraceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(TraceServiceSettings settings) {
            super((ClientSettings)settings);
            this.patchTracesSettings = settings.patchTracesSettings.toBuilder();
            this.getTraceSettings = settings.getTraceSettings.toBuilder();
            this.listTracesSettings = settings.listTracesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setTransportProvider(TransportProvider transportProvider) {
            super.setTransportProvider(transportProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder, Void> settingsUpdater) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public SimpleCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings() {
            return this.patchTracesSettings;
        }

        public SimpleCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings() {
            return this.getTraceSettings;
        }

        public PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings() {
            return this.listTracesSettings;
        }

        public TraceServiceSettings build() throws IOException {
            return new TraceServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode[]{GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE)})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)45000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

