/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.trace.v1.PagedResponseWrappers;
import com.google.cloud.trace.v1.TraceServiceSettings;
import com.google.cloud.trace.v1.stub.TraceServiceStub;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.Traces;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TraceServiceClient
implements BackgroundResource {
    private final TraceServiceSettings settings;
    private final TraceServiceStub stub;

    public static final TraceServiceClient create() throws IOException {
        return TraceServiceClient.create(TraceServiceSettings.newBuilder().build());
    }

    public static final TraceServiceClient create(TraceServiceSettings settings) throws IOException {
        return new TraceServiceClient(settings);
    }

    public static final TraceServiceClient create(TraceServiceStub stub) {
        return new TraceServiceClient(stub);
    }

    protected TraceServiceClient(TraceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    protected TraceServiceClient(TraceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TraceServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi
    public TraceServiceStub getStub() {
        return this.stub;
    }

    public final void patchTraces(String projectId, Traces traces) {
        PatchTracesRequest request = PatchTracesRequest.newBuilder().setProjectId(projectId).setTraces(traces).build();
        this.patchTraces(request);
    }

    public final void patchTraces(PatchTracesRequest request) {
        this.patchTracesCallable().call((Object)request);
    }

    public final UnaryCallable<PatchTracesRequest, Empty> patchTracesCallable() {
        return this.stub.patchTracesCallable();
    }

    public final Trace getTrace(String projectId, String traceId) {
        GetTraceRequest request = GetTraceRequest.newBuilder().setProjectId(projectId).setTraceId(traceId).build();
        return this.getTrace(request);
    }

    private final Trace getTrace(GetTraceRequest request) {
        return (Trace)this.getTraceCallable().call((Object)request);
    }

    public final UnaryCallable<GetTraceRequest, Trace> getTraceCallable() {
        return this.stub.getTraceCallable();
    }

    public final PagedResponseWrappers.ListTracesPagedResponse listTraces(String projectId) {
        ListTracesRequest request = ListTracesRequest.newBuilder().setProjectId(projectId).build();
        return this.listTraces(request);
    }

    public final PagedResponseWrappers.ListTracesPagedResponse listTraces(ListTracesRequest request) {
        return (PagedResponseWrappers.ListTracesPagedResponse)((Object)this.listTracesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTracesRequest, PagedResponseWrappers.ListTracesPagedResponse> listTracesPagedCallable() {
        return this.stub.listTracesPagedCallable();
    }

    public final UnaryCallable<ListTracesRequest, ListTracesResponse> listTracesCallable() {
        return this.stub.listTracesCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

