/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.spi.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PageContext;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.trace.spi.v1.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.joda.time.Duration;

public class TraceServiceSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/trace.append").add((Object)"https://www.googleapis.com/auth/trace.readonly").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/trace/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private static final MethodDescriptor<PatchTracesRequest, Empty> METHOD_PATCH_TRACES;
    private static final MethodDescriptor<GetTraceRequest, Trace> METHOD_GET_TRACE;
    private static final MethodDescriptor<ListTracesRequest, ListTracesResponse> METHOD_LIST_TRACES;
    private final SimpleCallSettings<PatchTracesRequest, Empty> patchTracesSettings;
    private final SimpleCallSettings<GetTraceRequest, Trace> getTraceSettings;
    private final PagedCallSettings<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings;
    private static final PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace> LIST_TRACES_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> LIST_TRACES_PAGE_STR_FACT;

    public SimpleCallSettings<PatchTracesRequest, Empty> patchTracesSettings() {
        return this.patchTracesSettings;
    }

    public SimpleCallSettings<GetTraceRequest, Trace> getTraceSettings() {
        return this.getTraceSettings;
    }

    public PagedCallSettings<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings() {
        return this.listTracesSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudtrace.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(TraceServiceSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, TraceServiceSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)TraceServiceSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(TraceServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TraceServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.patchTracesSettings = settingsBuilder.patchTracesSettings().build();
        this.getTraceSettings = settingsBuilder.getTraceSettings().build();
        this.listTracesSettings = settingsBuilder.listTracesSettings().build();
    }

    static {
        METHOD_PATCH_TRACES = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.devtools.cloudtrace.v1.TraceService/PatchTraces", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)PatchTracesRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_GET_TRACE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.devtools.cloudtrace.v1.TraceService/GetTrace", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetTraceRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Trace.getDefaultInstance()));
        METHOD_LIST_TRACES = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.devtools.cloudtrace.v1.TraceService/ListTraces", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListTracesRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListTracesResponse.getDefaultInstance()));
        LIST_TRACES_PAGE_STR_DESC = new PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace>(){

            public String emptyToken() {
                return TraceServiceSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListTracesRequest injectToken(ListTracesRequest payload, String token) {
                return ListTracesRequest.newBuilder((ListTracesRequest)payload).setPageToken(token).build();
            }

            public ListTracesRequest injectPageSize(ListTracesRequest payload, int pageSize) {
                throw new UnsupportedOperationException("page size is not supported by this API method");
            }

            public Integer extractPageSize(ListTracesRequest payload) {
                throw new UnsupportedOperationException("page size is not supported by this API method");
            }

            public String extractNextToken(ListTracesResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<Trace> extractResources(ListTracesResponse payload) {
                return payload.getTracesList();
            }
        };
        LIST_TRACES_PAGE_STR_FACT = new PagedListResponseFactory<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListTracesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTracesRequest, ListTracesResponse> callable, ListTracesRequest request, CallContext context, ApiFuture<ListTracesResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRACES_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListTracesPagedResponse.createAsync((PageContext<ListTracesRequest, ListTracesResponse, Trace>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings;
        private final SimpleCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings;
        private final PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(TraceServiceSettings.defaultChannelProviderBuilder().build());
            this.patchTracesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_PATCH_TRACES);
            this.getTraceSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_GET_TRACE);
            this.listTracesSettings = PagedCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_TRACES, (PagedListResponseFactory)LIST_TRACES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.patchTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTraceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(TraceServiceSettings settings) {
            super((ClientSettings)settings);
            this.patchTracesSettings = settings.patchTracesSettings.toBuilder();
            this.getTraceSettings = settings.getTraceSettings.toBuilder();
            this.listTracesSettings = settings.listTracesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings() {
            return this.patchTracesSettings;
        }

        public SimpleCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings() {
            return this.getTraceSettings;
        }

        public PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings() {
            return this.listTracesSettings;
        }

        public TraceServiceSettings build() throws IOException {
            return new TraceServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

