/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.spi.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.trace.spi.v1.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.TraceServiceGrpc;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;
import org.joda.time.Duration;

public class TraceServiceSettings
extends ClientSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "cloudtrace.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/trace.append").add((Object)"https://www.googleapis.com/auth/trace.readonly").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private final SimpleCallSettings<PatchTracesRequest, Empty> patchTracesSettings;
    private final SimpleCallSettings<GetTraceRequest, Trace> getTraceSettings;
    private final PagedCallSettings<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings;
    private static final PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace> LIST_TRACES_PAGE_STR_DESC = new PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace>(){

        public Object emptyToken() {
            return TraceServiceSettings.DEFAULT_GAPIC_VERSION;
        }

        public ListTracesRequest injectToken(ListTracesRequest payload, Object token) {
            return ListTracesRequest.newBuilder((ListTracesRequest)payload).setPageToken((String)token).build();
        }

        public ListTracesRequest injectPageSize(ListTracesRequest payload, int pageSize) {
            throw new UnsupportedOperationException("page size is not supported by this API method");
        }

        public Integer extractPageSize(ListTracesRequest payload) {
            throw new UnsupportedOperationException("page size is not supported by this API method");
        }

        public Object extractNextToken(ListTracesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Trace> extractResources(ListTracesResponse payload) {
            return payload.getTracesList();
        }
    };
    private static final PagedListResponseFactory<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> LIST_TRACES_PAGE_STR_FACT = new PagedListResponseFactory<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse>(){

        public PagedResponseWrappers.ListTracesPagedResponse createPagedListResponse(UnaryCallable<ListTracesRequest, ListTracesResponse> callable, ListTracesRequest request, CallContext context) {
            return new PagedResponseWrappers.ListTracesPagedResponse(callable, (PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace>)LIST_TRACES_PAGE_STR_DESC, request, context);
        }
    };

    public SimpleCallSettings<PatchTracesRequest, Empty> patchTracesSettings() {
        return this.patchTracesSettings;
    }

    public SimpleCallSettings<GetTraceRequest, Trace> getTraceSettings() {
        return this.getTraceSettings;
    }

    public PagedCallSettings<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings() {
        return this.listTracesSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setServiceAddress(DEFAULT_SERVICE_ADDRESS).setPort(443).setGeneratorHeader(DEFAULT_GAPIC_NAME, TraceServiceSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)TraceServiceSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        String packageVersion = TraceServiceSettings.class.getPackage().getImplementationVersion();
        return packageVersion != null ? packageVersion : DEFAULT_GAPIC_VERSION;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TraceServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.patchTracesSettings = settingsBuilder.patchTracesSettings().build();
        this.getTraceSettings = settingsBuilder.getTraceSettings().build();
        this.listTracesSettings = settingsBuilder.listTracesSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings;
        private final SimpleCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings;
        private final PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(TraceServiceSettings.defaultChannelProviderBuilder().build());
            this.patchTracesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)TraceServiceGrpc.METHOD_PATCH_TRACES);
            this.getTraceSettings = SimpleCallSettings.newBuilder((MethodDescriptor)TraceServiceGrpc.METHOD_GET_TRACE);
            this.listTracesSettings = PagedCallSettings.newBuilder((MethodDescriptor)TraceServiceGrpc.METHOD_LIST_TRACES, (PagedListResponseFactory)LIST_TRACES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.patchTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTraceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTracesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(TraceServiceSettings settings) {
            super((ClientSettings)settings);
            this.patchTracesSettings = settings.patchTracesSettings.toBuilder();
            this.getTraceSettings = settings.getTraceSettings.toBuilder();
            this.listTracesSettings = settings.listTracesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings() {
            return this.patchTracesSettings;
        }

        public SimpleCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings() {
            return this.getTraceSettings;
        }

        public PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, PagedResponseWrappers.ListTracesPagedResponse> listTracesSettings() {
            return this.listTracesSettings;
        }

        public TraceServiceSettings build() throws IOException {
            return new TraceServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

