/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.tpu.v2.AcceleratorType;
import com.google.cloud.tpu.v2.CreateNodeRequest;
import com.google.cloud.tpu.v2.DeleteNodeRequest;
import com.google.cloud.tpu.v2.GenerateServiceIdentityRequest;
import com.google.cloud.tpu.v2.GenerateServiceIdentityResponse;
import com.google.cloud.tpu.v2.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v2.GetGuestAttributesRequest;
import com.google.cloud.tpu.v2.GetGuestAttributesResponse;
import com.google.cloud.tpu.v2.GetNodeRequest;
import com.google.cloud.tpu.v2.GetRuntimeVersionRequest;
import com.google.cloud.tpu.v2.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v2.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v2.ListNodesRequest;
import com.google.cloud.tpu.v2.ListNodesResponse;
import com.google.cloud.tpu.v2.ListRuntimeVersionsRequest;
import com.google.cloud.tpu.v2.ListRuntimeVersionsResponse;
import com.google.cloud.tpu.v2.Node;
import com.google.cloud.tpu.v2.OperationMetadata;
import com.google.cloud.tpu.v2.RuntimeVersion;
import com.google.cloud.tpu.v2.StartNodeRequest;
import com.google.cloud.tpu.v2.StopNodeRequest;
import com.google.cloud.tpu.v2.TpuClient;
import com.google.cloud.tpu.v2.UpdateNodeRequest;
import com.google.cloud.tpu.v2.stub.GrpcTpuStub;
import com.google.cloud.tpu.v2.stub.HttpJsonTpuStub;
import com.google.cloud.tpu.v2.stub.TpuStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TpuStubSettings
extends StubSettings<TpuStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> listNodesSettings;
    private final UnaryCallSettings<GetNodeRequest, Node> getNodeSettings;
    private final UnaryCallSettings<CreateNodeRequest, Operation> createNodeSettings;
    private final OperationCallSettings<CreateNodeRequest, Node, OperationMetadata> createNodeOperationSettings;
    private final UnaryCallSettings<DeleteNodeRequest, Operation> deleteNodeSettings;
    private final OperationCallSettings<DeleteNodeRequest, Empty, OperationMetadata> deleteNodeOperationSettings;
    private final UnaryCallSettings<StopNodeRequest, Operation> stopNodeSettings;
    private final OperationCallSettings<StopNodeRequest, Node, OperationMetadata> stopNodeOperationSettings;
    private final UnaryCallSettings<StartNodeRequest, Operation> startNodeSettings;
    private final OperationCallSettings<StartNodeRequest, Node, OperationMetadata> startNodeOperationSettings;
    private final UnaryCallSettings<UpdateNodeRequest, Operation> updateNodeSettings;
    private final OperationCallSettings<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationSettings;
    private final UnaryCallSettings<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentitySettings;
    private final PagedCallSettings<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings;
    private final UnaryCallSettings<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeSettings;
    private final PagedCallSettings<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, TpuClient.ListRuntimeVersionsPagedResponse> listRuntimeVersionsSettings;
    private final UnaryCallSettings<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionSettings;
    private final UnaryCallSettings<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, TpuClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListNodesRequest, ListNodesResponse, Node> LIST_NODES_PAGE_STR_DESC = new PagedListDescriptor<ListNodesRequest, ListNodesResponse, Node>(){

        public String emptyToken() {
            return "";
        }

        public ListNodesRequest injectToken(ListNodesRequest payload, String token) {
            return ListNodesRequest.newBuilder((ListNodesRequest)payload).setPageToken(token).build();
        }

        public ListNodesRequest injectPageSize(ListNodesRequest payload, int pageSize) {
            return ListNodesRequest.newBuilder((ListNodesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNodesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNodesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Node> extractResources(ListNodesResponse payload) {
            return payload.getNodesList() == null ? ImmutableList.of() : payload.getNodesList();
        }
    };
    private static final PagedListDescriptor<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> LIST_ACCELERATOR_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType>(){

        public String emptyToken() {
            return "";
        }

        public ListAcceleratorTypesRequest injectToken(ListAcceleratorTypesRequest payload, String token) {
            return ListAcceleratorTypesRequest.newBuilder((ListAcceleratorTypesRequest)payload).setPageToken(token).build();
        }

        public ListAcceleratorTypesRequest injectPageSize(ListAcceleratorTypesRequest payload, int pageSize) {
            return ListAcceleratorTypesRequest.newBuilder((ListAcceleratorTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAcceleratorTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAcceleratorTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AcceleratorType> extractResources(ListAcceleratorTypesResponse payload) {
            return payload.getAcceleratorTypesList() == null ? ImmutableList.of() : payload.getAcceleratorTypesList();
        }
    };
    private static final PagedListDescriptor<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion> LIST_RUNTIME_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListRuntimeVersionsRequest injectToken(ListRuntimeVersionsRequest payload, String token) {
            return ListRuntimeVersionsRequest.newBuilder((ListRuntimeVersionsRequest)payload).setPageToken(token).build();
        }

        public ListRuntimeVersionsRequest injectPageSize(ListRuntimeVersionsRequest payload, int pageSize) {
            return ListRuntimeVersionsRequest.newBuilder((ListRuntimeVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRuntimeVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRuntimeVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RuntimeVersion> extractResources(ListRuntimeVersionsResponse payload) {
            return payload.getRuntimeVersionsList() == null ? ImmutableList.of() : payload.getRuntimeVersionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> LIST_NODES_PAGE_STR_FACT = new PagedListResponseFactory<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse>(){

        public ApiFuture<TpuClient.ListNodesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodesRequest, ListNodesResponse> callable, ListNodesRequest request, ApiCallContext context, ApiFuture<ListNodesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NODES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TpuClient.ListNodesPagedResponse.createAsync((PageContext<ListNodesRequest, ListNodesResponse, Node>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> LIST_ACCELERATOR_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse>(){

        public ApiFuture<TpuClient.ListAcceleratorTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> callable, ListAcceleratorTypesRequest request, ApiCallContext context, ApiFuture<ListAcceleratorTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCELERATOR_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TpuClient.ListAcceleratorTypesPagedResponse.createAsync((PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, TpuClient.ListRuntimeVersionsPagedResponse> LIST_RUNTIME_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, TpuClient.ListRuntimeVersionsPagedResponse>(){

        public ApiFuture<TpuClient.ListRuntimeVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse> callable, ListRuntimeVersionsRequest request, ApiCallContext context, ApiFuture<ListRuntimeVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RUNTIME_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TpuClient.ListRuntimeVersionsPagedResponse.createAsync((PageContext<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, TpuClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, TpuClient.ListLocationsPagedResponse>(){

        public ApiFuture<TpuClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TpuClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> listNodesSettings() {
        return this.listNodesSettings;
    }

    public UnaryCallSettings<GetNodeRequest, Node> getNodeSettings() {
        return this.getNodeSettings;
    }

    public UnaryCallSettings<CreateNodeRequest, Operation> createNodeSettings() {
        return this.createNodeSettings;
    }

    public OperationCallSettings<CreateNodeRequest, Node, OperationMetadata> createNodeOperationSettings() {
        return this.createNodeOperationSettings;
    }

    public UnaryCallSettings<DeleteNodeRequest, Operation> deleteNodeSettings() {
        return this.deleteNodeSettings;
    }

    public OperationCallSettings<DeleteNodeRequest, Empty, OperationMetadata> deleteNodeOperationSettings() {
        return this.deleteNodeOperationSettings;
    }

    public UnaryCallSettings<StopNodeRequest, Operation> stopNodeSettings() {
        return this.stopNodeSettings;
    }

    public OperationCallSettings<StopNodeRequest, Node, OperationMetadata> stopNodeOperationSettings() {
        return this.stopNodeOperationSettings;
    }

    public UnaryCallSettings<StartNodeRequest, Operation> startNodeSettings() {
        return this.startNodeSettings;
    }

    public OperationCallSettings<StartNodeRequest, Node, OperationMetadata> startNodeOperationSettings() {
        return this.startNodeOperationSettings;
    }

    public UnaryCallSettings<UpdateNodeRequest, Operation> updateNodeSettings() {
        return this.updateNodeSettings;
    }

    public OperationCallSettings<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationSettings() {
        return this.updateNodeOperationSettings;
    }

    public UnaryCallSettings<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentitySettings() {
        return this.generateServiceIdentitySettings;
    }

    public PagedCallSettings<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings() {
        return this.listAcceleratorTypesSettings;
    }

    public UnaryCallSettings<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeSettings() {
        return this.getAcceleratorTypeSettings;
    }

    public PagedCallSettings<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, TpuClient.ListRuntimeVersionsPagedResponse> listRuntimeVersionsSettings() {
        return this.listRuntimeVersionsSettings;
    }

    public UnaryCallSettings<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionSettings() {
        return this.getRuntimeVersionSettings;
    }

    public UnaryCallSettings<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesSettings() {
        return this.getGuestAttributesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, TpuClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public TpuStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTpuStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTpuStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "tpu";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "tpu.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "tpu.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TpuStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TpuStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TpuStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TpuStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TpuStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listNodesSettings = settingsBuilder.listNodesSettings().build();
        this.getNodeSettings = settingsBuilder.getNodeSettings().build();
        this.createNodeSettings = settingsBuilder.createNodeSettings().build();
        this.createNodeOperationSettings = settingsBuilder.createNodeOperationSettings().build();
        this.deleteNodeSettings = settingsBuilder.deleteNodeSettings().build();
        this.deleteNodeOperationSettings = settingsBuilder.deleteNodeOperationSettings().build();
        this.stopNodeSettings = settingsBuilder.stopNodeSettings().build();
        this.stopNodeOperationSettings = settingsBuilder.stopNodeOperationSettings().build();
        this.startNodeSettings = settingsBuilder.startNodeSettings().build();
        this.startNodeOperationSettings = settingsBuilder.startNodeOperationSettings().build();
        this.updateNodeSettings = settingsBuilder.updateNodeSettings().build();
        this.updateNodeOperationSettings = settingsBuilder.updateNodeOperationSettings().build();
        this.generateServiceIdentitySettings = settingsBuilder.generateServiceIdentitySettings().build();
        this.listAcceleratorTypesSettings = settingsBuilder.listAcceleratorTypesSettings().build();
        this.getAcceleratorTypeSettings = settingsBuilder.getAcceleratorTypeSettings().build();
        this.listRuntimeVersionsSettings = settingsBuilder.listRuntimeVersionsSettings().build();
        this.getRuntimeVersionSettings = settingsBuilder.getRuntimeVersionSettings().build();
        this.getGuestAttributesSettings = settingsBuilder.getGuestAttributesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TpuStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> listNodesSettings;
        private final UnaryCallSettings.Builder<GetNodeRequest, Node> getNodeSettings;
        private final UnaryCallSettings.Builder<CreateNodeRequest, Operation> createNodeSettings;
        private final OperationCallSettings.Builder<CreateNodeRequest, Node, OperationMetadata> createNodeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteNodeRequest, Operation> deleteNodeSettings;
        private final OperationCallSettings.Builder<DeleteNodeRequest, Empty, OperationMetadata> deleteNodeOperationSettings;
        private final UnaryCallSettings.Builder<StopNodeRequest, Operation> stopNodeSettings;
        private final OperationCallSettings.Builder<StopNodeRequest, Node, OperationMetadata> stopNodeOperationSettings;
        private final UnaryCallSettings.Builder<StartNodeRequest, Operation> startNodeSettings;
        private final OperationCallSettings.Builder<StartNodeRequest, Node, OperationMetadata> startNodeOperationSettings;
        private final UnaryCallSettings.Builder<UpdateNodeRequest, Operation> updateNodeSettings;
        private final OperationCallSettings.Builder<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationSettings;
        private final UnaryCallSettings.Builder<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentitySettings;
        private final PagedCallSettings.Builder<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings;
        private final UnaryCallSettings.Builder<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeSettings;
        private final PagedCallSettings.Builder<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, TpuClient.ListRuntimeVersionsPagedResponse> listRuntimeVersionsSettings;
        private final UnaryCallSettings.Builder<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionSettings;
        private final UnaryCallSettings.Builder<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, TpuClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listNodesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NODES_PAGE_STR_FACT);
            this.getNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNodeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNodeOperationSettings = OperationCallSettings.newBuilder();
            this.stopNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopNodeOperationSettings = OperationCallSettings.newBuilder();
            this.startNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startNodeOperationSettings = OperationCallSettings.newBuilder();
            this.updateNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNodeOperationSettings = OperationCallSettings.newBuilder();
            this.generateServiceIdentitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAcceleratorTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCELERATOR_TYPES_PAGE_STR_FACT);
            this.getAcceleratorTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRuntimeVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RUNTIME_VERSIONS_PAGE_STR_FACT);
            this.getRuntimeVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGuestAttributesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listNodesSettings, this.getNodeSettings, this.createNodeSettings, this.deleteNodeSettings, this.stopNodeSettings, this.startNodeSettings, this.updateNodeSettings, this.generateServiceIdentitySettings, this.listAcceleratorTypesSettings, this.getAcceleratorTypeSettings, this.listRuntimeVersionsSettings, this.getRuntimeVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.getGuestAttributesSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(TpuStubSettings settings) {
            super((StubSettings)settings);
            this.listNodesSettings = settings.listNodesSettings.toBuilder();
            this.getNodeSettings = settings.getNodeSettings.toBuilder();
            this.createNodeSettings = settings.createNodeSettings.toBuilder();
            this.createNodeOperationSettings = settings.createNodeOperationSettings.toBuilder();
            this.deleteNodeSettings = settings.deleteNodeSettings.toBuilder();
            this.deleteNodeOperationSettings = settings.deleteNodeOperationSettings.toBuilder();
            this.stopNodeSettings = settings.stopNodeSettings.toBuilder();
            this.stopNodeOperationSettings = settings.stopNodeOperationSettings.toBuilder();
            this.startNodeSettings = settings.startNodeSettings.toBuilder();
            this.startNodeOperationSettings = settings.startNodeOperationSettings.toBuilder();
            this.updateNodeSettings = settings.updateNodeSettings.toBuilder();
            this.updateNodeOperationSettings = settings.updateNodeOperationSettings.toBuilder();
            this.generateServiceIdentitySettings = settings.generateServiceIdentitySettings.toBuilder();
            this.listAcceleratorTypesSettings = settings.listAcceleratorTypesSettings.toBuilder();
            this.getAcceleratorTypeSettings = settings.getAcceleratorTypeSettings.toBuilder();
            this.listRuntimeVersionsSettings = settings.listRuntimeVersionsSettings.toBuilder();
            this.getRuntimeVersionSettings = settings.getRuntimeVersionSettings.toBuilder();
            this.getGuestAttributesSettings = settings.getGuestAttributesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listNodesSettings, this.getNodeSettings, this.createNodeSettings, this.deleteNodeSettings, this.stopNodeSettings, this.startNodeSettings, this.updateNodeSettings, this.generateServiceIdentitySettings, this.listAcceleratorTypesSettings, this.getAcceleratorTypeSettings, this.listRuntimeVersionsSettings, this.getRuntimeVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.getGuestAttributesSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TpuStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TpuStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TpuStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TpuStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TpuStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TpuStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TpuStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TpuStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listNodesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.stopNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.startNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.generateServiceIdentitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listAcceleratorTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getAcceleratorTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listRuntimeVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getRuntimeVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getGuestAttributesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> listNodesSettings() {
            return this.listNodesSettings;
        }

        public UnaryCallSettings.Builder<GetNodeRequest, Node> getNodeSettings() {
            return this.getNodeSettings;
        }

        public UnaryCallSettings.Builder<CreateNodeRequest, Operation> createNodeSettings() {
            return this.createNodeSettings;
        }

        public OperationCallSettings.Builder<CreateNodeRequest, Node, OperationMetadata> createNodeOperationSettings() {
            return this.createNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodeRequest, Operation> deleteNodeSettings() {
            return this.deleteNodeSettings;
        }

        public OperationCallSettings.Builder<DeleteNodeRequest, Empty, OperationMetadata> deleteNodeOperationSettings() {
            return this.deleteNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<StopNodeRequest, Operation> stopNodeSettings() {
            return this.stopNodeSettings;
        }

        public OperationCallSettings.Builder<StopNodeRequest, Node, OperationMetadata> stopNodeOperationSettings() {
            return this.stopNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<StartNodeRequest, Operation> startNodeSettings() {
            return this.startNodeSettings;
        }

        public OperationCallSettings.Builder<StartNodeRequest, Node, OperationMetadata> startNodeOperationSettings() {
            return this.startNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateNodeRequest, Operation> updateNodeSettings() {
            return this.updateNodeSettings;
        }

        public OperationCallSettings.Builder<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationSettings() {
            return this.updateNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentitySettings() {
            return this.generateServiceIdentitySettings;
        }

        public PagedCallSettings.Builder<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings() {
            return this.listAcceleratorTypesSettings;
        }

        public UnaryCallSettings.Builder<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeSettings() {
            return this.getAcceleratorTypeSettings;
        }

        public PagedCallSettings.Builder<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, TpuClient.ListRuntimeVersionsPagedResponse> listRuntimeVersionsSettings() {
            return this.listRuntimeVersionsSettings;
        }

        public UnaryCallSettings.Builder<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionSettings() {
            return this.getRuntimeVersionSettings;
        }

        public UnaryCallSettings.Builder<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesSettings() {
            return this.getGuestAttributesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, TpuClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public TpuStubSettings build() throws IOException {
            return new TpuStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

