/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v2alpha1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.tpu.v2alpha1.AcceleratorType;
import com.google.cloud.tpu.v2alpha1.AcceleratorTypeName;
import com.google.cloud.tpu.v2alpha1.CreateNodeRequest;
import com.google.cloud.tpu.v2alpha1.DeleteNodeRequest;
import com.google.cloud.tpu.v2alpha1.GenerateServiceIdentityRequest;
import com.google.cloud.tpu.v2alpha1.GenerateServiceIdentityResponse;
import com.google.cloud.tpu.v2alpha1.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v2alpha1.GetGuestAttributesRequest;
import com.google.cloud.tpu.v2alpha1.GetGuestAttributesResponse;
import com.google.cloud.tpu.v2alpha1.GetNodeRequest;
import com.google.cloud.tpu.v2alpha1.GetRuntimeVersionRequest;
import com.google.cloud.tpu.v2alpha1.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v2alpha1.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v2alpha1.ListNodesRequest;
import com.google.cloud.tpu.v2alpha1.ListNodesResponse;
import com.google.cloud.tpu.v2alpha1.ListRuntimeVersionsRequest;
import com.google.cloud.tpu.v2alpha1.ListRuntimeVersionsResponse;
import com.google.cloud.tpu.v2alpha1.LocationName;
import com.google.cloud.tpu.v2alpha1.Node;
import com.google.cloud.tpu.v2alpha1.NodeName;
import com.google.cloud.tpu.v2alpha1.OperationMetadata;
import com.google.cloud.tpu.v2alpha1.RuntimeVersion;
import com.google.cloud.tpu.v2alpha1.RuntimeVersionName;
import com.google.cloud.tpu.v2alpha1.StartNodeRequest;
import com.google.cloud.tpu.v2alpha1.StopNodeRequest;
import com.google.cloud.tpu.v2alpha1.TpuSettings;
import com.google.cloud.tpu.v2alpha1.UpdateNodeRequest;
import com.google.cloud.tpu.v2alpha1.stub.TpuStub;
import com.google.cloud.tpu.v2alpha1.stub.TpuStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TpuClient
implements BackgroundResource {
    private final TpuSettings settings;
    private final TpuStub stub;
    private final OperationsClient operationsClient;

    public static final TpuClient create() throws IOException {
        return TpuClient.create(TpuSettings.newBuilder().build());
    }

    public static final TpuClient create(TpuSettings settings) throws IOException {
        return new TpuClient(settings);
    }

    public static final TpuClient create(TpuStub stub) {
        return new TpuClient(stub);
    }

    protected TpuClient(TpuSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TpuStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected TpuClient(TpuStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final TpuSettings getSettings() {
        return this.settings;
    }

    public TpuStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListNodesPagedResponse listNodes(NodeName parent) {
        ListNodesRequest request = ListNodesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNodes(request);
    }

    public final ListNodesPagedResponse listNodes(String parent) {
        ListNodesRequest request = ListNodesRequest.newBuilder().setParent(parent).build();
        return this.listNodes(request);
    }

    public final ListNodesPagedResponse listNodes(ListNodesRequest request) {
        return (ListNodesPagedResponse)((Object)this.listNodesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodesRequest, ListNodesPagedResponse> listNodesPagedCallable() {
        return this.stub.listNodesPagedCallable();
    }

    public final UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable() {
        return this.stub.listNodesCallable();
    }

    public final Node getNode(NodeName name) {
        GetNodeRequest request = GetNodeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNode(request);
    }

    public final Node getNode(String name) {
        GetNodeRequest request = GetNodeRequest.newBuilder().setName(name).build();
        return this.getNode(request);
    }

    public final Node getNode(GetNodeRequest request) {
        return (Node)this.getNodeCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeRequest, Node> getNodeCallable() {
        return this.stub.getNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> createNodeAsync(LocationName parent, Node node, String nodeId) {
        CreateNodeRequest request = CreateNodeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNode(node).setNodeId(nodeId).build();
        return this.createNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> createNodeAsync(String parent, Node node, String nodeId) {
        CreateNodeRequest request = CreateNodeRequest.newBuilder().setParent(parent).setNode(node).setNodeId(nodeId).build();
        return this.createNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> createNodeAsync(CreateNodeRequest request) {
        return this.createNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNodeRequest, Node, OperationMetadata> createNodeOperationCallable() {
        return this.stub.createNodeOperationCallable();
    }

    public final UnaryCallable<CreateNodeRequest, Operation> createNodeCallable() {
        return this.stub.createNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> deleteNodeAsync(NodeName name) {
        DeleteNodeRequest request = DeleteNodeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> deleteNodeAsync(String name) {
        DeleteNodeRequest request = DeleteNodeRequest.newBuilder().setName(name).build();
        return this.deleteNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> deleteNodeAsync(DeleteNodeRequest request) {
        return this.deleteNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNodeRequest, Node, OperationMetadata> deleteNodeOperationCallable() {
        return this.stub.deleteNodeOperationCallable();
    }

    public final UnaryCallable<DeleteNodeRequest, Operation> deleteNodeCallable() {
        return this.stub.deleteNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> stopNodeAsync(StopNodeRequest request) {
        return this.stopNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopNodeRequest, Node, OperationMetadata> stopNodeOperationCallable() {
        return this.stub.stopNodeOperationCallable();
    }

    public final UnaryCallable<StopNodeRequest, Operation> stopNodeCallable() {
        return this.stub.stopNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> startNodeAsync(StartNodeRequest request) {
        return this.startNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartNodeRequest, Node, OperationMetadata> startNodeOperationCallable() {
        return this.stub.startNodeOperationCallable();
    }

    public final UnaryCallable<StartNodeRequest, Operation> startNodeCallable() {
        return this.stub.startNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> updateNodeAsync(Node node, FieldMask updateMask) {
        UpdateNodeRequest request = UpdateNodeRequest.newBuilder().setNode(node).setUpdateMask(updateMask).build();
        return this.updateNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> updateNodeAsync(UpdateNodeRequest request) {
        return this.updateNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationCallable() {
        return this.stub.updateNodeOperationCallable();
    }

    public final UnaryCallable<UpdateNodeRequest, Operation> updateNodeCallable() {
        return this.stub.updateNodeCallable();
    }

    public final GenerateServiceIdentityResponse generateServiceIdentity(GenerateServiceIdentityRequest request) {
        return (GenerateServiceIdentityResponse)this.generateServiceIdentityCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentityCallable() {
        return this.stub.generateServiceIdentityCallable();
    }

    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(AcceleratorTypeName parent) {
        ListAcceleratorTypesRequest request = ListAcceleratorTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAcceleratorTypes(request);
    }

    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(String parent) {
        ListAcceleratorTypesRequest request = ListAcceleratorTypesRequest.newBuilder().setParent(parent).build();
        return this.listAcceleratorTypes(request);
    }

    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(ListAcceleratorTypesRequest request) {
        return (ListAcceleratorTypesPagedResponse)((Object)this.listAcceleratorTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable() {
        return this.stub.listAcceleratorTypesPagedCallable();
    }

    public final UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesCallable() {
        return this.stub.listAcceleratorTypesCallable();
    }

    public final AcceleratorType getAcceleratorType(AcceleratorTypeName name) {
        GetAcceleratorTypeRequest request = GetAcceleratorTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAcceleratorType(request);
    }

    public final AcceleratorType getAcceleratorType(String name) {
        GetAcceleratorTypeRequest request = GetAcceleratorTypeRequest.newBuilder().setName(name).build();
        return this.getAcceleratorType(request);
    }

    public final AcceleratorType getAcceleratorType(GetAcceleratorTypeRequest request) {
        return (AcceleratorType)this.getAcceleratorTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeCallable() {
        return this.stub.getAcceleratorTypeCallable();
    }

    public final ListRuntimeVersionsPagedResponse listRuntimeVersions(RuntimeVersionName parent) {
        ListRuntimeVersionsRequest request = ListRuntimeVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRuntimeVersions(request);
    }

    public final ListRuntimeVersionsPagedResponse listRuntimeVersions(String parent) {
        ListRuntimeVersionsRequest request = ListRuntimeVersionsRequest.newBuilder().setParent(parent).build();
        return this.listRuntimeVersions(request);
    }

    public final ListRuntimeVersionsPagedResponse listRuntimeVersions(ListRuntimeVersionsRequest request) {
        return (ListRuntimeVersionsPagedResponse)((Object)this.listRuntimeVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRuntimeVersionsRequest, ListRuntimeVersionsPagedResponse> listRuntimeVersionsPagedCallable() {
        return this.stub.listRuntimeVersionsPagedCallable();
    }

    public final UnaryCallable<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse> listRuntimeVersionsCallable() {
        return this.stub.listRuntimeVersionsCallable();
    }

    public final RuntimeVersion getRuntimeVersion(RuntimeVersionName name) {
        GetRuntimeVersionRequest request = GetRuntimeVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRuntimeVersion(request);
    }

    public final RuntimeVersion getRuntimeVersion(String name) {
        GetRuntimeVersionRequest request = GetRuntimeVersionRequest.newBuilder().setName(name).build();
        return this.getRuntimeVersion(request);
    }

    public final RuntimeVersion getRuntimeVersion(GetRuntimeVersionRequest request) {
        return (RuntimeVersion)this.getRuntimeVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionCallable() {
        return this.stub.getRuntimeVersionCallable();
    }

    public final GetGuestAttributesResponse getGuestAttributes(GetGuestAttributesRequest request) {
        return (GetGuestAttributesResponse)this.getGuestAttributesCallable().call((Object)request);
    }

    public final UnaryCallable<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesCallable() {
        return this.stub.getGuestAttributesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRuntimeVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion, ListRuntimeVersionsPage, ListRuntimeVersionsFixedSizeCollection> {
        private ListRuntimeVersionsFixedSizeCollection(List<ListRuntimeVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRuntimeVersionsFixedSizeCollection createEmptyCollection() {
            return new ListRuntimeVersionsFixedSizeCollection(null, 0);
        }

        protected ListRuntimeVersionsFixedSizeCollection createCollection(List<ListRuntimeVersionsPage> pages, int collectionSize) {
            return new ListRuntimeVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRuntimeVersionsPage
    extends AbstractPage<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion, ListRuntimeVersionsPage> {
        private ListRuntimeVersionsPage(PageContext<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion> context, ListRuntimeVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListRuntimeVersionsPage createEmptyPage() {
            return new ListRuntimeVersionsPage(null, null);
        }

        protected ListRuntimeVersionsPage createPage(PageContext<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion> context, ListRuntimeVersionsResponse response) {
            return new ListRuntimeVersionsPage(context, response);
        }

        public ApiFuture<ListRuntimeVersionsPage> createPageAsync(PageContext<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion> context, ApiFuture<ListRuntimeVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRuntimeVersionsPagedResponse
    extends AbstractPagedListResponse<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion, ListRuntimeVersionsPage, ListRuntimeVersionsFixedSizeCollection> {
        public static ApiFuture<ListRuntimeVersionsPagedResponse> createAsync(PageContext<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse, RuntimeVersion> context, ApiFuture<ListRuntimeVersionsResponse> futureResponse) {
            ApiFuture<ListRuntimeVersionsPage> futurePage = ListRuntimeVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRuntimeVersionsPagedResponse((ListRuntimeVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRuntimeVersionsPagedResponse(ListRuntimeVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRuntimeVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAcceleratorTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType, ListAcceleratorTypesPage, ListAcceleratorTypesFixedSizeCollection> {
        private ListAcceleratorTypesFixedSizeCollection(List<ListAcceleratorTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAcceleratorTypesFixedSizeCollection createEmptyCollection() {
            return new ListAcceleratorTypesFixedSizeCollection(null, 0);
        }

        protected ListAcceleratorTypesFixedSizeCollection createCollection(List<ListAcceleratorTypesPage> pages, int collectionSize) {
            return new ListAcceleratorTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAcceleratorTypesPage
    extends AbstractPage<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType, ListAcceleratorTypesPage> {
        private ListAcceleratorTypesPage(PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> context, ListAcceleratorTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListAcceleratorTypesPage createEmptyPage() {
            return new ListAcceleratorTypesPage(null, null);
        }

        protected ListAcceleratorTypesPage createPage(PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> context, ListAcceleratorTypesResponse response) {
            return new ListAcceleratorTypesPage(context, response);
        }

        public ApiFuture<ListAcceleratorTypesPage> createPageAsync(PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> context, ApiFuture<ListAcceleratorTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAcceleratorTypesPagedResponse
    extends AbstractPagedListResponse<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType, ListAcceleratorTypesPage, ListAcceleratorTypesFixedSizeCollection> {
        public static ApiFuture<ListAcceleratorTypesPagedResponse> createAsync(PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> context, ApiFuture<ListAcceleratorTypesResponse> futureResponse) {
            ApiFuture<ListAcceleratorTypesPage> futurePage = ListAcceleratorTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAcceleratorTypesPagedResponse((ListAcceleratorTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAcceleratorTypesPagedResponse(ListAcceleratorTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAcceleratorTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNodesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodesRequest, ListNodesResponse, Node, ListNodesPage, ListNodesFixedSizeCollection> {
        private ListNodesFixedSizeCollection(List<ListNodesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodesFixedSizeCollection createEmptyCollection() {
            return new ListNodesFixedSizeCollection(null, 0);
        }

        protected ListNodesFixedSizeCollection createCollection(List<ListNodesPage> pages, int collectionSize) {
            return new ListNodesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodesPage
    extends AbstractPage<ListNodesRequest, ListNodesResponse, Node, ListNodesPage> {
        private ListNodesPage(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ListNodesResponse response) {
            super(context, (Object)response);
        }

        private static ListNodesPage createEmptyPage() {
            return new ListNodesPage(null, null);
        }

        protected ListNodesPage createPage(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ListNodesResponse response) {
            return new ListNodesPage(context, response);
        }

        public ApiFuture<ListNodesPage> createPageAsync(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ApiFuture<ListNodesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodesPagedResponse
    extends AbstractPagedListResponse<ListNodesRequest, ListNodesResponse, Node, ListNodesPage, ListNodesFixedSizeCollection> {
        public static ApiFuture<ListNodesPagedResponse> createAsync(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ApiFuture<ListNodesResponse> futureResponse) {
            ApiFuture<ListNodesPage> futurePage = ListNodesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNodesPagedResponse((ListNodesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNodesPagedResponse(ListNodesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodesFixedSizeCollection.createEmptyCollection());
        }
    }
}

