/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.telcoautomation.v1alpha1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.telcoautomation.v1alpha1.ApplyDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.ApplyHydratedDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.ApproveBlueprintRequest;
import com.google.cloud.telcoautomation.v1alpha1.Blueprint;
import com.google.cloud.telcoautomation.v1alpha1.BlueprintName;
import com.google.cloud.telcoautomation.v1alpha1.ComputeDeploymentStatusRequest;
import com.google.cloud.telcoautomation.v1alpha1.ComputeDeploymentStatusResponse;
import com.google.cloud.telcoautomation.v1alpha1.CreateBlueprintRequest;
import com.google.cloud.telcoautomation.v1alpha1.CreateDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.CreateEdgeSlmRequest;
import com.google.cloud.telcoautomation.v1alpha1.CreateOrchestrationClusterRequest;
import com.google.cloud.telcoautomation.v1alpha1.DeleteBlueprintRequest;
import com.google.cloud.telcoautomation.v1alpha1.DeleteEdgeSlmRequest;
import com.google.cloud.telcoautomation.v1alpha1.DeleteOrchestrationClusterRequest;
import com.google.cloud.telcoautomation.v1alpha1.Deployment;
import com.google.cloud.telcoautomation.v1alpha1.DeploymentName;
import com.google.cloud.telcoautomation.v1alpha1.DiscardBlueprintChangesRequest;
import com.google.cloud.telcoautomation.v1alpha1.DiscardBlueprintChangesResponse;
import com.google.cloud.telcoautomation.v1alpha1.DiscardDeploymentChangesRequest;
import com.google.cloud.telcoautomation.v1alpha1.DiscardDeploymentChangesResponse;
import com.google.cloud.telcoautomation.v1alpha1.EdgeSlm;
import com.google.cloud.telcoautomation.v1alpha1.EdgeSlmName;
import com.google.cloud.telcoautomation.v1alpha1.GetBlueprintRequest;
import com.google.cloud.telcoautomation.v1alpha1.GetDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.GetEdgeSlmRequest;
import com.google.cloud.telcoautomation.v1alpha1.GetHydratedDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.GetOrchestrationClusterRequest;
import com.google.cloud.telcoautomation.v1alpha1.GetPublicBlueprintRequest;
import com.google.cloud.telcoautomation.v1alpha1.HydratedDeployment;
import com.google.cloud.telcoautomation.v1alpha1.HydratedDeploymentName;
import com.google.cloud.telcoautomation.v1alpha1.ListBlueprintRevisionsRequest;
import com.google.cloud.telcoautomation.v1alpha1.ListBlueprintRevisionsResponse;
import com.google.cloud.telcoautomation.v1alpha1.ListBlueprintsRequest;
import com.google.cloud.telcoautomation.v1alpha1.ListBlueprintsResponse;
import com.google.cloud.telcoautomation.v1alpha1.ListDeploymentRevisionsRequest;
import com.google.cloud.telcoautomation.v1alpha1.ListDeploymentRevisionsResponse;
import com.google.cloud.telcoautomation.v1alpha1.ListDeploymentsRequest;
import com.google.cloud.telcoautomation.v1alpha1.ListDeploymentsResponse;
import com.google.cloud.telcoautomation.v1alpha1.ListEdgeSlmsRequest;
import com.google.cloud.telcoautomation.v1alpha1.ListEdgeSlmsResponse;
import com.google.cloud.telcoautomation.v1alpha1.ListHydratedDeploymentsRequest;
import com.google.cloud.telcoautomation.v1alpha1.ListHydratedDeploymentsResponse;
import com.google.cloud.telcoautomation.v1alpha1.ListOrchestrationClustersRequest;
import com.google.cloud.telcoautomation.v1alpha1.ListOrchestrationClustersResponse;
import com.google.cloud.telcoautomation.v1alpha1.ListPublicBlueprintsRequest;
import com.google.cloud.telcoautomation.v1alpha1.ListPublicBlueprintsResponse;
import com.google.cloud.telcoautomation.v1alpha1.LocationName;
import com.google.cloud.telcoautomation.v1alpha1.OperationMetadata;
import com.google.cloud.telcoautomation.v1alpha1.OrchestrationCluster;
import com.google.cloud.telcoautomation.v1alpha1.OrchestrationClusterName;
import com.google.cloud.telcoautomation.v1alpha1.ProposeBlueprintRequest;
import com.google.cloud.telcoautomation.v1alpha1.PublicBlueprint;
import com.google.cloud.telcoautomation.v1alpha1.PublicBlueprintName;
import com.google.cloud.telcoautomation.v1alpha1.RejectBlueprintRequest;
import com.google.cloud.telcoautomation.v1alpha1.RemoveDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.RollbackDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.SearchBlueprintRevisionsRequest;
import com.google.cloud.telcoautomation.v1alpha1.SearchBlueprintRevisionsResponse;
import com.google.cloud.telcoautomation.v1alpha1.SearchDeploymentRevisionsRequest;
import com.google.cloud.telcoautomation.v1alpha1.SearchDeploymentRevisionsResponse;
import com.google.cloud.telcoautomation.v1alpha1.TelcoAutomationSettings;
import com.google.cloud.telcoautomation.v1alpha1.UpdateBlueprintRequest;
import com.google.cloud.telcoautomation.v1alpha1.UpdateDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.UpdateHydratedDeploymentRequest;
import com.google.cloud.telcoautomation.v1alpha1.stub.TelcoAutomationStub;
import com.google.cloud.telcoautomation.v1alpha1.stub.TelcoAutomationStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TelcoAutomationClient
implements BackgroundResource {
    private final TelcoAutomationSettings settings;
    private final TelcoAutomationStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final TelcoAutomationClient create() throws IOException {
        return TelcoAutomationClient.create(TelcoAutomationSettings.newBuilder().build());
    }

    public static final TelcoAutomationClient create(TelcoAutomationSettings settings) throws IOException {
        return new TelcoAutomationClient(settings);
    }

    public static final TelcoAutomationClient create(TelcoAutomationStub stub) {
        return new TelcoAutomationClient(stub);
    }

    protected TelcoAutomationClient(TelcoAutomationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TelcoAutomationStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected TelcoAutomationClient(TelcoAutomationStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final TelcoAutomationSettings getSettings() {
        return this.settings;
    }

    public TelcoAutomationStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListOrchestrationClustersPagedResponse listOrchestrationClusters(LocationName parent) {
        ListOrchestrationClustersRequest request = ListOrchestrationClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOrchestrationClusters(request);
    }

    public final ListOrchestrationClustersPagedResponse listOrchestrationClusters(String parent) {
        ListOrchestrationClustersRequest request = ListOrchestrationClustersRequest.newBuilder().setParent(parent).build();
        return this.listOrchestrationClusters(request);
    }

    public final ListOrchestrationClustersPagedResponse listOrchestrationClusters(ListOrchestrationClustersRequest request) {
        return (ListOrchestrationClustersPagedResponse)((Object)this.listOrchestrationClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrchestrationClustersRequest, ListOrchestrationClustersPagedResponse> listOrchestrationClustersPagedCallable() {
        return this.stub.listOrchestrationClustersPagedCallable();
    }

    public final UnaryCallable<ListOrchestrationClustersRequest, ListOrchestrationClustersResponse> listOrchestrationClustersCallable() {
        return this.stub.listOrchestrationClustersCallable();
    }

    public final OrchestrationCluster getOrchestrationCluster(OrchestrationClusterName name) {
        GetOrchestrationClusterRequest request = GetOrchestrationClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrchestrationCluster(request);
    }

    public final OrchestrationCluster getOrchestrationCluster(String name) {
        GetOrchestrationClusterRequest request = GetOrchestrationClusterRequest.newBuilder().setName(name).build();
        return this.getOrchestrationCluster(request);
    }

    public final OrchestrationCluster getOrchestrationCluster(GetOrchestrationClusterRequest request) {
        return (OrchestrationCluster)this.getOrchestrationClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrchestrationClusterRequest, OrchestrationCluster> getOrchestrationClusterCallable() {
        return this.stub.getOrchestrationClusterCallable();
    }

    public final OperationFuture<OrchestrationCluster, OperationMetadata> createOrchestrationClusterAsync(LocationName parent, OrchestrationCluster orchestrationCluster, String orchestrationClusterId) {
        CreateOrchestrationClusterRequest request = CreateOrchestrationClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setOrchestrationCluster(orchestrationCluster).setOrchestrationClusterId(orchestrationClusterId).build();
        return this.createOrchestrationClusterAsync(request);
    }

    public final OperationFuture<OrchestrationCluster, OperationMetadata> createOrchestrationClusterAsync(String parent, OrchestrationCluster orchestrationCluster, String orchestrationClusterId) {
        CreateOrchestrationClusterRequest request = CreateOrchestrationClusterRequest.newBuilder().setParent(parent).setOrchestrationCluster(orchestrationCluster).setOrchestrationClusterId(orchestrationClusterId).build();
        return this.createOrchestrationClusterAsync(request);
    }

    public final OperationFuture<OrchestrationCluster, OperationMetadata> createOrchestrationClusterAsync(CreateOrchestrationClusterRequest request) {
        return this.createOrchestrationClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateOrchestrationClusterRequest, OrchestrationCluster, OperationMetadata> createOrchestrationClusterOperationCallable() {
        return this.stub.createOrchestrationClusterOperationCallable();
    }

    public final UnaryCallable<CreateOrchestrationClusterRequest, Operation> createOrchestrationClusterCallable() {
        return this.stub.createOrchestrationClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOrchestrationClusterAsync(OrchestrationClusterName name) {
        DeleteOrchestrationClusterRequest request = DeleteOrchestrationClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteOrchestrationClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOrchestrationClusterAsync(String name) {
        DeleteOrchestrationClusterRequest request = DeleteOrchestrationClusterRequest.newBuilder().setName(name).build();
        return this.deleteOrchestrationClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOrchestrationClusterAsync(DeleteOrchestrationClusterRequest request) {
        return this.deleteOrchestrationClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteOrchestrationClusterRequest, Empty, OperationMetadata> deleteOrchestrationClusterOperationCallable() {
        return this.stub.deleteOrchestrationClusterOperationCallable();
    }

    public final UnaryCallable<DeleteOrchestrationClusterRequest, Operation> deleteOrchestrationClusterCallable() {
        return this.stub.deleteOrchestrationClusterCallable();
    }

    public final ListEdgeSlmsPagedResponse listEdgeSlms(LocationName parent) {
        ListEdgeSlmsRequest request = ListEdgeSlmsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEdgeSlms(request);
    }

    public final ListEdgeSlmsPagedResponse listEdgeSlms(String parent) {
        ListEdgeSlmsRequest request = ListEdgeSlmsRequest.newBuilder().setParent(parent).build();
        return this.listEdgeSlms(request);
    }

    public final ListEdgeSlmsPagedResponse listEdgeSlms(ListEdgeSlmsRequest request) {
        return (ListEdgeSlmsPagedResponse)((Object)this.listEdgeSlmsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEdgeSlmsRequest, ListEdgeSlmsPagedResponse> listEdgeSlmsPagedCallable() {
        return this.stub.listEdgeSlmsPagedCallable();
    }

    public final UnaryCallable<ListEdgeSlmsRequest, ListEdgeSlmsResponse> listEdgeSlmsCallable() {
        return this.stub.listEdgeSlmsCallable();
    }

    public final EdgeSlm getEdgeSlm(EdgeSlmName name) {
        GetEdgeSlmRequest request = GetEdgeSlmRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEdgeSlm(request);
    }

    public final EdgeSlm getEdgeSlm(String name) {
        GetEdgeSlmRequest request = GetEdgeSlmRequest.newBuilder().setName(name).build();
        return this.getEdgeSlm(request);
    }

    public final EdgeSlm getEdgeSlm(GetEdgeSlmRequest request) {
        return (EdgeSlm)this.getEdgeSlmCallable().call((Object)request);
    }

    public final UnaryCallable<GetEdgeSlmRequest, EdgeSlm> getEdgeSlmCallable() {
        return this.stub.getEdgeSlmCallable();
    }

    public final OperationFuture<EdgeSlm, OperationMetadata> createEdgeSlmAsync(LocationName parent, EdgeSlm edgeSlm, String edgeSlmId) {
        CreateEdgeSlmRequest request = CreateEdgeSlmRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEdgeSlm(edgeSlm).setEdgeSlmId(edgeSlmId).build();
        return this.createEdgeSlmAsync(request);
    }

    public final OperationFuture<EdgeSlm, OperationMetadata> createEdgeSlmAsync(String parent, EdgeSlm edgeSlm, String edgeSlmId) {
        CreateEdgeSlmRequest request = CreateEdgeSlmRequest.newBuilder().setParent(parent).setEdgeSlm(edgeSlm).setEdgeSlmId(edgeSlmId).build();
        return this.createEdgeSlmAsync(request);
    }

    public final OperationFuture<EdgeSlm, OperationMetadata> createEdgeSlmAsync(CreateEdgeSlmRequest request) {
        return this.createEdgeSlmOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEdgeSlmRequest, EdgeSlm, OperationMetadata> createEdgeSlmOperationCallable() {
        return this.stub.createEdgeSlmOperationCallable();
    }

    public final UnaryCallable<CreateEdgeSlmRequest, Operation> createEdgeSlmCallable() {
        return this.stub.createEdgeSlmCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEdgeSlmAsync(EdgeSlmName name) {
        DeleteEdgeSlmRequest request = DeleteEdgeSlmRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEdgeSlmAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEdgeSlmAsync(String name) {
        DeleteEdgeSlmRequest request = DeleteEdgeSlmRequest.newBuilder().setName(name).build();
        return this.deleteEdgeSlmAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEdgeSlmAsync(DeleteEdgeSlmRequest request) {
        return this.deleteEdgeSlmOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEdgeSlmRequest, Empty, OperationMetadata> deleteEdgeSlmOperationCallable() {
        return this.stub.deleteEdgeSlmOperationCallable();
    }

    public final UnaryCallable<DeleteEdgeSlmRequest, Operation> deleteEdgeSlmCallable() {
        return this.stub.deleteEdgeSlmCallable();
    }

    public final Blueprint createBlueprint(OrchestrationClusterName parent, Blueprint blueprint, String blueprintId) {
        CreateBlueprintRequest request = CreateBlueprintRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBlueprint(blueprint).setBlueprintId(blueprintId).build();
        return this.createBlueprint(request);
    }

    public final Blueprint createBlueprint(String parent, Blueprint blueprint, String blueprintId) {
        CreateBlueprintRequest request = CreateBlueprintRequest.newBuilder().setParent(parent).setBlueprint(blueprint).setBlueprintId(blueprintId).build();
        return this.createBlueprint(request);
    }

    public final Blueprint createBlueprint(CreateBlueprintRequest request) {
        return (Blueprint)this.createBlueprintCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBlueprintRequest, Blueprint> createBlueprintCallable() {
        return this.stub.createBlueprintCallable();
    }

    public final Blueprint updateBlueprint(Blueprint blueprint, FieldMask updateMask) {
        UpdateBlueprintRequest request = UpdateBlueprintRequest.newBuilder().setBlueprint(blueprint).setUpdateMask(updateMask).build();
        return this.updateBlueprint(request);
    }

    public final Blueprint updateBlueprint(UpdateBlueprintRequest request) {
        return (Blueprint)this.updateBlueprintCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBlueprintRequest, Blueprint> updateBlueprintCallable() {
        return this.stub.updateBlueprintCallable();
    }

    public final Blueprint getBlueprint(BlueprintName name) {
        GetBlueprintRequest request = GetBlueprintRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBlueprint(request);
    }

    public final Blueprint getBlueprint(String name) {
        GetBlueprintRequest request = GetBlueprintRequest.newBuilder().setName(name).build();
        return this.getBlueprint(request);
    }

    public final Blueprint getBlueprint(GetBlueprintRequest request) {
        return (Blueprint)this.getBlueprintCallable().call((Object)request);
    }

    public final UnaryCallable<GetBlueprintRequest, Blueprint> getBlueprintCallable() {
        return this.stub.getBlueprintCallable();
    }

    public final void deleteBlueprint(BlueprintName name) {
        DeleteBlueprintRequest request = DeleteBlueprintRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBlueprint(request);
    }

    public final void deleteBlueprint(String name) {
        DeleteBlueprintRequest request = DeleteBlueprintRequest.newBuilder().setName(name).build();
        this.deleteBlueprint(request);
    }

    public final void deleteBlueprint(DeleteBlueprintRequest request) {
        this.deleteBlueprintCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBlueprintRequest, Empty> deleteBlueprintCallable() {
        return this.stub.deleteBlueprintCallable();
    }

    public final ListBlueprintsPagedResponse listBlueprints(OrchestrationClusterName parent) {
        ListBlueprintsRequest request = ListBlueprintsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBlueprints(request);
    }

    public final ListBlueprintsPagedResponse listBlueprints(String parent) {
        ListBlueprintsRequest request = ListBlueprintsRequest.newBuilder().setParent(parent).build();
        return this.listBlueprints(request);
    }

    public final ListBlueprintsPagedResponse listBlueprints(ListBlueprintsRequest request) {
        return (ListBlueprintsPagedResponse)((Object)this.listBlueprintsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBlueprintsRequest, ListBlueprintsPagedResponse> listBlueprintsPagedCallable() {
        return this.stub.listBlueprintsPagedCallable();
    }

    public final UnaryCallable<ListBlueprintsRequest, ListBlueprintsResponse> listBlueprintsCallable() {
        return this.stub.listBlueprintsCallable();
    }

    public final Blueprint approveBlueprint(BlueprintName name) {
        ApproveBlueprintRequest request = ApproveBlueprintRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.approveBlueprint(request);
    }

    public final Blueprint approveBlueprint(String name) {
        ApproveBlueprintRequest request = ApproveBlueprintRequest.newBuilder().setName(name).build();
        return this.approveBlueprint(request);
    }

    public final Blueprint approveBlueprint(ApproveBlueprintRequest request) {
        return (Blueprint)this.approveBlueprintCallable().call((Object)request);
    }

    public final UnaryCallable<ApproveBlueprintRequest, Blueprint> approveBlueprintCallable() {
        return this.stub.approveBlueprintCallable();
    }

    public final Blueprint proposeBlueprint(BlueprintName name) {
        ProposeBlueprintRequest request = ProposeBlueprintRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.proposeBlueprint(request);
    }

    public final Blueprint proposeBlueprint(String name) {
        ProposeBlueprintRequest request = ProposeBlueprintRequest.newBuilder().setName(name).build();
        return this.proposeBlueprint(request);
    }

    public final Blueprint proposeBlueprint(ProposeBlueprintRequest request) {
        return (Blueprint)this.proposeBlueprintCallable().call((Object)request);
    }

    public final UnaryCallable<ProposeBlueprintRequest, Blueprint> proposeBlueprintCallable() {
        return this.stub.proposeBlueprintCallable();
    }

    public final Blueprint rejectBlueprint(BlueprintName name) {
        RejectBlueprintRequest request = RejectBlueprintRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.rejectBlueprint(request);
    }

    public final Blueprint rejectBlueprint(String name) {
        RejectBlueprintRequest request = RejectBlueprintRequest.newBuilder().setName(name).build();
        return this.rejectBlueprint(request);
    }

    public final Blueprint rejectBlueprint(RejectBlueprintRequest request) {
        return (Blueprint)this.rejectBlueprintCallable().call((Object)request);
    }

    public final UnaryCallable<RejectBlueprintRequest, Blueprint> rejectBlueprintCallable() {
        return this.stub.rejectBlueprintCallable();
    }

    public final ListBlueprintRevisionsPagedResponse listBlueprintRevisions(BlueprintName name) {
        ListBlueprintRevisionsRequest request = ListBlueprintRevisionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listBlueprintRevisions(request);
    }

    public final ListBlueprintRevisionsPagedResponse listBlueprintRevisions(String name) {
        ListBlueprintRevisionsRequest request = ListBlueprintRevisionsRequest.newBuilder().setName(name).build();
        return this.listBlueprintRevisions(request);
    }

    public final ListBlueprintRevisionsPagedResponse listBlueprintRevisions(ListBlueprintRevisionsRequest request) {
        return (ListBlueprintRevisionsPagedResponse)((Object)this.listBlueprintRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBlueprintRevisionsRequest, ListBlueprintRevisionsPagedResponse> listBlueprintRevisionsPagedCallable() {
        return this.stub.listBlueprintRevisionsPagedCallable();
    }

    public final UnaryCallable<ListBlueprintRevisionsRequest, ListBlueprintRevisionsResponse> listBlueprintRevisionsCallable() {
        return this.stub.listBlueprintRevisionsCallable();
    }

    public final SearchBlueprintRevisionsPagedResponse searchBlueprintRevisions(OrchestrationClusterName parent, String query) {
        SearchBlueprintRevisionsRequest request = SearchBlueprintRevisionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setQuery(query).build();
        return this.searchBlueprintRevisions(request);
    }

    public final SearchBlueprintRevisionsPagedResponse searchBlueprintRevisions(String parent, String query) {
        SearchBlueprintRevisionsRequest request = SearchBlueprintRevisionsRequest.newBuilder().setParent(parent).setQuery(query).build();
        return this.searchBlueprintRevisions(request);
    }

    public final SearchBlueprintRevisionsPagedResponse searchBlueprintRevisions(SearchBlueprintRevisionsRequest request) {
        return (SearchBlueprintRevisionsPagedResponse)((Object)this.searchBlueprintRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsPagedResponse> searchBlueprintRevisionsPagedCallable() {
        return this.stub.searchBlueprintRevisionsPagedCallable();
    }

    public final UnaryCallable<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsResponse> searchBlueprintRevisionsCallable() {
        return this.stub.searchBlueprintRevisionsCallable();
    }

    public final SearchDeploymentRevisionsPagedResponse searchDeploymentRevisions(OrchestrationClusterName parent, String query) {
        SearchDeploymentRevisionsRequest request = SearchDeploymentRevisionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setQuery(query).build();
        return this.searchDeploymentRevisions(request);
    }

    public final SearchDeploymentRevisionsPagedResponse searchDeploymentRevisions(String parent, String query) {
        SearchDeploymentRevisionsRequest request = SearchDeploymentRevisionsRequest.newBuilder().setParent(parent).setQuery(query).build();
        return this.searchDeploymentRevisions(request);
    }

    public final SearchDeploymentRevisionsPagedResponse searchDeploymentRevisions(SearchDeploymentRevisionsRequest request) {
        return (SearchDeploymentRevisionsPagedResponse)((Object)this.searchDeploymentRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsPagedResponse> searchDeploymentRevisionsPagedCallable() {
        return this.stub.searchDeploymentRevisionsPagedCallable();
    }

    public final UnaryCallable<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsResponse> searchDeploymentRevisionsCallable() {
        return this.stub.searchDeploymentRevisionsCallable();
    }

    public final DiscardBlueprintChangesResponse discardBlueprintChanges(BlueprintName name) {
        DiscardBlueprintChangesRequest request = DiscardBlueprintChangesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.discardBlueprintChanges(request);
    }

    public final DiscardBlueprintChangesResponse discardBlueprintChanges(String name) {
        DiscardBlueprintChangesRequest request = DiscardBlueprintChangesRequest.newBuilder().setName(name).build();
        return this.discardBlueprintChanges(request);
    }

    public final DiscardBlueprintChangesResponse discardBlueprintChanges(DiscardBlueprintChangesRequest request) {
        return (DiscardBlueprintChangesResponse)this.discardBlueprintChangesCallable().call((Object)request);
    }

    public final UnaryCallable<DiscardBlueprintChangesRequest, DiscardBlueprintChangesResponse> discardBlueprintChangesCallable() {
        return this.stub.discardBlueprintChangesCallable();
    }

    public final ListPublicBlueprintsPagedResponse listPublicBlueprints(LocationName parent) {
        ListPublicBlueprintsRequest request = ListPublicBlueprintsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPublicBlueprints(request);
    }

    public final ListPublicBlueprintsPagedResponse listPublicBlueprints(String parent) {
        ListPublicBlueprintsRequest request = ListPublicBlueprintsRequest.newBuilder().setParent(parent).build();
        return this.listPublicBlueprints(request);
    }

    public final ListPublicBlueprintsPagedResponse listPublicBlueprints(ListPublicBlueprintsRequest request) {
        return (ListPublicBlueprintsPagedResponse)((Object)this.listPublicBlueprintsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPublicBlueprintsRequest, ListPublicBlueprintsPagedResponse> listPublicBlueprintsPagedCallable() {
        return this.stub.listPublicBlueprintsPagedCallable();
    }

    public final UnaryCallable<ListPublicBlueprintsRequest, ListPublicBlueprintsResponse> listPublicBlueprintsCallable() {
        return this.stub.listPublicBlueprintsCallable();
    }

    public final PublicBlueprint getPublicBlueprint(PublicBlueprintName name) {
        GetPublicBlueprintRequest request = GetPublicBlueprintRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPublicBlueprint(request);
    }

    public final PublicBlueprint getPublicBlueprint(String name) {
        GetPublicBlueprintRequest request = GetPublicBlueprintRequest.newBuilder().setName(name).build();
        return this.getPublicBlueprint(request);
    }

    public final PublicBlueprint getPublicBlueprint(GetPublicBlueprintRequest request) {
        return (PublicBlueprint)this.getPublicBlueprintCallable().call((Object)request);
    }

    public final UnaryCallable<GetPublicBlueprintRequest, PublicBlueprint> getPublicBlueprintCallable() {
        return this.stub.getPublicBlueprintCallable();
    }

    public final Deployment createDeployment(OrchestrationClusterName parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeployment(request);
    }

    public final Deployment createDeployment(String parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeployment(request);
    }

    public final Deployment createDeployment(CreateDeploymentRequest request) {
        return (Deployment)this.createDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDeploymentRequest, Deployment> createDeploymentCallable() {
        return this.stub.createDeploymentCallable();
    }

    public final Deployment updateDeployment(Deployment deployment, FieldMask updateMask) {
        UpdateDeploymentRequest request = UpdateDeploymentRequest.newBuilder().setDeployment(deployment).setUpdateMask(updateMask).build();
        return this.updateDeployment(request);
    }

    public final Deployment updateDeployment(UpdateDeploymentRequest request) {
        return (Deployment)this.updateDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDeploymentRequest, Deployment> updateDeploymentCallable() {
        return this.stub.updateDeploymentCallable();
    }

    public final Deployment getDeployment(DeploymentName name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(String name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(GetDeploymentRequest request) {
        return (Deployment)this.getDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.stub.getDeploymentCallable();
    }

    public final void removeDeployment(DeploymentName name) {
        RemoveDeploymentRequest request = RemoveDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.removeDeployment(request);
    }

    public final void removeDeployment(String name) {
        RemoveDeploymentRequest request = RemoveDeploymentRequest.newBuilder().setName(name).build();
        this.removeDeployment(request);
    }

    public final void removeDeployment(RemoveDeploymentRequest request) {
        this.removeDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveDeploymentRequest, Empty> removeDeploymentCallable() {
        return this.stub.removeDeploymentCallable();
    }

    public final ListDeploymentsPagedResponse listDeployments(OrchestrationClusterName parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(String parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(ListDeploymentsRequest request) {
        return (ListDeploymentsPagedResponse)((Object)this.listDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.stub.listDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.stub.listDeploymentsCallable();
    }

    public final ListDeploymentRevisionsPagedResponse listDeploymentRevisions(DeploymentName name) {
        ListDeploymentRevisionsRequest request = ListDeploymentRevisionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listDeploymentRevisions(request);
    }

    public final ListDeploymentRevisionsPagedResponse listDeploymentRevisions(String name) {
        ListDeploymentRevisionsRequest request = ListDeploymentRevisionsRequest.newBuilder().setName(name).build();
        return this.listDeploymentRevisions(request);
    }

    public final ListDeploymentRevisionsPagedResponse listDeploymentRevisions(ListDeploymentRevisionsRequest request) {
        return (ListDeploymentRevisionsPagedResponse)((Object)this.listDeploymentRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeploymentRevisionsRequest, ListDeploymentRevisionsPagedResponse> listDeploymentRevisionsPagedCallable() {
        return this.stub.listDeploymentRevisionsPagedCallable();
    }

    public final UnaryCallable<ListDeploymentRevisionsRequest, ListDeploymentRevisionsResponse> listDeploymentRevisionsCallable() {
        return this.stub.listDeploymentRevisionsCallable();
    }

    public final DiscardDeploymentChangesResponse discardDeploymentChanges(DeploymentName name) {
        DiscardDeploymentChangesRequest request = DiscardDeploymentChangesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.discardDeploymentChanges(request);
    }

    public final DiscardDeploymentChangesResponse discardDeploymentChanges(String name) {
        DiscardDeploymentChangesRequest request = DiscardDeploymentChangesRequest.newBuilder().setName(name).build();
        return this.discardDeploymentChanges(request);
    }

    public final DiscardDeploymentChangesResponse discardDeploymentChanges(DiscardDeploymentChangesRequest request) {
        return (DiscardDeploymentChangesResponse)this.discardDeploymentChangesCallable().call((Object)request);
    }

    public final UnaryCallable<DiscardDeploymentChangesRequest, DiscardDeploymentChangesResponse> discardDeploymentChangesCallable() {
        return this.stub.discardDeploymentChangesCallable();
    }

    public final Deployment applyDeployment(DeploymentName name) {
        ApplyDeploymentRequest request = ApplyDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.applyDeployment(request);
    }

    public final Deployment applyDeployment(String name) {
        ApplyDeploymentRequest request = ApplyDeploymentRequest.newBuilder().setName(name).build();
        return this.applyDeployment(request);
    }

    public final Deployment applyDeployment(ApplyDeploymentRequest request) {
        return (Deployment)this.applyDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<ApplyDeploymentRequest, Deployment> applyDeploymentCallable() {
        return this.stub.applyDeploymentCallable();
    }

    public final ComputeDeploymentStatusResponse computeDeploymentStatus(DeploymentName name) {
        ComputeDeploymentStatusRequest request = ComputeDeploymentStatusRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.computeDeploymentStatus(request);
    }

    public final ComputeDeploymentStatusResponse computeDeploymentStatus(String name) {
        ComputeDeploymentStatusRequest request = ComputeDeploymentStatusRequest.newBuilder().setName(name).build();
        return this.computeDeploymentStatus(request);
    }

    public final ComputeDeploymentStatusResponse computeDeploymentStatus(ComputeDeploymentStatusRequest request) {
        return (ComputeDeploymentStatusResponse)this.computeDeploymentStatusCallable().call((Object)request);
    }

    public final UnaryCallable<ComputeDeploymentStatusRequest, ComputeDeploymentStatusResponse> computeDeploymentStatusCallable() {
        return this.stub.computeDeploymentStatusCallable();
    }

    public final Deployment rollbackDeployment(DeploymentName name, String revisionId) {
        RollbackDeploymentRequest request = RollbackDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).setRevisionId(revisionId).build();
        return this.rollbackDeployment(request);
    }

    public final Deployment rollbackDeployment(String name, String revisionId) {
        RollbackDeploymentRequest request = RollbackDeploymentRequest.newBuilder().setName(name).setRevisionId(revisionId).build();
        return this.rollbackDeployment(request);
    }

    public final Deployment rollbackDeployment(RollbackDeploymentRequest request) {
        return (Deployment)this.rollbackDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<RollbackDeploymentRequest, Deployment> rollbackDeploymentCallable() {
        return this.stub.rollbackDeploymentCallable();
    }

    public final HydratedDeployment getHydratedDeployment(HydratedDeploymentName name) {
        GetHydratedDeploymentRequest request = GetHydratedDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHydratedDeployment(request);
    }

    public final HydratedDeployment getHydratedDeployment(String name) {
        GetHydratedDeploymentRequest request = GetHydratedDeploymentRequest.newBuilder().setName(name).build();
        return this.getHydratedDeployment(request);
    }

    public final HydratedDeployment getHydratedDeployment(GetHydratedDeploymentRequest request) {
        return (HydratedDeployment)this.getHydratedDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetHydratedDeploymentRequest, HydratedDeployment> getHydratedDeploymentCallable() {
        return this.stub.getHydratedDeploymentCallable();
    }

    public final ListHydratedDeploymentsPagedResponse listHydratedDeployments(DeploymentName parent) {
        ListHydratedDeploymentsRequest request = ListHydratedDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHydratedDeployments(request);
    }

    public final ListHydratedDeploymentsPagedResponse listHydratedDeployments(String parent) {
        ListHydratedDeploymentsRequest request = ListHydratedDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listHydratedDeployments(request);
    }

    public final ListHydratedDeploymentsPagedResponse listHydratedDeployments(ListHydratedDeploymentsRequest request) {
        return (ListHydratedDeploymentsPagedResponse)((Object)this.listHydratedDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHydratedDeploymentsRequest, ListHydratedDeploymentsPagedResponse> listHydratedDeploymentsPagedCallable() {
        return this.stub.listHydratedDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListHydratedDeploymentsRequest, ListHydratedDeploymentsResponse> listHydratedDeploymentsCallable() {
        return this.stub.listHydratedDeploymentsCallable();
    }

    public final HydratedDeployment updateHydratedDeployment(HydratedDeployment hydratedDeployment, FieldMask updateMask) {
        UpdateHydratedDeploymentRequest request = UpdateHydratedDeploymentRequest.newBuilder().setHydratedDeployment(hydratedDeployment).setUpdateMask(updateMask).build();
        return this.updateHydratedDeployment(request);
    }

    public final HydratedDeployment updateHydratedDeployment(UpdateHydratedDeploymentRequest request) {
        return (HydratedDeployment)this.updateHydratedDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateHydratedDeploymentRequest, HydratedDeployment> updateHydratedDeploymentCallable() {
        return this.stub.updateHydratedDeploymentCallable();
    }

    public final HydratedDeployment applyHydratedDeployment(HydratedDeploymentName name) {
        ApplyHydratedDeploymentRequest request = ApplyHydratedDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.applyHydratedDeployment(request);
    }

    public final HydratedDeployment applyHydratedDeployment(String name) {
        ApplyHydratedDeploymentRequest request = ApplyHydratedDeploymentRequest.newBuilder().setName(name).build();
        return this.applyHydratedDeployment(request);
    }

    public final HydratedDeployment applyHydratedDeployment(ApplyHydratedDeploymentRequest request) {
        return (HydratedDeployment)this.applyHydratedDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<ApplyHydratedDeploymentRequest, HydratedDeployment> applyHydratedDeploymentCallable() {
        return this.stub.applyHydratedDeploymentCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHydratedDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHydratedDeploymentsRequest, ListHydratedDeploymentsResponse, HydratedDeployment, ListHydratedDeploymentsPage, ListHydratedDeploymentsFixedSizeCollection> {
        private ListHydratedDeploymentsFixedSizeCollection(List<ListHydratedDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHydratedDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListHydratedDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListHydratedDeploymentsFixedSizeCollection createCollection(List<ListHydratedDeploymentsPage> pages, int collectionSize) {
            return new ListHydratedDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHydratedDeploymentsPage
    extends AbstractPage<ListHydratedDeploymentsRequest, ListHydratedDeploymentsResponse, HydratedDeployment, ListHydratedDeploymentsPage> {
        private ListHydratedDeploymentsPage(PageContext<ListHydratedDeploymentsRequest, ListHydratedDeploymentsResponse, HydratedDeployment> context, ListHydratedDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListHydratedDeploymentsPage createEmptyPage() {
            return new ListHydratedDeploymentsPage(null, null);
        }

        protected ListHydratedDeploymentsPage createPage(PageContext<ListHydratedDeploymentsRequest, ListHydratedDeploymentsResponse, HydratedDeployment> context, ListHydratedDeploymentsResponse response) {
            return new ListHydratedDeploymentsPage(context, response);
        }

        public ApiFuture<ListHydratedDeploymentsPage> createPageAsync(PageContext<ListHydratedDeploymentsRequest, ListHydratedDeploymentsResponse, HydratedDeployment> context, ApiFuture<ListHydratedDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHydratedDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListHydratedDeploymentsRequest, ListHydratedDeploymentsResponse, HydratedDeployment, ListHydratedDeploymentsPage, ListHydratedDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListHydratedDeploymentsPagedResponse> createAsync(PageContext<ListHydratedDeploymentsRequest, ListHydratedDeploymentsResponse, HydratedDeployment> context, ApiFuture<ListHydratedDeploymentsResponse> futureResponse) {
            ApiFuture<ListHydratedDeploymentsPage> futurePage = ListHydratedDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHydratedDeploymentsPagedResponse((ListHydratedDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHydratedDeploymentsPagedResponse(ListHydratedDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHydratedDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeploymentRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeploymentRevisionsRequest, ListDeploymentRevisionsResponse, Deployment, ListDeploymentRevisionsPage, ListDeploymentRevisionsFixedSizeCollection> {
        private ListDeploymentRevisionsFixedSizeCollection(List<ListDeploymentRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeploymentRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListDeploymentRevisionsFixedSizeCollection(null, 0);
        }

        protected ListDeploymentRevisionsFixedSizeCollection createCollection(List<ListDeploymentRevisionsPage> pages, int collectionSize) {
            return new ListDeploymentRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeploymentRevisionsPage
    extends AbstractPage<ListDeploymentRevisionsRequest, ListDeploymentRevisionsResponse, Deployment, ListDeploymentRevisionsPage> {
        private ListDeploymentRevisionsPage(PageContext<ListDeploymentRevisionsRequest, ListDeploymentRevisionsResponse, Deployment> context, ListDeploymentRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeploymentRevisionsPage createEmptyPage() {
            return new ListDeploymentRevisionsPage(null, null);
        }

        protected ListDeploymentRevisionsPage createPage(PageContext<ListDeploymentRevisionsRequest, ListDeploymentRevisionsResponse, Deployment> context, ListDeploymentRevisionsResponse response) {
            return new ListDeploymentRevisionsPage(context, response);
        }

        public ApiFuture<ListDeploymentRevisionsPage> createPageAsync(PageContext<ListDeploymentRevisionsRequest, ListDeploymentRevisionsResponse, Deployment> context, ApiFuture<ListDeploymentRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeploymentRevisionsPagedResponse
    extends AbstractPagedListResponse<ListDeploymentRevisionsRequest, ListDeploymentRevisionsResponse, Deployment, ListDeploymentRevisionsPage, ListDeploymentRevisionsFixedSizeCollection> {
        public static ApiFuture<ListDeploymentRevisionsPagedResponse> createAsync(PageContext<ListDeploymentRevisionsRequest, ListDeploymentRevisionsResponse, Deployment> context, ApiFuture<ListDeploymentRevisionsResponse> futureResponse) {
            ApiFuture<ListDeploymentRevisionsPage> futurePage = ListDeploymentRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeploymentRevisionsPagedResponse((ListDeploymentRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeploymentRevisionsPagedResponse(ListDeploymentRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeploymentRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        private ListDeploymentsFixedSizeCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListDeploymentsFixedSizeCollection createCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            return new ListDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeploymentsPage
    extends AbstractPage<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage> {
        private ListDeploymentsPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeploymentsPage createEmptyPage() {
            return new ListDeploymentsPage(null, null);
        }

        protected ListDeploymentsPage createPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            return new ListDeploymentsPage(context, response);
        }

        public ApiFuture<ListDeploymentsPage> createPageAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListDeploymentsPagedResponse> createAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            ApiFuture<ListDeploymentsPage> futurePage = ListDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeploymentsPagedResponse((ListDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeploymentsPagedResponse(ListDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPublicBlueprintsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPublicBlueprintsRequest, ListPublicBlueprintsResponse, PublicBlueprint, ListPublicBlueprintsPage, ListPublicBlueprintsFixedSizeCollection> {
        private ListPublicBlueprintsFixedSizeCollection(List<ListPublicBlueprintsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPublicBlueprintsFixedSizeCollection createEmptyCollection() {
            return new ListPublicBlueprintsFixedSizeCollection(null, 0);
        }

        protected ListPublicBlueprintsFixedSizeCollection createCollection(List<ListPublicBlueprintsPage> pages, int collectionSize) {
            return new ListPublicBlueprintsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPublicBlueprintsPage
    extends AbstractPage<ListPublicBlueprintsRequest, ListPublicBlueprintsResponse, PublicBlueprint, ListPublicBlueprintsPage> {
        private ListPublicBlueprintsPage(PageContext<ListPublicBlueprintsRequest, ListPublicBlueprintsResponse, PublicBlueprint> context, ListPublicBlueprintsResponse response) {
            super(context, (Object)response);
        }

        private static ListPublicBlueprintsPage createEmptyPage() {
            return new ListPublicBlueprintsPage(null, null);
        }

        protected ListPublicBlueprintsPage createPage(PageContext<ListPublicBlueprintsRequest, ListPublicBlueprintsResponse, PublicBlueprint> context, ListPublicBlueprintsResponse response) {
            return new ListPublicBlueprintsPage(context, response);
        }

        public ApiFuture<ListPublicBlueprintsPage> createPageAsync(PageContext<ListPublicBlueprintsRequest, ListPublicBlueprintsResponse, PublicBlueprint> context, ApiFuture<ListPublicBlueprintsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPublicBlueprintsPagedResponse
    extends AbstractPagedListResponse<ListPublicBlueprintsRequest, ListPublicBlueprintsResponse, PublicBlueprint, ListPublicBlueprintsPage, ListPublicBlueprintsFixedSizeCollection> {
        public static ApiFuture<ListPublicBlueprintsPagedResponse> createAsync(PageContext<ListPublicBlueprintsRequest, ListPublicBlueprintsResponse, PublicBlueprint> context, ApiFuture<ListPublicBlueprintsResponse> futureResponse) {
            ApiFuture<ListPublicBlueprintsPage> futurePage = ListPublicBlueprintsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPublicBlueprintsPagedResponse((ListPublicBlueprintsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPublicBlueprintsPagedResponse(ListPublicBlueprintsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPublicBlueprintsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchDeploymentRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsResponse, Deployment, SearchDeploymentRevisionsPage, SearchDeploymentRevisionsFixedSizeCollection> {
        private SearchDeploymentRevisionsFixedSizeCollection(List<SearchDeploymentRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchDeploymentRevisionsFixedSizeCollection createEmptyCollection() {
            return new SearchDeploymentRevisionsFixedSizeCollection(null, 0);
        }

        protected SearchDeploymentRevisionsFixedSizeCollection createCollection(List<SearchDeploymentRevisionsPage> pages, int collectionSize) {
            return new SearchDeploymentRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchDeploymentRevisionsPage
    extends AbstractPage<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsResponse, Deployment, SearchDeploymentRevisionsPage> {
        private SearchDeploymentRevisionsPage(PageContext<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsResponse, Deployment> context, SearchDeploymentRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static SearchDeploymentRevisionsPage createEmptyPage() {
            return new SearchDeploymentRevisionsPage(null, null);
        }

        protected SearchDeploymentRevisionsPage createPage(PageContext<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsResponse, Deployment> context, SearchDeploymentRevisionsResponse response) {
            return new SearchDeploymentRevisionsPage(context, response);
        }

        public ApiFuture<SearchDeploymentRevisionsPage> createPageAsync(PageContext<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsResponse, Deployment> context, ApiFuture<SearchDeploymentRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchDeploymentRevisionsPagedResponse
    extends AbstractPagedListResponse<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsResponse, Deployment, SearchDeploymentRevisionsPage, SearchDeploymentRevisionsFixedSizeCollection> {
        public static ApiFuture<SearchDeploymentRevisionsPagedResponse> createAsync(PageContext<SearchDeploymentRevisionsRequest, SearchDeploymentRevisionsResponse, Deployment> context, ApiFuture<SearchDeploymentRevisionsResponse> futureResponse) {
            ApiFuture<SearchDeploymentRevisionsPage> futurePage = SearchDeploymentRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchDeploymentRevisionsPagedResponse((SearchDeploymentRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchDeploymentRevisionsPagedResponse(SearchDeploymentRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchDeploymentRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchBlueprintRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsResponse, Blueprint, SearchBlueprintRevisionsPage, SearchBlueprintRevisionsFixedSizeCollection> {
        private SearchBlueprintRevisionsFixedSizeCollection(List<SearchBlueprintRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchBlueprintRevisionsFixedSizeCollection createEmptyCollection() {
            return new SearchBlueprintRevisionsFixedSizeCollection(null, 0);
        }

        protected SearchBlueprintRevisionsFixedSizeCollection createCollection(List<SearchBlueprintRevisionsPage> pages, int collectionSize) {
            return new SearchBlueprintRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchBlueprintRevisionsPage
    extends AbstractPage<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsResponse, Blueprint, SearchBlueprintRevisionsPage> {
        private SearchBlueprintRevisionsPage(PageContext<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsResponse, Blueprint> context, SearchBlueprintRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static SearchBlueprintRevisionsPage createEmptyPage() {
            return new SearchBlueprintRevisionsPage(null, null);
        }

        protected SearchBlueprintRevisionsPage createPage(PageContext<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsResponse, Blueprint> context, SearchBlueprintRevisionsResponse response) {
            return new SearchBlueprintRevisionsPage(context, response);
        }

        public ApiFuture<SearchBlueprintRevisionsPage> createPageAsync(PageContext<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsResponse, Blueprint> context, ApiFuture<SearchBlueprintRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchBlueprintRevisionsPagedResponse
    extends AbstractPagedListResponse<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsResponse, Blueprint, SearchBlueprintRevisionsPage, SearchBlueprintRevisionsFixedSizeCollection> {
        public static ApiFuture<SearchBlueprintRevisionsPagedResponse> createAsync(PageContext<SearchBlueprintRevisionsRequest, SearchBlueprintRevisionsResponse, Blueprint> context, ApiFuture<SearchBlueprintRevisionsResponse> futureResponse) {
            ApiFuture<SearchBlueprintRevisionsPage> futurePage = SearchBlueprintRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchBlueprintRevisionsPagedResponse((SearchBlueprintRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchBlueprintRevisionsPagedResponse(SearchBlueprintRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchBlueprintRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBlueprintRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBlueprintRevisionsRequest, ListBlueprintRevisionsResponse, Blueprint, ListBlueprintRevisionsPage, ListBlueprintRevisionsFixedSizeCollection> {
        private ListBlueprintRevisionsFixedSizeCollection(List<ListBlueprintRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBlueprintRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListBlueprintRevisionsFixedSizeCollection(null, 0);
        }

        protected ListBlueprintRevisionsFixedSizeCollection createCollection(List<ListBlueprintRevisionsPage> pages, int collectionSize) {
            return new ListBlueprintRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBlueprintRevisionsPage
    extends AbstractPage<ListBlueprintRevisionsRequest, ListBlueprintRevisionsResponse, Blueprint, ListBlueprintRevisionsPage> {
        private ListBlueprintRevisionsPage(PageContext<ListBlueprintRevisionsRequest, ListBlueprintRevisionsResponse, Blueprint> context, ListBlueprintRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListBlueprintRevisionsPage createEmptyPage() {
            return new ListBlueprintRevisionsPage(null, null);
        }

        protected ListBlueprintRevisionsPage createPage(PageContext<ListBlueprintRevisionsRequest, ListBlueprintRevisionsResponse, Blueprint> context, ListBlueprintRevisionsResponse response) {
            return new ListBlueprintRevisionsPage(context, response);
        }

        public ApiFuture<ListBlueprintRevisionsPage> createPageAsync(PageContext<ListBlueprintRevisionsRequest, ListBlueprintRevisionsResponse, Blueprint> context, ApiFuture<ListBlueprintRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBlueprintRevisionsPagedResponse
    extends AbstractPagedListResponse<ListBlueprintRevisionsRequest, ListBlueprintRevisionsResponse, Blueprint, ListBlueprintRevisionsPage, ListBlueprintRevisionsFixedSizeCollection> {
        public static ApiFuture<ListBlueprintRevisionsPagedResponse> createAsync(PageContext<ListBlueprintRevisionsRequest, ListBlueprintRevisionsResponse, Blueprint> context, ApiFuture<ListBlueprintRevisionsResponse> futureResponse) {
            ApiFuture<ListBlueprintRevisionsPage> futurePage = ListBlueprintRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBlueprintRevisionsPagedResponse((ListBlueprintRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBlueprintRevisionsPagedResponse(ListBlueprintRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBlueprintRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBlueprintsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBlueprintsRequest, ListBlueprintsResponse, Blueprint, ListBlueprintsPage, ListBlueprintsFixedSizeCollection> {
        private ListBlueprintsFixedSizeCollection(List<ListBlueprintsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBlueprintsFixedSizeCollection createEmptyCollection() {
            return new ListBlueprintsFixedSizeCollection(null, 0);
        }

        protected ListBlueprintsFixedSizeCollection createCollection(List<ListBlueprintsPage> pages, int collectionSize) {
            return new ListBlueprintsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBlueprintsPage
    extends AbstractPage<ListBlueprintsRequest, ListBlueprintsResponse, Blueprint, ListBlueprintsPage> {
        private ListBlueprintsPage(PageContext<ListBlueprintsRequest, ListBlueprintsResponse, Blueprint> context, ListBlueprintsResponse response) {
            super(context, (Object)response);
        }

        private static ListBlueprintsPage createEmptyPage() {
            return new ListBlueprintsPage(null, null);
        }

        protected ListBlueprintsPage createPage(PageContext<ListBlueprintsRequest, ListBlueprintsResponse, Blueprint> context, ListBlueprintsResponse response) {
            return new ListBlueprintsPage(context, response);
        }

        public ApiFuture<ListBlueprintsPage> createPageAsync(PageContext<ListBlueprintsRequest, ListBlueprintsResponse, Blueprint> context, ApiFuture<ListBlueprintsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBlueprintsPagedResponse
    extends AbstractPagedListResponse<ListBlueprintsRequest, ListBlueprintsResponse, Blueprint, ListBlueprintsPage, ListBlueprintsFixedSizeCollection> {
        public static ApiFuture<ListBlueprintsPagedResponse> createAsync(PageContext<ListBlueprintsRequest, ListBlueprintsResponse, Blueprint> context, ApiFuture<ListBlueprintsResponse> futureResponse) {
            ApiFuture<ListBlueprintsPage> futurePage = ListBlueprintsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBlueprintsPagedResponse((ListBlueprintsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBlueprintsPagedResponse(ListBlueprintsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBlueprintsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEdgeSlmsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEdgeSlmsRequest, ListEdgeSlmsResponse, EdgeSlm, ListEdgeSlmsPage, ListEdgeSlmsFixedSizeCollection> {
        private ListEdgeSlmsFixedSizeCollection(List<ListEdgeSlmsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEdgeSlmsFixedSizeCollection createEmptyCollection() {
            return new ListEdgeSlmsFixedSizeCollection(null, 0);
        }

        protected ListEdgeSlmsFixedSizeCollection createCollection(List<ListEdgeSlmsPage> pages, int collectionSize) {
            return new ListEdgeSlmsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEdgeSlmsPage
    extends AbstractPage<ListEdgeSlmsRequest, ListEdgeSlmsResponse, EdgeSlm, ListEdgeSlmsPage> {
        private ListEdgeSlmsPage(PageContext<ListEdgeSlmsRequest, ListEdgeSlmsResponse, EdgeSlm> context, ListEdgeSlmsResponse response) {
            super(context, (Object)response);
        }

        private static ListEdgeSlmsPage createEmptyPage() {
            return new ListEdgeSlmsPage(null, null);
        }

        protected ListEdgeSlmsPage createPage(PageContext<ListEdgeSlmsRequest, ListEdgeSlmsResponse, EdgeSlm> context, ListEdgeSlmsResponse response) {
            return new ListEdgeSlmsPage(context, response);
        }

        public ApiFuture<ListEdgeSlmsPage> createPageAsync(PageContext<ListEdgeSlmsRequest, ListEdgeSlmsResponse, EdgeSlm> context, ApiFuture<ListEdgeSlmsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEdgeSlmsPagedResponse
    extends AbstractPagedListResponse<ListEdgeSlmsRequest, ListEdgeSlmsResponse, EdgeSlm, ListEdgeSlmsPage, ListEdgeSlmsFixedSizeCollection> {
        public static ApiFuture<ListEdgeSlmsPagedResponse> createAsync(PageContext<ListEdgeSlmsRequest, ListEdgeSlmsResponse, EdgeSlm> context, ApiFuture<ListEdgeSlmsResponse> futureResponse) {
            ApiFuture<ListEdgeSlmsPage> futurePage = ListEdgeSlmsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEdgeSlmsPagedResponse((ListEdgeSlmsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEdgeSlmsPagedResponse(ListEdgeSlmsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEdgeSlmsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOrchestrationClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrchestrationClustersRequest, ListOrchestrationClustersResponse, OrchestrationCluster, ListOrchestrationClustersPage, ListOrchestrationClustersFixedSizeCollection> {
        private ListOrchestrationClustersFixedSizeCollection(List<ListOrchestrationClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrchestrationClustersFixedSizeCollection createEmptyCollection() {
            return new ListOrchestrationClustersFixedSizeCollection(null, 0);
        }

        protected ListOrchestrationClustersFixedSizeCollection createCollection(List<ListOrchestrationClustersPage> pages, int collectionSize) {
            return new ListOrchestrationClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrchestrationClustersPage
    extends AbstractPage<ListOrchestrationClustersRequest, ListOrchestrationClustersResponse, OrchestrationCluster, ListOrchestrationClustersPage> {
        private ListOrchestrationClustersPage(PageContext<ListOrchestrationClustersRequest, ListOrchestrationClustersResponse, OrchestrationCluster> context, ListOrchestrationClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListOrchestrationClustersPage createEmptyPage() {
            return new ListOrchestrationClustersPage(null, null);
        }

        protected ListOrchestrationClustersPage createPage(PageContext<ListOrchestrationClustersRequest, ListOrchestrationClustersResponse, OrchestrationCluster> context, ListOrchestrationClustersResponse response) {
            return new ListOrchestrationClustersPage(context, response);
        }

        public ApiFuture<ListOrchestrationClustersPage> createPageAsync(PageContext<ListOrchestrationClustersRequest, ListOrchestrationClustersResponse, OrchestrationCluster> context, ApiFuture<ListOrchestrationClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrchestrationClustersPagedResponse
    extends AbstractPagedListResponse<ListOrchestrationClustersRequest, ListOrchestrationClustersResponse, OrchestrationCluster, ListOrchestrationClustersPage, ListOrchestrationClustersFixedSizeCollection> {
        public static ApiFuture<ListOrchestrationClustersPagedResponse> createAsync(PageContext<ListOrchestrationClustersRequest, ListOrchestrationClustersResponse, OrchestrationCluster> context, ApiFuture<ListOrchestrationClustersResponse> futureResponse) {
            ApiFuture<ListOrchestrationClustersPage> futurePage = ListOrchestrationClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrchestrationClustersPagedResponse((ListOrchestrationClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrchestrationClustersPagedResponse(ListOrchestrationClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrchestrationClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

