/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tasks.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.tasks.v2.CloudTasksClient;
import com.google.cloud.tasks.v2.CreateQueueRequest;
import com.google.cloud.tasks.v2.CreateTaskRequest;
import com.google.cloud.tasks.v2.DeleteQueueRequest;
import com.google.cloud.tasks.v2.DeleteTaskRequest;
import com.google.cloud.tasks.v2.GetQueueRequest;
import com.google.cloud.tasks.v2.GetTaskRequest;
import com.google.cloud.tasks.v2.ListQueuesRequest;
import com.google.cloud.tasks.v2.ListQueuesResponse;
import com.google.cloud.tasks.v2.ListTasksRequest;
import com.google.cloud.tasks.v2.ListTasksResponse;
import com.google.cloud.tasks.v2.PauseQueueRequest;
import com.google.cloud.tasks.v2.PurgeQueueRequest;
import com.google.cloud.tasks.v2.Queue;
import com.google.cloud.tasks.v2.ResumeQueueRequest;
import com.google.cloud.tasks.v2.RunTaskRequest;
import com.google.cloud.tasks.v2.Task;
import com.google.cloud.tasks.v2.UpdateQueueRequest;
import com.google.cloud.tasks.v2.stub.CloudTasksStub;
import com.google.cloud.tasks.v2.stub.GrpcCloudTasksStub;
import com.google.cloud.tasks.v2.stub.HttpJsonCloudTasksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudTasksStubSettings
extends StubSettings<CloudTasksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListQueuesRequest, ListQueuesResponse, CloudTasksClient.ListQueuesPagedResponse> listQueuesSettings;
    private final UnaryCallSettings<GetQueueRequest, Queue> getQueueSettings;
    private final UnaryCallSettings<CreateQueueRequest, Queue> createQueueSettings;
    private final UnaryCallSettings<UpdateQueueRequest, Queue> updateQueueSettings;
    private final UnaryCallSettings<DeleteQueueRequest, Empty> deleteQueueSettings;
    private final UnaryCallSettings<PurgeQueueRequest, Queue> purgeQueueSettings;
    private final UnaryCallSettings<PauseQueueRequest, Queue> pauseQueueSettings;
    private final UnaryCallSettings<ResumeQueueRequest, Queue> resumeQueueSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final PagedCallSettings<ListTasksRequest, ListTasksResponse, CloudTasksClient.ListTasksPagedResponse> listTasksSettings;
    private final UnaryCallSettings<GetTaskRequest, Task> getTaskSettings;
    private final UnaryCallSettings<CreateTaskRequest, Task> createTaskSettings;
    private final UnaryCallSettings<DeleteTaskRequest, Empty> deleteTaskSettings;
    private final UnaryCallSettings<RunTaskRequest, Task> runTaskSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CloudTasksClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListQueuesRequest, ListQueuesResponse, Queue> LIST_QUEUES_PAGE_STR_DESC = new PagedListDescriptor<ListQueuesRequest, ListQueuesResponse, Queue>(){

        public String emptyToken() {
            return "";
        }

        public ListQueuesRequest injectToken(ListQueuesRequest payload, String token) {
            return ListQueuesRequest.newBuilder((ListQueuesRequest)payload).setPageToken(token).build();
        }

        public ListQueuesRequest injectPageSize(ListQueuesRequest payload, int pageSize) {
            return ListQueuesRequest.newBuilder((ListQueuesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListQueuesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListQueuesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Queue> extractResources(ListQueuesResponse payload) {
            return payload.getQueuesList();
        }
    };
    private static final PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task> LIST_TASKS_PAGE_STR_DESC = new PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task>(){

        public String emptyToken() {
            return "";
        }

        public ListTasksRequest injectToken(ListTasksRequest payload, String token) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageToken(token).build();
        }

        public ListTasksRequest injectPageSize(ListTasksRequest payload, int pageSize) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTasksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTasksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Task> extractResources(ListTasksResponse payload) {
            return payload.getTasksList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListQueuesRequest, ListQueuesResponse, CloudTasksClient.ListQueuesPagedResponse> LIST_QUEUES_PAGE_STR_FACT = new PagedListResponseFactory<ListQueuesRequest, ListQueuesResponse, CloudTasksClient.ListQueuesPagedResponse>(){

        public ApiFuture<CloudTasksClient.ListQueuesPagedResponse> getFuturePagedResponse(UnaryCallable<ListQueuesRequest, ListQueuesResponse> callable, ListQueuesRequest request, ApiCallContext context, ApiFuture<ListQueuesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_QUEUES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudTasksClient.ListQueuesPagedResponse.createAsync((PageContext<ListQueuesRequest, ListQueuesResponse, Queue>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTasksRequest, ListTasksResponse, CloudTasksClient.ListTasksPagedResponse> LIST_TASKS_PAGE_STR_FACT = new PagedListResponseFactory<ListTasksRequest, ListTasksResponse, CloudTasksClient.ListTasksPagedResponse>(){

        public ApiFuture<CloudTasksClient.ListTasksPagedResponse> getFuturePagedResponse(UnaryCallable<ListTasksRequest, ListTasksResponse> callable, ListTasksRequest request, ApiCallContext context, ApiFuture<ListTasksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TASKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudTasksClient.ListTasksPagedResponse.createAsync((PageContext<ListTasksRequest, ListTasksResponse, Task>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CloudTasksClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CloudTasksClient.ListLocationsPagedResponse>(){

        public ApiFuture<CloudTasksClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudTasksClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListQueuesRequest, ListQueuesResponse, CloudTasksClient.ListQueuesPagedResponse> listQueuesSettings() {
        return this.listQueuesSettings;
    }

    public UnaryCallSettings<GetQueueRequest, Queue> getQueueSettings() {
        return this.getQueueSettings;
    }

    public UnaryCallSettings<CreateQueueRequest, Queue> createQueueSettings() {
        return this.createQueueSettings;
    }

    public UnaryCallSettings<UpdateQueueRequest, Queue> updateQueueSettings() {
        return this.updateQueueSettings;
    }

    public UnaryCallSettings<DeleteQueueRequest, Empty> deleteQueueSettings() {
        return this.deleteQueueSettings;
    }

    public UnaryCallSettings<PurgeQueueRequest, Queue> purgeQueueSettings() {
        return this.purgeQueueSettings;
    }

    public UnaryCallSettings<PauseQueueRequest, Queue> pauseQueueSettings() {
        return this.pauseQueueSettings;
    }

    public UnaryCallSettings<ResumeQueueRequest, Queue> resumeQueueSettings() {
        return this.resumeQueueSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public PagedCallSettings<ListTasksRequest, ListTasksResponse, CloudTasksClient.ListTasksPagedResponse> listTasksSettings() {
        return this.listTasksSettings;
    }

    public UnaryCallSettings<GetTaskRequest, Task> getTaskSettings() {
        return this.getTaskSettings;
    }

    public UnaryCallSettings<CreateTaskRequest, Task> createTaskSettings() {
        return this.createTaskSettings;
    }

    public UnaryCallSettings<DeleteTaskRequest, Empty> deleteTaskSettings() {
        return this.deleteTaskSettings;
    }

    public UnaryCallSettings<RunTaskRequest, Task> runTaskSettings() {
        return this.runTaskSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CloudTasksClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public CloudTasksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudTasksStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudTasksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudtasks";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudtasks.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudtasks.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudTasksStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudTasksStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudTasksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudTasksStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudTasksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listQueuesSettings = settingsBuilder.listQueuesSettings().build();
        this.getQueueSettings = settingsBuilder.getQueueSettings().build();
        this.createQueueSettings = settingsBuilder.createQueueSettings().build();
        this.updateQueueSettings = settingsBuilder.updateQueueSettings().build();
        this.deleteQueueSettings = settingsBuilder.deleteQueueSettings().build();
        this.purgeQueueSettings = settingsBuilder.purgeQueueSettings().build();
        this.pauseQueueSettings = settingsBuilder.pauseQueueSettings().build();
        this.resumeQueueSettings = settingsBuilder.resumeQueueSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.listTasksSettings = settingsBuilder.listTasksSettings().build();
        this.getTaskSettings = settingsBuilder.getTaskSettings().build();
        this.createTaskSettings = settingsBuilder.createTaskSettings().build();
        this.deleteTaskSettings = settingsBuilder.deleteTaskSettings().build();
        this.runTaskSettings = settingsBuilder.runTaskSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudTasksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListQueuesRequest, ListQueuesResponse, CloudTasksClient.ListQueuesPagedResponse> listQueuesSettings;
        private final UnaryCallSettings.Builder<GetQueueRequest, Queue> getQueueSettings;
        private final UnaryCallSettings.Builder<CreateQueueRequest, Queue> createQueueSettings;
        private final UnaryCallSettings.Builder<UpdateQueueRequest, Queue> updateQueueSettings;
        private final UnaryCallSettings.Builder<DeleteQueueRequest, Empty> deleteQueueSettings;
        private final UnaryCallSettings.Builder<PurgeQueueRequest, Queue> purgeQueueSettings;
        private final UnaryCallSettings.Builder<PauseQueueRequest, Queue> pauseQueueSettings;
        private final UnaryCallSettings.Builder<ResumeQueueRequest, Queue> resumeQueueSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, CloudTasksClient.ListTasksPagedResponse> listTasksSettings;
        private final UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings;
        private final UnaryCallSettings.Builder<CreateTaskRequest, Task> createTaskSettings;
        private final UnaryCallSettings.Builder<DeleteTaskRequest, Empty> deleteTaskSettings;
        private final UnaryCallSettings.Builder<RunTaskRequest, Task> runTaskSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CloudTasksClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listQueuesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_QUEUES_PAGE_STR_FACT);
            this.getQueueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createQueueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateQueueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteQueueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.purgeQueueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pauseQueueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeQueueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTasksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TASKS_PAGE_STR_FACT);
            this.getTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listQueuesSettings, this.getQueueSettings, this.createQueueSettings, this.updateQueueSettings, this.deleteQueueSettings, this.purgeQueueSettings, this.pauseQueueSettings, this.resumeQueueSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.listTasksSettings, (Object[])new UnaryCallSettings.Builder[]{this.getTaskSettings, this.createTaskSettings, this.deleteTaskSettings, this.runTaskSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CloudTasksStubSettings settings) {
            super((StubSettings)settings);
            this.listQueuesSettings = settings.listQueuesSettings.toBuilder();
            this.getQueueSettings = settings.getQueueSettings.toBuilder();
            this.createQueueSettings = settings.createQueueSettings.toBuilder();
            this.updateQueueSettings = settings.updateQueueSettings.toBuilder();
            this.deleteQueueSettings = settings.deleteQueueSettings.toBuilder();
            this.purgeQueueSettings = settings.purgeQueueSettings.toBuilder();
            this.pauseQueueSettings = settings.pauseQueueSettings.toBuilder();
            this.resumeQueueSettings = settings.resumeQueueSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.listTasksSettings = settings.listTasksSettings.toBuilder();
            this.getTaskSettings = settings.getTaskSettings.toBuilder();
            this.createTaskSettings = settings.createTaskSettings.toBuilder();
            this.deleteTaskSettings = settings.deleteTaskSettings.toBuilder();
            this.runTaskSettings = settings.runTaskSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listQueuesSettings, this.getQueueSettings, this.createQueueSettings, this.updateQueueSettings, this.deleteQueueSettings, this.purgeQueueSettings, this.pauseQueueSettings, this.resumeQueueSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.listTasksSettings, (Object[])new UnaryCallSettings.Builder[]{this.getTaskSettings, this.createTaskSettings, this.deleteTaskSettings, this.runTaskSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudTasksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudTasksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudTasksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudTasksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudTasksStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudTasksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudTasksStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudTasksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listQueuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getQueueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createQueueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateQueueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteQueueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.purgeQueueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.pauseQueueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resumeQueueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTasksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.runTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListQueuesRequest, ListQueuesResponse, CloudTasksClient.ListQueuesPagedResponse> listQueuesSettings() {
            return this.listQueuesSettings;
        }

        public UnaryCallSettings.Builder<GetQueueRequest, Queue> getQueueSettings() {
            return this.getQueueSettings;
        }

        public UnaryCallSettings.Builder<CreateQueueRequest, Queue> createQueueSettings() {
            return this.createQueueSettings;
        }

        public UnaryCallSettings.Builder<UpdateQueueRequest, Queue> updateQueueSettings() {
            return this.updateQueueSettings;
        }

        public UnaryCallSettings.Builder<DeleteQueueRequest, Empty> deleteQueueSettings() {
            return this.deleteQueueSettings;
        }

        public UnaryCallSettings.Builder<PurgeQueueRequest, Queue> purgeQueueSettings() {
            return this.purgeQueueSettings;
        }

        public UnaryCallSettings.Builder<PauseQueueRequest, Queue> pauseQueueSettings() {
            return this.pauseQueueSettings;
        }

        public UnaryCallSettings.Builder<ResumeQueueRequest, Queue> resumeQueueSettings() {
            return this.resumeQueueSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, CloudTasksClient.ListTasksPagedResponse> listTasksSettings() {
            return this.listTasksSettings;
        }

        public UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings() {
            return this.getTaskSettings;
        }

        public UnaryCallSettings.Builder<CreateTaskRequest, Task> createTaskSettings() {
            return this.createTaskSettings;
        }

        public UnaryCallSettings.Builder<DeleteTaskRequest, Empty> deleteTaskSettings() {
            return this.deleteTaskSettings;
        }

        public UnaryCallSettings.Builder<RunTaskRequest, Task> runTaskSettings() {
            return this.runTaskSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CloudTasksClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public CloudTasksStubSettings build() throws IOException {
            return new CloudTasksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)20000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)20000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

