/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4.Company;
import com.google.cloud.talent.v4.CompanyServiceClient;
import com.google.cloud.talent.v4.CreateCompanyRequest;
import com.google.cloud.talent.v4.DeleteCompanyRequest;
import com.google.cloud.talent.v4.GetCompanyRequest;
import com.google.cloud.talent.v4.ListCompaniesRequest;
import com.google.cloud.talent.v4.ListCompaniesResponse;
import com.google.cloud.talent.v4.UpdateCompanyRequest;
import com.google.cloud.talent.v4.stub.CompanyServiceStub;
import com.google.cloud.talent.v4.stub.GrpcCompanyServiceStub;
import com.google.cloud.talent.v4.stub.HttpJsonCompanyServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CompanyServiceStubSettings
extends StubSettings<CompanyServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/jobs").build();
    private final UnaryCallSettings<CreateCompanyRequest, Company> createCompanySettings;
    private final UnaryCallSettings<GetCompanyRequest, Company> getCompanySettings;
    private final UnaryCallSettings<UpdateCompanyRequest, Company> updateCompanySettings;
    private final UnaryCallSettings<DeleteCompanyRequest, Empty> deleteCompanySettings;
    private final PagedCallSettings<ListCompaniesRequest, ListCompaniesResponse, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesSettings;
    private static final PagedListDescriptor<ListCompaniesRequest, ListCompaniesResponse, Company> LIST_COMPANIES_PAGE_STR_DESC = new PagedListDescriptor<ListCompaniesRequest, ListCompaniesResponse, Company>(){

        public String emptyToken() {
            return "";
        }

        public ListCompaniesRequest injectToken(ListCompaniesRequest payload, String token) {
            return ListCompaniesRequest.newBuilder((ListCompaniesRequest)payload).setPageToken(token).build();
        }

        public ListCompaniesRequest injectPageSize(ListCompaniesRequest payload, int pageSize) {
            return ListCompaniesRequest.newBuilder((ListCompaniesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCompaniesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCompaniesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Company> extractResources(ListCompaniesResponse payload) {
            return payload.getCompaniesList() == null ? ImmutableList.of() : payload.getCompaniesList();
        }
    };
    private static final PagedListResponseFactory<ListCompaniesRequest, ListCompaniesResponse, CompanyServiceClient.ListCompaniesPagedResponse> LIST_COMPANIES_PAGE_STR_FACT = new PagedListResponseFactory<ListCompaniesRequest, ListCompaniesResponse, CompanyServiceClient.ListCompaniesPagedResponse>(){

        public ApiFuture<CompanyServiceClient.ListCompaniesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCompaniesRequest, ListCompaniesResponse> callable, ListCompaniesRequest request, ApiCallContext context, ApiFuture<ListCompaniesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_COMPANIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CompanyServiceClient.ListCompaniesPagedResponse.createAsync((PageContext<ListCompaniesRequest, ListCompaniesResponse, Company>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateCompanyRequest, Company> createCompanySettings() {
        return this.createCompanySettings;
    }

    public UnaryCallSettings<GetCompanyRequest, Company> getCompanySettings() {
        return this.getCompanySettings;
    }

    public UnaryCallSettings<UpdateCompanyRequest, Company> updateCompanySettings() {
        return this.updateCompanySettings;
    }

    public UnaryCallSettings<DeleteCompanyRequest, Empty> deleteCompanySettings() {
        return this.deleteCompanySettings;
    }

    public PagedCallSettings<ListCompaniesRequest, ListCompaniesResponse, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesSettings() {
        return this.listCompaniesSettings;
    }

    public CompanyServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCompanyServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCompanyServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "jobs";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "jobs.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "jobs.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CompanyServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CompanyServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CompanyServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CompanyServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CompanyServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createCompanySettings = settingsBuilder.createCompanySettings().build();
        this.getCompanySettings = settingsBuilder.getCompanySettings().build();
        this.updateCompanySettings = settingsBuilder.updateCompanySettings().build();
        this.deleteCompanySettings = settingsBuilder.deleteCompanySettings().build();
        this.listCompaniesSettings = settingsBuilder.listCompaniesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CompanyServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateCompanyRequest, Company> createCompanySettings;
        private final UnaryCallSettings.Builder<GetCompanyRequest, Company> getCompanySettings;
        private final UnaryCallSettings.Builder<UpdateCompanyRequest, Company> updateCompanySettings;
        private final UnaryCallSettings.Builder<DeleteCompanyRequest, Empty> deleteCompanySettings;
        private final PagedCallSettings.Builder<ListCompaniesRequest, ListCompaniesResponse, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createCompanySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCompanySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCompanySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCompanySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCompaniesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_COMPANIES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCompanySettings, this.getCompanySettings, this.updateCompanySettings, this.deleteCompanySettings, this.listCompaniesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CompanyServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createCompanySettings = settings.createCompanySettings.toBuilder();
            this.getCompanySettings = settings.getCompanySettings.toBuilder();
            this.updateCompanySettings = settings.updateCompanySettings.toBuilder();
            this.deleteCompanySettings = settings.deleteCompanySettings.toBuilder();
            this.listCompaniesSettings = settings.listCompaniesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCompanySettings, this.getCompanySettings, this.updateCompanySettings, this.deleteCompanySettings, this.listCompaniesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CompanyServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CompanyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CompanyServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CompanyServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CompanyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CompanyServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CompanyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CompanyServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CompanyServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CompanyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createCompanySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.getCompanySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.updateCompanySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.deleteCompanySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.listCompaniesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateCompanyRequest, Company> createCompanySettings() {
            return this.createCompanySettings;
        }

        public UnaryCallSettings.Builder<GetCompanyRequest, Company> getCompanySettings() {
            return this.getCompanySettings;
        }

        public UnaryCallSettings.Builder<UpdateCompanyRequest, Company> updateCompanySettings() {
            return this.updateCompanySettings;
        }

        public UnaryCallSettings.Builder<DeleteCompanyRequest, Empty> deleteCompanySettings() {
            return this.deleteCompanySettings;
        }

        public PagedCallSettings.Builder<ListCompaniesRequest, ListCompaniesResponse, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesSettings() {
            return this.listCompaniesSettings;
        }

        public CompanyServiceStubSettings build() throws IOException {
            return new CompanyServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_5_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_6_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_5_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_6_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

