/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4.BatchCreateJobsRequest;
import com.google.cloud.talent.v4.BatchCreateJobsResponse;
import com.google.cloud.talent.v4.BatchDeleteJobsRequest;
import com.google.cloud.talent.v4.BatchDeleteJobsResponse;
import com.google.cloud.talent.v4.BatchOperationMetadata;
import com.google.cloud.talent.v4.BatchUpdateJobsRequest;
import com.google.cloud.talent.v4.BatchUpdateJobsResponse;
import com.google.cloud.talent.v4.CreateJobRequest;
import com.google.cloud.talent.v4.DeleteJobRequest;
import com.google.cloud.talent.v4.GetJobRequest;
import com.google.cloud.talent.v4.Job;
import com.google.cloud.talent.v4.JobServiceClient;
import com.google.cloud.talent.v4.ListJobsRequest;
import com.google.cloud.talent.v4.ListJobsResponse;
import com.google.cloud.talent.v4.SearchJobsRequest;
import com.google.cloud.talent.v4.SearchJobsResponse;
import com.google.cloud.talent.v4.UpdateJobRequest;
import com.google.cloud.talent.v4.stub.GrpcJobServiceCallableFactory;
import com.google.cloud.talent.v4.stub.JobServiceStub;
import com.google.cloud.talent.v4.stub.JobServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcJobServiceStub
extends JobServiceStub {
    private static final MethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/CreateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchCreateJobsRequest, Operation> batchCreateJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/BatchCreateJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchCreateJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/GetJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/UpdateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchUpdateJobsRequest, Operation> batchUpdateJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/BatchUpdateJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchUpdateJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteJobRequest, Empty> deleteJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/DeleteJob").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchDeleteJobsRequest, Operation> batchDeleteJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/BatchDeleteJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchDeleteJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/ListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchJobsRequest, SearchJobsResponse> searchJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/SearchJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.JobService/SearchJobsForAlert").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchJobsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<BatchCreateJobsRequest, Operation> batchCreateJobsCallable;
    private final OperationCallable<BatchCreateJobsRequest, BatchCreateJobsResponse, BatchOperationMetadata> batchCreateJobsOperationCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<BatchUpdateJobsRequest, Operation> batchUpdateJobsCallable;
    private final OperationCallable<BatchUpdateJobsRequest, BatchUpdateJobsResponse, BatchOperationMetadata> batchUpdateJobsOperationCallable;
    private final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable;
    private final UnaryCallable<BatchDeleteJobsRequest, Operation> batchDeleteJobsCallable;
    private final OperationCallable<BatchDeleteJobsRequest, BatchDeleteJobsResponse, BatchOperationMetadata> batchDeleteJobsOperationCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobServiceClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsCallable;
    private final UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcJobServiceStub create(JobServiceStubSettings settings) throws IOException {
        return new GrpcJobServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcJobServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcJobServiceStub(JobServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcJobServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcJobServiceStub(JobServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcJobServiceStub(JobServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcJobServiceCallableFactory());
    }

    protected GrpcJobServiceStub(JobServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings batchCreateJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("job.name", String.valueOf(request.getJob().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings batchUpdateJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchUpdateJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings batchDeleteJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchDeleteJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings searchJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings searchJobsForAlertTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchJobsForAlertMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.batchCreateJobsCallable = callableFactory.createUnaryCallable(batchCreateJobsTransportSettings, settings.batchCreateJobsSettings(), clientContext);
        this.batchCreateJobsOperationCallable = callableFactory.createOperationCallable(batchCreateJobsTransportSettings, settings.batchCreateJobsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.batchUpdateJobsCallable = callableFactory.createUnaryCallable(batchUpdateJobsTransportSettings, settings.batchUpdateJobsSettings(), clientContext);
        this.batchUpdateJobsOperationCallable = callableFactory.createOperationCallable(batchUpdateJobsTransportSettings, settings.batchUpdateJobsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.batchDeleteJobsCallable = callableFactory.createUnaryCallable(batchDeleteJobsTransportSettings, settings.batchDeleteJobsSettings(), clientContext);
        this.batchDeleteJobsOperationCallable = callableFactory.createOperationCallable(batchDeleteJobsTransportSettings, settings.batchDeleteJobsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.searchJobsCallable = callableFactory.createUnaryCallable(searchJobsTransportSettings, settings.searchJobsSettings(), clientContext);
        this.searchJobsForAlertCallable = callableFactory.createUnaryCallable(searchJobsForAlertTransportSettings, settings.searchJobsForAlertSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<BatchCreateJobsRequest, Operation> batchCreateJobsCallable() {
        return this.batchCreateJobsCallable;
    }

    @Override
    public OperationCallable<BatchCreateJobsRequest, BatchCreateJobsResponse, BatchOperationMetadata> batchCreateJobsOperationCallable() {
        return this.batchCreateJobsOperationCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<BatchUpdateJobsRequest, Operation> batchUpdateJobsCallable() {
        return this.batchUpdateJobsCallable;
    }

    @Override
    public OperationCallable<BatchUpdateJobsRequest, BatchUpdateJobsResponse, BatchOperationMetadata> batchUpdateJobsOperationCallable() {
        return this.batchUpdateJobsOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public UnaryCallable<BatchDeleteJobsRequest, Operation> batchDeleteJobsCallable() {
        return this.batchDeleteJobsCallable;
    }

    @Override
    public OperationCallable<BatchDeleteJobsRequest, BatchDeleteJobsResponse, BatchOperationMetadata> batchDeleteJobsOperationCallable() {
        return this.batchDeleteJobsOperationCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobServiceClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsCallable() {
        return this.searchJobsCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertCallable() {
        return this.searchJobsForAlertCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

