/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.BatchCreateJobsRequest;
import com.google.cloud.talent.v4beta1.BatchDeleteJobsRequest;
import com.google.cloud.talent.v4beta1.BatchOperationMetadata;
import com.google.cloud.talent.v4beta1.BatchUpdateJobsRequest;
import com.google.cloud.talent.v4beta1.CreateJobRequest;
import com.google.cloud.talent.v4beta1.DeleteJobRequest;
import com.google.cloud.talent.v4beta1.GetJobRequest;
import com.google.cloud.talent.v4beta1.Job;
import com.google.cloud.talent.v4beta1.JobOperationResult;
import com.google.cloud.talent.v4beta1.JobServiceClient;
import com.google.cloud.talent.v4beta1.ListJobsRequest;
import com.google.cloud.talent.v4beta1.ListJobsResponse;
import com.google.cloud.talent.v4beta1.SearchJobsRequest;
import com.google.cloud.talent.v4beta1.SearchJobsResponse;
import com.google.cloud.talent.v4beta1.UpdateJobRequest;
import com.google.cloud.talent.v4beta1.stub.GrpcJobServiceCallableFactory;
import com.google.cloud.talent.v4beta1.stub.JobServiceStub;
import com.google.cloud.talent.v4beta1.stub.JobServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcJobServiceStub
extends JobServiceStub {
    private static final MethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/CreateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchCreateJobsRequest, Operation> batchCreateJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/BatchCreateJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchCreateJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/GetJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/UpdateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchUpdateJobsRequest, Operation> batchUpdateJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/BatchUpdateJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchUpdateJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteJobRequest, Empty> deleteJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/DeleteJob").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchDeleteJobsRequest, Empty> batchDeleteJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/BatchDeleteJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchDeleteJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/ListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchJobsRequest, SearchJobsResponse> searchJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/SearchJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.JobService/SearchJobsForAlert").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchJobsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<BatchCreateJobsRequest, Operation> batchCreateJobsCallable;
    private final OperationCallable<BatchCreateJobsRequest, JobOperationResult, BatchOperationMetadata> batchCreateJobsOperationCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<BatchUpdateJobsRequest, Operation> batchUpdateJobsCallable;
    private final OperationCallable<BatchUpdateJobsRequest, JobOperationResult, BatchOperationMetadata> batchUpdateJobsOperationCallable;
    private final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable;
    private final UnaryCallable<BatchDeleteJobsRequest, Empty> batchDeleteJobsCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobServiceClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsCallable;
    private final UnaryCallable<SearchJobsRequest, JobServiceClient.SearchJobsPagedResponse> searchJobsPagedCallable;
    private final UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertCallable;
    private final UnaryCallable<SearchJobsRequest, JobServiceClient.SearchJobsForAlertPagedResponse> searchJobsForAlertPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcJobServiceStub create(JobServiceStubSettings settings) throws IOException {
        return new GrpcJobServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcJobServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcJobServiceStub(JobServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcJobServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcJobServiceStub(JobServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcJobServiceStub(JobServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcJobServiceCallableFactory());
    }

    protected GrpcJobServiceStub(JobServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateJobRequest>(){

            public Map<String, String> extract(CreateJobRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchCreateJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateJobsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchCreateJobsRequest>(){

            public Map<String, String> extract(BatchCreateJobsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetJobRequest>(){

            public Map<String, String> extract(GetJobRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateJobRequest>(){

            public Map<String, String> extract(UpdateJobRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"job.name", (Object)String.valueOf(request.getJob().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchUpdateJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchUpdateJobsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchUpdateJobsRequest>(){

            public Map<String, String> extract(BatchUpdateJobsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteJobRequest>(){

            public Map<String, String> extract(DeleteJobRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchDeleteJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchDeleteJobsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchDeleteJobsRequest>(){

            public Map<String, String> extract(BatchDeleteJobsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListJobsRequest>(){

            public Map<String, String> extract(ListJobsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings searchJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchJobsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SearchJobsRequest>(){

            public Map<String, String> extract(SearchJobsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings searchJobsForAlertTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchJobsForAlertMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SearchJobsRequest>(){

            public Map<String, String> extract(SearchJobsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.batchCreateJobsCallable = callableFactory.createUnaryCallable(batchCreateJobsTransportSettings, settings.batchCreateJobsSettings(), clientContext);
        this.batchCreateJobsOperationCallable = callableFactory.createOperationCallable(batchCreateJobsTransportSettings, settings.batchCreateJobsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.batchUpdateJobsCallable = callableFactory.createUnaryCallable(batchUpdateJobsTransportSettings, settings.batchUpdateJobsSettings(), clientContext);
        this.batchUpdateJobsOperationCallable = callableFactory.createOperationCallable(batchUpdateJobsTransportSettings, settings.batchUpdateJobsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.batchDeleteJobsCallable = callableFactory.createUnaryCallable(batchDeleteJobsTransportSettings, settings.batchDeleteJobsSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.searchJobsCallable = callableFactory.createUnaryCallable(searchJobsTransportSettings, settings.searchJobsSettings(), clientContext);
        this.searchJobsPagedCallable = callableFactory.createPagedCallable(searchJobsTransportSettings, settings.searchJobsSettings(), clientContext);
        this.searchJobsForAlertCallable = callableFactory.createUnaryCallable(searchJobsForAlertTransportSettings, settings.searchJobsForAlertSettings(), clientContext);
        this.searchJobsForAlertPagedCallable = callableFactory.createPagedCallable(searchJobsForAlertTransportSettings, settings.searchJobsForAlertSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<BatchCreateJobsRequest, Operation> batchCreateJobsCallable() {
        return this.batchCreateJobsCallable;
    }

    @Override
    public OperationCallable<BatchCreateJobsRequest, JobOperationResult, BatchOperationMetadata> batchCreateJobsOperationCallable() {
        return this.batchCreateJobsOperationCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<BatchUpdateJobsRequest, Operation> batchUpdateJobsCallable() {
        return this.batchUpdateJobsCallable;
    }

    @Override
    public OperationCallable<BatchUpdateJobsRequest, JobOperationResult, BatchOperationMetadata> batchUpdateJobsOperationCallable() {
        return this.batchUpdateJobsOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public UnaryCallable<BatchDeleteJobsRequest, Empty> batchDeleteJobsCallable() {
        return this.batchDeleteJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobServiceClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsCallable() {
        return this.searchJobsCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, JobServiceClient.SearchJobsPagedResponse> searchJobsPagedCallable() {
        return this.searchJobsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertCallable() {
        return this.searchJobsForAlertCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, JobServiceClient.SearchJobsForAlertPagedResponse> searchJobsForAlertPagedCallable() {
        return this.searchJobsForAlertPagedCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

