/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.ClientEvent;
import com.google.cloud.talent.v4beta1.CreateClientEventRequest;
import com.google.cloud.talent.v4beta1.EventServiceSettings;
import com.google.cloud.talent.v4beta1.TenantOrProjectName;
import com.google.cloud.talent.v4beta1.stub.EventServiceStub;
import com.google.cloud.talent.v4beta1.stub.EventServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EventServiceClient
implements BackgroundResource {
    private final EventServiceSettings settings;
    private final EventServiceStub stub;

    public static final EventServiceClient create() throws IOException {
        return EventServiceClient.create(EventServiceSettings.newBuilder().build());
    }

    public static final EventServiceClient create(EventServiceSettings settings) throws IOException {
        return new EventServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final EventServiceClient create(EventServiceStub stub) {
        return new EventServiceClient(stub);
    }

    protected EventServiceClient(EventServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EventServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected EventServiceClient(EventServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final EventServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EventServiceStub getStub() {
        return this.stub;
    }

    public final ClientEvent createClientEvent(TenantOrProjectName parent, ClientEvent clientEvent) {
        CreateClientEventRequest request = CreateClientEventRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setClientEvent(clientEvent).build();
        return this.createClientEvent(request);
    }

    public final ClientEvent createClientEvent(String parent, ClientEvent clientEvent) {
        CreateClientEventRequest request = CreateClientEventRequest.newBuilder().setParent(parent).setClientEvent(clientEvent).build();
        return this.createClientEvent(request);
    }

    public final ClientEvent createClientEvent(CreateClientEventRequest request) {
        return (ClientEvent)this.createClientEventCallable().call((Object)request);
    }

    public final UnaryCallable<CreateClientEventRequest, ClientEvent> createClientEventCallable() {
        return this.stub.createClientEventCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

