/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.Application;
import com.google.cloud.talent.v4beta1.ApplicationServiceClient;
import com.google.cloud.talent.v4beta1.CreateApplicationRequest;
import com.google.cloud.talent.v4beta1.DeleteApplicationRequest;
import com.google.cloud.talent.v4beta1.GetApplicationRequest;
import com.google.cloud.talent.v4beta1.ListApplicationsRequest;
import com.google.cloud.talent.v4beta1.ListApplicationsResponse;
import com.google.cloud.talent.v4beta1.UpdateApplicationRequest;
import com.google.cloud.talent.v4beta1.stub.ApplicationServiceStub;
import com.google.cloud.talent.v4beta1.stub.ApplicationServiceStubSettings;
import com.google.cloud.talent.v4beta1.stub.GrpcApplicationServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcApplicationServiceStub
extends ApplicationServiceStub {
    private static final MethodDescriptor<CreateApplicationRequest, Application> createApplicationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.ApplicationService/CreateApplication").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateApplicationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Application.getDefaultInstance())).build();
    private static final MethodDescriptor<GetApplicationRequest, Application> getApplicationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.ApplicationService/GetApplication").setRequestMarshaller(ProtoUtils.marshaller((Message)GetApplicationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Application.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateApplicationRequest, Application> updateApplicationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.ApplicationService/UpdateApplication").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateApplicationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Application.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteApplicationRequest, Empty> deleteApplicationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.ApplicationService/DeleteApplication").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteApplicationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListApplicationsRequest, ListApplicationsResponse> listApplicationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.ApplicationService/ListApplications").setRequestMarshaller(ProtoUtils.marshaller((Message)ListApplicationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListApplicationsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<CreateApplicationRequest, Application> createApplicationCallable;
    private final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable;
    private final UnaryCallable<UpdateApplicationRequest, Application> updateApplicationCallable;
    private final UnaryCallable<DeleteApplicationRequest, Empty> deleteApplicationCallable;
    private final UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> listApplicationsCallable;
    private final UnaryCallable<ListApplicationsRequest, ApplicationServiceClient.ListApplicationsPagedResponse> listApplicationsPagedCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcApplicationServiceStub create(ApplicationServiceStubSettings settings) throws IOException {
        return new GrpcApplicationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcApplicationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcApplicationServiceStub(ApplicationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcApplicationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcApplicationServiceStub(ApplicationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcApplicationServiceStub(ApplicationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcApplicationServiceCallableFactory());
    }

    protected GrpcApplicationServiceStub(ApplicationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings createApplicationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createApplicationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateApplicationRequest>(){

            public Map<String, String> extract(CreateApplicationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getApplicationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getApplicationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetApplicationRequest>(){

            public Map<String, String> extract(GetApplicationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateApplicationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateApplicationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateApplicationRequest>(){

            public Map<String, String> extract(UpdateApplicationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"application.name", (Object)String.valueOf(request.getApplication().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteApplicationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteApplicationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteApplicationRequest>(){

            public Map<String, String> extract(DeleteApplicationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listApplicationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listApplicationsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListApplicationsRequest>(){

            public Map<String, String> extract(ListApplicationsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.createApplicationCallable = callableFactory.createUnaryCallable(createApplicationTransportSettings, settings.createApplicationSettings(), clientContext);
        this.getApplicationCallable = callableFactory.createUnaryCallable(getApplicationTransportSettings, settings.getApplicationSettings(), clientContext);
        this.updateApplicationCallable = callableFactory.createUnaryCallable(updateApplicationTransportSettings, settings.updateApplicationSettings(), clientContext);
        this.deleteApplicationCallable = callableFactory.createUnaryCallable(deleteApplicationTransportSettings, settings.deleteApplicationSettings(), clientContext);
        this.listApplicationsCallable = callableFactory.createUnaryCallable(listApplicationsTransportSettings, settings.listApplicationsSettings(), clientContext);
        this.listApplicationsPagedCallable = callableFactory.createPagedCallable(listApplicationsTransportSettings, settings.listApplicationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<CreateApplicationRequest, Application> createApplicationCallable() {
        return this.createApplicationCallable;
    }

    @Override
    public UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.getApplicationCallable;
    }

    @Override
    public UnaryCallable<UpdateApplicationRequest, Application> updateApplicationCallable() {
        return this.updateApplicationCallable;
    }

    @Override
    public UnaryCallable<DeleteApplicationRequest, Empty> deleteApplicationCallable() {
        return this.deleteApplicationCallable;
    }

    @Override
    public UnaryCallable<ListApplicationsRequest, ApplicationServiceClient.ListApplicationsPagedResponse> listApplicationsPagedCallable() {
        return this.listApplicationsPagedCallable;
    }

    @Override
    public UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> listApplicationsCallable() {
        return this.listApplicationsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

