/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storageinsights.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.storageinsights.v1.CreateReportConfigRequest;
import com.google.cloud.storageinsights.v1.DeleteReportConfigRequest;
import com.google.cloud.storageinsights.v1.GetReportConfigRequest;
import com.google.cloud.storageinsights.v1.GetReportDetailRequest;
import com.google.cloud.storageinsights.v1.ListReportConfigsRequest;
import com.google.cloud.storageinsights.v1.ListReportConfigsResponse;
import com.google.cloud.storageinsights.v1.ListReportDetailsRequest;
import com.google.cloud.storageinsights.v1.ListReportDetailsResponse;
import com.google.cloud.storageinsights.v1.LocationName;
import com.google.cloud.storageinsights.v1.ReportConfig;
import com.google.cloud.storageinsights.v1.ReportConfigName;
import com.google.cloud.storageinsights.v1.ReportDetail;
import com.google.cloud.storageinsights.v1.ReportDetailName;
import com.google.cloud.storageinsights.v1.StorageInsightsSettings;
import com.google.cloud.storageinsights.v1.UpdateReportConfigRequest;
import com.google.cloud.storageinsights.v1.stub.StorageInsightsStub;
import com.google.cloud.storageinsights.v1.stub.StorageInsightsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class StorageInsightsClient
implements BackgroundResource {
    private final StorageInsightsSettings settings;
    private final StorageInsightsStub stub;

    public static final StorageInsightsClient create() throws IOException {
        return StorageInsightsClient.create(StorageInsightsSettings.newBuilder().build());
    }

    public static final StorageInsightsClient create(StorageInsightsSettings settings) throws IOException {
        return new StorageInsightsClient(settings);
    }

    public static final StorageInsightsClient create(StorageInsightsStub stub) {
        return new StorageInsightsClient(stub);
    }

    protected StorageInsightsClient(StorageInsightsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StorageInsightsStubSettings)settings.getStubSettings()).createStub();
    }

    protected StorageInsightsClient(StorageInsightsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final StorageInsightsSettings getSettings() {
        return this.settings;
    }

    public StorageInsightsStub getStub() {
        return this.stub;
    }

    public final ListReportConfigsPagedResponse listReportConfigs(LocationName parent) {
        ListReportConfigsRequest request = ListReportConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReportConfigs(request);
    }

    public final ListReportConfigsPagedResponse listReportConfigs(String parent) {
        ListReportConfigsRequest request = ListReportConfigsRequest.newBuilder().setParent(parent).build();
        return this.listReportConfigs(request);
    }

    public final ListReportConfigsPagedResponse listReportConfigs(ListReportConfigsRequest request) {
        return (ListReportConfigsPagedResponse)((Object)this.listReportConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReportConfigsRequest, ListReportConfigsPagedResponse> listReportConfigsPagedCallable() {
        return this.stub.listReportConfigsPagedCallable();
    }

    public final UnaryCallable<ListReportConfigsRequest, ListReportConfigsResponse> listReportConfigsCallable() {
        return this.stub.listReportConfigsCallable();
    }

    public final ReportConfig getReportConfig(ReportConfigName name) {
        GetReportConfigRequest request = GetReportConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReportConfig(request);
    }

    public final ReportConfig getReportConfig(String name) {
        GetReportConfigRequest request = GetReportConfigRequest.newBuilder().setName(name).build();
        return this.getReportConfig(request);
    }

    public final ReportConfig getReportConfig(GetReportConfigRequest request) {
        return (ReportConfig)this.getReportConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetReportConfigRequest, ReportConfig> getReportConfigCallable() {
        return this.stub.getReportConfigCallable();
    }

    public final ReportConfig createReportConfig(LocationName parent, ReportConfig reportConfig) {
        CreateReportConfigRequest request = CreateReportConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReportConfig(reportConfig).build();
        return this.createReportConfig(request);
    }

    public final ReportConfig createReportConfig(String parent, ReportConfig reportConfig) {
        CreateReportConfigRequest request = CreateReportConfigRequest.newBuilder().setParent(parent).setReportConfig(reportConfig).build();
        return this.createReportConfig(request);
    }

    public final ReportConfig createReportConfig(CreateReportConfigRequest request) {
        return (ReportConfig)this.createReportConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateReportConfigRequest, ReportConfig> createReportConfigCallable() {
        return this.stub.createReportConfigCallable();
    }

    public final ReportConfig updateReportConfig(ReportConfig reportConfig, FieldMask updateMask) {
        UpdateReportConfigRequest request = UpdateReportConfigRequest.newBuilder().setReportConfig(reportConfig).setUpdateMask(updateMask).build();
        return this.updateReportConfig(request);
    }

    public final ReportConfig updateReportConfig(UpdateReportConfigRequest request) {
        return (ReportConfig)this.updateReportConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateReportConfigRequest, ReportConfig> updateReportConfigCallable() {
        return this.stub.updateReportConfigCallable();
    }

    public final void deleteReportConfig(ReportConfigName name) {
        DeleteReportConfigRequest request = DeleteReportConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteReportConfig(request);
    }

    public final void deleteReportConfig(String name) {
        DeleteReportConfigRequest request = DeleteReportConfigRequest.newBuilder().setName(name).build();
        this.deleteReportConfig(request);
    }

    public final void deleteReportConfig(DeleteReportConfigRequest request) {
        this.deleteReportConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteReportConfigRequest, Empty> deleteReportConfigCallable() {
        return this.stub.deleteReportConfigCallable();
    }

    public final ListReportDetailsPagedResponse listReportDetails(ReportConfigName parent) {
        ListReportDetailsRequest request = ListReportDetailsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReportDetails(request);
    }

    public final ListReportDetailsPagedResponse listReportDetails(String parent) {
        ListReportDetailsRequest request = ListReportDetailsRequest.newBuilder().setParent(parent).build();
        return this.listReportDetails(request);
    }

    public final ListReportDetailsPagedResponse listReportDetails(ListReportDetailsRequest request) {
        return (ListReportDetailsPagedResponse)((Object)this.listReportDetailsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReportDetailsRequest, ListReportDetailsPagedResponse> listReportDetailsPagedCallable() {
        return this.stub.listReportDetailsPagedCallable();
    }

    public final UnaryCallable<ListReportDetailsRequest, ListReportDetailsResponse> listReportDetailsCallable() {
        return this.stub.listReportDetailsCallable();
    }

    public final ReportDetail getReportDetail(ReportDetailName name) {
        GetReportDetailRequest request = GetReportDetailRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReportDetail(request);
    }

    public final ReportDetail getReportDetail(String name) {
        GetReportDetailRequest request = GetReportDetailRequest.newBuilder().setName(name).build();
        return this.getReportDetail(request);
    }

    public final ReportDetail getReportDetail(GetReportDetailRequest request) {
        return (ReportDetail)this.getReportDetailCallable().call((Object)request);
    }

    public final UnaryCallable<GetReportDetailRequest, ReportDetail> getReportDetailCallable() {
        return this.stub.getReportDetailCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReportDetailsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReportDetailsRequest, ListReportDetailsResponse, ReportDetail, ListReportDetailsPage, ListReportDetailsFixedSizeCollection> {
        private ListReportDetailsFixedSizeCollection(List<ListReportDetailsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReportDetailsFixedSizeCollection createEmptyCollection() {
            return new ListReportDetailsFixedSizeCollection(null, 0);
        }

        protected ListReportDetailsFixedSizeCollection createCollection(List<ListReportDetailsPage> pages, int collectionSize) {
            return new ListReportDetailsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReportDetailsPage
    extends AbstractPage<ListReportDetailsRequest, ListReportDetailsResponse, ReportDetail, ListReportDetailsPage> {
        private ListReportDetailsPage(PageContext<ListReportDetailsRequest, ListReportDetailsResponse, ReportDetail> context, ListReportDetailsResponse response) {
            super(context, (Object)response);
        }

        private static ListReportDetailsPage createEmptyPage() {
            return new ListReportDetailsPage(null, null);
        }

        protected ListReportDetailsPage createPage(PageContext<ListReportDetailsRequest, ListReportDetailsResponse, ReportDetail> context, ListReportDetailsResponse response) {
            return new ListReportDetailsPage(context, response);
        }

        public ApiFuture<ListReportDetailsPage> createPageAsync(PageContext<ListReportDetailsRequest, ListReportDetailsResponse, ReportDetail> context, ApiFuture<ListReportDetailsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReportDetailsPagedResponse
    extends AbstractPagedListResponse<ListReportDetailsRequest, ListReportDetailsResponse, ReportDetail, ListReportDetailsPage, ListReportDetailsFixedSizeCollection> {
        public static ApiFuture<ListReportDetailsPagedResponse> createAsync(PageContext<ListReportDetailsRequest, ListReportDetailsResponse, ReportDetail> context, ApiFuture<ListReportDetailsResponse> futureResponse) {
            ApiFuture<ListReportDetailsPage> futurePage = ListReportDetailsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReportDetailsPagedResponse((ListReportDetailsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReportDetailsPagedResponse(ListReportDetailsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReportDetailsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReportConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig, ListReportConfigsPage, ListReportConfigsFixedSizeCollection> {
        private ListReportConfigsFixedSizeCollection(List<ListReportConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReportConfigsFixedSizeCollection createEmptyCollection() {
            return new ListReportConfigsFixedSizeCollection(null, 0);
        }

        protected ListReportConfigsFixedSizeCollection createCollection(List<ListReportConfigsPage> pages, int collectionSize) {
            return new ListReportConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReportConfigsPage
    extends AbstractPage<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig, ListReportConfigsPage> {
        private ListReportConfigsPage(PageContext<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig> context, ListReportConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListReportConfigsPage createEmptyPage() {
            return new ListReportConfigsPage(null, null);
        }

        protected ListReportConfigsPage createPage(PageContext<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig> context, ListReportConfigsResponse response) {
            return new ListReportConfigsPage(context, response);
        }

        public ApiFuture<ListReportConfigsPage> createPageAsync(PageContext<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig> context, ApiFuture<ListReportConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReportConfigsPagedResponse
    extends AbstractPagedListResponse<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig, ListReportConfigsPage, ListReportConfigsFixedSizeCollection> {
        public static ApiFuture<ListReportConfigsPagedResponse> createAsync(PageContext<ListReportConfigsRequest, ListReportConfigsResponse, ReportConfig> context, ApiFuture<ListReportConfigsResponse> futureResponse) {
            ApiFuture<ListReportConfigsPage> futurePage = ListReportConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReportConfigsPagedResponse((ListReportConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReportConfigsPagedResponse(ListReportConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReportConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

