/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class UploadPartResponse {
    private final String eTag;
    private final String md5;
    private final String crc32c;

    private UploadPartResponse(Builder builder) {
        this.eTag = builder.etag;
        this.md5 = builder.md5;
        this.crc32c = builder.crc32c;
    }

    public String eTag() {
        return this.eTag;
    }

    public String md5() {
        return this.md5;
    }

    public String crc32c() {
        return this.crc32c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadPartResponse)) {
            return false;
        }
        UploadPartResponse that = (UploadPartResponse)o;
        return Objects.equals(this.eTag, that.eTag) && Objects.equals(this.md5, that.md5) && Objects.equals(this.crc32c, that.crc32c);
    }

    public int hashCode() {
        return Objects.hash(this.eTag, this.md5, this.crc32c);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("etag", (Object)this.eTag).add("md5", (Object)this.md5).add("crc32c", (Object)this.crc32c).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String etag;
        private String md5;
        private String crc32c;

        private Builder() {
        }

        public Builder eTag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public Builder crc32c(String crc32c) {
            this.crc32c = crc32c;
            return this;
        }

        public UploadPartResponse build() {
            return new UploadPartResponse(this);
        }
    }
}

