/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class ListPartsRequest {
    private final String bucket;
    private final String key;
    private final String uploadId;
    private final Integer maxParts;
    private final Integer partNumberMarker;
    private final String userProject;

    private ListPartsRequest(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.maxParts = builder.maxParts;
        this.partNumberMarker = builder.partNumberMarker;
        this.userProject = builder.userProject;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Integer maxParts() {
        return this.maxParts;
    }

    public Integer partNumberMarker() {
        return this.partNumberMarker;
    }

    public String userProject() {
        return this.userProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPartsRequest)) {
            return false;
        }
        ListPartsRequest that = (ListPartsRequest)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.maxParts, that.maxParts) && Objects.equals(this.partNumberMarker, that.partNumberMarker) && Objects.equals(this.userProject, that.userProject);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.key, this.uploadId, this.maxParts, this.partNumberMarker, this.userProject);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("uploadId", (Object)this.uploadId).add("maxParts", (Object)this.maxParts).add("partNumberMarker", (Object)this.partNumberMarker).add("userProject", (Object)this.userProject).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String bucket;
        private String key;
        private String uploadId;
        private Integer maxParts;
        private Integer partNumberMarker;
        private String userProject;

        private Builder() {
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public Builder partNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public Builder userProject(String userProject) {
            this.userProject = userProject;
            return this;
        }

        public ListPartsRequest build() {
            return new ListPartsRequest(this);
        }
    }
}

