/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

public final class CompletedPart {
    @JacksonXmlProperty(localName="PartNumber")
    private final int partNumber;
    @JacksonXmlProperty(localName="ETag")
    private final String eTag;

    private CompletedPart(int partNumber, String eTag) {
        this.partNumber = partNumber;
        this.eTag = eTag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int partNumber() {
        return this.partNumber;
    }

    public String eTag() {
        return this.eTag;
    }

    public static class Builder {
        private int partNumber;
        private String etag;

        public Builder partNumber(int partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public Builder eTag(String etag) {
            this.etag = etag;
            return this;
        }

        public CompletedPart build() {
            return new CompletedPart(this.partNumber, this.etag);
        }
    }
}

