/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.core.InternalApi;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.Expr;
import com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.api.services.storage.model.Notification;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.ObjectCustomContextPayload;
import com.google.api.services.storage.model.Policy;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.Binding;
import com.google.cloud.Condition;
import com.google.cloud.Policy;
import com.google.cloud.StringEnumValue;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.Rpo;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.Utils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
final class JsonConversions {
    static final JsonConversions INSTANCE = new JsonConversions();
    private final Conversions.Codec<Acl.Entity, String> entityCodec = Conversions.Codec.of(this::entityEncode, this::entityDecode);
    private final Conversions.Codec<Acl, ObjectAccessControl> objectAclCodec = Conversions.Codec.of(this::objectAclEncode, this::objectAclDecode);
    private final Conversions.Codec<Acl, BucketAccessControl> bucketAclCodec = Conversions.Codec.of(this::bucketAclEncode, this::bucketAclDecode);
    private final Conversions.Codec<HmacKey.HmacKeyMetadata, HmacKeyMetadata> hmacKeyMetadataCodec = Conversions.Codec.of(this::hmacKeyMetadataEncode, this::hmacKeyMetadataDecode);
    private final Conversions.Codec<HmacKey, com.google.api.services.storage.model.HmacKey> hmacKeyCodec = Conversions.Codec.of(this::hmacKeyEncode, this::hmacKeyDecode);
    private final Conversions.Codec<ServiceAccount, com.google.api.services.storage.model.ServiceAccount> serviceAccountCodec = Conversions.Codec.of(this::serviceAccountEncode, this::serviceAccountDecode);
    private final Conversions.Codec<Cors, Bucket.Cors> corsCodec = Conversions.Codec.of(this::corsEncode, this::corsDecode);
    private final Conversions.Codec<BucketInfo.Logging, Bucket.Logging> loggingCodec = Conversions.Codec.of(this::loggingEncode, this::loggingDecode);
    private final Conversions.Codec<BucketInfo.IamConfiguration, Bucket.IamConfiguration> iamConfigurationCodec = Conversions.Codec.of(this::iamConfigEncode, this::iamConfigDecode);
    private final Conversions.Codec<BucketInfo.Autoclass, Bucket.Autoclass> autoclassCodec = Conversions.Codec.of(this::autoclassEncode, this::autoclassDecode);
    private final Conversions.Codec<BucketInfo.ObjectRetention, Bucket.ObjectRetention> objectRetentionCodec = Conversions.Codec.of(this::objectRetentionEncode, this::objectRetentionDecode);
    private final Conversions.Codec<BucketInfo.SoftDeletePolicy, Bucket.SoftDeletePolicy> softDeletePolicyCodec = Conversions.Codec.of(this::softDeletePolicyEncode, this::softDeletePolicyDecode);
    private final Conversions.Codec<BucketInfo.LifecycleRule, Bucket.Lifecycle.Rule> lifecycleRuleCodec = Conversions.Codec.of(this::lifecycleRuleEncode, this::lifecycleRuleDecode);
    private final Conversions.Codec<BucketInfo.LifecycleRule.LifecycleCondition, Bucket.Lifecycle.Rule.Condition> lifecycleConditionCodec = Conversions.Codec.of(this::ruleConditionEncode, this::ruleConditionDecode);
    private final Conversions.Codec<BucketInfo, Bucket> bucketInfoCodec = Conversions.Codec.of(this::bucketInfoEncode, this::bucketInfoDecode);
    private final Conversions.Codec<BlobInfo.CustomerEncryption, StorageObject.CustomerEncryption> customerEncryptionCodec = Conversions.Codec.of(this::customerEncryptionEncode, this::customerEncryptionDecode);
    private final Conversions.Codec<BlobInfo.Retention, StorageObject.Retention> retentionCodec = Conversions.Codec.of(this::retentionEncode, this::retentionDecode);
    private final Conversions.Codec<BlobId, StorageObject> blobIdCodec = Conversions.Codec.of(this::blobIdEncode, this::blobIdDecode);
    private final Conversions.Codec<BlobInfo, StorageObject> blobInfoCodec = Conversions.Codec.of(this::blobInfoEncode, this::blobInfoDecode);
    private final Conversions.Codec<BucketInfo.HierarchicalNamespace, Bucket.HierarchicalNamespace> hierarchicalNamespaceCodec = Conversions.Codec.of(this::hierarchicalNamespaceEncode, this::hierarchicalNamespaceDecode);
    private final Conversions.Codec<NotificationInfo, Notification> notificationInfoCodec = Conversions.Codec.of(this::notificationEncode, this::notificationDecode);
    private final Conversions.Codec<BucketInfo.CustomPlacementConfig, Bucket.CustomPlacementConfig> customPlacementConfigCodec = Conversions.Codec.of(this::customPlacementConfigEncode, this::customPlacementConfigDecode);
    private final Conversions.Codec<Policy, com.google.api.services.storage.model.Policy> policyCodec = Conversions.Codec.of(this::policyEncode, this::policyDecode);
    private final Conversions.Codec<Binding, Policy.Bindings> bindingCodec = Conversions.Codec.of(this::bindingEncode, this::bindingDecode);
    private final Conversions.Codec<Condition, Expr> iamConditionCodec = Conversions.Codec.of(this::conditionEncode, this::conditionDecode);
    private final Conversions.Codec<BucketInfo.IpFilter, Bucket.IpFilter> ipFilterCodec = Conversions.Codec.of(this::ipFilterEncode, this::ipFilterDecode);
    private final Conversions.Codec<BucketInfo.IpFilter.PublicNetworkSource, Bucket.IpFilter.PublicNetworkSource> publicNetworkSourceCodec = Conversions.Codec.of(this::publicNetworkSourceEncode, this::publicNetworkSourceDecode);
    private final Conversions.Codec<BucketInfo.IpFilter.VpcNetworkSource, Bucket.IpFilter.VpcNetworkSources> vpcNetworkSourceCodec = Conversions.Codec.of(this::vpcNetworkSourceEncode, this::vpcNetworkSourceDecode);
    private final Conversions.Codec<BucketInfo.EncryptionEnforcementRestrictionMode, String> encryptionEnforcementRestrictionModeCodec = Conversions.Codec.of(StringEnumValue::toString, BucketInfo.EncryptionEnforcementRestrictionMode::valueOf);
    private final Conversions.Codec<BucketInfo.GoogleManagedEncryptionEnforcementConfig, Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig> googleManagedEncryptionEnforcementConfigCodec = Conversions.Codec.of(from -> {
        Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig to = new Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig();
        Utils.ifNonNull(from.getRestrictionMode(), this.encryptionEnforcementRestrictionModeCodec::encode, arg_0 -> ((Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)to).setRestrictionMode(arg_0));
        Utils.ifNonNull(from.getEffectiveTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)to).setEffectiveTime(arg_0));
        return to;
    }, from -> {
        @Nullable BucketInfo.EncryptionEnforcementRestrictionMode mode = null;
        if (from.getRestrictionMode() != null) {
            mode = (BucketInfo.EncryptionEnforcementRestrictionMode)((Object)((Object)this.encryptionEnforcementRestrictionModeCodec.decode(from.getRestrictionMode())));
        }
        if (from.getEffectiveTime() != null) {
            return BucketInfo.GoogleManagedEncryptionEnforcementConfig.of(mode, (OffsetDateTime)Utils.dateTimeCodec.decode(from.getEffectiveTime()));
        }
        return BucketInfo.GoogleManagedEncryptionEnforcementConfig.of(mode);
    });
    private final Conversions.Codec<BucketInfo.CustomerManagedEncryptionEnforcementConfig, Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig> customerManagedEncryptionEnforcementConfigCodec = Conversions.Codec.of(from -> {
        Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig to = new Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig();
        Utils.ifNonNull(from.getRestrictionMode(), this.encryptionEnforcementRestrictionModeCodec::encode, arg_0 -> ((Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)to).setRestrictionMode(arg_0));
        Utils.ifNonNull(from.getEffectiveTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)to).setEffectiveTime(arg_0));
        return to;
    }, from -> {
        @Nullable BucketInfo.EncryptionEnforcementRestrictionMode mode = null;
        if (from.getRestrictionMode() != null) {
            mode = (BucketInfo.EncryptionEnforcementRestrictionMode)((Object)((Object)this.encryptionEnforcementRestrictionModeCodec.decode(from.getRestrictionMode())));
        }
        if (from.getEffectiveTime() != null) {
            return BucketInfo.CustomerManagedEncryptionEnforcementConfig.of(mode, (OffsetDateTime)Utils.dateTimeCodec.decode(from.getEffectiveTime()));
        }
        return BucketInfo.CustomerManagedEncryptionEnforcementConfig.of(mode);
    });
    private final Conversions.Codec<BucketInfo.CustomerSuppliedEncryptionEnforcementConfig, Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig> customerSuppliedEncryptionEnforcementConfigCodec = Conversions.Codec.of(from -> {
        Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig to = new Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig();
        Utils.ifNonNull(from.getRestrictionMode(), this.encryptionEnforcementRestrictionModeCodec::encode, arg_0 -> ((Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)to).setRestrictionMode(arg_0));
        Utils.ifNonNull(from.getEffectiveTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)to).setEffectiveTime(arg_0));
        return to;
    }, from -> {
        @Nullable BucketInfo.EncryptionEnforcementRestrictionMode mode = null;
        if (from.getRestrictionMode() != null) {
            mode = (BucketInfo.EncryptionEnforcementRestrictionMode)((Object)((Object)this.encryptionEnforcementRestrictionModeCodec.decode(from.getRestrictionMode())));
        }
        if (from.getEffectiveTime() != null) {
            return BucketInfo.CustomerSuppliedEncryptionEnforcementConfig.of(mode, (OffsetDateTime)Utils.dateTimeCodec.decode(from.getEffectiveTime()));
        }
        return BucketInfo.CustomerSuppliedEncryptionEnforcementConfig.of(mode);
    });
    private final Conversions.Codec<BlobInfo.ObjectContexts, StorageObject.Contexts> objectContextsCodec = Conversions.Codec.of(this::objectContextsEncode, this::objectContextsDecode);
    private final Conversions.Codec<BlobInfo.ObjectCustomContextPayload, ObjectCustomContextPayload> objectCustomContextPayloadCodec = Conversions.Codec.of(this::objectCustomContextPayloadEncode, this::objectCustomContextPayloadDecode).nullable();

    private JsonConversions() {
    }

    Conversions.Codec<Acl.Entity, String> entity() {
        return this.entityCodec;
    }

    Conversions.Codec<Acl, ObjectAccessControl> objectAcl() {
        return this.objectAclCodec;
    }

    Conversions.Codec<Acl, BucketAccessControl> bucketAcl() {
        return this.bucketAclCodec;
    }

    Conversions.Codec<HmacKey.HmacKeyMetadata, HmacKeyMetadata> hmacKeyMetadata() {
        return this.hmacKeyMetadataCodec;
    }

    Conversions.Codec<HmacKey, com.google.api.services.storage.model.HmacKey> hmacKey() {
        return this.hmacKeyCodec;
    }

    Conversions.Codec<ServiceAccount, com.google.api.services.storage.model.ServiceAccount> serviceAccount() {
        return this.serviceAccountCodec;
    }

    Conversions.Codec<Cors, Bucket.Cors> cors() {
        return this.corsCodec;
    }

    Conversions.Codec<BucketInfo.Logging, Bucket.Logging> logging() {
        return this.loggingCodec;
    }

    Conversions.Codec<BucketInfo.IamConfiguration, Bucket.IamConfiguration> iamConfiguration() {
        return this.iamConfigurationCodec;
    }

    Conversions.Codec<BucketInfo.LifecycleRule, Bucket.Lifecycle.Rule> lifecycleRule() {
        return this.lifecycleRuleCodec;
    }

    Conversions.Codec<BucketInfo, Bucket> bucketInfo() {
        return this.bucketInfoCodec;
    }

    Conversions.Codec<BlobInfo.CustomerEncryption, StorageObject.CustomerEncryption> customerEncryption() {
        return this.customerEncryptionCodec;
    }

    Conversions.Codec<BlobId, StorageObject> blobId() {
        return this.blobIdCodec;
    }

    Conversions.Codec<BlobInfo, StorageObject> blobInfo() {
        return this.blobInfoCodec;
    }

    Conversions.Codec<NotificationInfo, Notification> notificationInfo() {
        return this.notificationInfoCodec;
    }

    Conversions.Codec<BucketInfo.LifecycleRule.LifecycleCondition, Bucket.Lifecycle.Rule.Condition> lifecycleCondition() {
        return this.lifecycleConditionCodec;
    }

    Conversions.Codec<BucketInfo.CustomPlacementConfig, Bucket.CustomPlacementConfig> customPlacementConfig() {
        return this.customPlacementConfigCodec;
    }

    Conversions.Codec<Policy, com.google.api.services.storage.model.Policy> policyCodec() {
        return this.policyCodec;
    }

    private StorageObject blobInfoEncode(BlobInfo from) {
        StorageObject to = this.blobIdEncode(from.getBlobId());
        Utils.ifNonNull(from.getAcl(), JsonConversions.toListOf(this.objectAcl()::encode), arg_0 -> ((StorageObject)to).setAcl(arg_0));
        Utils.ifNonNull(from.getDeleteTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject)to).setTimeDeleted(arg_0));
        Utils.ifNonNull(from.getUpdateTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject)to).setUpdated(arg_0));
        Utils.ifNonNull(from.getCreateTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject)to).setTimeCreated(arg_0));
        Utils.ifNonNull(from.getCustomTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject)to).setCustomTime(arg_0));
        Utils.ifNonNull(from.getSize(), BigInteger::valueOf, arg_0 -> ((StorageObject)to).setSize(arg_0));
        Utils.ifNonNull(from.getOwner(), Utils.lift(this::entityEncode).andThen(o -> new StorageObject.Owner().setEntity(o)), arg_0 -> ((StorageObject)to).setOwner(arg_0));
        Utils.ifNonNull(from.getStorageClass(), StringEnumValue::toString, arg_0 -> ((StorageObject)to).setStorageClass(arg_0));
        Utils.ifNonNull(from.getTimeStorageClassUpdatedOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject)to).setTimeStorageClassUpdated(arg_0));
        Utils.ifNonNull(from.getCustomerEncryption(), this::customerEncryptionEncode, arg_0 -> ((StorageObject)to).setCustomerEncryption(arg_0));
        Utils.ifNonNull(from.getRetentionExpirationTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject)to).setRetentionExpirationTime(arg_0));
        Utils.ifNonNull(from.getSoftDeleteTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject)to).setSoftDeleteTime(arg_0));
        Utils.ifNonNull(from.getHardDeleteTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject)to).setHardDeleteTime(arg_0));
        if (from.getModifiedFields().contains((Object)Storage.BlobField.RETENTION) && from.getRetention() == null) {
            to.setRetention((StorageObject.Retention)Data.nullOf(StorageObject.Retention.class));
        }
        Utils.ifNonNull(from.getRetention(), this::retentionEncode, arg_0 -> ((StorageObject)to).setRetention(arg_0));
        to.setKmsKeyName(from.getKmsKeyName());
        to.setEventBasedHold(from.getEventBasedHold());
        to.setTemporaryHold(from.getTemporaryHold());
        HashMap pbMetadata = from.metadata;
        if (pbMetadata != null && !Data.isNull(pbMetadata)) {
            pbMetadata = Maps.newHashMapWithExpectedSize((int)from.getMetadata().size());
            for (Map.Entry<String, String> entry : from.getMetadata().entrySet()) {
                pbMetadata.put(entry.getKey(), (String)MoreObjects.firstNonNull((Object)entry.getValue(), (Object)((String)Data.nullOf(String.class))));
            }
        }
        to.setMetadata(pbMetadata);
        to.setCacheControl(from.getCacheControl());
        to.setContentEncoding(from.getContentEncoding());
        to.setCrc32c(from.getCrc32c());
        to.setContentType(from.getContentType());
        to.setMd5Hash(from.getMd5());
        to.setMediaLink(from.getMediaLink());
        to.setMetageneration(from.getMetageneration());
        to.setContentDisposition(from.getContentDisposition());
        to.setComponentCount(from.getComponentCount());
        to.setContentLanguage(from.getContentLanguage());
        to.setEtag(from.getEtag());
        to.setId(from.getGeneratedId());
        to.setSelfLink(from.getSelfLink());
        Utils.ifNonNull(from.getContexts(), this.objectContextsCodec::encode, arg_0 -> ((StorageObject)to).setContexts(arg_0));
        return to;
    }

    private BlobInfo blobInfoDecode(StorageObject from) {
        BlobInfo.Builder to = BlobInfo.newBuilder(this.blobIdDecode(from));
        Utils.ifNonNull(from.getCacheControl(), to::setCacheControl);
        Utils.ifNonNull(from.getContentEncoding(), to::setContentEncoding);
        Utils.ifNonNull(from.getCrc32c(), to::setCrc32c);
        Utils.ifNonNull(from.getContentType(), to::setContentType);
        Utils.ifNonNull(from.getMd5Hash(), to::setMd5);
        Utils.ifNonNull(from.getMediaLink(), to::setMediaLink);
        Utils.ifNonNull(from.getMetageneration(), to::setMetageneration);
        Utils.ifNonNull(from.getContentDisposition(), to::setContentDisposition);
        Utils.ifNonNull(from.getComponentCount(), to::setComponentCount);
        Utils.ifNonNull(from.getContentLanguage(), to::setContentLanguage);
        Utils.ifNonNull(from.getEtag(), to::setEtag);
        Utils.ifNonNull(from.getId(), to::setGeneratedId);
        Utils.ifNonNull(from.getSelfLink(), to::setSelfLink);
        Utils.ifNonNull(from.getMetadata(), to::setMetadata);
        Utils.ifNonNull(from.getTimeDeleted(), Utils.dateTimeCodec::decode, to::setDeleteTimeOffsetDateTime);
        Utils.ifNonNull(from.getUpdated(), Utils.dateTimeCodec::decode, to::setUpdateTimeOffsetDateTime);
        Utils.ifNonNull(from.getTimeCreated(), Utils.dateTimeCodec::decode, to::setCreateTimeOffsetDateTime);
        Utils.ifNonNull(from.getCustomTime(), Utils.dateTimeCodec::decode, to::setCustomTimeOffsetDateTime);
        Utils.ifNonNull(from.getSize(), BigInteger::longValue, to::setSize);
        Utils.ifNonNull(from.getOwner(), Utils.lift(StorageObject.Owner::getEntity).andThen(this::entityDecode), to::setOwner);
        Utils.ifNonNull(from.getAcl(), JsonConversions.toListOf(this.objectAcl()::decode), to::setAcl);
        if (from.containsKey((Object)"isDirectory")) {
            to.setIsDirectory(Boolean.TRUE);
        }
        Utils.ifNonNull(from.getCustomerEncryption(), this::customerEncryptionDecode, to::setCustomerEncryption);
        Utils.ifNonNull(from.getStorageClass(), StorageClass::valueOf, to::setStorageClass);
        Utils.ifNonNull(from.getTimeStorageClassUpdated(), Utils.dateTimeCodec::decode, to::setTimeStorageClassUpdatedOffsetDateTime);
        Utils.ifNonNull(from.getKmsKeyName(), to::setKmsKeyName);
        Utils.ifNonNull(from.getEventBasedHold(), to::setEventBasedHold);
        Utils.ifNonNull(from.getTemporaryHold(), to::setTemporaryHold);
        Utils.ifNonNull(from.getRetentionExpirationTime(), Utils.dateTimeCodec::decode, to::setRetentionExpirationTimeOffsetDateTime);
        Utils.ifNonNull(from.getRetention(), this::retentionDecode, to::setRetention);
        Utils.ifNonNull(from.getSoftDeleteTime(), Utils.dateTimeCodec::decode, to::setSoftDeleteTime);
        Utils.ifNonNull(from.getHardDeleteTime(), Utils.dateTimeCodec::decode, to::setHardDeleteTime);
        Utils.ifNonNull(from.getContexts(), this.objectContextsCodec::decode, to::setContexts);
        return to.build();
    }

    private StorageObject blobIdEncode(BlobId from) {
        StorageObject to = new StorageObject();
        to.setBucket(from.getBucket());
        to.setName(from.getName());
        to.setGeneration(from.getGeneration());
        return to;
    }

    private BlobId blobIdDecode(StorageObject from) {
        return BlobId.of(from.getBucket(), from.getName(), from.getGeneration());
    }

    private StorageObject.CustomerEncryption customerEncryptionEncode(BlobInfo.CustomerEncryption from) {
        return new StorageObject.CustomerEncryption().setEncryptionAlgorithm(from.getEncryptionAlgorithm()).setKeySha256(from.getKeySha256());
    }

    private BlobInfo.CustomerEncryption customerEncryptionDecode(StorageObject.CustomerEncryption from) {
        return new BlobInfo.CustomerEncryption(from.getEncryptionAlgorithm(), from.getKeySha256());
    }

    private StorageObject.Retention retentionEncode(BlobInfo.Retention from) {
        StorageObject.Retention to = new StorageObject.Retention();
        Utils.ifNonNull(from.getMode(), StringEnumValue::toString, arg_0 -> ((StorageObject.Retention)to).setMode(arg_0));
        Utils.ifNonNull(from.getRetainUntilTime(), Utils.dateTimeCodec::encode, arg_0 -> ((StorageObject.Retention)to).setRetainUntilTime(arg_0));
        return to;
    }

    private BlobInfo.Retention retentionDecode(StorageObject.Retention from) {
        BlobInfo.Retention.Builder to = BlobInfo.Retention.newBuilder();
        Utils.ifNonNull(from.getMode(), BlobInfo.Retention.Mode::valueOf, to::setMode);
        Utils.ifNonNull(from.getRetainUntilTime(), Utils.dateTimeCodec::decode, to::setRetainUntilTime);
        return to.build();
    }

    private Bucket.SoftDeletePolicy softDeletePolicyEncode(BucketInfo.SoftDeletePolicy from) {
        Bucket.SoftDeletePolicy to = new Bucket.SoftDeletePolicy();
        Utils.ifNonNull(from.getRetentionDuration(), Utils.durationSecondsCodec::encode, arg_0 -> ((Bucket.SoftDeletePolicy)to).setRetentionDurationSeconds(arg_0));
        return to;
    }

    private BucketInfo.SoftDeletePolicy softDeletePolicyDecode(Bucket.SoftDeletePolicy from) {
        BucketInfo.SoftDeletePolicy.Builder to = BucketInfo.SoftDeletePolicy.newBuilder();
        Utils.ifNonNull(from.getRetentionDurationSeconds(), Utils.durationSecondsCodec::decode, to::setRetentionDuration);
        Utils.ifNonNull(from.getEffectiveTime(), Utils.dateTimeCodec::decode, to::setEffectiveTime);
        return to.build();
    }

    private Bucket bucketInfoEncode(BucketInfo from) {
        HashMap pbLabels;
        List<BucketInfo.LifecycleRule> lifecycleRules;
        Bucket to = new Bucket();
        Utils.ifNonNull(from.getProject(), arg_0 -> ((Bucket)to).setProjectNumber(arg_0));
        Utils.ifNonNull(from.getAcl(), JsonConversions.toListOf(this.bucketAcl()::encode), arg_0 -> ((Bucket)to).setAcl(arg_0));
        Utils.ifNonNull(from.getCors(), JsonConversions.toListOf(this.cors()::encode), arg_0 -> ((Bucket)to).setCors(arg_0));
        Utils.ifNonNull(from.getCreateTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket)to).setTimeCreated(arg_0));
        Utils.ifNonNull(from.getDefaultAcl(), JsonConversions.toListOf(this.objectAcl()::encode), arg_0 -> ((Bucket)to).setDefaultObjectAcl(arg_0));
        Utils.ifNonNull(from.getLocation(), arg_0 -> ((Bucket)to).setLocation(arg_0));
        Utils.ifNonNull(from.getLocationType(), arg_0 -> ((Bucket)to).setLocationType(arg_0));
        Utils.ifNonNull(from.getMetageneration(), arg_0 -> ((Bucket)to).setMetageneration(arg_0));
        Utils.ifNonNull(from.getOwner(), Utils.lift(this::entityEncode).andThen(o -> new Bucket.Owner().setEntity(o)), arg_0 -> ((Bucket)to).setOwner(arg_0));
        Utils.ifNonNull(from.getRpo(), StringEnumValue::toString, arg_0 -> ((Bucket)to).setRpo(arg_0));
        Utils.ifNonNull(from.getStorageClass(), StringEnumValue::toString, arg_0 -> ((Bucket)to).setStorageClass(arg_0));
        Utils.ifNonNull(from.getUpdateTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket)to).setUpdated(arg_0));
        Utils.ifNonNull(from.versioningEnabled(), b -> new Bucket.Versioning().setEnabled(b), arg_0 -> ((Bucket)to).setVersioning(arg_0));
        to.setEtag(from.getEtag());
        to.setId(from.getGeneratedId());
        to.setName(from.getName());
        to.setSelfLink(from.getSelfLink());
        Utils.ifNonNull(from.requesterPays(), b -> new Bucket.Billing().setRequesterPays(b), arg_0 -> ((Bucket)to).setBilling(arg_0));
        if (from.getIndexPage() != null || from.getNotFoundPage() != null) {
            Bucket.Website website = new Bucket.Website();
            website.setMainPageSuffix(from.getIndexPage());
            website.setNotFoundPage(from.getNotFoundPage());
            to.setWebsite(website);
        }
        if ((lifecycleRules = from.lifecycleRules) != null) {
            Bucket.Lifecycle lifecycle = new Bucket.Lifecycle();
            if (lifecycleRules.isEmpty()) {
                lifecycle.setRule(Collections.emptyList());
            } else {
                ArrayList rules = new ArrayList();
                Utils.ifNonNull(lifecycleRules, r -> r.stream().map(this.lifecycleRule()::encode).forEach(rules::add));
                if (!rules.isEmpty()) {
                    lifecycle.setRule((List)ImmutableList.copyOf(rules));
                }
            }
            to.setLifecycle(lifecycle);
        }
        Utils.ifNonNull(from.getDefaultEventBasedHold(), arg_0 -> ((Bucket)to).setDefaultEventBasedHold(arg_0));
        if (Stream.of(from.getDefaultKmsKeyName(), from.getGoogleManagedEncryptionEnforcementConfig(), from.getCustomerManagedEncryptionEnforcementConfig(), from.getCustomerSuppliedEncryptionEnforcementConfig()).anyMatch(Objects::nonNull)) {
            Bucket.Encryption encryptionBuilder = new Bucket.Encryption();
            Utils.ifNonNull(from.getDefaultKmsKeyName(), arg_0 -> ((Bucket.Encryption)encryptionBuilder).setDefaultKmsKeyName(arg_0));
            Utils.ifNonNull(from.getGoogleManagedEncryptionEnforcementConfig(), this.googleManagedEncryptionEnforcementConfigCodec::encode, arg_0 -> ((Bucket.Encryption)encryptionBuilder).setGoogleManagedEncryptionEnforcementConfig(arg_0));
            Utils.ifNonNull(from.getCustomerManagedEncryptionEnforcementConfig(), this.customerManagedEncryptionEnforcementConfigCodec::encode, arg_0 -> ((Bucket.Encryption)encryptionBuilder).setCustomerManagedEncryptionEnforcementConfig(arg_0));
            Utils.ifNonNull(from.getCustomerSuppliedEncryptionEnforcementConfig(), this.customerSuppliedEncryptionEnforcementConfigCodec::encode, arg_0 -> ((Bucket.Encryption)encryptionBuilder).setCustomerSuppliedEncryptionEnforcementConfig(arg_0));
            to.setEncryption(encryptionBuilder);
        }
        if ((pbLabels = from.getLabels()) != null && !Data.isNull(pbLabels)) {
            pbLabels = Maps.newHashMapWithExpectedSize((int)from.getLabels().size());
            for (Map.Entry<String, String> entry : from.getLabels().entrySet()) {
                pbLabels.put(entry.getKey(), (String)MoreObjects.firstNonNull((Object)entry.getValue(), (Object)((String)Data.nullOf(String.class))));
            }
        }
        to.setLabels(pbLabels);
        JsonConversions.maybeEncodeRetentionPolicy(from, to);
        Utils.ifNonNull(from.getIamConfiguration(), this::iamConfigEncode, arg_0 -> ((Bucket)to).setIamConfiguration(arg_0));
        Utils.ifNonNull(from.getAutoclass(), this::autoclassEncode, arg_0 -> ((Bucket)to).setAutoclass(arg_0));
        Utils.ifNonNull(from.getLogging(), this::loggingEncode, arg_0 -> ((Bucket)to).setLogging(arg_0));
        Utils.ifNonNull(from.getCustomPlacementConfig(), this::customPlacementConfigEncode, arg_0 -> ((Bucket)to).setCustomPlacementConfig(arg_0));
        Utils.ifNonNull(from.getObjectRetention(), this::objectRetentionEncode, arg_0 -> ((Bucket)to).setObjectRetention(arg_0));
        Utils.ifNonNull(from.getSoftDeletePolicy(), this::softDeletePolicyEncode, arg_0 -> ((Bucket)to).setSoftDeletePolicy(arg_0));
        if (from.getSoftDeletePolicy() == null && from.getModifiedFields().contains((Object)Storage.BucketField.SOFT_DELETE_POLICY)) {
            to.setSoftDeletePolicy((Bucket.SoftDeletePolicy)Data.nullOf(Bucket.SoftDeletePolicy.class));
        }
        Utils.ifNonNull(from.getHierarchicalNamespace(), this::hierarchicalNamespaceEncode, arg_0 -> ((Bucket)to).setHierarchicalNamespace(arg_0));
        Utils.ifNonNull(from.getIpFilter(), this.ipFilterCodec::encode, arg_0 -> ((Bucket)to).setIpFilter(arg_0));
        if (from.getModifiedFields().contains((Object)Storage.BucketField.IP_FILTER) && from.getIpFilter() == null) {
            to.setIpFilter((Bucket.IpFilter)Data.nullOf(Bucket.IpFilter.class));
        }
        return to;
    }

    private BucketInfo bucketInfoDecode(Bucket from) {
        BucketInfo.BuilderImpl to = new BucketInfo.BuilderImpl((String)Utils.bucketNameCodec.decode(from.getName()));
        Utils.ifNonNull(from.getProjectNumber(), to::setProject);
        Utils.ifNonNull(from.getAcl(), JsonConversions.toListOf(this.bucketAcl()::decode), to::setAcl);
        Utils.ifNonNull(from.getCors(), JsonConversions.toListOf(this.cors()::decode), to::setCors);
        Utils.ifNonNull(from.getDefaultObjectAcl(), JsonConversions.toListOf(this.objectAcl()::decode), to::setDefaultAcl);
        Utils.ifNonNull(from.getEtag(), to::setEtag);
        Utils.ifNonNull(from.getId(), to::setGeneratedId);
        Utils.ifNonNull(from.getLocation(), to::setLocation);
        Utils.ifNonNull(from.getLocationType(), to::setLocationType);
        Utils.ifNonNull(from.getMetageneration(), to::setMetageneration);
        Utils.ifNonNull(from.getOwner(), Utils.lift(Bucket.Owner::getEntity).andThen(this::entityDecode), to::setOwner);
        Utils.ifNonNull(from.getRpo(), Rpo::valueOf, to::setRpo);
        Utils.ifNonNull(from.getSelfLink(), to::setSelfLink);
        Utils.ifNonNull(from.getStorageClass(), StorageClass::valueOf, to::setStorageClass);
        Utils.ifNonNull(from.getTimeCreated(), Utils.dateTimeCodec::decode, to::setCreateTimeOffsetDateTime);
        Utils.ifNonNull(from.getUpdated(), Utils.dateTimeCodec::decode, to::setUpdateTimeOffsetDateTime);
        Utils.ifNonNull(from.getVersioning(), Bucket.Versioning::getEnabled, to::setVersioningEnabled);
        Utils.ifNonNull(from.getWebsite(), Bucket.Website::getMainPageSuffix, to::setIndexPage);
        Utils.ifNonNull(from.getWebsite(), Bucket.Website::getNotFoundPage, to::setNotFoundPage);
        Utils.ifNonNull(from.getLifecycle(), Utils.lift(Bucket.Lifecycle::getRule).andThen(JsonConversions.toListOf(this.lifecycleRule()::decode)), to::setLifecycleRules);
        Utils.ifNonNull(from.getDefaultEventBasedHold(), to::setDefaultEventBasedHold);
        Utils.ifNonNull(from.getLabels(), JsonConversions::replaceDataNullValuesWithNull, to::setLabels);
        Utils.ifNonNull(from.getBilling(), Bucket.Billing::getRequesterPays, to::setRequesterPays);
        Bucket.Encryption encryption = from.getEncryption();
        if (encryption != null) {
            String defaultKmsKeyName = encryption.getDefaultKmsKeyName();
            if (defaultKmsKeyName != null && !encryption.getDefaultKmsKeyName().isEmpty()) {
                ((BucketInfo.Builder)to).setDefaultKmsKeyName(defaultKmsKeyName);
            }
            if (encryption.getGoogleManagedEncryptionEnforcementConfig() != null) {
                ((BucketInfo.Builder)to).setGoogleManagedEncryptionEnforcementConfig((BucketInfo.GoogleManagedEncryptionEnforcementConfig)this.googleManagedEncryptionEnforcementConfigCodec.decode(encryption.getGoogleManagedEncryptionEnforcementConfig()));
            }
            if (encryption.getCustomerManagedEncryptionEnforcementConfig() != null) {
                ((BucketInfo.Builder)to).setCustomerManagedEncryptionEnforcementConfig((BucketInfo.CustomerManagedEncryptionEnforcementConfig)this.customerManagedEncryptionEnforcementConfigCodec.decode(encryption.getCustomerManagedEncryptionEnforcementConfig()));
            }
            if (encryption.getCustomerSuppliedEncryptionEnforcementConfig() != null) {
                ((BucketInfo.Builder)to).setCustomerSuppliedEncryptionEnforcementConfig((BucketInfo.CustomerSuppliedEncryptionEnforcementConfig)this.customerSuppliedEncryptionEnforcementConfigCodec.decode(encryption.getCustomerSuppliedEncryptionEnforcementConfig()));
            }
        }
        JsonConversions.maybeDecodeRetentionPolicy(from, to);
        Utils.ifNonNull(from.getIamConfiguration(), this::iamConfigDecode, to::setIamConfiguration);
        Utils.ifNonNull(from.getAutoclass(), this::autoclassDecode, to::setAutoclass);
        Utils.ifNonNull(from.getLogging(), this::loggingDecode, to::setLogging);
        Utils.ifNonNull(from.getCustomPlacementConfig(), this::customPlacementConfigDecode, to::setCustomPlacementConfig);
        Utils.ifNonNull(from.getHierarchicalNamespace(), this::hierarchicalNamespaceDecode, to::setHierarchicalNamespace);
        Utils.ifNonNull(from.getObjectRetention(), this::objectRetentionDecode, to::setObjectRetention);
        Utils.ifNonNull(from.getSoftDeletePolicy(), this::softDeletePolicyDecode, to::setSoftDeletePolicy);
        Utils.ifNonNull(from.getIpFilter(), this.ipFilterCodec::decode, to::setIpFilter);
        if (from.containsKey((Object)"isUnreachable")) {
            ((BucketInfo.Builder)to).setIsUnreachable(Boolean.TRUE);
        }
        return ((BucketInfo.Builder)to).build();
    }

    private Bucket.IamConfiguration iamConfigEncode(BucketInfo.IamConfiguration from) {
        Bucket.IamConfiguration to = new Bucket.IamConfiguration();
        to.setUniformBucketLevelAccess(this.ublaEncode(from));
        Utils.ifNonNull(from.getPublicAccessPrevention(), BucketInfo.PublicAccessPrevention::getValue, arg_0 -> ((Bucket.IamConfiguration)to).setPublicAccessPrevention(arg_0));
        return to;
    }

    private BucketInfo.IamConfiguration iamConfigDecode(Bucket.IamConfiguration from) {
        Bucket.IamConfiguration.UniformBucketLevelAccess ubla = from.getUniformBucketLevelAccess();
        BucketInfo.IamConfiguration.Builder to = BucketInfo.IamConfiguration.newBuilder().setIsUniformBucketLevelAccessEnabled(ubla.getEnabled());
        Utils.ifNonNull(ubla.getLockedTime(), Utils.dateTimeCodec::decode, to::setUniformBucketLevelAccessLockedTimeOffsetDateTime);
        Utils.ifNonNull(from.getPublicAccessPrevention(), BucketInfo.PublicAccessPrevention::parse, to::setPublicAccessPrevention);
        return to.build();
    }

    private Bucket.Autoclass autoclassEncode(BucketInfo.Autoclass from) {
        Bucket.Autoclass to = new Bucket.Autoclass();
        Utils.ifNonNull(from.getEnabled(), arg_0 -> ((Bucket.Autoclass)to).setEnabled(arg_0));
        Utils.ifNonNull(from.getToggleTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket.Autoclass)to).setToggleTime(arg_0));
        Utils.ifNonNull(from.getTerminalStorageClass(), StringEnumValue::toString, arg_0 -> ((Bucket.Autoclass)to).setTerminalStorageClass(arg_0));
        Utils.ifNonNull(from.getTerminalStorageClassUpdateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket.Autoclass)to).setTerminalStorageClassUpdateTime(arg_0));
        return to;
    }

    private BucketInfo.Autoclass autoclassDecode(Bucket.Autoclass from) {
        BucketInfo.Autoclass.Builder to = BucketInfo.Autoclass.newBuilder();
        to.setEnabled(from.getEnabled());
        Utils.ifNonNull(from.getToggleTime(), Utils.dateTimeCodec::decode, to::setToggleTime);
        Utils.ifNonNull(from.getTerminalStorageClass(), StorageClass::valueOf, to::setTerminalStorageClass);
        Utils.ifNonNull(from.getTerminalStorageClassUpdateTime(), Utils.dateTimeCodec::decode, to::setTerminalStorageClassUpdateTime);
        return to.build();
    }

    private Bucket.ObjectRetention objectRetentionEncode(BucketInfo.ObjectRetention from) {
        Bucket.ObjectRetention to = new Bucket.ObjectRetention();
        Utils.ifNonNull(from.getMode(), StringEnumValue::toString, arg_0 -> ((Bucket.ObjectRetention)to).setMode(arg_0));
        return to;
    }

    private BucketInfo.ObjectRetention objectRetentionDecode(Bucket.ObjectRetention from) {
        BucketInfo.ObjectRetention.Builder to = BucketInfo.ObjectRetention.newBuilder();
        Utils.ifNonNull(from.getMode(), BucketInfo.ObjectRetention.Mode::valueOf, to::setMode);
        return to.build();
    }

    private Bucket.IamConfiguration.UniformBucketLevelAccess ublaEncode(BucketInfo.IamConfiguration from) {
        Bucket.IamConfiguration.UniformBucketLevelAccess to = new Bucket.IamConfiguration.UniformBucketLevelAccess();
        to.setEnabled(from.isUniformBucketLevelAccessEnabled());
        Utils.ifNonNull(from.getUniformBucketLevelAccessLockedTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket.IamConfiguration.UniformBucketLevelAccess)to).setLockedTime(arg_0));
        return to;
    }

    private Bucket.Lifecycle.Rule lifecycleRuleEncode(BucketInfo.LifecycleRule from) {
        Bucket.Lifecycle.Rule to = new Bucket.Lifecycle.Rule();
        to.setAction(this.ruleActionEncode(from.getAction()));
        to.setCondition(this.ruleConditionEncode(from.getCondition()));
        return to;
    }

    private Bucket.Lifecycle.Rule.Condition ruleConditionEncode(BucketInfo.LifecycleRule.LifecycleCondition from) {
        Function<OffsetDateTime, DateTime> truncatingDateFunction = Utils.lift(Utils.dateTimeCodec::encode).andThen(dt -> new DateTime(true, dt.getValue(), Integer.valueOf(0)));
        Bucket.Lifecycle.Rule.Condition to = new Bucket.Lifecycle.Rule.Condition().setAge(from.getAge()).setIsLive(from.getIsLive()).setNumNewerVersions(from.getNumberOfNewerVersions()).setDaysSinceNoncurrentTime(from.getDaysSinceNoncurrentTime()).setDaysSinceCustomTime(from.getDaysSinceCustomTime());
        Utils.ifNonNull(from.getCreatedBeforeOffsetDateTime(), truncatingDateFunction, arg_0 -> ((Bucket.Lifecycle.Rule.Condition)to).setCreatedBefore(arg_0));
        Utils.ifNonNull(from.getNoncurrentTimeBeforeOffsetDateTime(), truncatingDateFunction, arg_0 -> ((Bucket.Lifecycle.Rule.Condition)to).setNoncurrentTimeBefore(arg_0));
        Utils.ifNonNull(from.getCustomTimeBeforeOffsetDateTime(), truncatingDateFunction, arg_0 -> ((Bucket.Lifecycle.Rule.Condition)to).setCustomTimeBefore(arg_0));
        Utils.ifNonNull(from.getMatchesStorageClass(), JsonConversions.toListOf(Object::toString), arg_0 -> ((Bucket.Lifecycle.Rule.Condition)to).setMatchesStorageClass(arg_0));
        Utils.ifNonNull(from.getMatchesPrefix(), arg_0 -> ((Bucket.Lifecycle.Rule.Condition)to).setMatchesPrefix(arg_0));
        Utils.ifNonNull(from.getMatchesSuffix(), arg_0 -> ((Bucket.Lifecycle.Rule.Condition)to).setMatchesSuffix(arg_0));
        return to;
    }

    private BucketInfo.LifecycleRule.LifecycleCondition ruleConditionDecode(Bucket.Lifecycle.Rule.Condition condition) {
        if (condition == null) {
            return BucketInfo.LifecycleRule.LifecycleCondition.newBuilder().build();
        }
        BucketInfo.LifecycleRule.LifecycleCondition.Builder conditionBuilder = BucketInfo.LifecycleRule.LifecycleCondition.newBuilder().setAge(condition.getAge()).setCreatedBeforeOffsetDateTime((OffsetDateTime)Utils.nullableDateTimeCodec.decode(condition.getCreatedBefore())).setIsLive(condition.getIsLive()).setNumberOfNewerVersions(condition.getNumNewerVersions()).setDaysSinceNoncurrentTime(condition.getDaysSinceNoncurrentTime()).setNoncurrentTimeBeforeOffsetDateTime((OffsetDateTime)Utils.nullableDateTimeCodec.decode(condition.getNoncurrentTimeBefore())).setCustomTimeBeforeOffsetDateTime((OffsetDateTime)Utils.nullableDateTimeCodec.decode(condition.getCustomTimeBefore())).setDaysSinceCustomTime(condition.getDaysSinceCustomTime());
        Utils.ifNonNull(condition.getMatchesStorageClass(), JsonConversions.toListOf(StorageClass::valueOf), conditionBuilder::setMatchesStorageClass);
        Utils.ifNonNull(condition.getMatchesPrefix(), conditionBuilder::setMatchesPrefix);
        Utils.ifNonNull(condition.getMatchesSuffix(), conditionBuilder::setMatchesSuffix);
        return conditionBuilder.build();
    }

    private Bucket.Lifecycle.Rule.Action ruleActionEncode(BucketInfo.LifecycleRule.LifecycleAction from) {
        Bucket.Lifecycle.Rule.Action to = new Bucket.Lifecycle.Rule.Action().setType(from.getActionType());
        if (from.getActionType().equals("SetStorageClass")) {
            to.setStorageClass(((BucketInfo.LifecycleRule.SetStorageClassLifecycleAction)from).getStorageClass().toString());
        }
        return to;
    }

    private BucketInfo.LifecycleRule lifecycleRuleDecode(Bucket.Lifecycle.Rule from) {
        BucketInfo.LifecycleRule.LifecycleAction lifecycleAction;
        Bucket.Lifecycle.Rule.Action action = from.getAction();
        switch (action.getType()) {
            case "Delete": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newDeleteAction();
                break;
            }
            case "SetStorageClass": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newSetStorageClassAction(StorageClass.valueOf(action.getStorageClass()));
                break;
            }
            case "AbortIncompleteMultipartUpload": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newAbortIncompleteMPUploadAction();
                break;
            }
            default: {
                BucketInfo.log.warning("The lifecycle action " + action.getType() + " is not supported by this version of the library. Attempting to update with this rule may cause errors. Please update to the latest version of google-cloud-storage.");
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newLifecycleAction("Unknown action");
            }
        }
        BucketInfo.LifecycleRule.LifecycleCondition lifecycleCondition = this.ruleConditionDecode(from.getCondition());
        return new BucketInfo.LifecycleRule(lifecycleAction, lifecycleCondition);
    }

    private Bucket.Logging loggingEncode(BucketInfo.Logging from) {
        Bucket.Logging to;
        if (from.getLogBucket() != null || from.getLogObjectPrefix() != null) {
            to = new Bucket.Logging();
            Utils.ifNonNull(from.getLogBucket(), arg_0 -> ((Bucket.Logging)to).setLogBucket(arg_0));
            Utils.ifNonNull(from.getLogObjectPrefix(), arg_0 -> ((Bucket.Logging)to).setLogObjectPrefix(arg_0));
        } else {
            to = (Bucket.Logging)Data.nullOf(Bucket.Logging.class);
        }
        return to;
    }

    private BucketInfo.Logging loggingDecode(Bucket.Logging from) {
        return BucketInfo.Logging.newBuilder().setLogBucket(from.getLogBucket()).setLogObjectPrefix(from.getLogObjectPrefix()).build();
    }

    private Bucket.Cors corsEncode(Cors from) {
        Bucket.Cors to = new Bucket.Cors();
        to.setMaxAgeSeconds(from.getMaxAgeSeconds());
        to.setResponseHeader(from.getResponseHeaders());
        Utils.ifNonNull(from.getMethods(), JsonConversions.toListOf(Object::toString), arg_0 -> ((Bucket.Cors)to).setMethod(arg_0));
        Utils.ifNonNull(from.getOrigins(), JsonConversions.toListOf(Object::toString), arg_0 -> ((Bucket.Cors)to).setOrigin(arg_0));
        return to;
    }

    private Cors corsDecode(Bucket.Cors from) {
        Cors.Builder to = Cors.newBuilder().setMaxAgeSeconds(from.getMaxAgeSeconds());
        Utils.ifNonNull(from.getMethod(), m -> (ImmutableList)m.stream().map(String::toUpperCase).map(HttpMethod::valueOf).collect(ImmutableList.toImmutableList()), to::setMethods);
        Utils.ifNonNull(from.getOrigin(), JsonConversions.toListOf(Cors.Origin::of), to::setOrigins);
        to.setResponseHeaders(from.getResponseHeader());
        return to.build();
    }

    private com.google.api.services.storage.model.ServiceAccount serviceAccountEncode(ServiceAccount from) {
        return new com.google.api.services.storage.model.ServiceAccount().setEmailAddress(from.getEmail());
    }

    private ServiceAccount serviceAccountDecode(com.google.api.services.storage.model.ServiceAccount from) {
        return ServiceAccount.of(from.getEmailAddress());
    }

    private com.google.api.services.storage.model.HmacKey hmacKeyEncode(HmacKey from) {
        com.google.api.services.storage.model.HmacKey to = new com.google.api.services.storage.model.HmacKey();
        to.setSecret(from.getSecretKey());
        Utils.ifNonNull(from.getMetadata(), this::hmacKeyMetadataEncode, arg_0 -> ((com.google.api.services.storage.model.HmacKey)to).setMetadata(arg_0));
        return to;
    }

    private HmacKey hmacKeyDecode(com.google.api.services.storage.model.HmacKey from) {
        return HmacKey.newBuilder(from.getSecret()).setMetadata(this.hmacKeyMetadataDecode(from.getMetadata())).build();
    }

    private HmacKeyMetadata hmacKeyMetadataEncode(HmacKey.HmacKeyMetadata from) {
        HmacKeyMetadata to = new HmacKeyMetadata();
        to.setAccessId(from.getAccessId());
        to.setEtag(from.getEtag());
        to.setId(from.getId());
        to.setProjectId(from.getProjectId());
        Utils.ifNonNull(from.getServiceAccount(), ServiceAccount::getEmail, arg_0 -> ((HmacKeyMetadata)to).setServiceAccountEmail(arg_0));
        Utils.ifNonNull(from.getState(), Enum::name, arg_0 -> ((HmacKeyMetadata)to).setState(arg_0));
        Utils.ifNonNull(from.getCreateTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((HmacKeyMetadata)to).setTimeCreated(arg_0));
        Utils.ifNonNull(from.getUpdateTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((HmacKeyMetadata)to).setUpdated(arg_0));
        return to;
    }

    private HmacKey.HmacKeyMetadata hmacKeyMetadataDecode(HmacKeyMetadata from) {
        return HmacKey.HmacKeyMetadata.newBuilder(ServiceAccount.of(from.getServiceAccountEmail())).setAccessId(from.getAccessId()).setCreateTimeOffsetDateTime((OffsetDateTime)Utils.dateTimeCodec.decode(from.getTimeCreated())).setEtag(from.getEtag()).setId(from.getId()).setProjectId(from.getProjectId()).setState(HmacKey.HmacKeyState.valueOf(from.getState())).setUpdateTimeOffsetDateTime((OffsetDateTime)Utils.dateTimeCodec.decode(from.getUpdated())).build();
    }

    private String entityEncode(Acl.Entity from) {
        if (from instanceof Acl.RawEntity) {
            return from.getValue();
        }
        if (from instanceof Acl.User) {
            switch (from.getValue()) {
                case "allAuthenticatedUsers": {
                    return "allAuthenticatedUsers";
                }
                case "allUsers": {
                    return "allUsers";
                }
            }
        }
        return from.getType().name().toLowerCase() + "-" + from.getValue();
    }

    private Acl.Entity entityDecode(String from) {
        if (from.startsWith("user-")) {
            return new Acl.User(from.substring(5));
        }
        if (from.equals("allUsers")) {
            return Acl.User.ofAllUsers();
        }
        if (from.equals("allAuthenticatedUsers")) {
            return Acl.User.ofAllAuthenticatedUsers();
        }
        if (from.startsWith("group-")) {
            return new Acl.Group(from.substring(6));
        }
        if (from.startsWith("domain-")) {
            return new Acl.Domain(from.substring(7));
        }
        if (from.startsWith("project-")) {
            int idx = from.indexOf(45, 8);
            String team = from.substring(8, idx);
            String projectId = from.substring(idx + 1);
            return new Acl.Project(Acl.Project.ProjectRole.valueOf(team.toUpperCase()), projectId);
        }
        return new Acl.RawEntity(from);
    }

    private Acl objectAclDecode(ObjectAccessControl from) {
        Acl.Role role = Acl.Role.valueOf(from.getRole());
        Acl.Entity entity = this.entityDecode(from.getEntity());
        return Acl.newBuilder(entity, role).setEtag(from.getEtag()).setId(from.getId()).build();
    }

    private Acl bucketAclDecode(BucketAccessControl from) {
        Acl.Role role = Acl.Role.valueOf(from.getRole());
        Acl.Entity entity = this.entityDecode(from.getEntity());
        return Acl.newBuilder(entity, role).setEtag(from.getEtag()).setId(from.getId()).build();
    }

    private BucketAccessControl bucketAclEncode(Acl from) {
        return new BucketAccessControl().setEntity(from.getEntity().toString()).setRole(from.getRole().toString()).setId(from.getId()).setEtag(from.getEtag());
    }

    private ObjectAccessControl objectAclEncode(Acl from) {
        return new ObjectAccessControl().setEntity(this.entityEncode(from.getEntity())).setRole(from.getRole().name()).setId(from.getId()).setEtag(from.getEtag());
    }

    private Notification notificationEncode(NotificationInfo from) {
        NotificationInfo.PayloadFormat payloadFormat;
        Notification to = new Notification();
        to.setEtag(from.getEtag());
        to.setSelfLink(from.getSelfLink());
        to.setTopic(from.getTopic());
        Utils.ifNonNull(from.getNotificationId(), arg_0 -> ((Notification)to).setId(arg_0));
        Utils.ifNonNull(from.getCustomAttributes(), arg_0 -> ((Notification)to).setCustomAttributes(arg_0));
        Utils.ifNonNull(from.getObjectNamePrefix(), arg_0 -> ((Notification)to).setObjectNamePrefix(arg_0));
        List<NotificationInfo.EventType> eventTypes = from.getEventTypes();
        if (eventTypes != null && eventTypes.size() > 0) {
            ArrayList<String> eventTypesPb = new ArrayList<String>();
            for (NotificationInfo.EventType eventType : eventTypes) {
                eventTypesPb.add(eventType.toString());
            }
            to.setEventTypes(eventTypesPb);
        }
        if ((payloadFormat = from.getPayloadFormat()) != null) {
            to.setPayloadFormat(payloadFormat.toString());
        } else {
            to.setPayloadFormat(NotificationInfo.PayloadFormat.NONE.toString());
        }
        return to;
    }

    private Bucket.HierarchicalNamespace hierarchicalNamespaceEncode(BucketInfo.HierarchicalNamespace from) {
        Bucket.HierarchicalNamespace to = new Bucket.HierarchicalNamespace();
        Utils.ifNonNull(from.getEnabled(), arg_0 -> ((Bucket.HierarchicalNamespace)to).setEnabled(arg_0));
        return to;
    }

    private BucketInfo.HierarchicalNamespace hierarchicalNamespaceDecode(Bucket.HierarchicalNamespace from) {
        BucketInfo.HierarchicalNamespace.Builder to = BucketInfo.HierarchicalNamespace.newBuilder();
        to.setEnabled(from.getEnabled());
        return to.build();
    }

    private NotificationInfo notificationDecode(Notification from) {
        NotificationInfo.BuilderImpl builder = new NotificationInfo.BuilderImpl(from.getTopic());
        Utils.ifNonNull(from.getId(), builder::setNotificationId);
        Utils.ifNonNull(from.getEtag(), builder::setEtag);
        Utils.ifNonNull(from.getCustomAttributes(), builder::setCustomAttributes);
        Utils.ifNonNull(from.getSelfLink(), builder::setSelfLink);
        Utils.ifNonNull(from.getObjectNamePrefix(), builder::setObjectNamePrefix);
        Utils.ifNonNull(from.getPayloadFormat(), NotificationInfo.PayloadFormat::valueOf, builder::setPayloadFormat);
        if (from.getEventTypes() != null) {
            List eventTypesPb = from.getEventTypes();
            NotificationInfo.EventType[] eventTypes = new NotificationInfo.EventType[eventTypesPb.size()];
            for (int index = 0; index < eventTypesPb.size(); ++index) {
                eventTypes[index] = NotificationInfo.EventType.valueOf((String)eventTypesPb.get(index));
            }
            ((NotificationInfo.Builder)builder).setEventTypes(eventTypes);
        }
        return ((NotificationInfo.Builder)builder).build();
    }

    private com.google.api.services.storage.model.Policy policyEncode(Policy from) {
        com.google.api.services.storage.model.Policy to = new com.google.api.services.storage.model.Policy();
        Utils.ifNonNull(from.getEtag(), arg_0 -> ((com.google.api.services.storage.model.Policy)to).setEtag(arg_0));
        Utils.ifNonNull(from.getVersion(), arg_0 -> ((com.google.api.services.storage.model.Policy)to).setVersion(arg_0));
        if (from.getBindingsList() != null) {
            ImmutableList bindings = (ImmutableList)from.getBindingsList().stream().map(this.bindingCodec::encode).collect(ImmutableList.toImmutableList());
            to.setBindings((List)bindings);
        }
        return to;
    }

    private Policy policyDecode(com.google.api.services.storage.model.Policy from) {
        Policy.Builder to = Policy.newBuilder();
        String etag = from.getEtag();
        if (etag != null && !etag.isEmpty()) {
            to.setEtag(etag);
        }
        to.setVersion(from.getVersion().intValue());
        List bindings = from.getBindings();
        if (bindings != null && !bindings.isEmpty()) {
            to.setBindings((List)bindings.stream().map(this.bindingCodec::decode).collect(ImmutableList.toImmutableList()));
        }
        return to.build();
    }

    private Policy.Bindings bindingEncode(Binding from) {
        Policy.Bindings to = new Policy.Bindings();
        Utils.ifNonNull(from.getRole(), arg_0 -> ((Policy.Bindings)to).setRole(arg_0));
        Utils.ifNonNull(from.getMembers(), arg_0 -> ((Policy.Bindings)to).setMembers(arg_0));
        Utils.ifNonNull(from.getCondition(), this.iamConditionCodec::encode, arg_0 -> ((Policy.Bindings)to).setCondition(arg_0));
        return to;
    }

    private Binding bindingDecode(Policy.Bindings from) {
        Binding.Builder to = Binding.newBuilder();
        Utils.ifNonNull(from.getRole(), arg_0 -> ((Binding.Builder)to).setRole(arg_0));
        Utils.ifNonNull(from.getMembers(), arg_0 -> ((Binding.Builder)to).setMembers(arg_0));
        Utils.ifNonNull(from.getCondition(), this.iamConditionCodec::decode, arg_0 -> ((Binding.Builder)to).setCondition(arg_0));
        return to.build();
    }

    private Expr conditionEncode(Condition from) {
        Expr to = new Expr();
        Utils.ifNonNull(from.getExpression(), arg_0 -> ((Expr)to).setExpression(arg_0));
        Utils.ifNonNull(from.getTitle(), arg_0 -> ((Expr)to).setTitle(arg_0));
        Utils.ifNonNull(from.getDescription(), arg_0 -> ((Expr)to).setDescription(arg_0));
        return to;
    }

    private Condition conditionDecode(Expr from) {
        Condition.Builder to = Condition.newBuilder();
        Utils.ifNonNull(from.getExpression(), arg_0 -> ((Condition.Builder)to).setExpression(arg_0));
        Utils.ifNonNull(from.getTitle(), arg_0 -> ((Condition.Builder)to).setTitle(arg_0));
        Utils.ifNonNull(from.getDescription(), arg_0 -> ((Condition.Builder)to).setDescription(arg_0));
        return to.build();
    }

    private Bucket.CustomPlacementConfig customPlacementConfigEncode(BucketInfo.CustomPlacementConfig from) {
        Bucket.CustomPlacementConfig to = null;
        if (from.getDataLocations() != null) {
            to = new Bucket.CustomPlacementConfig();
            to.setDataLocations(from.getDataLocations());
        }
        return to;
    }

    private BucketInfo.CustomPlacementConfig customPlacementConfigDecode(Bucket.CustomPlacementConfig from) {
        return BucketInfo.CustomPlacementConfig.newBuilder().setDataLocations(from.getDataLocations()).build();
    }

    private Bucket.IpFilter ipFilterEncode(BucketInfo.IpFilter from) {
        Bucket.IpFilter to = new Bucket.IpFilter();
        Utils.ifNonNull(from.getMode(), arg_0 -> ((Bucket.IpFilter)to).setMode(arg_0));
        Utils.ifNonNull(from.getPublicNetworkSource(), this.publicNetworkSourceCodec::encode, arg_0 -> ((Bucket.IpFilter)to).setPublicNetworkSource(arg_0));
        Utils.ifNonNull(from.getVpcNetworkSources(), JsonConversions.toListOf(this.vpcNetworkSourceCodec::encode), arg_0 -> ((Bucket.IpFilter)to).setVpcNetworkSources(arg_0));
        Utils.ifNonNull(from.getAllowCrossOrgVpcs(), arg_0 -> ((Bucket.IpFilter)to).setAllowCrossOrgVpcs(arg_0));
        Utils.ifNonNull(from.getAllowAllServiceAgentAccess(), arg_0 -> ((Bucket.IpFilter)to).setAllowAllServiceAgentAccess(arg_0));
        return to;
    }

    private BucketInfo.IpFilter ipFilterDecode(Bucket.IpFilter from) {
        BucketInfo.IpFilter.Builder to = BucketInfo.IpFilter.newBuilder();
        Utils.ifNonNull(from.getMode(), to::setMode);
        Utils.ifNonNull(from.getPublicNetworkSource(), this.publicNetworkSourceCodec::decode, to::setPublicNetworkSource);
        Utils.ifNonNull(from.getVpcNetworkSources(), JsonConversions.toListOf(this.vpcNetworkSourceCodec::decode), to::setVpcNetworkSources);
        Utils.ifNonNull(from.getAllowCrossOrgVpcs(), to::setAllowCrossOrgVpcs);
        Utils.ifNonNull(from.getAllowAllServiceAgentAccess(), to::setAllowAllServiceAgentAccess);
        return to.build();
    }

    private Bucket.IpFilter.PublicNetworkSource publicNetworkSourceEncode(BucketInfo.IpFilter.PublicNetworkSource from) {
        Bucket.IpFilter.PublicNetworkSource to = new Bucket.IpFilter.PublicNetworkSource();
        Utils.ifNonNull(from.getAllowedIpCidrRanges(), arg_0 -> ((Bucket.IpFilter.PublicNetworkSource)to).setAllowedIpCidrRanges(arg_0));
        return to;
    }

    private BucketInfo.IpFilter.PublicNetworkSource publicNetworkSourceDecode(Bucket.IpFilter.PublicNetworkSource from) {
        return BucketInfo.IpFilter.PublicNetworkSource.of(from.getAllowedIpCidrRanges());
    }

    private Bucket.IpFilter.VpcNetworkSources vpcNetworkSourceEncode(BucketInfo.IpFilter.VpcNetworkSource from) {
        Bucket.IpFilter.VpcNetworkSources to = new Bucket.IpFilter.VpcNetworkSources();
        Utils.ifNonNull(from.getNetwork(), arg_0 -> ((Bucket.IpFilter.VpcNetworkSources)to).setNetwork(arg_0));
        Utils.ifNonNull(from.getAllowedIpCidrRanges(), arg_0 -> ((Bucket.IpFilter.VpcNetworkSources)to).setAllowedIpCidrRanges(arg_0));
        return to;
    }

    private BucketInfo.IpFilter.VpcNetworkSource vpcNetworkSourceDecode(Bucket.IpFilter.VpcNetworkSources from) {
        BucketInfo.IpFilter.VpcNetworkSource.Builder to = BucketInfo.IpFilter.VpcNetworkSource.newBuilder();
        Utils.ifNonNull(from.getNetwork(), to::setNetwork);
        Utils.ifNonNull(from.getAllowedIpCidrRanges(), to::setAllowedIpCidrRanges);
        return to.build();
    }

    private static void maybeEncodeRetentionPolicy(BucketInfo from, Bucket to) {
        if (from.getRetentionPeriodDuration() != null || from.retentionPolicyIsLocked() != null || from.getRetentionEffectiveTimeOffsetDateTime() != null) {
            Bucket.RetentionPolicy retentionPolicy = new Bucket.RetentionPolicy();
            Utils.ifNonNull(from.getRetentionPeriodDuration(), Utils.durationSecondsCodec::encode, arg_0 -> ((Bucket.RetentionPolicy)retentionPolicy).setRetentionPeriod(arg_0));
            Utils.ifNonNull(from.retentionPolicyIsLocked(), arg_0 -> ((Bucket.RetentionPolicy)retentionPolicy).setIsLocked(arg_0));
            Utils.ifNonNull(from.getRetentionEffectiveTimeOffsetDateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((Bucket.RetentionPolicy)retentionPolicy).setEffectiveTime(arg_0));
            to.setRetentionPolicy(retentionPolicy);
        } else {
            to.setRetentionPolicy((Bucket.RetentionPolicy)Data.nullOf(Bucket.RetentionPolicy.class));
        }
    }

    private static void maybeDecodeRetentionPolicy(Bucket from, BucketInfo.Builder to) {
        Bucket.RetentionPolicy retentionPolicy = from.getRetentionPolicy();
        if (retentionPolicy != null && retentionPolicy.getEffectiveTime() != null) {
            to.setRetentionEffectiveTimeOffsetDateTime((OffsetDateTime)Utils.dateTimeCodec.decode(retentionPolicy.getEffectiveTime()));
        }
        if (retentionPolicy != null) {
            Utils.ifNonNull(retentionPolicy.getIsLocked(), to::setRetentionPolicyIsLocked);
            Utils.ifNonNull(retentionPolicy.getRetentionPeriod(), Utils.durationSecondsCodec::decode, to::setRetentionPeriodDuration);
        }
    }

    private StorageObject.Contexts objectContextsEncode(BlobInfo.ObjectContexts from) {
        if (from == null) {
            return null;
        }
        StorageObject.Contexts to = new StorageObject.Contexts();
        Utils.ifNonNull(from.getCustom(), m -> new HashMap(Maps.transformValues((Map)m, this.objectCustomContextPayloadCodec::encode)), arg_0 -> ((StorageObject.Contexts)to).setCustom(arg_0));
        return to;
    }

    private BlobInfo.ObjectContexts objectContextsDecode(StorageObject.Contexts from) {
        if (from == null) {
            return null;
        }
        BlobInfo.ObjectContexts.Builder to = BlobInfo.ObjectContexts.newBuilder();
        Utils.ifNonNull(from.getCustom(), m -> new HashMap(Maps.transformValues((Map)m, this.objectCustomContextPayloadCodec::decode)), to::setCustom);
        return to.build();
    }

    private ObjectCustomContextPayload objectCustomContextPayloadEncode(BlobInfo.ObjectCustomContextPayload from) {
        ObjectCustomContextPayload to = new ObjectCustomContextPayload();
        Utils.ifNonNull(from.getValue(), arg_0 -> ((ObjectCustomContextPayload)to).setValue(arg_0));
        Utils.ifNonNull(from.getCreateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((ObjectCustomContextPayload)to).setCreateTime(arg_0));
        Utils.ifNonNull(from.getUpdateTime(), Utils.dateTimeCodec::encode, arg_0 -> ((ObjectCustomContextPayload)to).setUpdateTime(arg_0));
        return to;
    }

    private BlobInfo.ObjectCustomContextPayload objectCustomContextPayloadDecode(ObjectCustomContextPayload from) {
        BlobInfo.ObjectCustomContextPayload.Builder to = BlobInfo.ObjectCustomContextPayload.newBuilder();
        Utils.ifNonNull(from.getValue(), to::setValue);
        Utils.ifNonNull(from.getCreateTime(), Utils.dateTimeCodec::decode, to::setCreateTime);
        Utils.ifNonNull(from.getUpdateTime(), Utils.dateTimeCodec::decode, to::setUpdateTime);
        return to.build();
    }

    private static Map<String, String> replaceDataNullValuesWithNull(Map<String, String> labels) {
        boolean anyDataNull = labels.values().stream().anyMatch(Data::isNull);
        if (anyDataNull) {
            HashMap tmp = Maps.newHashMapWithExpectedSize((int)labels.size());
            for (Map.Entry<String, String> e : labels.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                tmp.put(k, Data.isNull((Object)v) ? null : v);
            }
            return Collections.unmodifiableMap(tmp);
        }
        return labels;
    }

    private static <T1, T2> Function<List<T1>, List<T2>> toListOf(Function<T1, T2> f) {
        return l -> {
            if (l == null) {
                return ImmutableList.of();
            }
            return l.stream().filter(Objects::nonNull).map(f).collect(Collectors.toList());
        };
    }
}

