/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.Hasher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ChunkSegmenter {
    private final Hasher hasher;
    private final ByteStringStrategy bss;
    private final int maxSegmentSize;
    private final int blockSize;

    ChunkSegmenter(Hasher hasher, ByteStringStrategy bss, int maxSegmentSize) {
        this(hasher, bss, maxSegmentSize, 262144);
    }

    @VisibleForTesting
    ChunkSegmenter(Hasher hasher, ByteStringStrategy bss, int maxSegmentSize, int blockSize) {
        int mod = maxSegmentSize % blockSize;
        Preconditions.checkArgument((mod == 0 ? 1 : 0) != 0, (String)"maxSegmentSize % blockSize == 0 (%s % %s == %s)", (Object)maxSegmentSize, (Object)blockSize, (Object)mod);
        this.hasher = hasher;
        this.bss = bss;
        this.maxSegmentSize = maxSegmentSize;
        this.blockSize = blockSize;
    }

    Hasher getHasher() {
        return this.hasher;
    }

    ChunkSegment[] segmentBuffer(ByteBuffer bb) {
        return this.segmentBuffers(new ByteBuffer[]{bb}, 0, 1);
    }

    ChunkSegment[] segmentBuffers(ByteBuffer[] bbs) {
        return this.segmentBuffers(bbs, 0, bbs.length);
    }

    ChunkSegment[] segmentBuffers(ByteBuffer[] bbs, int offset, int length) {
        return this.segmentBuffers(bbs, offset, length, true);
    }

    ChunkSegment[] segmentBuffers(ByteBuffer[] bbs, int offset, int length, boolean allowUnalignedBlocks) {
        if (allowUnalignedBlocks) {
            return this.segmentWithUnaligned(bbs, offset, length, Long.MAX_VALUE);
        }
        return this.segmentWithoutUnaligned(bbs, offset, length, Long.MAX_VALUE);
    }

    ChunkSegment[] segmentBuffers(ByteBuffer[] bbs, int offset, int length, boolean allowUnalignedBlocks, long maxBytesToConsume) {
        if (allowUnalignedBlocks) {
            return this.segmentWithUnaligned(bbs, offset, length, maxBytesToConsume);
        }
        long misaligned = maxBytesToConsume % (long)this.blockSize;
        long alignedMaxBytesToConsume = maxBytesToConsume - misaligned;
        return this.segmentWithoutUnaligned(bbs, offset, length, alignedMaxBytesToConsume);
    }

    private ChunkSegment[] segmentWithUnaligned(ByteBuffer[] bbs, int offset, int length, long maxBytesToConsume) {
        ArrayDeque<ChunkSegment> data = new ArrayDeque<ChunkSegment>();
        long consumed = 0L;
        for (int i = offset; i < length; ++i) {
            int remaining;
            ByteBuffer buffer = bbs[i];
            while ((remaining = buffer.remaining()) > 0 && consumed < maxBytesToConsume) {
                long remainingConsumable = maxBytesToConsume - consumed;
                int toConsume = remaining;
                if (remainingConsumable < (long)remaining) {
                    toConsume = Math.toIntExact(remainingConsumable);
                }
                long consumeBytes = this.consumeBytes(data, toConsume, buffer);
                consumed += consumeBytes;
            }
        }
        return data.toArray(new ChunkSegment[0]);
    }

    private ChunkSegment[] segmentWithoutUnaligned(ByteBuffer[] bbs, int offset, int length, long maxBytesToConsume) {
        ArrayDeque<ChunkSegment> data = new ArrayDeque<ChunkSegment>();
        long buffersTotalRemaining = Buffers.totalRemaining(bbs, offset, length);
        long totalRemaining = Math.min(maxBytesToConsume, buffersTotalRemaining);
        long consumedSoFar = 0L;
        int currentBlockPending = this.blockSize;
        block0: for (int i = offset; i < length; ++i) {
            int remaining;
            ByteBuffer buffer = bbs[i];
            while ((remaining = buffer.remaining()) > 0) {
                int numBytesConsumable;
                long overallRemaining = totalRemaining - consumedSoFar;
                if (overallRemaining < (long)this.blockSize && currentBlockPending == this.blockSize) break block0;
                if (remaining >= this.blockSize && currentBlockPending == this.blockSize) {
                    int blockCount = IntMath.divide((int)remaining, (int)this.blockSize, (RoundingMode)RoundingMode.DOWN);
                    numBytesConsumable = blockCount * this.blockSize;
                } else {
                    numBytesConsumable = Math.min(remaining, currentBlockPending);
                }
                if (numBytesConsumable <= 0) break block0;
                int consumed = this.consumeBytes(data, numBytesConsumable, buffer);
                int currentBlockPendingLessConsumed = currentBlockPending - consumed;
                if ((currentBlockPending = currentBlockPendingLessConsumed % this.blockSize) == 0) {
                    currentBlockPending = this.blockSize;
                }
                consumedSoFar += (long)consumed;
            }
        }
        return data.toArray(new ChunkSegment[0]);
    }

    private int consumeBytes(Deque<ChunkSegment> data, int numBytesConsumable, ByteBuffer buffer) {
        ChunkSegment peekLast = data.peekLast();
        if (peekLast == null || peekLast.b.size() == this.maxSegmentSize) {
            int limit = Math.min(numBytesConsumable, this.maxSegmentSize);
            ChunkSegment datum = this.newSegment(buffer, limit);
            data.addLast(datum);
            return limit;
        }
        ChunkSegment chunkSoFar = data.pollLast();
        int limit = Ints.min((int[])new int[]{buffer.remaining(), numBytesConsumable, this.maxSegmentSize - chunkSoFar.b.size()});
        ChunkSegment datum = this.newSegment(buffer, limit);
        ChunkSegment plus = chunkSoFar.concat(datum);
        data.addLast(plus);
        return limit;
    }

    private ChunkSegment newSegment(ByteBuffer buffer, int limit) {
        ByteBuffer slice = buffer.slice();
        slice.limit(limit);
        Crc32cValue.Crc32cLengthKnown hash = this.hasher.hash(slice::duplicate);
        ByteString byteString = (ByteString)this.bss.apply(slice);
        Buffers.position(buffer, buffer.position() + limit);
        return new ChunkSegment(byteString, hash);
    }

    final class ChunkSegment {
        private final ByteString b;
        private final @Nullable Crc32cValue.Crc32cLengthKnown crc32c;
        private final boolean onlyFullBlocks;

        private ChunkSegment(@Nullable ByteString b, Crc32cValue.Crc32cLengthKnown crc32c) {
            this.b = b;
            this.onlyFullBlocks = b.size() % ChunkSegmenter.this.blockSize == 0;
            this.crc32c = crc32c;
        }

        public ChunkSegment concat(ChunkSegment other) {
            Crc32cValue.Crc32cLengthKnown newCrc = null;
            if (this.crc32c != null && other.crc32c != null) {
                newCrc = this.crc32c.concat(other.crc32c);
            }
            ByteString concat = this.b.concat(other.b);
            return new ChunkSegment(concat, newCrc);
        }

        public ByteString getB() {
            return this.b;
        }

        public @Nullable Crc32cValue.Crc32cLengthKnown getCrc32c() {
            return this.crc32c;
        }

        public boolean isOnlyFullBlocks() {
            return this.onlyFullBlocks;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("crc32c", (Object)this.crc32c).add("onlyFullBlocks", this.onlyFullBlocks).add("b", (Object)this.b).toString();
        }
    }
}

