/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.api.core.BetaApi;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@BetaApi
@JsonDeserialize(builder=Builder.class)
public final class CompleteMultipartUploadResponse {
    private final String location;
    private final String bucket;
    private final String key;
    private final String etag;
    private final String crc32c;

    private CompleteMultipartUploadResponse(Builder builder) {
        this.location = builder.location;
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.etag = builder.etag;
        this.crc32c = builder.crc32c;
    }

    @BetaApi
    @JsonProperty(value="Location")
    public String location() {
        return this.location;
    }

    @BetaApi
    @JsonProperty(value="Bucket")
    public String bucket() {
        return this.bucket;
    }

    @BetaApi
    @JsonProperty(value="Key")
    public String key() {
        return this.key;
    }

    @BetaApi
    @JsonProperty(value="ETag")
    public String etag() {
        return this.etag;
    }

    @BetaApi
    public String crc32c() {
        return this.crc32c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompleteMultipartUploadResponse)) {
            return false;
        }
        CompleteMultipartUploadResponse that = (CompleteMultipartUploadResponse)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.etag, that.etag) && Objects.equals(this.crc32c, that.crc32c);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.bucket, this.key, this.etag, this.crc32c);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.location).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("etag", (Object)this.etag).add("crc32c", (Object)this.crc32c).toString();
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    @JsonPOJOBuilder(buildMethodName="build")
    public static class Builder {
        private String location;
        private String bucket;
        private String key;
        private String etag;
        private String crc32c;

        private Builder() {
        }

        @BetaApi
        @JsonProperty(value="Location")
        public Builder location(String location) {
            this.location = location;
            return this;
        }

        @BetaApi
        @JsonProperty(value="Bucket")
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @BetaApi
        @JsonProperty(value="Key")
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @BetaApi
        @JsonProperty(value="ETag")
        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        @BetaApi
        public Builder crc32c(String crc32c) {
            this.crc32c = crc32c;
            return this;
        }

        @BetaApi
        public CompleteMultipartUploadResponse build() {
            return new CompleteMultipartUploadResponse(this);
        }
    }
}

