/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.HttpRetryAlgorithmManager;
import com.google.cloud.storage.MultipartUploadClient;
import com.google.cloud.storage.MultipartUploadHttpRequestManager;
import com.google.cloud.storage.RequestBody;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.multipartupload.model.AbortMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.AbortMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.CreateMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.CreateMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.ListMultipartUploadsRequest;
import com.google.cloud.storage.multipartupload.model.ListMultipartUploadsResponse;
import com.google.cloud.storage.multipartupload.model.ListPartsRequest;
import com.google.cloud.storage.multipartupload.model.ListPartsResponse;
import com.google.cloud.storage.multipartupload.model.UploadPartRequest;
import com.google.cloud.storage.multipartupload.model.UploadPartResponse;
import java.util.concurrent.atomic.AtomicBoolean;

final class MultipartUploadClientImpl
extends MultipartUploadClient {
    private final MultipartUploadHttpRequestManager httpRequestManager;
    private final Retrying.Retrier retrier;
    private final HttpRetryAlgorithmManager retryAlgorithmManager;

    MultipartUploadClientImpl(Retrying.Retrier retrier, MultipartUploadHttpRequestManager multipartUploadHttpRequestManager, HttpRetryAlgorithmManager retryAlgorithmManager) {
        this.httpRequestManager = multipartUploadHttpRequestManager;
        this.retrier = retrier;
        this.retryAlgorithmManager = retryAlgorithmManager;
    }

    @Override
    public CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest request) {
        return (CreateMultipartUploadResponse)this.retrier.run(this.retryAlgorithmManager.nonIdempotent(), () -> this.httpRequestManager.sendCreateMultipartUploadRequest(request), Conversions.Decoder.identity());
    }

    @Override
    public ListPartsResponse listParts(ListPartsRequest request) {
        return (ListPartsResponse)this.retrier.run(this.retryAlgorithmManager.idempotent(), () -> this.httpRequestManager.sendListPartsRequest(request), Conversions.Decoder.identity());
    }

    @Override
    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest request) {
        return (AbortMultipartUploadResponse)this.retrier.run(this.retryAlgorithmManager.idempotent(), () -> this.httpRequestManager.sendAbortMultipartUploadRequest(request), Conversions.Decoder.identity());
    }

    @Override
    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest request) {
        return (CompleteMultipartUploadResponse)this.retrier.run(this.retryAlgorithmManager.idempotent(), () -> this.httpRequestManager.sendCompleteMultipartUploadRequest(request), Conversions.Decoder.identity());
    }

    @Override
    public UploadPartResponse uploadPart(UploadPartRequest request, RequestBody requestBody) {
        AtomicBoolean dirty = new AtomicBoolean(false);
        return (UploadPartResponse)this.retrier.run(this.retryAlgorithmManager.idempotent(), () -> {
            if (dirty.getAndSet(true)) {
                requestBody.getContent().rewindTo(0L);
            }
            return this.httpRequestManager.sendUploadPartRequest(request, requestBody.getContent());
        }, Conversions.Decoder.identity());
    }

    @Override
    public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest request) {
        return (ListMultipartUploadsResponse)this.retrier.run(this.retryAlgorithmManager.idempotent(), () -> this.httpRequestManager.sendListMultipartUploadsRequest(request), Conversions.Decoder.identity());
    }
}

