/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import java.net.URL;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

final class ResumableMedia {
    ResumableMedia() {
    }

    static Supplier<String> startUploadForBlobInfo(StorageOptions storageOptions, BlobInfo blob, Map<StorageRpc.Option, ?> optionsMap, ResultRetryAlgorithm<?> algorithm) {
        return () -> (String)Retrying.run(storageOptions, algorithm, () -> storageOptions.getStorageRpcV1().open(blob.toPb(), optionsMap), Function.identity());
    }

    static Supplier<String> startUploadForSignedUrl(StorageOptions storageOptions, URL signedURL, ResultRetryAlgorithm<?> algorithm) {
        if (!ResumableMedia.isValidSignedURL(signedURL.getQuery())) {
            throw new StorageException(2, "invalid signedURL");
        }
        return () -> (String)Retrying.run(storageOptions, algorithm, () -> storageOptions.getStorageRpcV1().open(signedURL.toString()), Function.identity());
    }

    private static boolean isValidSignedURL(String signedURLQuery) {
        boolean isValid = true;
        if (signedURLQuery.startsWith("X-Goog-Algorithm=")) {
            if (!(signedURLQuery.contains("&X-Goog-Credential=") && signedURLQuery.contains("&X-Goog-Date=") && signedURLQuery.contains("&X-Goog-Expires=") && signedURLQuery.contains("&X-Goog-SignedHeaders=") && signedURLQuery.contains("&X-Goog-Signature="))) {
                isValid = false;
            }
        } else if (signedURLQuery.startsWith("GoogleAccessId=")) {
            if (!signedURLQuery.contains("&Expires=") || !signedURLQuery.contains("&Signature=")) {
                isValid = false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }
}

