/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpResponseException;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.HttpClientContext;
import com.google.cloud.storage.HttpContentRange;
import com.google.cloud.storage.JsonResumableSessionFailureScenario;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.StorageException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JsonResumableSessionQueryTask
implements Callable<ResumableOperationResult<StorageObject>> {
    private final HttpClientContext context;
    private final String uploadId;

    JsonResumableSessionQueryTask(HttpClientContext context, String uploadId) {
        this.context = context;
        this.uploadId = uploadId;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResumableOperationResult<@Nullable StorageObject> call() {
        response = null;
        try {
            req = this.context.getRequestFactory().buildPutRequest(new GenericUrl(this.uploadId), (HttpContent)new EmptyContent()).setParser(this.context.getObjectParser());
            req.setThrowExceptionOnExecuteError(false);
            req.getHeaders().setContentRange(HttpContentRange.query().getHeaderValue());
            response = req.execute();
            code = response.getStatusCode();
            if (JsonResumableSessionFailureScenario.isOk(code)) {
                contentLength = response.getHeaders().getContentLength();
                contentType = response.getHeaders().getContentType();
                storedContentLength = HttpClientContext.firstHeaderValue(response.getHeaders(), "x-goog-stored-content-length");
                v0 = isJson = contentType != null && contentType.startsWith("application/json") != false;
                if (isJson) {
                    storageObject = (StorageObject)response.parseAs(StorageObject.class);
                    actualSize = storageObject != null ? storageObject.getSize() : null;
                } else if ((contentLength == null || contentLength == 0L) && storedContentLength != null) {
                    response.ignore();
                    actualSize = new BigInteger(storedContentLength, 10);
                    storageObject = null;
                } else {
                    response.ignore();
                    throw JsonResumableSessionFailureScenario.SCENARIO_0_1.toStorageException(this.uploadId, response, null, (StorageException.IOExceptionCallable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$0(), ()Ljava/lang/String;)());
                }
                if (actualSize == null) throw JsonResumableSessionFailureScenario.SCENARIO_0.toStorageException(this.uploadId, response, null, (StorageException.IOExceptionCallable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$1(com.google.api.services.storage.model.StorageObject ), ()Ljava/lang/String;)((StorageObject)storageObject));
                if (storageObject != null) {
                    var10_20 = ResumableOperationResult.complete(storageObject, actualSize.longValue());
                    return var10_20;
                }
                var10_21 = ResumableOperationResult.incremental(actualSize.longValue());
                return var10_21;
            }
            if (!JsonResumableSessionFailureScenario.isContinue(code)) ** GOTO lbl41
            range1 = response.getHeaders().getRange();
            if (range1 != null) {
                range = ByteRangeSpec.parse(range1);
                endOffset = range.endOffset();
                var8_11 = ResumableOperationResult.incremental(endOffset);
                return var8_11;
            }
            throw JsonResumableSessionFailureScenario.QUERY_SCENARIO_1.toStorageException(this.uploadId, response);
lbl41:
            // 1 sources

            cause = new HttpResponseException(response);
            contentType = response.getHeaders().getContentType();
            if (JsonResumableSessionFailureScenario.isOk(code) != false) throw JsonResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            if (JsonResumableSessionFailureScenario.isContinue(code) != false) throw JsonResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            if (contentType == null) throw JsonResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            if (contentType.startsWith("text/plain") == false) throw JsonResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            errorMessage = cause.getContent().toLowerCase(Locale.US);
            if (errorMessage.contains("content-range") == false) throw JsonResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            throw JsonResumableSessionFailureScenario.SCENARIO_5.toStorageException(this.uploadId, response, cause, (StorageException.IOExceptionCallable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getContent(), ()Ljava/lang/String;)((HttpResponseException)cause));
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw JsonResumableSessionFailureScenario.SCENARIO_0.toStorageException(this.uploadId, response, e);
        }
        finally {
            if (response != null) {
                try {
                    response.ignore();
                }
                catch (IOException var11_22) {}
            }
        }
    }

    private static /* synthetic */ String lambda$call$1(StorageObject storageObject) throws IOException {
        return storageObject != null ? storageObject.toString() : null;
    }

    private static /* synthetic */ String lambda$call$0() throws IOException {
        return null;
    }
}

