/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.HttpClientContext;
import com.google.cloud.storage.HttpContentRange;
import com.google.cloud.storage.JsonResumableSession;
import com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.ResumableSession;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.function.LongConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.checkerframework.checker.nullness.qual.Nullable;

@ParametersAreNonnullByDefault
final class ApiaryUnbufferedWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final JsonResumableSession session;
    private final SettableApiFuture<StorageObject> result;
    private final LongConsumer committedBytesCallback;
    private boolean open;
    private long cumulativeByteCount;
    private boolean finished;

    ApiaryUnbufferedWritableByteChannel(HttpClientContext httpClientContext, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, JsonResumableWrite resumableWrite, SettableApiFuture<StorageObject> result, LongConsumer committedBytesCallback) {
        this.session = ResumableSession.json(httpClientContext, deps, alg, resumableWrite);
        this.result = result;
        this.committedBytesCallback = committedBytesCallback;
        this.open = true;
        this.cumulativeByteCount = resumableWrite.getBeginOffset();
        this.finished = false;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        HttpContentRange header;
        if (!this.open) {
            throw new ClosedChannelException();
        }
        RewindableContent content = RewindableContent.of(Utils.subArray(srcs, offset, length));
        long available = content.getLength();
        long newFinalByteOffset = this.cumulativeByteCount + available;
        ByteRangeSpec rangeSpec = ByteRangeSpec.explicit(this.cumulativeByteCount, newFinalByteOffset);
        if (available % 262144L == 0L) {
            header = HttpContentRange.of(rangeSpec);
        } else {
            header = HttpContentRange.of(rangeSpec, newFinalByteOffset);
            this.finished = true;
        }
        try {
            ResumableOperationResult<@Nullable StorageObject> operationResult = this.session.put(content, header);
            long persistedSize = operationResult.getPersistedSize();
            this.committedBytesCallback.accept(persistedSize);
            this.cumulativeByteCount = persistedSize;
            if (this.finished) {
                StorageObject storageObject = operationResult.getObject();
                this.result.set((Object)storageObject);
            }
            return available;
        }
        catch (Exception e) {
            this.result.setException((Throwable)e);
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        if (!this.finished) {
            try {
                ResumableOperationResult<@Nullable StorageObject> operationResult = this.session.put(RewindableContent.empty(), HttpContentRange.of(this.cumulativeByteCount));
                long persistedSize = operationResult.getPersistedSize();
                this.committedBytesCallback.accept(persistedSize);
                this.result.set((Object)operationResult.getObject());
            }
            catch (Exception e) {
                this.result.setException((Throwable)e);
                throw StorageException.coalesce(e);
            }
        }
    }
}

