/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ApiaryUnbufferedReadableByteChannel;
import com.google.cloud.storage.BlobReadChannelV2;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.storage.ChannelSession;
import com.google.cloud.storage.DefaultBufferedReadableByteChannel;
import com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.concurrent.Immutable;

@Immutable
final class HttpDownloadSessionBuilder {
    private static final HttpDownloadSessionBuilder INSTANCE = new HttpDownloadSessionBuilder();
    private static final int DEFAULT_BUFFER_CAPACITY = 0x200000;

    private HttpDownloadSessionBuilder() {
    }

    public static HttpDownloadSessionBuilder create() {
        return INSTANCE;
    }

    public ReadableByteChannelSessionBuilder byteChannel(BlobReadChannelV2.BlobReadChannelContext blobReadChannelContext) {
        return new ReadableByteChannelSessionBuilder(blobReadChannelContext);
    }

    public static final class ReadableByteChannelSessionBuilder {
        private final BlobReadChannelV2.BlobReadChannelContext blobReadChannelContext;
        private Consumer<StorageObject> callback;

        private ReadableByteChannelSessionBuilder(BlobReadChannelV2.BlobReadChannelContext blobReadChannelContext) {
            this.blobReadChannelContext = blobReadChannelContext;
        }

        public ReadableByteChannelSessionBuilder setCallback(Consumer<StorageObject> callback) {
            this.callback = callback;
            return this;
        }

        public BufferedReadableByteChannelSessionBuilder buffered() {
            return this.buffered(BufferHandle.allocate(0x200000));
        }

        public BufferedReadableByteChannelSessionBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedReadableByteChannelSessionBuilder(bufferHandle, this.bindFunction());
        }

        public BufferedReadableByteChannelSessionBuilder buffered(ByteBuffer buffer) {
            return this.buffered(BufferHandle.handleOf(buffer));
        }

        public UnbufferedReadableByteChannelSessionBuilder unbuffered() {
            return new UnbufferedReadableByteChannelSessionBuilder(this.bindFunction());
        }

        private BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> bindFunction() {
            return (request, resultFuture) -> new ApiaryUnbufferedReadableByteChannel((ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest)request, this.blobReadChannelContext.getApiaryClient(), (SettableApiFuture<StorageObject>)resultFuture, this.blobReadChannelContext.getStorageOptions(), this.blobReadChannelContext.getRetryAlgorithmManager().idempotent(), this.callback);
        }

        public static final class UnbufferedReadableByteChannelSessionBuilder {
            private final BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f;
            private ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request;

            private UnbufferedReadableByteChannelSessionBuilder(BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
                this.f = f;
            }

            public UnbufferedReadableByteChannelSessionBuilder setApiaryReadRequest(ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request) {
                this.request = Objects.requireNonNull(request, "request must be non null");
                return this;
            }

            public UnbufferedReadableByteChannelSession<StorageObject> build() {
                return new ChannelSession.UnbufferedReadSession<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, StorageObject>((ApiFuture<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest>)ApiFutures.immediateFuture((Object)this.request), this.f.andThen(StorageByteChannels.readable()::createSynchronized));
            }
        }

        public static final class BufferedReadableByteChannelSessionBuilder {
            private final BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, BufferedReadableByteChannelSession.BufferedReadableByteChannel> f;
            private ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request;

            private BufferedReadableByteChannelSessionBuilder(BufferHandle buffer, BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
                this.f = f.andThen(c -> new DefaultBufferedReadableByteChannel(buffer, (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel)c));
            }

            public BufferedReadableByteChannelSessionBuilder setApiaryReadRequest(ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request) {
                this.request = Objects.requireNonNull(request, "request must be non null");
                return this;
            }

            public BufferedReadableByteChannelSession<StorageObject> build() {
                return new ChannelSession.BufferedReadSession<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, StorageObject>((ApiFuture<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest>)ApiFutures.immediateFuture((Object)this.request), this.f.andThen(StorageByteChannels.readable()::createSynchronized));
            }
        }
    }
}

