/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.paging.Page;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.ServiceAccountSigner;
import com.google.cloud.BaseService;
import com.google.cloud.BatchResult;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.PageImpl;
import com.google.cloud.Policy;
import com.google.cloud.ReadChannel;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobReadChannel;
import com.google.cloud.storage.BlobWriteChannel;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.PolicyHelper;
import com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.RetryAlgorithmManager;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.SignatureInfo;
import com.google.cloud.storage.SignedUrlEncodingHelper;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

final class StorageImpl
extends BaseService<StorageOptions>
implements Storage {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String EMPTY_BYTE_ARRAY_MD5 = "1B2M2Y8AsgTpgAmY7PhCfg==";
    private static final String EMPTY_BYTE_ARRAY_CRC32C = "AAAAAA==";
    private static final String PATH_DELIMITER = "/";
    private static final String STORAGE_XML_URI_SCHEME = "https";
    private static final String STORAGE_XML_URI_HOST_NAME = "storage.googleapis.com";
    private static final int DEFAULT_BUFFER_SIZE = 0xF00000;
    private static final int MIN_BUFFER_SIZE = 262144;
    private final RetryAlgorithmManager retryAlgorithmManager;
    private final StorageRpc storageRpc;

    StorageImpl(StorageOptions options) {
        super((ServiceOptions)options);
        this.retryAlgorithmManager = options.getRetryAlgorithmManager();
        this.storageRpc = options.getStorageRpcV1();
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        com.google.api.services.storage.model.Bucket bucketPb = bucketInfo.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(bucketInfo, (Option[])options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketsCreate(bucketPb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.create(bucketPb, optionsMap), b -> Bucket.fromPb(this, b));
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(EMPTY_BYTE_ARRAY_MD5).setCrc32c(EMPTY_BYTE_ARRAY_CRC32C).build();
        return this.internalCreate(updatedInfo, EMPTY_BYTE_ARRAY, 0, 0, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        content = (byte[])MoreObjects.firstNonNull((Object)content, (Object)EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content).asBytes())).setCrc32c(BaseEncoding.base64().encode(Ints.toByteArray((int)Hashing.crc32c().hashBytes(content).asInt()))).build();
        return this.internalCreate(updatedInfo, content, 0, content.length, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        content = (byte[])MoreObjects.firstNonNull((Object)content, (Object)EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content, offset, length).asBytes())).setCrc32c(BaseEncoding.base64().encode(Ints.toByteArray((int)Hashing.crc32c().hashBytes(content, offset, length).asInt()))).build();
        return this.internalCreate(updatedInfo, content, offset, length, options);
    }

    @Override
    @Deprecated
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        Tuple<BlobInfo, Storage.BlobTargetOption[]> targetOptions = Storage.BlobTargetOption.convert(blobInfo, options);
        StorageObject blobPb = ((BlobInfo)targetOptions.x()).toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap((BlobInfo)targetOptions.x(), (Option[])targetOptions.y());
        InputStream inputStreamParam = (InputStream)MoreObjects.firstNonNull((Object)content, (Object)new ByteArrayInputStream(EMPTY_BYTE_ARRAY));
        return Blob.fromPb(this, this.storageRpc.create(blobPb, inputStreamParam, optionsMap));
    }

    private Blob internalCreate(BlobInfo info, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        Preconditions.checkNotNull((Object)content);
        StorageObject blobPb = info.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(info, (Option[])options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectsCreate(blobPb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.create(blobPb, new ByteArrayInputStream(content, offset, length), optionsMap), x -> Blob.fromPb(this, x));
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, Storage.BlobWriteOption ... options) throws IOException {
        return this.createFrom(blobInfo, path, 0xF00000, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new StorageException(0, path + " is a directory");
        }
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            Blob blob = this.createFrom(blobInfo, input, bufferSize, options);
            return blob;
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) throws IOException {
        return this.createFrom(blobInfo, content, 0xF00000, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        BlobWriteChannel blobWriteChannel;
        try (BlobWriteChannel writer = this.writer(blobInfo, options);){
            blobWriteChannel = writer;
            StorageImpl.uploadHelper(Channels.newChannel(content), (WriteChannel)writer, bufferSize);
        }
        StorageObject objectProto = blobWriteChannel.getStorageObject();
        return Blob.fromPb(this, objectProto);
    }

    private static void uploadHelper(ReadableByteChannel reader, WriteChannel writer, int bufferSize) throws IOException {
        bufferSize = Math.max(bufferSize, 262144);
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        writer.setChunkSize(bufferSize);
        while (reader.read(buffer) >= 0) {
            buffer.flip();
            writer.write(buffer);
            buffer.clear();
        }
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        com.google.api.services.storage.model.Bucket bucketPb = BucketInfo.of(bucket).toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketsGet(bucketPb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.get(bucketPb, optionsMap), b -> Bucket.fromPb(this, b));
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.get(BlobId.of(bucket, blob), options);
    }

    @Override
    public Blob get(BlobId blob, Storage.BlobGetOption ... options) {
        StorageObject storedObject = blob.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectsGet(storedObject, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.get(storedObject, optionsMap), x -> Blob.fromPb(this, x));
    }

    @Override
    public Blob get(BlobId blob) {
        return this.get(blob, new Storage.BlobGetOption[0]);
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        return StorageImpl.listBuckets((StorageOptions)this.getOptions(), StorageImpl.optionMap(options));
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        return StorageImpl.listBlobs(bucket, (StorageOptions)this.getOptions(), StorageImpl.optionMap(options));
    }

    private static Page<Bucket> listBuckets(StorageOptions serviceOptions, Map<StorageRpc.Option, ?> optionsMap) {
        ExceptionHandler exceptionHandler = serviceOptions.getRetryAlgorithmManager().getForBucketsList(optionsMap);
        return (Page)Retrying.run(serviceOptions, exceptionHandler, () -> serviceOptions.getStorageRpcV1().list(optionsMap), result -> {
            String cursor = (String)result.x();
            ImmutableList buckets = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), bucketPb -> Bucket.fromPb((Storage)serviceOptions.getService(), bucketPb));
            return new PageImpl((PageImpl.NextPageFetcher)new BucketPageFetcher(serviceOptions, cursor, optionsMap), cursor, (Iterable)buckets);
        });
    }

    private static Page<Blob> listBlobs(String bucket, StorageOptions serviceOptions, Map<StorageRpc.Option, ?> optionsMap) {
        ExceptionHandler exceptionHandler = serviceOptions.getRetryAlgorithmManager().getForObjectsList(bucket, optionsMap);
        return (Page)Retrying.run(serviceOptions, exceptionHandler, () -> serviceOptions.getStorageRpcV1().list(bucket, optionsMap), result -> {
            String cursor = (String)result.x();
            ImmutableList blobs = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), storageObject -> Blob.fromPb((Storage)serviceOptions.getService(), storageObject));
            return new PageImpl((PageImpl.NextPageFetcher)new BlobPageFetcher(bucket, serviceOptions, cursor, optionsMap), cursor, (Iterable)blobs);
        });
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        com.google.api.services.storage.model.Bucket bucketPb = bucketInfo.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(bucketInfo, (Option[])options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketsUpdate(bucketPb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.patch(bucketPb, optionsMap), x -> Bucket.fromPb(this, x));
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        StorageObject storageObject = blobInfo.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blobInfo, (Option[])options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectsUpdate(storageObject, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.patch(storageObject, optionsMap), x -> Blob.fromPb(this, x));
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        return this.update(blobInfo, new Storage.BlobTargetOption[0]);
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        com.google.api.services.storage.model.Bucket bucketPb = BucketInfo.of(bucket).toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketsDelete(bucketPb, optionsMap);
        return (Boolean)this.run(exceptionHandler, () -> this.storageRpc.delete(bucketPb, optionsMap), Function.identity());
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.delete(BlobId.of(bucket, blob), options);
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        StorageObject storageObject = blob.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectsDelete(storageObject, optionsMap);
        return (Boolean)this.run(exceptionHandler, () -> this.storageRpc.delete(storageObject, optionsMap), Function.identity());
    }

    @Override
    public boolean delete(BlobId blob) {
        return this.delete(blob, new Storage.BlobSourceOption[0]);
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        ArrayList sources = Lists.newArrayListWithCapacity((int)composeRequest.getSourceBlobs().size());
        for (Storage.ComposeRequest.SourceBlob sourceBlob : composeRequest.getSourceBlobs()) {
            sources.add(BlobInfo.newBuilder(BlobId.of(composeRequest.getTarget().getBucket(), sourceBlob.getName(), sourceBlob.getGeneration())).build().toPb());
        }
        StorageObject target = composeRequest.getTarget().toPb();
        Map<StorageRpc.Option, ?> targetOptions = StorageImpl.optionMap(composeRequest.getTarget().getGeneration(), composeRequest.getTarget().getMetageneration(), composeRequest.getTargetOptions());
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectsCompose(sources, target, targetOptions);
        return this.run(exceptionHandler, () -> this.storageRpc.compose(sources, target, targetOptions), x -> Blob.fromPb(this, x));
    }

    @Override
    public CopyWriter copy(Storage.CopyRequest copyRequest) {
        StorageObject source = copyRequest.getSource().toPb();
        Map<StorageRpc.Option, ?> sourceOptions = StorageImpl.optionMap(copyRequest.getSource().getGeneration(), null, copyRequest.getSourceOptions(), true);
        StorageObject targetObject = copyRequest.getTarget().toPb();
        Map<StorageRpc.Option, ?> targetOptions = StorageImpl.optionMap(copyRequest.getTarget().getGeneration(), copyRequest.getTarget().getMetageneration(), copyRequest.getTargetOptions());
        StorageRpc.RewriteRequest rewriteRequest = new StorageRpc.RewriteRequest(source, sourceOptions, copyRequest.overrideInfo(), targetObject, targetOptions, copyRequest.getMegabytesCopiedPerChunk());
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectsRewrite(rewriteRequest);
        return this.run(exceptionHandler, () -> this.storageRpc.openRewrite(rewriteRequest), r -> new CopyWriter((StorageOptions)this.getOptions(), (StorageRpc.RewriteResponse)r));
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.readAllBytes(BlobId.of(bucket, blob), options);
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        StorageObject storageObject = blob.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectsGet(storageObject, optionsMap);
        return (byte[])this.run(exceptionHandler, () -> this.storageRpc.load(storageObject, optionsMap), Function.identity());
    }

    @Override
    public StorageBatch batch() {
        return new StorageBatch((StorageOptions)this.getOptions());
    }

    @Override
    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        return new BlobReadChannel((StorageOptions)this.getOptions(), BlobId.of(bucket, blob), optionsMap);
    }

    @Override
    public ReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        return new BlobReadChannel((StorageOptions)this.getOptions(), blob, optionsMap);
    }

    public BlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        Tuple<BlobInfo, Storage.BlobTargetOption[]> targetOptions = Storage.BlobTargetOption.convert(blobInfo, options);
        return this.writer((BlobInfo)targetOptions.x(), (Storage.BlobTargetOption[])targetOptions.y());
    }

    public BlobWriteChannel writer(URL signedURL) {
        ExceptionHandler forResumableUploadSessionCreate = this.retryAlgorithmManager.getForResumableUploadSessionCreate(Collections.emptyMap());
        return BlobWriteChannel.newBuilder().setStorageOptions((StorageOptions)this.getOptions()).setUploadIdSupplier(ResumableMedia.startUploadForSignedUrl((StorageOptions)this.getOptions(), signedURL, forResumableUploadSessionCreate)).setPutExceptionHandler(this.retryAlgorithmManager.getForResumableUploadSessionWrite(StorageImpl.optionMap(new Option[0]))).build();
    }

    private BlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blobInfo, (Option[])options);
        return BlobWriteChannel.newBuilder().setStorageOptions((StorageOptions)this.getOptions()).setUploadIdSupplier(ResumableMedia.startUploadForBlobInfo((StorageOptions)this.getOptions(), blobInfo, optionsMap, this.retryAlgorithmManager.getForResumableUploadSessionCreate(optionsMap))).setPutExceptionHandler(this.retryAlgorithmManager.getForResumableUploadSessionWrite(optionsMap)).build();
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        boolean usePathStyle;
        String storageXmlHostName;
        EnumMap optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.SignUrlOption option : options) {
            optionMap.put(option.getOption(), option.getValue());
        }
        boolean isV2 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V2);
        boolean isV4 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V4);
        ServiceAccountSigner credentials = (ServiceAccountSigner)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        if (credentials == null) {
            Preconditions.checkState((boolean)(((StorageOptions)this.getOptions()).getCredentials() instanceof ServiceAccountSigner), (Object)"Signing key was not provided and could not be derived");
            credentials = (ServiceAccountSigner)((StorageOptions)this.getOptions()).getCredentials();
        }
        long expiration = isV4 ? TimeUnit.SECONDS.convert(unit.toMillis(duration), TimeUnit.MILLISECONDS) : TimeUnit.SECONDS.convert(((StorageOptions)this.getOptions()).getClock().millisTime() + unit.toMillis(duration), TimeUnit.MILLISECONDS);
        Preconditions.checkArgument((!optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.PATH_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME) ? 1 : 0) != 0, (Object)"Only one of VIRTUAL_HOSTED_STYLE, PATH_STYLE, or BUCKET_BOUND_HOST_NAME SignUrlOptions can be specified.");
        String bucketName = this.slashlessBucketNameFromBlobInfo(blobInfo);
        String escapedBlobName = "";
        if (!Strings.isNullOrEmpty((String)blobInfo.getName())) {
            escapedBlobName = SignedUrlEncodingHelper.Rfc3986UriEncode(blobInfo.getName(), false);
        }
        String string = storageXmlHostName = (usePathStyle = this.shouldUsePathStyleForSignedUrl(optionMap)) ? "https://" + this.getBaseStorageHostName(optionMap) : "https://" + bucketName + "." + this.getBaseStorageHostName(optionMap);
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME)) {
            storageXmlHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
        }
        String stPath = usePathStyle ? this.constructResourceUriPath(bucketName, escapedBlobName, optionMap) : this.constructResourceUriPath("", escapedBlobName, optionMap);
        URI path = URI.create(stPath);
        URI pathForSigning = isV2 ? URI.create(this.constructResourceUriPath(bucketName, escapedBlobName, optionMap)) : path;
        try {
            SignatureInfo signatureInfo = this.buildSignatureInfo(optionMap, blobInfo, expiration, pathForSigning, credentials.getAccount());
            String unsignedPayload = signatureInfo.constructUnsignedPayload();
            byte[] signatureBytes = credentials.sign(unsignedPayload.getBytes(StandardCharsets.UTF_8));
            StringBuilder stBuilder = new StringBuilder();
            stBuilder.append(storageXmlHostName).append(path);
            if (isV4) {
                BaseEncoding encoding = BaseEncoding.base16().lowerCase();
                String signature = URLEncoder.encode(encoding.encode(signatureBytes), StandardCharsets.UTF_8.name());
                String v4QueryString = signatureInfo.constructV4QueryString();
                stBuilder.append('?');
                if (!Strings.isNullOrEmpty((String)v4QueryString)) {
                    stBuilder.append(v4QueryString).append('&');
                }
                stBuilder.append("X-Goog-Signature=").append(signature);
            } else {
                BaseEncoding encoding = BaseEncoding.base64();
                String signature = URLEncoder.encode(encoding.encode(signatureBytes), StandardCharsets.UTF_8.name());
                String v2QueryString = signatureInfo.constructV2QueryString();
                stBuilder.append('?');
                if (!Strings.isNullOrEmpty((String)v2QueryString)) {
                    stBuilder.append(v2QueryString).append('&');
                }
                stBuilder.append("GoogleAccessId=").append(credentials.getAccount());
                stBuilder.append("&Expires=").append(expiration);
                stBuilder.append("&Signature=").append(signature);
            }
            return new URL(stBuilder.toString());
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        EnumMap optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.PostPolicyV4Option option : options) {
            optionMap.put(Storage.SignUrlOption.Option.valueOf(option.getOption().name()), option.getValue());
        }
        optionMap.put(Storage.SignUrlOption.Option.SIGNATURE_VERSION, Storage.SignUrlOption.SignatureVersion.V4);
        ServiceAccountSigner credentials = (ServiceAccountSigner)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        if (credentials == null) {
            Preconditions.checkState((boolean)(((StorageOptions)this.getOptions()).getCredentials() instanceof ServiceAccountSigner), (Object)"Signing key was not provided and could not be derived");
            credentials = (ServiceAccountSigner)((StorageOptions)this.getOptions()).getCredentials();
        }
        Preconditions.checkArgument((!optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.PATH_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME) ? 1 : 0) != 0, (Object)"Only one of VIRTUAL_HOSTED_STYLE, PATH_STYLE, or BUCKET_BOUND_HOST_NAME SignUrlOptions can be specified.");
        String bucketName = this.slashlessBucketNameFromBlobInfo(blobInfo);
        boolean usePathStyle = this.shouldUsePathStyleForSignedUrl(optionMap);
        String url = usePathStyle ? "https://storage.googleapis.com/" + bucketName + PATH_DELIMITER : "https://" + bucketName + "." + STORAGE_XML_URI_HOST_NAME + PATH_DELIMITER;
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME)) {
            url = optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME) + PATH_DELIMITER;
        }
        SimpleDateFormat googDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        SimpleDateFormat yearMonthDayFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat expirationFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        googDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        yearMonthDayFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        expirationFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long timestamp = ((StorageOptions)this.getOptions()).getClock().millisTime();
        String date = googDateFormat.format(timestamp);
        String signingCredential = credentials.getAccount() + PATH_DELIMITER + yearMonthDayFormat.format(timestamp) + "/auto/storage/goog4_request";
        HashMap<String, String> policyFields = new HashMap<String, String>();
        PostPolicyV4.PostConditionsV4.Builder conditionsBuilder = conditions.toBuilder();
        for (Map.Entry<String, String> entry : fields.getFieldsMap().entrySet()) {
            conditionsBuilder.addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, entry.getKey(), entry.getValue());
            policyFields.put(entry.getKey(), entry.getValue());
        }
        PostPolicyV4.PostConditionsV4 v4Conditions = conditionsBuilder.addBucketCondition(PostPolicyV4.ConditionV4Type.MATCHES, blobInfo.getBucket()).addKeyCondition(PostPolicyV4.ConditionV4Type.MATCHES, blobInfo.getName()).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-date", date).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-credential", signingCredential).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-algorithm", "GOOG4-RSA-SHA256").build();
        PostPolicyV4.PostPolicyV4Document document = PostPolicyV4.PostPolicyV4Document.of(expirationFormat.format(timestamp + unit.toMillis(duration)), v4Conditions);
        String policy = BaseEncoding.base64().encode(document.toJson().getBytes());
        String signature = BaseEncoding.base16().encode(credentials.sign(policy.getBytes())).toLowerCase();
        for (PostPolicyV4.ConditionV4 condition : v4Conditions.getConditions()) {
            if (condition.type != PostPolicyV4.ConditionV4Type.MATCHES) continue;
            policyFields.put(condition.operand1, condition.operand2);
        }
        policyFields.put("key", blobInfo.getName());
        policyFields.put("x-goog-credential", signingCredential);
        policyFields.put("x-goog-algorithm", "GOOG4-RSA-SHA256");
        policyFields.put("x-goog-date", date);
        policyFields.put("x-goog-signature", signature);
        policyFields.put("policy", policy);
        policyFields.remove("bucket");
        return PostPolicyV4.of(url, policyFields);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, PostPolicyV4.PostConditionsV4.newBuilder().build(), options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, PostPolicyV4.PostFieldsV4.newBuilder().build(), conditions, options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, PostPolicyV4.PostFieldsV4.newBuilder().build(), options);
    }

    private String constructResourceUriPath(String slashlessBucketName, String escapedBlobName, EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        if (Strings.isNullOrEmpty((String)slashlessBucketName)) {
            if (Strings.isNullOrEmpty((String)escapedBlobName)) {
                return PATH_DELIMITER;
            }
            if (escapedBlobName.startsWith(PATH_DELIMITER)) {
                return escapedBlobName;
            }
            return PATH_DELIMITER + escapedBlobName;
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(PATH_DELIMITER).append(slashlessBucketName);
        if (Strings.isNullOrEmpty((String)escapedBlobName)) {
            boolean isV2 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V2);
            if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) && isV2) {
                pathBuilder.append(PATH_DELIMITER);
            }
            return pathBuilder.toString();
        }
        pathBuilder.append(PATH_DELIMITER);
        pathBuilder.append(escapedBlobName);
        return pathBuilder.toString();
    }

    private Storage.SignUrlOption.SignatureVersion getPreferredSignatureVersion(EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        for (Storage.SignUrlOption.SignatureVersion version : Storage.SignUrlOption.SignatureVersion.values()) {
            if (!version.equals(optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION))) continue;
            return version;
        }
        return Storage.SignUrlOption.SignatureVersion.V2;
    }

    private boolean shouldUsePathStyleForSignedUrl(EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        return !optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) && !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
    }

    private SignatureInfo buildSignatureInfo(Map<Storage.SignUrlOption.Option, Object> optionMap, BlobInfo blobInfo, long expiration, URI path, String accountEmail) {
        HttpMethod httpVerb = optionMap.containsKey((Object)Storage.SignUrlOption.Option.HTTP_METHOD) ? (HttpMethod)((Object)optionMap.get((Object)Storage.SignUrlOption.Option.HTTP_METHOD)) : HttpMethod.GET;
        SignatureInfo.Builder signatureInfoBuilder = new SignatureInfo.Builder(httpVerb, expiration, path);
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.MD5)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.getMd5() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for md5");
            signatureInfoBuilder.setContentMd5(blobInfo.getMd5());
        }
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.CONTENT_TYPE)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.getContentType() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for content-type");
            signatureInfoBuilder.setContentType(blobInfo.getContentType());
        }
        signatureInfoBuilder.setSignatureVersion((Storage.SignUrlOption.SignatureVersion)((Object)optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION)));
        signatureInfoBuilder.setAccountEmail(accountEmail);
        signatureInfoBuilder.setTimestamp(((StorageOptions)this.getOptions()).getClock().millisTime());
        ImmutableMap.Builder extHeadersBuilder = new ImmutableMap.Builder();
        boolean isV4 = Storage.SignUrlOption.SignatureVersion.V4.equals(optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION));
        if (isV4) {
            if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE)) {
                extHeadersBuilder.put((Object)"host", (Object)(this.slashlessBucketNameFromBlobInfo(blobInfo) + "." + this.getBaseStorageHostName(optionMap)));
            } else if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.HOST_NAME) || optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME)) {
                extHeadersBuilder.put((Object)"host", (Object)this.getBaseStorageHostName(optionMap));
            }
        }
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.EXT_HEADERS)) {
            extHeadersBuilder.putAll((Map)optionMap.get((Object)Storage.SignUrlOption.Option.EXT_HEADERS));
        }
        ImmutableMap.Builder queryParamsBuilder = new ImmutableMap.Builder();
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.QUERY_PARAMS)) {
            queryParamsBuilder.putAll((Map)optionMap.get((Object)Storage.SignUrlOption.Option.QUERY_PARAMS));
        }
        return signatureInfoBuilder.setCanonicalizedExtensionHeaders((Map<String, String>)extHeadersBuilder.build()).setCanonicalizedQueryParams((Map<String, String>)queryParamsBuilder.build()).build();
    }

    private String slashlessBucketNameFromBlobInfo(BlobInfo blobInfo) {
        return CharMatcher.anyOf((CharSequence)PATH_DELIMITER).trimFrom((CharSequence)blobInfo.getBucket());
    }

    private String getBaseStorageHostName(Map<Storage.SignUrlOption.Option, Object> optionMap) {
        String specifiedBaseHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.HOST_NAME);
        String bucketBoundHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
        if (!Strings.isNullOrEmpty((String)specifiedBaseHostName)) {
            return specifiedBaseHostName.replaceFirst("http(s)?://", "");
        }
        if (!Strings.isNullOrEmpty((String)bucketBoundHostName)) {
            return bucketBoundHostName.replaceFirst("http(s)?://", "");
        }
        return STORAGE_XML_URI_HOST_NAME;
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        return this.get(Arrays.asList(blobIds));
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.get(blob, new Storage.BlobGetOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Blob, StorageException>(){

                public void success(Blob result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        return this.update(Arrays.asList(blobInfos));
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobInfo blobInfo : blobInfos) {
            batch.update(blobInfo, new Storage.BlobTargetOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Blob, StorageException>(){

                public void success(Blob result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        return this.delete(Arrays.asList(blobIds));
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.delete(blob, new Storage.BlobSourceOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Boolean, StorageException>(){

                public void success(Boolean result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(Boolean.FALSE);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        String pb = entity.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketAclGet(pb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.getAcl(bucket, pb, optionsMap), Acl::fromPb);
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity) {
        return this.getAcl(bucket, entity, new Storage.BucketSourceOption[0]);
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        String pb = entity.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketAclDelete(pb, optionsMap);
        return (Boolean)this.run(exceptionHandler, () -> this.storageRpc.deleteAcl(bucket, pb, optionsMap), Function.identity());
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity) {
        return this.deleteAcl(bucket, entity, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        BucketAccessControl aclPb = acl.toBucketPb().setBucket(bucket);
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketAclCreate(aclPb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.createAcl(aclPb, optionsMap), Acl::fromPb);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        return this.createAcl(bucket, acl, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        BucketAccessControl aclPb = acl.toBucketPb().setBucket(bucket);
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketAclUpdate(aclPb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.patchAcl(aclPb, optionsMap), Acl::fromPb);
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        return this.updateAcl(bucket, acl, new Storage.BucketSourceOption[0]);
    }

    @Override
    public List<Acl> listAcls(String bucket, Storage.BucketSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketAclList(bucket, optionsMap);
        return (List)this.run(exceptionHandler, () -> this.storageRpc.listAcls(bucket, optionsMap), answer -> (ImmutableList)answer.stream().map(Acl.FROM_BUCKET_PB_FUNCTION).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public List<Acl> listAcls(String bucket) {
        return this.listAcls(bucket, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl getDefaultAcl(String bucket, Acl.Entity entity) {
        String pb = entity.toPb();
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForDefaultObjectAclGet(pb);
        return this.run(exceptionHandler, () -> this.storageRpc.getDefaultAcl(bucket, pb), Acl::fromPb);
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, Acl.Entity entity) {
        String pb = entity.toPb();
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForDefaultObjectAclDelete(pb);
        return (Boolean)this.run(exceptionHandler, () -> this.storageRpc.deleteDefaultAcl(bucket, pb), Function.identity());
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        ObjectAccessControl aclPb = acl.toObjectPb().setBucket(bucket);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForDefaultObjectAclCreate(aclPb);
        return this.run(exceptionHandler, () -> this.storageRpc.createDefaultAcl(aclPb), Acl::fromPb);
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        ObjectAccessControl aclPb = acl.toObjectPb().setBucket(bucket);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForDefaultObjectAclUpdate(aclPb);
        return this.run(exceptionHandler, () -> this.storageRpc.patchDefaultAcl(aclPb), Acl::fromPb);
    }

    @Override
    public List<Acl> listDefaultAcls(String bucket) {
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForDefaultObjectAclList(bucket);
        return (List)this.run(exceptionHandler, () -> this.storageRpc.listDefaultAcls(bucket), answer -> (ImmutableList)answer.stream().map(Acl.FROM_OBJECT_PB_FUNCTION).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Acl getAcl(BlobId blob, Acl.Entity entity) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        String pb = entity.toPb();
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectAclGet(bucket, name, generation, pb);
        return this.run(exceptionHandler, () -> this.storageRpc.getAcl(bucket, name, generation, pb), Acl::fromPb);
    }

    @Override
    public boolean deleteAcl(BlobId blob, Acl.Entity entity) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        String pb = entity.toPb();
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectAclDelete(bucket, name, generation, pb);
        return (Boolean)this.run(exceptionHandler, () -> this.storageRpc.deleteAcl(bucket, name, generation, pb), Function.identity());
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        ObjectAccessControl aclPb = acl.toObjectPb().setBucket(blob.getBucket()).setObject(blob.getName()).setGeneration(blob.getGeneration());
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectAclCreate(aclPb);
        return this.run(exceptionHandler, () -> this.storageRpc.createAcl(aclPb), Acl::fromPb);
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        ObjectAccessControl aclPb = acl.toObjectPb().setBucket(blob.getBucket()).setObject(blob.getName()).setGeneration(blob.getGeneration());
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectAclUpdate(aclPb);
        return this.run(exceptionHandler, () -> this.storageRpc.patchAcl(aclPb), Acl::fromPb);
    }

    @Override
    public List<Acl> listAcls(BlobId blob) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForObjectAclList(bucket, name, generation);
        return (List)this.run(exceptionHandler, () -> this.storageRpc.listAcls(bucket, name, generation), answer -> (ImmutableList)answer.stream().map(Acl.FROM_OBJECT_PB_FUNCTION).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public HmacKey createHmacKey(ServiceAccount serviceAccount, Storage.CreateHmacKeyOption ... options) {
        String pb = serviceAccount.getEmail();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForHmacKeyCreate(pb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.createHmacKey(pb, optionsMap), HmacKey::fromPb);
    }

    @Override
    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(Storage.ListHmacKeysOption ... options) {
        return StorageImpl.listHmacKeys((StorageOptions)this.getOptions(), this.retryAlgorithmManager, StorageImpl.optionMap(options));
    }

    @Override
    public HmacKey.HmacKeyMetadata getHmacKey(String accessId, Storage.GetHmacKeyOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForHmacKeyGet(accessId, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.getHmacKey(accessId, StorageImpl.optionMap(options)), HmacKey.HmacKeyMetadata::fromPb);
    }

    private HmacKey.HmacKeyMetadata updateHmacKey(HmacKey.HmacKeyMetadata hmacKeyMetadata, Storage.UpdateHmacKeyOption ... options) {
        HmacKeyMetadata pb = hmacKeyMetadata.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForHmacKeyUpdate(pb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.updateHmacKey(pb, optionsMap), HmacKey.HmacKeyMetadata::fromPb);
    }

    @Override
    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata hmacKeyMetadata, HmacKey.HmacKeyState state, Storage.UpdateHmacKeyOption ... options) {
        HmacKey.HmacKeyMetadata updatedMetadata = HmacKey.HmacKeyMetadata.newBuilder(hmacKeyMetadata.getServiceAccount()).setProjectId(hmacKeyMetadata.getProjectId()).setAccessId(hmacKeyMetadata.getAccessId()).setState(state).build();
        return this.updateHmacKey(updatedMetadata, options);
    }

    @Override
    public void deleteHmacKey(HmacKey.HmacKeyMetadata metadata, Storage.DeleteHmacKeyOption ... options) {
        HmacKeyMetadata pb = metadata.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForHmacKeyDelete(pb, optionsMap);
        this.run(exceptionHandler, () -> {
            this.storageRpc.deleteHmacKey(pb, optionsMap);
            return null;
        }, Function.identity());
    }

    private static Page<HmacKey.HmacKeyMetadata> listHmacKeys(StorageOptions serviceOptions, RetryAlgorithmManager retryAlgorithmManager, Map<StorageRpc.Option, ?> options) {
        ExceptionHandler exceptionHandler = retryAlgorithmManager.getForHmacKeyList(options);
        return (Page)Retrying.run(serviceOptions, exceptionHandler, () -> serviceOptions.getStorageRpcV1().listHmacKeys(options), result -> {
            String cursor = (String)result.x();
            ImmutableList metadata = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), HmacKey.HmacKeyMetadata::fromPb);
            return new PageImpl((PageImpl.NextPageFetcher)new HmacKeyMetadataPageFetcher(serviceOptions, retryAlgorithmManager, options), cursor, (Iterable)metadata);
        });
    }

    @Override
    public Policy getIamPolicy(String bucket, Storage.BucketSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketsGetIamPolicy(bucket, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.getIamPolicy(bucket, optionsMap), PolicyHelper::convertFromApiPolicy);
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Storage.BucketSourceOption ... options) {
        com.google.api.services.storage.model.Policy pb = PolicyHelper.convertToApiPolicy(policy);
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketsSetIamPolicy(bucket, pb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.setIamPolicy(bucket, pb, optionsMap), PolicyHelper::convertFromApiPolicy);
    }

    @Override
    public List<Boolean> testIamPermissions(String bucket, List<String> permissions, Storage.BucketSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketsTestIamPermissions(bucket, permissions, optionsMap);
        return (List)this.run(exceptionHandler, () -> this.storageRpc.testIamPermissions(bucket, permissions, optionsMap), response -> {
            ImmutableSet heldPermissions = response.getPermissions() != null ? ImmutableSet.copyOf((Collection)response.getPermissions()) : ImmutableSet.of();
            return (ImmutableList)permissions.stream().map(((Set)heldPermissions)::contains).collect(ImmutableList.toImmutableList());
        });
    }

    @Override
    public Bucket lockRetentionPolicy(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        com.google.api.services.storage.model.Bucket bucketPb = bucketInfo.toPb();
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(bucketInfo, (Option[])options);
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForBucketsLockRetentionPolicy(bucketPb, optionsMap);
        return this.run(exceptionHandler, () -> this.storageRpc.lockRetentionPolicy(bucketPb, optionsMap), x -> Bucket.fromPb(this, x));
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        ExceptionHandler exceptionHandler = this.retryAlgorithmManager.getForServiceAccountGet(projectId);
        return this.run(exceptionHandler, () -> this.storageRpc.getServiceAccount(projectId), ServiceAccount::fromPb);
    }

    private <T, U> U run(ExceptionHandler exceptionHandler, Callable<T> c, Function<T, U> f) {
        return Retrying.run((StorageOptions)this.getOptions(), exceptionHandler, c, f);
    }

    private static <T> void addToOptionMap(StorageRpc.Option option, T defaultValue, Map<StorageRpc.Option, Object> map) {
        StorageImpl.addToOptionMap(option, option, defaultValue, map);
    }

    private static <T> void addToOptionMap(StorageRpc.Option getOption, StorageRpc.Option putOption, T defaultValue, Map<StorageRpc.Option, Object> map) {
        if (map.containsKey((Object)getOption)) {
            Object value = map.remove((Object)getOption);
            Preconditions.checkArgument((value != null || defaultValue != null ? 1 : 0) != 0, (Object)("Option " + getOption.value() + " is missing a value"));
            value = MoreObjects.firstNonNull((Object)value, defaultValue);
            map.put(putOption, value);
        }
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Iterable<? extends Option> options) {
        return StorageImpl.optionMap(generation, metaGeneration, options, false);
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Iterable<? extends Option> options, boolean useAsSource) {
        EnumMap temp = Maps.newEnumMap(StorageRpc.Option.class);
        for (Option option : options) {
            Object prev = temp.put(option.getRpcOption(), option.getValue());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object)option);
        }
        if (Boolean.TRUE.equals(temp.get((Object)StorageRpc.Option.DELIMITER))) {
            temp.remove((Object)StorageRpc.Option.DELIMITER);
            temp.put(StorageRpc.Option.DELIMITER, PATH_DELIMITER);
        } else if (null != temp.get((Object)StorageRpc.Option.DELIMITER)) {
            temp.put(StorageRpc.Option.DELIMITER, temp.get((Object)StorageRpc.Option.DELIMITER));
        }
        if (useAsSource) {
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_MATCH, StorageRpc.Option.IF_SOURCE_GENERATION_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_NOT_MATCH, StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_MATCH, StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH, metaGeneration, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH, metaGeneration, temp);
        } else {
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_MATCH, metaGeneration, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metaGeneration, temp);
        }
        return ImmutableMap.copyOf((Map)temp);
    }

    private static Map<StorageRpc.Option, ?> optionMap(Option ... options) {
        return StorageImpl.optionMap(null, null, Arrays.asList(options));
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Option ... options) {
        return StorageImpl.optionMap(generation, metaGeneration, Arrays.asList(options));
    }

    private static Map<StorageRpc.Option, ?> optionMap(BucketInfo bucketInfo, Option ... options) {
        return StorageImpl.optionMap(null, bucketInfo.getMetageneration(), options);
    }

    static Map<StorageRpc.Option, ?> optionMap(BlobInfo blobInfo, Option ... options) {
        return StorageImpl.optionMap(blobInfo.getGeneration(), blobInfo.getMetageneration(), options);
    }

    static Map<StorageRpc.Option, ?> optionMap(BlobId blobId, Option ... options) {
        return StorageImpl.optionMap(blobId.getGeneration(), null, options);
    }

    private static class HmacKeyMetadataPageFetcher
    implements PageImpl.NextPageFetcher<HmacKey.HmacKeyMetadata> {
        private static final long serialVersionUID = 308012320541700881L;
        private final StorageOptions serviceOptions;
        private final RetryAlgorithmManager retryAlgorithmManager;
        private final Map<StorageRpc.Option, ?> options;

        HmacKeyMetadataPageFetcher(StorageOptions serviceOptions, RetryAlgorithmManager retryAlgorithmManager, Map<StorageRpc.Option, ?> options) {
            this.serviceOptions = serviceOptions;
            this.retryAlgorithmManager = retryAlgorithmManager;
            this.options = options;
        }

        public Page<HmacKey.HmacKeyMetadata> getNextPage() {
            return StorageImpl.listHmacKeys(this.serviceOptions, this.retryAlgorithmManager, this.options);
        }
    }

    private static class BlobPageFetcher
    implements PageImpl.NextPageFetcher<Blob> {
        private static final long serialVersionUID = 81807334445874098L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final StorageOptions serviceOptions;
        private final String bucket;

        BlobPageFetcher(String bucket, StorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.bucket = bucket;
        }

        public Page<Blob> getNextPage() {
            return StorageImpl.listBlobs(this.bucket, this.serviceOptions, this.requestOptions);
        }
    }

    private static class BucketPageFetcher
    implements PageImpl.NextPageFetcher<Bucket> {
        private static final long serialVersionUID = 5850406828803613729L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final StorageOptions serviceOptions;

        BucketPageFetcher(StorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Bucket> getNextPage() {
            return StorageImpl.listBuckets(this.serviceOptions, this.requestOptions);
        }
    }
}

