/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class PostPolicyV4 {
    private String url;
    private Map<String, String> fields;

    private PostPolicyV4(String url, Map<String, String> fields) {
        this.url = url;
        this.fields = fields;
    }

    public static PostPolicyV4 of(String url, Map<String, String> fields) {
        return new PostPolicyV4(url, fields);
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    static final class ConditionV4 {
        ConditionV4Type type;
        String operand1;
        String operand2;

        private ConditionV4(ConditionV4Type type, String operand1, String operand2) {
            this.type = type;
            this.operand1 = operand1;
            this.operand2 = operand2;
        }

        public boolean equals(Object other) {
            ConditionV4 condition = (ConditionV4)other;
            return this.type == condition.type && this.operand1.equals(condition.operand1) && this.operand2.equals(condition.operand2);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.operand1, this.operand2});
        }
    }

    public static enum ConditionV4Type {
        MATCHES,
        STARTS_WITH,
        CONTENT_LENGTH_RANGE;

    }

    public static final class PostPolicyV4Document {
        private String expiration;
        private PostConditionsV4 conditions;

        private PostPolicyV4Document(String expiration, PostConditionsV4 conditions) {
            this.expiration = expiration;
            this.conditions = conditions;
        }

        public static PostPolicyV4Document of(String expiration, PostConditionsV4 conditions) {
            return new PostPolicyV4Document(expiration, conditions);
        }

        public String toJson() {
            JsonObject object = new JsonObject();
            JsonArray conditions = new JsonArray();
            for (ConditionV4 condition : this.conditions.conditions) {
                switch (condition.type) {
                    case MATCHES: {
                        JsonObject match = new JsonObject();
                        match.addProperty(condition.operand1, condition.operand2);
                        conditions.add((JsonElement)match);
                        break;
                    }
                    case STARTS_WITH: {
                        JsonArray startsWith = new JsonArray();
                        startsWith.add("starts-with");
                        startsWith.add("$" + condition.operand1);
                        startsWith.add(condition.operand2);
                        conditions.add((JsonElement)startsWith);
                        break;
                    }
                    case CONTENT_LENGTH_RANGE: {
                        JsonArray contentLengthRange = new JsonArray();
                        contentLengthRange.add("content-length-range");
                        contentLengthRange.add((Number)Integer.parseInt(condition.operand1));
                        contentLengthRange.add((Number)Integer.parseInt(condition.operand2));
                        conditions.add((JsonElement)contentLengthRange);
                    }
                }
            }
            object.add("conditions", (JsonElement)conditions);
            object.addProperty("expiration", this.expiration);
            String json = object.toString();
            StringBuilder escapedJson = new StringBuilder();
            block15: for (char c : json.toCharArray()) {
                if (c >= '\u0080') {
                    escapedJson.append(String.format("\\u%04x", c));
                    continue;
                }
                switch (c) {
                    case '\\': {
                        escapedJson.append("\\\\");
                        continue block15;
                    }
                    case '\b': {
                        escapedJson.append("\\b");
                        continue block15;
                    }
                    case '\f': {
                        escapedJson.append("\\f");
                        continue block15;
                    }
                    case '\n': {
                        escapedJson.append("\\n");
                        continue block15;
                    }
                    case '\r': {
                        escapedJson.append("\\r");
                        continue block15;
                    }
                    case '\t': {
                        escapedJson.append("\\t");
                        continue block15;
                    }
                    case '\u000b': {
                        escapedJson.append("\\v");
                        continue block15;
                    }
                    default: {
                        escapedJson.append(c);
                    }
                }
            }
            return escapedJson.toString();
        }
    }

    public static final class PostConditionsV4 {
        private Set<ConditionV4> conditions;
        private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

        public PostConditionsV4(Builder builder) {
            this.conditions = builder.conditions;
        }

        public Builder toBuilder() {
            return new Builder(this.conditions);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Set<ConditionV4> getConditions() {
            return this.conditions;
        }

        public static class Builder {
            Set<ConditionV4> conditions;

            private Builder() {
                this.conditions = new LinkedHashSet<ConditionV4>();
            }

            private Builder(Set<ConditionV4> conditions) {
                this.conditions = conditions;
            }

            public static Builder newBuilder() {
                return new Builder();
            }

            public PostConditionsV4 build() {
                return new PostConditionsV4(this);
            }

            public Builder addAclCondition(ConditionV4Type type, String acl) {
                this.conditions.add(new ConditionV4(type, "acl", acl));
                return this;
            }

            public Builder addBucketCondition(ConditionV4Type type, String bucket) {
                this.conditions.add(new ConditionV4(type, "bucket", bucket));
                return this;
            }

            public Builder addCacheControlCondition(ConditionV4Type type, String cacheControl) {
                this.conditions.add(new ConditionV4(type, "cache-control", cacheControl));
                return this;
            }

            public Builder addContentDispositionCondition(ConditionV4Type type, String contentDisposition) {
                this.conditions.add(new ConditionV4(type, "content-disposition", contentDisposition));
                return this;
            }

            public Builder addContentEncodingCondition(ConditionV4Type type, String contentEncoding) {
                this.conditions.add(new ConditionV4(type, "content-encoding", contentEncoding));
                return this;
            }

            public Builder addContentLengthCondition(ConditionV4Type type, int contentLength) {
                this.conditions.add(new ConditionV4(type, "content-length", "" + contentLength));
                return this;
            }

            public Builder addContentTypeCondition(ConditionV4Type type, String contentType) {
                this.conditions.add(new ConditionV4(type, "content-type", contentType));
                return this;
            }

            public Builder addExpiresCondition(ConditionV4Type type, long expires) {
                this.conditions.add(new ConditionV4(type, "expires", dateFormat.format(expires)));
                return this;
            }

            public Builder addExpiresCondition(ConditionV4Type type, String expires) {
                this.conditions.add(new ConditionV4(type, "expires", expires));
                return this;
            }

            public Builder addKeyCondition(ConditionV4Type type, String key) {
                this.conditions.add(new ConditionV4(type, "key", key));
                return this;
            }

            public Builder addSuccessActionRedirectUrlCondition(ConditionV4Type type, String successActionRedirectUrl) {
                this.conditions.add(new ConditionV4(type, "success_action_redirect", successActionRedirectUrl));
                return this;
            }

            public Builder addSuccessActionStatusCondition(ConditionV4Type type, int status) {
                this.conditions.add(new ConditionV4(type, "success_action_status", "" + status));
                return this;
            }

            public Builder addContentLengthRangeCondition(int min, int max) {
                this.conditions.add(new ConditionV4(ConditionV4Type.CONTENT_LENGTH_RANGE, "" + min, "" + max));
                return this;
            }

            Builder addCustomCondition(ConditionV4Type type, String field, String value) {
                this.conditions.add(new ConditionV4(type, field, value));
                return this;
            }
        }
    }

    public static final class PostFieldsV4 {
        private Map<String, String> fieldsMap;

        private PostFieldsV4(Builder builder) {
            this.fieldsMap = builder.fieldsMap;
        }

        private PostFieldsV4(Map<String, String> fields) {
            this.fieldsMap = fields;
        }

        public static PostFieldsV4 of(Map<String, String> fields) {
            return new PostFieldsV4(fields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Map<String, String> getFieldsMap() {
            return this.fieldsMap;
        }

        public static class Builder {
            private Map<String, String> fieldsMap = new HashMap<String, String>();

            private Builder() {
            }

            public PostFieldsV4 build() {
                return new PostFieldsV4(this);
            }

            public Builder setAcl(String acl) {
                this.fieldsMap.put("acl", acl);
                return this;
            }

            public Builder setCacheControl(String cacheControl) {
                this.fieldsMap.put("cache-control", cacheControl);
                return this;
            }

            public Builder setContentDisposition(String contentDisposition) {
                this.fieldsMap.put("content-disposition", contentDisposition);
                return this;
            }

            public Builder setContentEncoding(String contentEncoding) {
                this.fieldsMap.put("content-encoding", contentEncoding);
                return this;
            }

            public Builder setContentLength(int contentLength) {
                this.fieldsMap.put("content-length", "" + contentLength);
                return this;
            }

            public Builder setContentType(String contentType) {
                this.fieldsMap.put("content-type", contentType);
                return this;
            }

            public Builder Expires(String expires) {
                this.fieldsMap.put("expires", expires);
                return this;
            }

            public Builder setSuccessActionRedirect(String successActionRedirect) {
                this.fieldsMap.put("success_action_redirect", successActionRedirect);
                return this;
            }

            public Builder setSuccessActionStatus(int successActionStatus) {
                this.fieldsMap.put("success_action_status", "" + successActionStatus);
                return this;
            }

            public Builder AddCustomMetadataField(String field, String value) {
                this.fieldsMap.put("x-goog-meta-" + field, value);
                return this;
            }
        }
    }
}

