/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageFactory;
import com.google.cloud.storage.StorageImpl;
import com.google.cloud.storage.spi.StorageRpcFactory;
import com.google.cloud.storage.spi.v1.HttpStorageRpc;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class StorageOptions
extends ServiceOptions<Storage, StorageOptions> {
    private static final long serialVersionUID = -2907268477247502947L;
    private static final String API_SHORT_NAME = "Storage";
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/devstorage.full_control");

    private StorageOptions(Builder builder) {
        super(StorageFactory.class, StorageRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new StorageDefaults());
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    protected boolean projectIdRequired() {
        return false;
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected StorageRpc getStorageRpcV1() {
        return (StorageRpc)this.getRpc();
    }

    public static StorageOptions getDefaultInstance() {
        return StorageOptions.newBuilder().build();
    }

    public static StorageOptions getUnauthenticatedInstance() {
        return ((Builder)StorageOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance())).build();
    }

    public Builder toBuilder() {
        return (Builder)new Builder(this).setHost("storage.googleapis.com");
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof StorageOptions && this.baseEquals((StorageOptions)((Object)obj));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class StorageDefaults
    implements ServiceDefaults<Storage, StorageOptions> {
        private StorageDefaults() {
        }

        public StorageFactory getDefaultServiceFactory() {
            return DefaultStorageFactory.INSTANCE;
        }

        public StorageRpcFactory getDefaultRpcFactory() {
            return DefaultStorageRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return StorageOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Storage, StorageOptions, Builder> {
        private Builder() {
        }

        private Builder(StorageOptions options) {
            super((ServiceOptions)options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Storage.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public StorageOptions build() {
            return new StorageOptions(this);
        }
    }

    public static class DefaultStorageRpcFactory
    implements StorageRpcFactory {
        private static final StorageRpcFactory INSTANCE = new DefaultStorageRpcFactory();

        public ServiceRpc create(StorageOptions options) {
            return new HttpStorageRpc(options);
        }
    }

    public static class DefaultStorageFactory
    implements StorageFactory {
        private static final StorageFactory INSTANCE = new DefaultStorageFactory();

        public Storage create(StorageOptions options) {
            return new StorageImpl(options);
        }
    }
}

