/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiClock;
import com.google.api.gax.core.RetrySettings;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.RetryHelper;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageImpl;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

class BlobReadChannel
implements ReadChannel {
    private static final int DEFAULT_CHUNK_SIZE = 0x200000;
    private final StorageOptions serviceOptions;
    private final BlobId blob;
    private final Map<StorageRpc.Option, ?> requestOptions;
    private String lastEtag;
    private long position;
    private boolean isOpen;
    private boolean endOfStream;
    private int chunkSize = 0x200000;
    private final StorageRpc storageRpc;
    private final StorageObject storageObject;
    private int bufferPos;
    private byte[] buffer;

    BlobReadChannel(StorageOptions serviceOptions, BlobId blob, Map<StorageRpc.Option, ?> requestOptions) {
        this.serviceOptions = serviceOptions;
        this.blob = blob;
        this.requestOptions = requestOptions;
        this.isOpen = true;
        this.storageRpc = serviceOptions.getStorageRpcV1();
        this.storageObject = blob.toPb();
    }

    public RestorableState<ReadChannel> capture() {
        StateImpl.Builder builder = StateImpl.builder(this.serviceOptions, this.blob, this.requestOptions).setPosition(this.position).setIsOpen(this.isOpen).setEndOfStream(this.endOfStream).setChunkSize(this.chunkSize);
        if (this.buffer != null) {
            builder.setPosition(this.position + (long)this.bufferPos);
            builder.setEndOfStream(false);
        }
        return builder.build();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() {
        if (this.isOpen) {
            this.buffer = null;
            this.isOpen = false;
        }
    }

    private void validateOpen() throws ClosedChannelException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    public void seek(long position) throws IOException {
        this.validateOpen();
        this.position = position;
        this.buffer = null;
        this.bufferPos = 0;
        this.endOfStream = false;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize <= 0 ? 0x200000 : chunkSize;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        this.validateOpen();
        if (this.buffer == null) {
            if (this.endOfStream) {
                return -1;
            }
            final int toRead = Math.max(byteBuffer.remaining(), this.chunkSize);
            try {
                StorageRpc.Tuple result = (StorageRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.Tuple<String, byte[]>>(){

                    @Override
                    public StorageRpc.Tuple<String, byte[]> call() {
                        return BlobReadChannel.this.storageRpc.read(BlobReadChannel.this.storageObject, BlobReadChannel.this.requestOptions, BlobReadChannel.this.position, toRead);
                    }
                }, (RetrySettings)this.serviceOptions.getRetrySettings(), (ExceptionHandler)StorageImpl.EXCEPTION_HANDLER, (ApiClock)this.serviceOptions.getClock());
                if (((byte[])result.y()).length > 0 && this.lastEtag != null && !Objects.equals(result.x(), this.lastEtag)) {
                    StringBuilder messageBuilder = new StringBuilder();
                    messageBuilder.append("Blob ").append(this.blob).append(" was updated while reading");
                    throw new StorageException(0, messageBuilder.toString());
                }
                this.lastEtag = (String)result.x();
                this.buffer = (byte[])result.y();
            }
            catch (RetryHelper.RetryHelperException e) {
                throw StorageException.translateAndThrow(e);
            }
            if (toRead > this.buffer.length) {
                this.endOfStream = true;
                if (this.buffer.length == 0) {
                    this.buffer = null;
                    return -1;
                }
            }
        }
        int toWrite = Math.min(this.buffer.length - this.bufferPos, byteBuffer.remaining());
        byteBuffer.put(this.buffer, this.bufferPos, toWrite);
        this.bufferPos += toWrite;
        if (this.bufferPos >= this.buffer.length) {
            this.position += (long)this.buffer.length;
            this.buffer = null;
            this.bufferPos = 0;
        }
        return toWrite;
    }

    static class StateImpl
    implements RestorableState<ReadChannel>,
    Serializable {
        private static final long serialVersionUID = 3889420316004453706L;
        private final StorageOptions serviceOptions;
        private final BlobId blob;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final String lastEtag;
        private final long position;
        private final boolean isOpen;
        private final boolean endOfStream;
        private final int chunkSize;

        StateImpl(Builder builder) {
            this.serviceOptions = builder.serviceOptions;
            this.blob = builder.blob;
            this.requestOptions = builder.requestOptions;
            this.lastEtag = builder.lastEtag;
            this.position = builder.position;
            this.isOpen = builder.isOpen;
            this.endOfStream = builder.endOfStream;
            this.chunkSize = builder.chunkSize;
        }

        static Builder builder(StorageOptions options, BlobId blob, Map<StorageRpc.Option, ?> reqOptions) {
            return new Builder(options, blob, reqOptions);
        }

        public ReadChannel restore() {
            BlobReadChannel channel = new BlobReadChannel(this.serviceOptions, this.blob, this.requestOptions);
            channel.lastEtag = this.lastEtag;
            channel.position = this.position;
            channel.isOpen = this.isOpen;
            channel.endOfStream = this.endOfStream;
            channel.chunkSize = this.chunkSize;
            return channel;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.serviceOptions, this.blob, this.requestOptions, this.lastEtag, this.position, this.isOpen, this.endOfStream, this.chunkSize});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StateImpl)) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return Objects.equals((Object)this.serviceOptions, (Object)other.serviceOptions) && Objects.equals(this.blob, other.blob) && Objects.equals(this.requestOptions, other.requestOptions) && Objects.equals(this.lastEtag, other.lastEtag) && this.position == other.position && this.isOpen == other.isOpen && this.endOfStream == other.endOfStream && this.chunkSize == other.chunkSize;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("blob", (Object)this.blob).add("position", this.position).add("isOpen", this.isOpen).add("endOfStream", this.endOfStream).toString();
        }

        static class Builder {
            private final StorageOptions serviceOptions;
            private final BlobId blob;
            private final Map<StorageRpc.Option, ?> requestOptions;
            private String lastEtag;
            private long position;
            private boolean isOpen;
            private boolean endOfStream;
            private int chunkSize;

            private Builder(StorageOptions options, BlobId blob, Map<StorageRpc.Option, ?> reqOptions) {
                this.serviceOptions = options;
                this.blob = blob;
                this.requestOptions = reqOptions;
            }

            Builder setLastEtag(String lastEtag) {
                this.lastEtag = lastEtag;
                return this;
            }

            Builder setPosition(long position) {
                this.position = position;
                return this;
            }

            Builder setIsOpen(boolean isOpen) {
                this.isOpen = isOpen;
                return this;
            }

            Builder setEndOfStream(boolean endOfStream) {
                this.endOfStream = endOfStream;
                return this;
            }

            Builder setChunkSize(int chunkSize) {
                this.chunkSize = chunkSize;
                return this;
            }

            RestorableState<ReadChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

