/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.BaseService;
import com.google.cloud.BatchResult;
import com.google.cloud.Clock;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.ReadChannel;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceAccountSigner;
import com.google.cloud.ServiceOptions;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobReadChannel;
import com.google.cloud.storage.BlobWriteChannel;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.StorageRpc;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.net.UrlEscapers;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class StorageImpl
extends BaseService<StorageOptions>
implements Storage {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String EMPTY_BYTE_ARRAY_MD5 = "1B2M2Y8AsgTpgAmY7PhCfg==";
    private static final String EMPTY_BYTE_ARRAY_CRC32C = "AAAAAA==";
    private static final String PATH_DELIMITER = "/";
    private static final Function<StorageRpc.Tuple<Storage, Boolean>, Boolean> DELETE_FUNCTION = new Function<StorageRpc.Tuple<Storage, Boolean>, Boolean>(){

        public Boolean apply(StorageRpc.Tuple<Storage, Boolean> tuple) {
            return tuple.y();
        }
    };
    private final StorageRpc storageRpc;

    StorageImpl(StorageOptions options) {
        super((ServiceOptions)options);
        this.storageRpc = (StorageRpc)options.rpc();
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        final com.google.api.services.storage.model.Bucket bucketPb = bucketInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(bucketInfo, (Option[])options);
        try {
            return Bucket.fromPb(this, (com.google.api.services.storage.model.Bucket)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Bucket>(){

                @Override
                public com.google.api.services.storage.model.Bucket call() {
                    return StorageImpl.this.storageRpc.create(bucketPb, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        BlobInfo updatedInfo = blobInfo.toBuilder().md5(EMPTY_BYTE_ARRAY_MD5).crc32c(EMPTY_BYTE_ARRAY_CRC32C).build();
        return this.create(updatedInfo, (InputStream)new ByteArrayInputStream(EMPTY_BYTE_ARRAY), options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        content = (byte[])MoreObjects.firstNonNull((Object)content, (Object)EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().md5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content).asBytes())).crc32c(BaseEncoding.base64().encode(Ints.toByteArray((int)Hashing.crc32c().hashBytes(content).asInt()))).build();
        return this.create(updatedInfo, (InputStream)new ByteArrayInputStream(content), options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption[]> targetOptions = Storage.BlobTargetOption.convert(blobInfo, options);
        return this.create(targetOptions.x(), content, targetOptions.y());
    }

    private Blob create(BlobInfo info, final InputStream content, Storage.BlobTargetOption ... options) {
        final StorageObject blobPb = info.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(info, (Option[])options);
        try {
            return Blob.fromPb(this, (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.create(blobPb, (InputStream)MoreObjects.firstNonNull((Object)content, (Object)new ByteArrayInputStream(EMPTY_BYTE_ARRAY)), optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        final com.google.api.services.storage.model.Bucket bucketPb = BucketInfo.of(bucket).toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        try {
            com.google.api.services.storage.model.Bucket answer = (com.google.api.services.storage.model.Bucket)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Bucket>(){

                @Override
                public com.google.api.services.storage.model.Bucket call() {
                    return StorageImpl.this.storageRpc.get(bucketPb, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return answer == null ? null : Bucket.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.get(BlobId.of(bucket, blob), options);
    }

    @Override
    public Blob get(BlobId blob, Storage.BlobGetOption ... options) {
        final StorageObject storedObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        try {
            StorageObject storageObject = (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.get(storedObject, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return storageObject == null ? null : Blob.fromPb(this, storageObject);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob get(BlobId blob) {
        return this.get(blob, new Storage.BlobGetOption[0]);
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        return StorageImpl.listBuckets((StorageOptions)this.options(), StorageImpl.optionMap(options));
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        return StorageImpl.listBlobs(bucket, (StorageOptions)this.options(), StorageImpl.optionMap(options));
    }

    private static Page<Bucket> listBuckets(final StorageOptions serviceOptions, final Map<StorageRpc.Option, ?> optionsMap) {
        try {
            StorageRpc.Tuple result = (StorageRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.Tuple<String, Iterable<com.google.api.services.storage.model.Bucket>>>(){

                @Override
                public StorageRpc.Tuple<String, Iterable<com.google.api.services.storage.model.Bucket>> call() {
                    return ((StorageRpc)serviceOptions.rpc()).list(optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            String cursor = (String)result.x();
            ImmutableList buckets = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.storage.model.Bucket, Bucket>(){

                public Bucket apply(com.google.api.services.storage.model.Bucket bucketPb) {
                    return Bucket.fromPb((Storage)serviceOptions.service(), bucketPb);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new BucketPageFetcher(serviceOptions, cursor, optionsMap), cursor, (Iterable)buckets);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    private static Page<Blob> listBlobs(final String bucket, final StorageOptions serviceOptions, final Map<StorageRpc.Option, ?> optionsMap) {
        try {
            StorageRpc.Tuple result = (StorageRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.Tuple<String, Iterable<StorageObject>>>(){

                @Override
                public StorageRpc.Tuple<String, Iterable<StorageObject>> call() {
                    return ((StorageRpc)serviceOptions.rpc()).list(bucket, optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            String cursor = (String)result.x();
            ImmutableList blobs = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<StorageObject, Blob>(){

                public Blob apply(StorageObject storageObject) {
                    return Blob.fromPb((Storage)serviceOptions.service(), storageObject);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new BlobPageFetcher(bucket, serviceOptions, cursor, optionsMap), cursor, (Iterable)blobs);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        final com.google.api.services.storage.model.Bucket bucketPb = bucketInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(bucketInfo, (Option[])options);
        try {
            return Bucket.fromPb(this, (com.google.api.services.storage.model.Bucket)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Bucket>(){

                @Override
                public com.google.api.services.storage.model.Bucket call() {
                    return StorageImpl.this.storageRpc.patch(bucketPb, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        final StorageObject storageObject = blobInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blobInfo, (Option[])options);
        try {
            return Blob.fromPb(this, (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.patch(storageObject, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        return this.update(blobInfo, new Storage.BlobTargetOption[0]);
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        final com.google.api.services.storage.model.Bucket bucketPb = BucketInfo.of(bucket).toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.delete(bucketPb, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.delete(BlobId.of(bucket, blob), options);
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        final StorageObject storageObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.delete(storageObject, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(BlobId blob) {
        return this.delete(blob, new Storage.BlobSourceOption[0]);
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        final ArrayList sources = Lists.newArrayListWithCapacity((int)composeRequest.sourceBlobs().size());
        for (Storage.ComposeRequest.SourceBlob sourceBlob : composeRequest.sourceBlobs()) {
            sources.add(BlobInfo.builder(BlobId.of(composeRequest.target().bucket(), sourceBlob.name(), sourceBlob.generation())).build().toPb());
        }
        final StorageObject target = composeRequest.target().toPb();
        final Map<StorageRpc.Option, ?> targetOptions = StorageImpl.optionMap(composeRequest.target().generation(), composeRequest.target().metageneration(), composeRequest.targetOptions());
        try {
            return Blob.fromPb(this, (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.compose(sources, target, targetOptions);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public CopyWriter copy(final Storage.CopyRequest copyRequest) {
        final StorageObject source = copyRequest.source().toPb();
        final Map<StorageRpc.Option, ?> sourceOptions = StorageImpl.optionMap(copyRequest.source().generation(), null, copyRequest.sourceOptions(), true);
        final StorageObject targetObject = copyRequest.target().toPb();
        final Map<StorageRpc.Option, ?> targetOptions = StorageImpl.optionMap(copyRequest.target().generation(), copyRequest.target().metageneration(), copyRequest.targetOptions());
        try {
            StorageRpc.RewriteResponse rewriteResponse = (StorageRpc.RewriteResponse)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.RewriteResponse>(){

                @Override
                public StorageRpc.RewriteResponse call() {
                    return StorageImpl.this.storageRpc.openRewrite(new StorageRpc.RewriteRequest(source, sourceOptions, copyRequest.overrideInfo(), targetObject, targetOptions, copyRequest.megabytesCopiedPerChunk()));
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return new CopyWriter((StorageOptions)this.options(), rewriteResponse);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.readAllBytes(BlobId.of(bucket, blob), options);
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        final StorageObject storageObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        try {
            return (byte[])RetryHelper.runWithRetries((Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() {
                    return StorageImpl.this.storageRpc.load(storageObject, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public StorageBatch batch() {
        return new StorageBatch((StorageOptions)this.options());
    }

    @Override
    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        return new BlobReadChannel((StorageOptions)this.options(), BlobId.of(bucket, blob), optionsMap);
    }

    @Override
    public ReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        return new BlobReadChannel((StorageOptions)this.options(), blob, optionsMap);
    }

    public BlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption[]> targetOptions = Storage.BlobTargetOption.convert(blobInfo, options);
        return this.writer(targetOptions.x(), targetOptions.y());
    }

    private BlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blobInfo, (Option[])options);
        return new BlobWriteChannel((StorageOptions)this.options(), blobInfo, optionsMap);
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        EnumMap optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.SignUrlOption option : options) {
            optionMap.put(option.option(), option.value());
        }
        ServiceAccountSigner authCredentials = (ServiceAccountSigner)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        if (authCredentials == null) {
            Preconditions.checkState((boolean)(((StorageOptions)this.options()).authCredentials() instanceof ServiceAccountSigner), (Object)"Signing key was not provided and could not be derived");
            authCredentials = (ServiceAccountSigner)((StorageOptions)this.options()).authCredentials();
        }
        StringBuilder stBuilder = new StringBuilder();
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.HTTP_METHOD)) {
            stBuilder.append(optionMap.get((Object)Storage.SignUrlOption.Option.HTTP_METHOD));
        } else {
            stBuilder.append((Object)HttpMethod.GET);
        }
        stBuilder.append('\n');
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.MD5)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.md5() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for md5");
            stBuilder.append(blobInfo.md5());
        }
        stBuilder.append('\n');
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.CONTENT_TYPE)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.contentType() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for content-type");
            stBuilder.append(blobInfo.contentType());
        }
        stBuilder.append('\n');
        long expiration = TimeUnit.SECONDS.convert(((StorageOptions)this.options()).clock().millis() + unit.toMillis(duration), TimeUnit.MILLISECONDS);
        stBuilder.append(expiration).append('\n');
        StringBuilder path = new StringBuilder();
        if (!blobInfo.bucket().startsWith(PATH_DELIMITER)) {
            path.append('/');
        }
        path.append(blobInfo.bucket());
        if (!blobInfo.bucket().endsWith(PATH_DELIMITER)) {
            path.append('/');
        }
        if (blobInfo.name().startsWith(PATH_DELIMITER)) {
            path.setLength(path.length() - 1);
        }
        path.append(UrlEscapers.urlPathSegmentEscaper().escape(blobInfo.name()));
        stBuilder.append((CharSequence)path);
        try {
            byte[] signatureBytes = authCredentials.sign(stBuilder.toString().getBytes(StandardCharsets.UTF_8));
            stBuilder = new StringBuilder("https://storage.googleapis.com").append((CharSequence)path);
            String signature = URLEncoder.encode(BaseEncoding.base64().encode(signatureBytes), StandardCharsets.UTF_8.name());
            stBuilder.append("?GoogleAccessId=").append(authCredentials.account());
            stBuilder.append("&Expires=").append(expiration);
            stBuilder.append("&Signature=").append(signature);
            return new URL(stBuilder.toString());
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        return this.get(Arrays.asList(blobIds));
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.get(blob, new Storage.BlobGetOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Blob, StorageException>(){

                public void success(Blob result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        return this.update(Arrays.asList(blobInfos));
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobInfo blobInfo : blobInfos) {
            batch.update(blobInfo, new Storage.BlobTargetOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Blob, StorageException>(){

                public void success(Blob result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        return this.delete(Arrays.asList(blobIds));
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.delete(blob, new Storage.BlobSourceOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Boolean, StorageException>(){

                public void success(Boolean result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(Boolean.FALSE);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public Acl getAcl(final String bucket, final Acl.Entity entity) {
        try {
            BucketAccessControl answer = (BucketAccessControl)RetryHelper.runWithRetries((Callable)new Callable<BucketAccessControl>(){

                @Override
                public BucketAccessControl call() {
                    return StorageImpl.this.storageRpc.getAcl(bucket, entity.toPb());
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return answer == null ? null : Acl.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean deleteAcl(final String bucket, final Acl.Entity entity) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.deleteAcl(bucket, entity.toPb());
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        final BucketAccessControl aclPb = acl.toBucketPb().setBucket(bucket);
        try {
            return Acl.fromPb((BucketAccessControl)RetryHelper.runWithRetries((Callable)new Callable<BucketAccessControl>(){

                @Override
                public BucketAccessControl call() {
                    return StorageImpl.this.storageRpc.createAcl(aclPb);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        final BucketAccessControl aclPb = acl.toBucketPb().setBucket(bucket);
        try {
            return Acl.fromPb((BucketAccessControl)RetryHelper.runWithRetries((Callable)new Callable<BucketAccessControl>(){

                @Override
                public BucketAccessControl call() {
                    return StorageImpl.this.storageRpc.patchAcl(aclPb);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public List<Acl> listAcls(final String bucket) {
        try {
            List answer = (List)RetryHelper.runWithRetries((Callable)new Callable<List<BucketAccessControl>>(){

                @Override
                public List<BucketAccessControl> call() {
                    return StorageImpl.this.storageRpc.listAcls(bucket);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return Lists.transform((List)answer, Acl.FROM_BUCKET_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl getDefaultAcl(final String bucket, final Acl.Entity entity) {
        try {
            ObjectAccessControl answer = (ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.getDefaultAcl(bucket, entity.toPb());
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return answer == null ? null : Acl.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean deleteDefaultAcl(final String bucket, final Acl.Entity entity) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.deleteDefaultAcl(bucket, entity.toPb());
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        final ObjectAccessControl aclPb = acl.toObjectPb().setBucket(bucket);
        try {
            return Acl.fromPb((ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.createDefaultAcl(aclPb);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        final ObjectAccessControl aclPb = acl.toObjectPb().setBucket(bucket);
        try {
            return Acl.fromPb((ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.patchDefaultAcl(aclPb);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public List<Acl> listDefaultAcls(final String bucket) {
        try {
            List answer = (List)RetryHelper.runWithRetries((Callable)new Callable<List<ObjectAccessControl>>(){

                @Override
                public List<ObjectAccessControl> call() {
                    return StorageImpl.this.storageRpc.listDefaultAcls(bucket);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return Lists.transform((List)answer, Acl.FROM_OBJECT_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl getAcl(final BlobId blob, final Acl.Entity entity) {
        try {
            ObjectAccessControl answer = (ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.getAcl(blob.bucket(), blob.name(), blob.generation(), entity.toPb());
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return answer == null ? null : Acl.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean deleteAcl(final BlobId blob, final Acl.Entity entity) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.deleteAcl(blob.bucket(), blob.name(), blob.generation(), entity.toPb());
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        final ObjectAccessControl aclPb = acl.toObjectPb().setBucket(blob.bucket()).setObject(blob.name()).setGeneration(blob.generation());
        try {
            return Acl.fromPb((ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.createAcl(aclPb);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        final ObjectAccessControl aclPb = acl.toObjectPb().setBucket(blob.bucket()).setObject(blob.name()).setGeneration(blob.generation());
        try {
            return Acl.fromPb((ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.patchAcl(aclPb);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public List<Acl> listAcls(final BlobId blob) {
        try {
            List answer = (List)RetryHelper.runWithRetries((Callable)new Callable<List<ObjectAccessControl>>(){

                @Override
                public List<ObjectAccessControl> call() {
                    return StorageImpl.this.storageRpc.listAcls(blob.bucket(), blob.name(), blob.generation());
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
            return Lists.transform((List)answer, Acl.FROM_OBJECT_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    private static <T> void addToOptionMap(StorageRpc.Option option, T defaultValue, Map<StorageRpc.Option, Object> map) {
        StorageImpl.addToOptionMap(option, option, defaultValue, map);
    }

    private static <T> void addToOptionMap(StorageRpc.Option getOption, StorageRpc.Option putOption, T defaultValue, Map<StorageRpc.Option, Object> map) {
        if (map.containsKey((Object)getOption)) {
            Object value = map.remove((Object)getOption);
            Preconditions.checkArgument((value != null || defaultValue != null ? 1 : 0) != 0, (Object)("Option " + getOption.value() + " is missing a value"));
            value = MoreObjects.firstNonNull((Object)value, defaultValue);
            map.put(putOption, value);
        }
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Iterable<? extends Option> options) {
        return StorageImpl.optionMap(generation, metaGeneration, options, false);
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Iterable<? extends Option> options, boolean useAsSource) {
        EnumMap temp = Maps.newEnumMap(StorageRpc.Option.class);
        for (Option option : options) {
            Object prev = temp.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        Boolean value = (Boolean)temp.remove((Object)StorageRpc.Option.DELIMITER);
        if (Boolean.TRUE.equals(value)) {
            temp.put(StorageRpc.Option.DELIMITER, PATH_DELIMITER);
        }
        if (useAsSource) {
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_MATCH, StorageRpc.Option.IF_SOURCE_GENERATION_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_NOT_MATCH, StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_MATCH, StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH, metaGeneration, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH, metaGeneration, temp);
        } else {
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_MATCH, metaGeneration, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metaGeneration, temp);
        }
        return ImmutableMap.copyOf((Map)temp);
    }

    private static Map<StorageRpc.Option, ?> optionMap(Option ... options) {
        return StorageImpl.optionMap(null, null, Arrays.asList(options));
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Option ... options) {
        return StorageImpl.optionMap(generation, metaGeneration, Arrays.asList(options));
    }

    private static Map<StorageRpc.Option, ?> optionMap(BucketInfo bucketInfo, Option ... options) {
        return StorageImpl.optionMap(null, bucketInfo.metageneration(), options);
    }

    static Map<StorageRpc.Option, ?> optionMap(BlobInfo blobInfo, Option ... options) {
        return StorageImpl.optionMap(blobInfo.generation(), blobInfo.metageneration(), options);
    }

    static Map<StorageRpc.Option, ?> optionMap(BlobId blobId, Option ... options) {
        return StorageImpl.optionMap(blobId.generation(), null, options);
    }

    private static class BlobPageFetcher
    implements PageImpl.NextPageFetcher<Blob> {
        private static final long serialVersionUID = 81807334445874098L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final StorageOptions serviceOptions;
        private final String bucket;

        BlobPageFetcher(String bucket, StorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.bucket = bucket;
        }

        public Page<Blob> nextPage() {
            return StorageImpl.listBlobs(this.bucket, this.serviceOptions, this.requestOptions);
        }
    }

    private static class BucketPageFetcher
    implements PageImpl.NextPageFetcher<Bucket> {
        private static final long serialVersionUID = 5850406828803613729L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final StorageOptions serviceOptions;

        BucketPageFetcher(StorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Bucket> nextPage() {
            return StorageImpl.listBuckets(this.serviceOptions, this.requestOptions);
        }
    }
}

