/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class Acl
implements Serializable {
    private static final long serialVersionUID = 7516713233557576082L;
    static final Function<ObjectAccessControl, Acl> FROM_OBJECT_PB_FUNCTION = new Function<ObjectAccessControl, Acl>(){

        public Acl apply(ObjectAccessControl aclPb) {
            return Acl.fromPb(aclPb);
        }
    };
    static final Function<BucketAccessControl, Acl> FROM_BUCKET_PB_FUNCTION = new Function<BucketAccessControl, Acl>(){

        public Acl apply(BucketAccessControl aclPb) {
            return Acl.fromPb(aclPb);
        }
    };
    private final Entity entity;
    private final Role role;
    private final String id;
    private final String etag;

    private Acl(Builder builder) {
        this.entity = (Entity)Preconditions.checkNotNull((Object)builder.entity);
        this.role = (Role)((Object)Preconditions.checkNotNull((Object)((Object)builder.role)));
        this.id = builder.id;
        this.etag = builder.etag;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Role getRole() {
        return this.role;
    }

    public String getId() {
        return this.id;
    }

    public String getEtag() {
        return this.etag;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Acl of(Entity entity, Role role) {
        return Acl.newBuilder(entity, role).build();
    }

    public static Builder newBuilder(Entity entity, Role role) {
        return new Builder(entity, role);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entity", (Object)this.entity).add("role", (Object)this.role).add("etag", (Object)this.etag).add("id", (Object)this.id).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entity, this.role});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Acl other = (Acl)obj;
        return Objects.equals(this.entity, other.entity) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.etag, other.etag) && Objects.equals(this.id, other.id);
    }

    BucketAccessControl toBucketPb() {
        BucketAccessControl bucketPb = new BucketAccessControl();
        bucketPb.setEntity(this.getEntity().toString());
        bucketPb.setRole(this.getRole().toString());
        bucketPb.setId(this.getId());
        bucketPb.setEtag(this.getEtag());
        return bucketPb;
    }

    ObjectAccessControl toObjectPb() {
        ObjectAccessControl objectPb = new ObjectAccessControl();
        objectPb.setEntity(this.getEntity().toPb());
        objectPb.setRole(this.getRole().name());
        objectPb.setId(this.getId());
        objectPb.setEtag(this.getEtag());
        return objectPb;
    }

    static Acl fromPb(ObjectAccessControl objectAccessControl) {
        Role role = Role.valueOf(objectAccessControl.getRole());
        Entity entity = Entity.fromPb(objectAccessControl.getEntity());
        return Acl.newBuilder(entity, role).setEtag(objectAccessControl.getEtag()).setId(objectAccessControl.getId()).build();
    }

    static Acl fromPb(BucketAccessControl bucketAccessControl) {
        Role role = Role.valueOf(bucketAccessControl.getRole());
        Entity entity = Entity.fromPb(bucketAccessControl.getEntity());
        return Acl.newBuilder(entity, role).setEtag(bucketAccessControl.getEtag()).setId(bucketAccessControl.getId()).build();
    }

    public static final class RawEntity
    extends Entity {
        private static final long serialVersionUID = 3966205614223053950L;

        RawEntity(String entity) {
            super(Entity.Type.UNKNOWN, entity);
        }

        @Override
        String toPb() {
            return this.getValue();
        }
    }

    public static final class Project
    extends Entity {
        private static final long serialVersionUID = 7933776866530023027L;
        private final ProjectRole projectRole;
        private final String projectId;

        public Project(ProjectRole projectRole, String projectId) {
            super(Entity.Type.PROJECT, projectRole.name().toLowerCase() + "-" + projectId);
            this.projectRole = projectRole;
            this.projectId = projectId;
        }

        public ProjectRole getProjectRole() {
            return this.projectRole;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public static enum ProjectRole {
            OWNERS,
            EDITORS,
            VIEWERS;

        }
    }

    public static final class User
    extends Entity {
        private static final long serialVersionUID = 3076518036392737008L;
        private static final String ALL_USERS = "allUsers";
        private static final String ALL_AUTHENTICATED_USERS = "allAuthenticatedUsers";

        public User(String email) {
            super(Entity.Type.USER, email);
        }

        public String getEmail() {
            return this.getValue();
        }

        @Override
        String toPb() {
            switch (this.getValue()) {
                case "allAuthenticatedUsers": {
                    return ALL_AUTHENTICATED_USERS;
                }
                case "allUsers": {
                    return ALL_USERS;
                }
            }
            return super.toPb();
        }

        public static User ofAllUsers() {
            return new User(ALL_USERS);
        }

        public static User ofAllAuthenticatedUsers() {
            return new User(ALL_AUTHENTICATED_USERS);
        }
    }

    public static final class Group
    extends Entity {
        private static final long serialVersionUID = -1660987136294408826L;

        public Group(String email) {
            super(Entity.Type.GROUP, email);
        }

        public String getEmail() {
            return this.getValue();
        }
    }

    public static final class Domain
    extends Entity {
        private static final long serialVersionUID = -3033025857280447253L;

        public Domain(String domain) {
            super(Entity.Type.DOMAIN, domain);
        }

        public String getDomain() {
            return this.getValue();
        }
    }

    public static abstract class Entity
    implements Serializable {
        private static final long serialVersionUID = -2707407252771255840L;
        private final Type type;
        private final String value;

        Entity(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public Type getType() {
            return this.type;
        }

        protected String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entity entity = (Entity)obj;
            return Objects.equals((Object)this.type, (Object)entity.type) && Objects.equals(this.value, entity.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        public String toString() {
            return this.toPb();
        }

        String toPb() {
            return this.type.name().toLowerCase() + "-" + this.getValue();
        }

        static Entity fromPb(String entity) {
            if (entity.startsWith("user-")) {
                return new User(entity.substring(5));
            }
            if (entity.equals("allUsers")) {
                return User.ofAllUsers();
            }
            if (entity.equals("allAuthenticatedUsers")) {
                return User.ofAllAuthenticatedUsers();
            }
            if (entity.startsWith("group-")) {
                return new Group(entity.substring(6));
            }
            if (entity.startsWith("domain-")) {
                return new Domain(entity.substring(7));
            }
            if (entity.startsWith("project-")) {
                int idx = entity.indexOf(45, 8);
                String team = entity.substring(8, idx);
                String projectId = entity.substring(idx + 1);
                return new Project(Project.ProjectRole.valueOf(team.toUpperCase()), projectId);
            }
            return new RawEntity(entity);
        }

        public static enum Type {
            DOMAIN,
            GROUP,
            USER,
            PROJECT,
            UNKNOWN;

        }
    }

    public static class Builder {
        private Entity entity;
        private Role role;
        private String id;
        private String etag;

        private Builder(Entity entity, Role role) {
            this.entity = entity;
            this.role = role;
        }

        private Builder(Acl acl) {
            this.entity = acl.entity;
            this.role = acl.role;
            this.id = acl.id;
            this.etag = acl.etag;
        }

        public Builder setEntity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public Builder setRole(Role role) {
            this.role = role;
            return this;
        }

        Builder setId(String id) {
            this.id = id;
            return this;
        }

        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        public Acl build() {
            return new Acl(this);
        }
    }

    public static enum Role {
        OWNER,
        READER,
        WRITER;

    }
}

