/*
 * Decompiled with CFR 0.152.
 */
package com.google.storagetransfer.v1.proto;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.storagetransfer.v1.proto.StorageTransferServiceSettings;
import com.google.storagetransfer.v1.proto.TransferProto;
import com.google.storagetransfer.v1.proto.TransferTypes;
import com.google.storagetransfer.v1.proto.stub.StorageTransferServiceStub;
import com.google.storagetransfer.v1.proto.stub.StorageTransferServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class StorageTransferServiceClient
implements BackgroundResource {
    private final StorageTransferServiceSettings settings;
    private final StorageTransferServiceStub stub;
    private final OperationsClient operationsClient;

    public static final StorageTransferServiceClient create() throws IOException {
        return StorageTransferServiceClient.create(StorageTransferServiceSettings.newBuilder().build());
    }

    public static final StorageTransferServiceClient create(StorageTransferServiceSettings settings) throws IOException {
        return new StorageTransferServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final StorageTransferServiceClient create(StorageTransferServiceStub stub) {
        return new StorageTransferServiceClient(stub);
    }

    protected StorageTransferServiceClient(StorageTransferServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StorageTransferServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected StorageTransferServiceClient(StorageTransferServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final StorageTransferServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public StorageTransferServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final TransferTypes.GoogleServiceAccount getGoogleServiceAccount(TransferProto.GetGoogleServiceAccountRequest request) {
        return (TransferTypes.GoogleServiceAccount)this.getGoogleServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.GetGoogleServiceAccountRequest, TransferTypes.GoogleServiceAccount> getGoogleServiceAccountCallable() {
        return this.stub.getGoogleServiceAccountCallable();
    }

    public final TransferTypes.TransferJob createTransferJob(TransferProto.CreateTransferJobRequest request) {
        return (TransferTypes.TransferJob)this.createTransferJobCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.CreateTransferJobRequest, TransferTypes.TransferJob> createTransferJobCallable() {
        return this.stub.createTransferJobCallable();
    }

    public final TransferTypes.TransferJob updateTransferJob(TransferProto.UpdateTransferJobRequest request) {
        return (TransferTypes.TransferJob)this.updateTransferJobCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.UpdateTransferJobRequest, TransferTypes.TransferJob> updateTransferJobCallable() {
        return this.stub.updateTransferJobCallable();
    }

    public final TransferTypes.TransferJob getTransferJob(TransferProto.GetTransferJobRequest request) {
        return (TransferTypes.TransferJob)this.getTransferJobCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.GetTransferJobRequest, TransferTypes.TransferJob> getTransferJobCallable() {
        return this.stub.getTransferJobCallable();
    }

    public final ListTransferJobsPagedResponse listTransferJobs(TransferProto.ListTransferJobsRequest request) {
        return (ListTransferJobsPagedResponse)((Object)this.listTransferJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<TransferProto.ListTransferJobsRequest, ListTransferJobsPagedResponse> listTransferJobsPagedCallable() {
        return this.stub.listTransferJobsPagedCallable();
    }

    public final UnaryCallable<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse> listTransferJobsCallable() {
        return this.stub.listTransferJobsCallable();
    }

    public final void pauseTransferOperation(TransferProto.PauseTransferOperationRequest request) {
        this.pauseTransferOperationCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.PauseTransferOperationRequest, Empty> pauseTransferOperationCallable() {
        return this.stub.pauseTransferOperationCallable();
    }

    public final void resumeTransferOperation(TransferProto.ResumeTransferOperationRequest request) {
        this.resumeTransferOperationCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.ResumeTransferOperationRequest, Empty> resumeTransferOperationCallable() {
        return this.stub.resumeTransferOperationCallable();
    }

    public final OperationFuture<Empty, TransferTypes.TransferOperation> runTransferJobAsync(TransferProto.RunTransferJobRequest request) {
        return this.runTransferJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TransferProto.RunTransferJobRequest, Empty, TransferTypes.TransferOperation> runTransferJobOperationCallable() {
        return this.stub.runTransferJobOperationCallable();
    }

    public final UnaryCallable<TransferProto.RunTransferJobRequest, Operation> runTransferJobCallable() {
        return this.stub.runTransferJobCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTransferJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob, ListTransferJobsPage, ListTransferJobsFixedSizeCollection> {
        private ListTransferJobsFixedSizeCollection(List<ListTransferJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTransferJobsFixedSizeCollection createEmptyCollection() {
            return new ListTransferJobsFixedSizeCollection(null, 0);
        }

        protected ListTransferJobsFixedSizeCollection createCollection(List<ListTransferJobsPage> pages, int collectionSize) {
            return new ListTransferJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTransferJobsPage
    extends AbstractPage<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob, ListTransferJobsPage> {
        private ListTransferJobsPage(PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> context, TransferProto.ListTransferJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListTransferJobsPage createEmptyPage() {
            return new ListTransferJobsPage(null, null);
        }

        protected ListTransferJobsPage createPage(PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> context, TransferProto.ListTransferJobsResponse response) {
            return new ListTransferJobsPage(context, response);
        }

        public ApiFuture<ListTransferJobsPage> createPageAsync(PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> context, ApiFuture<TransferProto.ListTransferJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTransferJobsPagedResponse
    extends AbstractPagedListResponse<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob, ListTransferJobsPage, ListTransferJobsFixedSizeCollection> {
        public static ApiFuture<ListTransferJobsPagedResponse> createAsync(PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> context, ApiFuture<TransferProto.ListTransferJobsResponse> futureResponse) {
            ApiFuture<ListTransferJobsPage> futurePage = ListTransferJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTransferJobsPagedResponse((ListTransferJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTransferJobsPagedResponse(ListTransferJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTransferJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

