/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.storage.control.v2.AnywhereCache;
import com.google.storage.control.v2.CreateAnywhereCacheMetadata;
import com.google.storage.control.v2.CreateAnywhereCacheRequest;
import com.google.storage.control.v2.CreateFolderRequest;
import com.google.storage.control.v2.CreateManagedFolderRequest;
import com.google.storage.control.v2.DeleteFolderRequest;
import com.google.storage.control.v2.DeleteManagedFolderRequest;
import com.google.storage.control.v2.DisableAnywhereCacheRequest;
import com.google.storage.control.v2.Folder;
import com.google.storage.control.v2.GetAnywhereCacheRequest;
import com.google.storage.control.v2.GetFolderIntelligenceConfigRequest;
import com.google.storage.control.v2.GetFolderRequest;
import com.google.storage.control.v2.GetManagedFolderRequest;
import com.google.storage.control.v2.GetOrganizationIntelligenceConfigRequest;
import com.google.storage.control.v2.GetProjectIntelligenceConfigRequest;
import com.google.storage.control.v2.GetStorageLayoutRequest;
import com.google.storage.control.v2.IntelligenceConfig;
import com.google.storage.control.v2.ListAnywhereCachesRequest;
import com.google.storage.control.v2.ListAnywhereCachesResponse;
import com.google.storage.control.v2.ListFoldersRequest;
import com.google.storage.control.v2.ListFoldersResponse;
import com.google.storage.control.v2.ListManagedFoldersRequest;
import com.google.storage.control.v2.ListManagedFoldersResponse;
import com.google.storage.control.v2.ManagedFolder;
import com.google.storage.control.v2.PauseAnywhereCacheRequest;
import com.google.storage.control.v2.RenameFolderMetadata;
import com.google.storage.control.v2.RenameFolderRequest;
import com.google.storage.control.v2.ResumeAnywhereCacheRequest;
import com.google.storage.control.v2.StorageControlClient;
import com.google.storage.control.v2.StorageLayout;
import com.google.storage.control.v2.UpdateAnywhereCacheMetadata;
import com.google.storage.control.v2.UpdateAnywhereCacheRequest;
import com.google.storage.control.v2.UpdateFolderIntelligenceConfigRequest;
import com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest;
import com.google.storage.control.v2.UpdateProjectIntelligenceConfigRequest;
import com.google.storage.control.v2.stub.GrpcStorageControlStub;
import com.google.storage.control.v2.stub.HttpJsonStorageControlStub;
import com.google.storage.control.v2.stub.StorageControlStub;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class StorageControlStubSettings
extends StubSettings<StorageControlStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<CreateFolderRequest, Folder> createFolderSettings;
    private final UnaryCallSettings<DeleteFolderRequest, Empty> deleteFolderSettings;
    private final UnaryCallSettings<GetFolderRequest, Folder> getFolderSettings;
    private final PagedCallSettings<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> listFoldersSettings;
    private final UnaryCallSettings<RenameFolderRequest, Operation> renameFolderSettings;
    private final OperationCallSettings<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationSettings;
    private final UnaryCallSettings<GetStorageLayoutRequest, StorageLayout> getStorageLayoutSettings;
    private final UnaryCallSettings<CreateManagedFolderRequest, ManagedFolder> createManagedFolderSettings;
    private final UnaryCallSettings<DeleteManagedFolderRequest, Empty> deleteManagedFolderSettings;
    private final UnaryCallSettings<GetManagedFolderRequest, ManagedFolder> getManagedFolderSettings;
    private final PagedCallSettings<ListManagedFoldersRequest, ListManagedFoldersResponse, StorageControlClient.ListManagedFoldersPagedResponse> listManagedFoldersSettings;
    private final UnaryCallSettings<CreateAnywhereCacheRequest, Operation> createAnywhereCacheSettings;
    private final OperationCallSettings<CreateAnywhereCacheRequest, AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheOperationSettings;
    private final UnaryCallSettings<UpdateAnywhereCacheRequest, Operation> updateAnywhereCacheSettings;
    private final OperationCallSettings<UpdateAnywhereCacheRequest, AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheOperationSettings;
    private final UnaryCallSettings<DisableAnywhereCacheRequest, AnywhereCache> disableAnywhereCacheSettings;
    private final UnaryCallSettings<PauseAnywhereCacheRequest, AnywhereCache> pauseAnywhereCacheSettings;
    private final UnaryCallSettings<ResumeAnywhereCacheRequest, AnywhereCache> resumeAnywhereCacheSettings;
    private final UnaryCallSettings<GetAnywhereCacheRequest, AnywhereCache> getAnywhereCacheSettings;
    private final PagedCallSettings<ListAnywhereCachesRequest, ListAnywhereCachesResponse, StorageControlClient.ListAnywhereCachesPagedResponse> listAnywhereCachesSettings;
    private final UnaryCallSettings<GetProjectIntelligenceConfigRequest, IntelligenceConfig> getProjectIntelligenceConfigSettings;
    private final UnaryCallSettings<UpdateProjectIntelligenceConfigRequest, IntelligenceConfig> updateProjectIntelligenceConfigSettings;
    private final UnaryCallSettings<GetFolderIntelligenceConfigRequest, IntelligenceConfig> getFolderIntelligenceConfigSettings;
    private final UnaryCallSettings<UpdateFolderIntelligenceConfigRequest, IntelligenceConfig> updateFolderIntelligenceConfigSettings;
    private final UnaryCallSettings<GetOrganizationIntelligenceConfigRequest, IntelligenceConfig> getOrganizationIntelligenceConfigSettings;
    private final UnaryCallSettings<UpdateOrganizationIntelligenceConfigRequest, IntelligenceConfig> updateOrganizationIntelligenceConfigSettings;
    private static final PagedListDescriptor<ListFoldersRequest, ListFoldersResponse, Folder> LIST_FOLDERS_PAGE_STR_DESC = new PagedListDescriptor<ListFoldersRequest, ListFoldersResponse, Folder>(){

        public String emptyToken() {
            return "";
        }

        public ListFoldersRequest injectToken(ListFoldersRequest payload, String token) {
            return ListFoldersRequest.newBuilder((ListFoldersRequest)payload).setPageToken(token).build();
        }

        public ListFoldersRequest injectPageSize(ListFoldersRequest payload, int pageSize) {
            return ListFoldersRequest.newBuilder((ListFoldersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFoldersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFoldersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Folder> extractResources(ListFoldersResponse payload) {
            return payload.getFoldersList();
        }
    };
    private static final PagedListDescriptor<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> LIST_MANAGED_FOLDERS_PAGE_STR_DESC = new PagedListDescriptor<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder>(){

        public String emptyToken() {
            return "";
        }

        public ListManagedFoldersRequest injectToken(ListManagedFoldersRequest payload, String token) {
            return ListManagedFoldersRequest.newBuilder((ListManagedFoldersRequest)payload).setPageToken(token).build();
        }

        public ListManagedFoldersRequest injectPageSize(ListManagedFoldersRequest payload, int pageSize) {
            return ListManagedFoldersRequest.newBuilder((ListManagedFoldersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListManagedFoldersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListManagedFoldersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ManagedFolder> extractResources(ListManagedFoldersResponse payload) {
            return payload.getManagedFoldersList();
        }
    };
    private static final PagedListDescriptor<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache> LIST_ANYWHERE_CACHES_PAGE_STR_DESC = new PagedListDescriptor<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache>(){

        public String emptyToken() {
            return "";
        }

        public ListAnywhereCachesRequest injectToken(ListAnywhereCachesRequest payload, String token) {
            return ListAnywhereCachesRequest.newBuilder((ListAnywhereCachesRequest)payload).setPageToken(token).build();
        }

        public ListAnywhereCachesRequest injectPageSize(ListAnywhereCachesRequest payload, int pageSize) {
            return ListAnywhereCachesRequest.newBuilder((ListAnywhereCachesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAnywhereCachesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAnywhereCachesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AnywhereCache> extractResources(ListAnywhereCachesResponse payload) {
            return payload.getAnywhereCachesList();
        }
    };
    private static final PagedListResponseFactory<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> LIST_FOLDERS_PAGE_STR_FACT = new PagedListResponseFactory<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse>(){

        public ApiFuture<StorageControlClient.ListFoldersPagedResponse> getFuturePagedResponse(UnaryCallable<ListFoldersRequest, ListFoldersResponse> callable, ListFoldersRequest request, ApiCallContext context, ApiFuture<ListFoldersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FOLDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StorageControlClient.ListFoldersPagedResponse.createAsync((PageContext<ListFoldersRequest, ListFoldersResponse, Folder>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListManagedFoldersRequest, ListManagedFoldersResponse, StorageControlClient.ListManagedFoldersPagedResponse> LIST_MANAGED_FOLDERS_PAGE_STR_FACT = new PagedListResponseFactory<ListManagedFoldersRequest, ListManagedFoldersResponse, StorageControlClient.ListManagedFoldersPagedResponse>(){

        public ApiFuture<StorageControlClient.ListManagedFoldersPagedResponse> getFuturePagedResponse(UnaryCallable<ListManagedFoldersRequest, ListManagedFoldersResponse> callable, ListManagedFoldersRequest request, ApiCallContext context, ApiFuture<ListManagedFoldersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MANAGED_FOLDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StorageControlClient.ListManagedFoldersPagedResponse.createAsync((PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAnywhereCachesRequest, ListAnywhereCachesResponse, StorageControlClient.ListAnywhereCachesPagedResponse> LIST_ANYWHERE_CACHES_PAGE_STR_FACT = new PagedListResponseFactory<ListAnywhereCachesRequest, ListAnywhereCachesResponse, StorageControlClient.ListAnywhereCachesPagedResponse>(){

        public ApiFuture<StorageControlClient.ListAnywhereCachesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAnywhereCachesRequest, ListAnywhereCachesResponse> callable, ListAnywhereCachesRequest request, ApiCallContext context, ApiFuture<ListAnywhereCachesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ANYWHERE_CACHES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StorageControlClient.ListAnywhereCachesPagedResponse.createAsync((PageContext<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateFolderRequest, Folder> createFolderSettings() {
        return this.createFolderSettings;
    }

    public UnaryCallSettings<DeleteFolderRequest, Empty> deleteFolderSettings() {
        return this.deleteFolderSettings;
    }

    public UnaryCallSettings<GetFolderRequest, Folder> getFolderSettings() {
        return this.getFolderSettings;
    }

    public PagedCallSettings<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> listFoldersSettings() {
        return this.listFoldersSettings;
    }

    public UnaryCallSettings<RenameFolderRequest, Operation> renameFolderSettings() {
        return this.renameFolderSettings;
    }

    public OperationCallSettings<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationSettings() {
        return this.renameFolderOperationSettings;
    }

    public UnaryCallSettings<GetStorageLayoutRequest, StorageLayout> getStorageLayoutSettings() {
        return this.getStorageLayoutSettings;
    }

    public UnaryCallSettings<CreateManagedFolderRequest, ManagedFolder> createManagedFolderSettings() {
        return this.createManagedFolderSettings;
    }

    public UnaryCallSettings<DeleteManagedFolderRequest, Empty> deleteManagedFolderSettings() {
        return this.deleteManagedFolderSettings;
    }

    public UnaryCallSettings<GetManagedFolderRequest, ManagedFolder> getManagedFolderSettings() {
        return this.getManagedFolderSettings;
    }

    public PagedCallSettings<ListManagedFoldersRequest, ListManagedFoldersResponse, StorageControlClient.ListManagedFoldersPagedResponse> listManagedFoldersSettings() {
        return this.listManagedFoldersSettings;
    }

    public UnaryCallSettings<CreateAnywhereCacheRequest, Operation> createAnywhereCacheSettings() {
        return this.createAnywhereCacheSettings;
    }

    public OperationCallSettings<CreateAnywhereCacheRequest, AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheOperationSettings() {
        return this.createAnywhereCacheOperationSettings;
    }

    public UnaryCallSettings<UpdateAnywhereCacheRequest, Operation> updateAnywhereCacheSettings() {
        return this.updateAnywhereCacheSettings;
    }

    public OperationCallSettings<UpdateAnywhereCacheRequest, AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheOperationSettings() {
        return this.updateAnywhereCacheOperationSettings;
    }

    public UnaryCallSettings<DisableAnywhereCacheRequest, AnywhereCache> disableAnywhereCacheSettings() {
        return this.disableAnywhereCacheSettings;
    }

    public UnaryCallSettings<PauseAnywhereCacheRequest, AnywhereCache> pauseAnywhereCacheSettings() {
        return this.pauseAnywhereCacheSettings;
    }

    public UnaryCallSettings<ResumeAnywhereCacheRequest, AnywhereCache> resumeAnywhereCacheSettings() {
        return this.resumeAnywhereCacheSettings;
    }

    public UnaryCallSettings<GetAnywhereCacheRequest, AnywhereCache> getAnywhereCacheSettings() {
        return this.getAnywhereCacheSettings;
    }

    public PagedCallSettings<ListAnywhereCachesRequest, ListAnywhereCachesResponse, StorageControlClient.ListAnywhereCachesPagedResponse> listAnywhereCachesSettings() {
        return this.listAnywhereCachesSettings;
    }

    public UnaryCallSettings<GetProjectIntelligenceConfigRequest, IntelligenceConfig> getProjectIntelligenceConfigSettings() {
        return this.getProjectIntelligenceConfigSettings;
    }

    public UnaryCallSettings<UpdateProjectIntelligenceConfigRequest, IntelligenceConfig> updateProjectIntelligenceConfigSettings() {
        return this.updateProjectIntelligenceConfigSettings;
    }

    public UnaryCallSettings<GetFolderIntelligenceConfigRequest, IntelligenceConfig> getFolderIntelligenceConfigSettings() {
        return this.getFolderIntelligenceConfigSettings;
    }

    public UnaryCallSettings<UpdateFolderIntelligenceConfigRequest, IntelligenceConfig> updateFolderIntelligenceConfigSettings() {
        return this.updateFolderIntelligenceConfigSettings;
    }

    public UnaryCallSettings<GetOrganizationIntelligenceConfigRequest, IntelligenceConfig> getOrganizationIntelligenceConfigSettings() {
        return this.getOrganizationIntelligenceConfigSettings;
    }

    public UnaryCallSettings<UpdateOrganizationIntelligenceConfigRequest, IntelligenceConfig> updateOrganizationIntelligenceConfigSettings() {
        return this.updateOrganizationIntelligenceConfigSettings;
    }

    public StorageControlStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcStorageControlStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonStorageControlStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "storage";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "storage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "storage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StorageControlStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StorageControlStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StorageControlStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return StorageControlStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StorageControlStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createFolderSettings = settingsBuilder.createFolderSettings().build();
        this.deleteFolderSettings = settingsBuilder.deleteFolderSettings().build();
        this.getFolderSettings = settingsBuilder.getFolderSettings().build();
        this.listFoldersSettings = settingsBuilder.listFoldersSettings().build();
        this.renameFolderSettings = settingsBuilder.renameFolderSettings().build();
        this.renameFolderOperationSettings = settingsBuilder.renameFolderOperationSettings().build();
        this.getStorageLayoutSettings = settingsBuilder.getStorageLayoutSettings().build();
        this.createManagedFolderSettings = settingsBuilder.createManagedFolderSettings().build();
        this.deleteManagedFolderSettings = settingsBuilder.deleteManagedFolderSettings().build();
        this.getManagedFolderSettings = settingsBuilder.getManagedFolderSettings().build();
        this.listManagedFoldersSettings = settingsBuilder.listManagedFoldersSettings().build();
        this.createAnywhereCacheSettings = settingsBuilder.createAnywhereCacheSettings().build();
        this.createAnywhereCacheOperationSettings = settingsBuilder.createAnywhereCacheOperationSettings().build();
        this.updateAnywhereCacheSettings = settingsBuilder.updateAnywhereCacheSettings().build();
        this.updateAnywhereCacheOperationSettings = settingsBuilder.updateAnywhereCacheOperationSettings().build();
        this.disableAnywhereCacheSettings = settingsBuilder.disableAnywhereCacheSettings().build();
        this.pauseAnywhereCacheSettings = settingsBuilder.pauseAnywhereCacheSettings().build();
        this.resumeAnywhereCacheSettings = settingsBuilder.resumeAnywhereCacheSettings().build();
        this.getAnywhereCacheSettings = settingsBuilder.getAnywhereCacheSettings().build();
        this.listAnywhereCachesSettings = settingsBuilder.listAnywhereCachesSettings().build();
        this.getProjectIntelligenceConfigSettings = settingsBuilder.getProjectIntelligenceConfigSettings().build();
        this.updateProjectIntelligenceConfigSettings = settingsBuilder.updateProjectIntelligenceConfigSettings().build();
        this.getFolderIntelligenceConfigSettings = settingsBuilder.getFolderIntelligenceConfigSettings().build();
        this.updateFolderIntelligenceConfigSettings = settingsBuilder.updateFolderIntelligenceConfigSettings().build();
        this.getOrganizationIntelligenceConfigSettings = settingsBuilder.getOrganizationIntelligenceConfigSettings().build();
        this.updateOrganizationIntelligenceConfigSettings = settingsBuilder.updateOrganizationIntelligenceConfigSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StorageControlStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateFolderRequest, Folder> createFolderSettings;
        private final UnaryCallSettings.Builder<DeleteFolderRequest, Empty> deleteFolderSettings;
        private final UnaryCallSettings.Builder<GetFolderRequest, Folder> getFolderSettings;
        private final PagedCallSettings.Builder<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> listFoldersSettings;
        private final UnaryCallSettings.Builder<RenameFolderRequest, Operation> renameFolderSettings;
        private final OperationCallSettings.Builder<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationSettings;
        private final UnaryCallSettings.Builder<GetStorageLayoutRequest, StorageLayout> getStorageLayoutSettings;
        private final UnaryCallSettings.Builder<CreateManagedFolderRequest, ManagedFolder> createManagedFolderSettings;
        private final UnaryCallSettings.Builder<DeleteManagedFolderRequest, Empty> deleteManagedFolderSettings;
        private final UnaryCallSettings.Builder<GetManagedFolderRequest, ManagedFolder> getManagedFolderSettings;
        private final PagedCallSettings.Builder<ListManagedFoldersRequest, ListManagedFoldersResponse, StorageControlClient.ListManagedFoldersPagedResponse> listManagedFoldersSettings;
        private final UnaryCallSettings.Builder<CreateAnywhereCacheRequest, Operation> createAnywhereCacheSettings;
        private final OperationCallSettings.Builder<CreateAnywhereCacheRequest, AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAnywhereCacheRequest, Operation> updateAnywhereCacheSettings;
        private final OperationCallSettings.Builder<UpdateAnywhereCacheRequest, AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheOperationSettings;
        private final UnaryCallSettings.Builder<DisableAnywhereCacheRequest, AnywhereCache> disableAnywhereCacheSettings;
        private final UnaryCallSettings.Builder<PauseAnywhereCacheRequest, AnywhereCache> pauseAnywhereCacheSettings;
        private final UnaryCallSettings.Builder<ResumeAnywhereCacheRequest, AnywhereCache> resumeAnywhereCacheSettings;
        private final UnaryCallSettings.Builder<GetAnywhereCacheRequest, AnywhereCache> getAnywhereCacheSettings;
        private final PagedCallSettings.Builder<ListAnywhereCachesRequest, ListAnywhereCachesResponse, StorageControlClient.ListAnywhereCachesPagedResponse> listAnywhereCachesSettings;
        private final UnaryCallSettings.Builder<GetProjectIntelligenceConfigRequest, IntelligenceConfig> getProjectIntelligenceConfigSettings;
        private final UnaryCallSettings.Builder<UpdateProjectIntelligenceConfigRequest, IntelligenceConfig> updateProjectIntelligenceConfigSettings;
        private final UnaryCallSettings.Builder<GetFolderIntelligenceConfigRequest, IntelligenceConfig> getFolderIntelligenceConfigSettings;
        private final UnaryCallSettings.Builder<UpdateFolderIntelligenceConfigRequest, IntelligenceConfig> updateFolderIntelligenceConfigSettings;
        private final UnaryCallSettings.Builder<GetOrganizationIntelligenceConfigRequest, IntelligenceConfig> getOrganizationIntelligenceConfigSettings;
        private final UnaryCallSettings.Builder<UpdateOrganizationIntelligenceConfigRequest, IntelligenceConfig> updateOrganizationIntelligenceConfigSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFoldersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FOLDERS_PAGE_STR_FACT);
            this.renameFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.renameFolderOperationSettings = OperationCallSettings.newBuilder();
            this.getStorageLayoutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createManagedFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteManagedFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getManagedFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listManagedFoldersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MANAGED_FOLDERS_PAGE_STR_FACT);
            this.createAnywhereCacheSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAnywhereCacheOperationSettings = OperationCallSettings.newBuilder();
            this.updateAnywhereCacheSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAnywhereCacheOperationSettings = OperationCallSettings.newBuilder();
            this.disableAnywhereCacheSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pauseAnywhereCacheSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeAnywhereCacheSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAnywhereCacheSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAnywhereCachesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ANYWHERE_CACHES_PAGE_STR_FACT);
            this.getProjectIntelligenceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProjectIntelligenceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFolderIntelligenceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFolderIntelligenceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getOrganizationIntelligenceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOrganizationIntelligenceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFolderSettings, this.deleteFolderSettings, this.getFolderSettings, this.listFoldersSettings, this.renameFolderSettings, this.getStorageLayoutSettings, this.createManagedFolderSettings, this.deleteManagedFolderSettings, this.getManagedFolderSettings, this.listManagedFoldersSettings, this.createAnywhereCacheSettings, this.updateAnywhereCacheSettings, (Object[])new UnaryCallSettings.Builder[]{this.disableAnywhereCacheSettings, this.pauseAnywhereCacheSettings, this.resumeAnywhereCacheSettings, this.getAnywhereCacheSettings, this.listAnywhereCachesSettings, this.getProjectIntelligenceConfigSettings, this.updateProjectIntelligenceConfigSettings, this.getFolderIntelligenceConfigSettings, this.updateFolderIntelligenceConfigSettings, this.getOrganizationIntelligenceConfigSettings, this.updateOrganizationIntelligenceConfigSettings});
            Builder.initDefaults(this);
        }

        protected Builder(StorageControlStubSettings settings) {
            super((StubSettings)settings);
            this.createFolderSettings = settings.createFolderSettings.toBuilder();
            this.deleteFolderSettings = settings.deleteFolderSettings.toBuilder();
            this.getFolderSettings = settings.getFolderSettings.toBuilder();
            this.listFoldersSettings = settings.listFoldersSettings.toBuilder();
            this.renameFolderSettings = settings.renameFolderSettings.toBuilder();
            this.renameFolderOperationSettings = settings.renameFolderOperationSettings.toBuilder();
            this.getStorageLayoutSettings = settings.getStorageLayoutSettings.toBuilder();
            this.createManagedFolderSettings = settings.createManagedFolderSettings.toBuilder();
            this.deleteManagedFolderSettings = settings.deleteManagedFolderSettings.toBuilder();
            this.getManagedFolderSettings = settings.getManagedFolderSettings.toBuilder();
            this.listManagedFoldersSettings = settings.listManagedFoldersSettings.toBuilder();
            this.createAnywhereCacheSettings = settings.createAnywhereCacheSettings.toBuilder();
            this.createAnywhereCacheOperationSettings = settings.createAnywhereCacheOperationSettings.toBuilder();
            this.updateAnywhereCacheSettings = settings.updateAnywhereCacheSettings.toBuilder();
            this.updateAnywhereCacheOperationSettings = settings.updateAnywhereCacheOperationSettings.toBuilder();
            this.disableAnywhereCacheSettings = settings.disableAnywhereCacheSettings.toBuilder();
            this.pauseAnywhereCacheSettings = settings.pauseAnywhereCacheSettings.toBuilder();
            this.resumeAnywhereCacheSettings = settings.resumeAnywhereCacheSettings.toBuilder();
            this.getAnywhereCacheSettings = settings.getAnywhereCacheSettings.toBuilder();
            this.listAnywhereCachesSettings = settings.listAnywhereCachesSettings.toBuilder();
            this.getProjectIntelligenceConfigSettings = settings.getProjectIntelligenceConfigSettings.toBuilder();
            this.updateProjectIntelligenceConfigSettings = settings.updateProjectIntelligenceConfigSettings.toBuilder();
            this.getFolderIntelligenceConfigSettings = settings.getFolderIntelligenceConfigSettings.toBuilder();
            this.updateFolderIntelligenceConfigSettings = settings.updateFolderIntelligenceConfigSettings.toBuilder();
            this.getOrganizationIntelligenceConfigSettings = settings.getOrganizationIntelligenceConfigSettings.toBuilder();
            this.updateOrganizationIntelligenceConfigSettings = settings.updateOrganizationIntelligenceConfigSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFolderSettings, this.deleteFolderSettings, this.getFolderSettings, this.listFoldersSettings, this.renameFolderSettings, this.getStorageLayoutSettings, this.createManagedFolderSettings, this.deleteManagedFolderSettings, this.getManagedFolderSettings, this.listManagedFoldersSettings, this.createAnywhereCacheSettings, this.updateAnywhereCacheSettings, (Object[])new UnaryCallSettings.Builder[]{this.disableAnywhereCacheSettings, this.pauseAnywhereCacheSettings, this.resumeAnywhereCacheSettings, this.getAnywhereCacheSettings, this.listAnywhereCachesSettings, this.getProjectIntelligenceConfigSettings, this.updateProjectIntelligenceConfigSettings, this.getFolderIntelligenceConfigSettings, this.updateFolderIntelligenceConfigSettings, this.getOrganizationIntelligenceConfigSettings, this.updateOrganizationIntelligenceConfigSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StorageControlStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StorageControlStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StorageControlStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StorageControlStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)StorageControlStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)StorageControlStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StorageControlStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StorageControlStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listFoldersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.renameFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getStorageLayoutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createManagedFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteManagedFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getManagedFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listManagedFoldersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAnywhereCacheSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateAnywhereCacheSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.disableAnywhereCacheSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.pauseAnywhereCacheSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.resumeAnywhereCacheSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAnywhereCacheSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAnywhereCachesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getProjectIntelligenceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateProjectIntelligenceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFolderIntelligenceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateFolderIntelligenceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getOrganizationIntelligenceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateOrganizationIntelligenceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.renameFolderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Folder.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RenameFolderMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createAnywhereCacheOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AnywhereCache.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateAnywhereCacheMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateAnywhereCacheOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AnywhereCache.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateAnywhereCacheMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateFolderRequest, Folder> createFolderSettings() {
            return this.createFolderSettings;
        }

        public UnaryCallSettings.Builder<DeleteFolderRequest, Empty> deleteFolderSettings() {
            return this.deleteFolderSettings;
        }

        public UnaryCallSettings.Builder<GetFolderRequest, Folder> getFolderSettings() {
            return this.getFolderSettings;
        }

        public PagedCallSettings.Builder<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> listFoldersSettings() {
            return this.listFoldersSettings;
        }

        public UnaryCallSettings.Builder<RenameFolderRequest, Operation> renameFolderSettings() {
            return this.renameFolderSettings;
        }

        public OperationCallSettings.Builder<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationSettings() {
            return this.renameFolderOperationSettings;
        }

        public UnaryCallSettings.Builder<GetStorageLayoutRequest, StorageLayout> getStorageLayoutSettings() {
            return this.getStorageLayoutSettings;
        }

        public UnaryCallSettings.Builder<CreateManagedFolderRequest, ManagedFolder> createManagedFolderSettings() {
            return this.createManagedFolderSettings;
        }

        public UnaryCallSettings.Builder<DeleteManagedFolderRequest, Empty> deleteManagedFolderSettings() {
            return this.deleteManagedFolderSettings;
        }

        public UnaryCallSettings.Builder<GetManagedFolderRequest, ManagedFolder> getManagedFolderSettings() {
            return this.getManagedFolderSettings;
        }

        public PagedCallSettings.Builder<ListManagedFoldersRequest, ListManagedFoldersResponse, StorageControlClient.ListManagedFoldersPagedResponse> listManagedFoldersSettings() {
            return this.listManagedFoldersSettings;
        }

        public UnaryCallSettings.Builder<CreateAnywhereCacheRequest, Operation> createAnywhereCacheSettings() {
            return this.createAnywhereCacheSettings;
        }

        public OperationCallSettings.Builder<CreateAnywhereCacheRequest, AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheOperationSettings() {
            return this.createAnywhereCacheOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAnywhereCacheRequest, Operation> updateAnywhereCacheSettings() {
            return this.updateAnywhereCacheSettings;
        }

        public OperationCallSettings.Builder<UpdateAnywhereCacheRequest, AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheOperationSettings() {
            return this.updateAnywhereCacheOperationSettings;
        }

        public UnaryCallSettings.Builder<DisableAnywhereCacheRequest, AnywhereCache> disableAnywhereCacheSettings() {
            return this.disableAnywhereCacheSettings;
        }

        public UnaryCallSettings.Builder<PauseAnywhereCacheRequest, AnywhereCache> pauseAnywhereCacheSettings() {
            return this.pauseAnywhereCacheSettings;
        }

        public UnaryCallSettings.Builder<ResumeAnywhereCacheRequest, AnywhereCache> resumeAnywhereCacheSettings() {
            return this.resumeAnywhereCacheSettings;
        }

        public UnaryCallSettings.Builder<GetAnywhereCacheRequest, AnywhereCache> getAnywhereCacheSettings() {
            return this.getAnywhereCacheSettings;
        }

        public PagedCallSettings.Builder<ListAnywhereCachesRequest, ListAnywhereCachesResponse, StorageControlClient.ListAnywhereCachesPagedResponse> listAnywhereCachesSettings() {
            return this.listAnywhereCachesSettings;
        }

        public UnaryCallSettings.Builder<GetProjectIntelligenceConfigRequest, IntelligenceConfig> getProjectIntelligenceConfigSettings() {
            return this.getProjectIntelligenceConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateProjectIntelligenceConfigRequest, IntelligenceConfig> updateProjectIntelligenceConfigSettings() {
            return this.updateProjectIntelligenceConfigSettings;
        }

        public UnaryCallSettings.Builder<GetFolderIntelligenceConfigRequest, IntelligenceConfig> getFolderIntelligenceConfigSettings() {
            return this.getFolderIntelligenceConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateFolderIntelligenceConfigRequest, IntelligenceConfig> updateFolderIntelligenceConfigSettings() {
            return this.updateFolderIntelligenceConfigSettings;
        }

        public UnaryCallSettings.Builder<GetOrganizationIntelligenceConfigRequest, IntelligenceConfig> getOrganizationIntelligenceConfigSettings() {
            return this.getOrganizationIntelligenceConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateOrganizationIntelligenceConfigRequest, IntelligenceConfig> updateOrganizationIntelligenceConfigSettings() {
            return this.updateOrganizationIntelligenceConfigSettings;
        }

        public StorageControlStubSettings build() throws IOException {
            return new StorageControlStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNKNOWN})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

