/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.speech.v2.BatchRecognizeRequest;
import com.google.cloud.speech.v2.BatchRecognizeResponse;
import com.google.cloud.speech.v2.Config;
import com.google.cloud.speech.v2.CreateCustomClassRequest;
import com.google.cloud.speech.v2.CreatePhraseSetRequest;
import com.google.cloud.speech.v2.CreateRecognizerRequest;
import com.google.cloud.speech.v2.CustomClass;
import com.google.cloud.speech.v2.DeleteCustomClassRequest;
import com.google.cloud.speech.v2.DeletePhraseSetRequest;
import com.google.cloud.speech.v2.DeleteRecognizerRequest;
import com.google.cloud.speech.v2.GetConfigRequest;
import com.google.cloud.speech.v2.GetCustomClassRequest;
import com.google.cloud.speech.v2.GetPhraseSetRequest;
import com.google.cloud.speech.v2.GetRecognizerRequest;
import com.google.cloud.speech.v2.ListCustomClassesRequest;
import com.google.cloud.speech.v2.ListCustomClassesResponse;
import com.google.cloud.speech.v2.ListPhraseSetsRequest;
import com.google.cloud.speech.v2.ListPhraseSetsResponse;
import com.google.cloud.speech.v2.ListRecognizersRequest;
import com.google.cloud.speech.v2.ListRecognizersResponse;
import com.google.cloud.speech.v2.OperationMetadata;
import com.google.cloud.speech.v2.PhraseSet;
import com.google.cloud.speech.v2.RecognizeRequest;
import com.google.cloud.speech.v2.RecognizeResponse;
import com.google.cloud.speech.v2.Recognizer;
import com.google.cloud.speech.v2.SpeechClient;
import com.google.cloud.speech.v2.StreamingRecognizeRequest;
import com.google.cloud.speech.v2.StreamingRecognizeResponse;
import com.google.cloud.speech.v2.UndeleteCustomClassRequest;
import com.google.cloud.speech.v2.UndeletePhraseSetRequest;
import com.google.cloud.speech.v2.UndeleteRecognizerRequest;
import com.google.cloud.speech.v2.UpdateConfigRequest;
import com.google.cloud.speech.v2.UpdateCustomClassRequest;
import com.google.cloud.speech.v2.UpdatePhraseSetRequest;
import com.google.cloud.speech.v2.UpdateRecognizerRequest;
import com.google.cloud.speech.v2.stub.GrpcSpeechCallableFactory;
import com.google.cloud.speech.v2.stub.SpeechStub;
import com.google.cloud.speech.v2.stub.SpeechStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSpeechStub
extends SpeechStub {
    private static final MethodDescriptor<CreateRecognizerRequest, Operation> createRecognizerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/CreateRecognizer").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateRecognizerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListRecognizersRequest, ListRecognizersResponse> listRecognizersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/ListRecognizers").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRecognizersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRecognizersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetRecognizerRequest, Recognizer> getRecognizerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/GetRecognizer").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRecognizerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Recognizer.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateRecognizerRequest, Operation> updateRecognizerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/UpdateRecognizer").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateRecognizerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteRecognizerRequest, Operation> deleteRecognizerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/DeleteRecognizer").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRecognizerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UndeleteRecognizerRequest, Operation> undeleteRecognizerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/UndeleteRecognizer").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeleteRecognizerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RecognizeRequest, RecognizeResponse> recognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/Recognize").setRequestMarshaller(ProtoUtils.marshaller((Message)RecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RecognizeResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.speech.v2.Speech/StreamingRecognize").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingRecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingRecognizeResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchRecognizeRequest, Operation> batchRecognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/BatchRecognize").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchRecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetConfigRequest, Config> getConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/GetConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Config.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateConfigRequest, Config> updateConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/UpdateConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Config.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateCustomClassRequest, Operation> createCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/CreateCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/ListCustomClasses").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCustomClassesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCustomClassesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetCustomClassRequest, CustomClass> getCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/GetCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomClass.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateCustomClassRequest, Operation> updateCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/UpdateCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteCustomClassRequest, Operation> deleteCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/DeleteCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UndeleteCustomClassRequest, Operation> undeleteCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/UndeleteCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeleteCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreatePhraseSetRequest, Operation> createPhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/CreatePhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListPhraseSetsRequest, ListPhraseSetsResponse> listPhraseSetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/ListPhraseSets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPhraseSetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPhraseSetsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetPhraseSetRequest, PhraseSet> getPhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/GetPhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PhraseSet.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdatePhraseSetRequest, Operation> updatePhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/UpdatePhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeletePhraseSetRequest, Operation> deletePhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/DeletePhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UndeletePhraseSetRequest, Operation> undeletePhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v2.Speech/UndeletePhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeletePhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateRecognizerRequest, Operation> createRecognizerCallable;
    private final OperationCallable<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationCallable;
    private final UnaryCallable<ListRecognizersRequest, ListRecognizersResponse> listRecognizersCallable;
    private final UnaryCallable<ListRecognizersRequest, SpeechClient.ListRecognizersPagedResponse> listRecognizersPagedCallable;
    private final UnaryCallable<GetRecognizerRequest, Recognizer> getRecognizerCallable;
    private final UnaryCallable<UpdateRecognizerRequest, Operation> updateRecognizerCallable;
    private final OperationCallable<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationCallable;
    private final UnaryCallable<DeleteRecognizerRequest, Operation> deleteRecognizerCallable;
    private final OperationCallable<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationCallable;
    private final UnaryCallable<UndeleteRecognizerRequest, Operation> undeleteRecognizerCallable;
    private final OperationCallable<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationCallable;
    private final UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable;
    private final BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable;
    private final UnaryCallable<BatchRecognizeRequest, Operation> batchRecognizeCallable;
    private final OperationCallable<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationCallable;
    private final UnaryCallable<GetConfigRequest, Config> getConfigCallable;
    private final UnaryCallable<UpdateConfigRequest, Config> updateConfigCallable;
    private final UnaryCallable<CreateCustomClassRequest, Operation> createCustomClassCallable;
    private final OperationCallable<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationCallable;
    private final UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesCallable;
    private final UnaryCallable<ListCustomClassesRequest, SpeechClient.ListCustomClassesPagedResponse> listCustomClassesPagedCallable;
    private final UnaryCallable<GetCustomClassRequest, CustomClass> getCustomClassCallable;
    private final UnaryCallable<UpdateCustomClassRequest, Operation> updateCustomClassCallable;
    private final OperationCallable<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationCallable;
    private final UnaryCallable<DeleteCustomClassRequest, Operation> deleteCustomClassCallable;
    private final OperationCallable<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationCallable;
    private final UnaryCallable<UndeleteCustomClassRequest, Operation> undeleteCustomClassCallable;
    private final OperationCallable<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationCallable;
    private final UnaryCallable<CreatePhraseSetRequest, Operation> createPhraseSetCallable;
    private final OperationCallable<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationCallable;
    private final UnaryCallable<ListPhraseSetsRequest, ListPhraseSetsResponse> listPhraseSetsCallable;
    private final UnaryCallable<ListPhraseSetsRequest, SpeechClient.ListPhraseSetsPagedResponse> listPhraseSetsPagedCallable;
    private final UnaryCallable<GetPhraseSetRequest, PhraseSet> getPhraseSetCallable;
    private final UnaryCallable<UpdatePhraseSetRequest, Operation> updatePhraseSetCallable;
    private final OperationCallable<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationCallable;
    private final UnaryCallable<DeletePhraseSetRequest, Operation> deletePhraseSetCallable;
    private final OperationCallable<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationCallable;
    private final UnaryCallable<UndeletePhraseSetRequest, Operation> undeletePhraseSetCallable;
    private final OperationCallable<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, SpeechClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSpeechStub create(SpeechStubSettings settings) throws IOException {
        return new GrpcSpeechStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSpeechStub create(ClientContext clientContext) throws IOException {
        return new GrpcSpeechStub(SpeechStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSpeechStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSpeechStub(SpeechStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSpeechStub(SpeechStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSpeechCallableFactory());
    }

    protected GrpcSpeechStub(SpeechStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createRecognizerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createRecognizerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listRecognizersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRecognizersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getRecognizerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRecognizerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateRecognizerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateRecognizerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("recognizer.name", String.valueOf(request.getRecognizer().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteRecognizerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRecognizerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings undeleteRecognizerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeleteRecognizerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings recognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(recognizeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("recognizer", String.valueOf(request.getRecognizer()));
            return builder.build();
        }).build();
        GrpcCallSettings streamingRecognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingRecognizeMethodDescriptor).build();
        GrpcCallSettings batchRecognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchRecognizeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("recognizer", String.valueOf(request.getRecognizer()));
            return builder.build();
        }).build();
        GrpcCallSettings getConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("config.name", String.valueOf(request.getConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listCustomClassesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCustomClassesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("custom_class.name", String.valueOf(request.getCustomClass().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings undeleteCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeleteCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listPhraseSetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPhraseSetsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updatePhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("phrase_set.name", String.valueOf(request.getPhraseSet().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings undeletePhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeletePhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createRecognizerCallable = callableFactory.createUnaryCallable(createRecognizerTransportSettings, settings.createRecognizerSettings(), clientContext);
        this.createRecognizerOperationCallable = callableFactory.createOperationCallable(createRecognizerTransportSettings, settings.createRecognizerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listRecognizersCallable = callableFactory.createUnaryCallable(listRecognizersTransportSettings, settings.listRecognizersSettings(), clientContext);
        this.listRecognizersPagedCallable = callableFactory.createPagedCallable(listRecognizersTransportSettings, settings.listRecognizersSettings(), clientContext);
        this.getRecognizerCallable = callableFactory.createUnaryCallable(getRecognizerTransportSettings, settings.getRecognizerSettings(), clientContext);
        this.updateRecognizerCallable = callableFactory.createUnaryCallable(updateRecognizerTransportSettings, settings.updateRecognizerSettings(), clientContext);
        this.updateRecognizerOperationCallable = callableFactory.createOperationCallable(updateRecognizerTransportSettings, settings.updateRecognizerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteRecognizerCallable = callableFactory.createUnaryCallable(deleteRecognizerTransportSettings, settings.deleteRecognizerSettings(), clientContext);
        this.deleteRecognizerOperationCallable = callableFactory.createOperationCallable(deleteRecognizerTransportSettings, settings.deleteRecognizerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeleteRecognizerCallable = callableFactory.createUnaryCallable(undeleteRecognizerTransportSettings, settings.undeleteRecognizerSettings(), clientContext);
        this.undeleteRecognizerOperationCallable = callableFactory.createOperationCallable(undeleteRecognizerTransportSettings, settings.undeleteRecognizerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.recognizeCallable = callableFactory.createUnaryCallable(recognizeTransportSettings, settings.recognizeSettings(), clientContext);
        this.streamingRecognizeCallable = callableFactory.createBidiStreamingCallable(streamingRecognizeTransportSettings, settings.streamingRecognizeSettings(), clientContext);
        this.batchRecognizeCallable = callableFactory.createUnaryCallable(batchRecognizeTransportSettings, settings.batchRecognizeSettings(), clientContext);
        this.batchRecognizeOperationCallable = callableFactory.createOperationCallable(batchRecognizeTransportSettings, settings.batchRecognizeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getConfigCallable = callableFactory.createUnaryCallable(getConfigTransportSettings, settings.getConfigSettings(), clientContext);
        this.updateConfigCallable = callableFactory.createUnaryCallable(updateConfigTransportSettings, settings.updateConfigSettings(), clientContext);
        this.createCustomClassCallable = callableFactory.createUnaryCallable(createCustomClassTransportSettings, settings.createCustomClassSettings(), clientContext);
        this.createCustomClassOperationCallable = callableFactory.createOperationCallable(createCustomClassTransportSettings, settings.createCustomClassOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listCustomClassesCallable = callableFactory.createUnaryCallable(listCustomClassesTransportSettings, settings.listCustomClassesSettings(), clientContext);
        this.listCustomClassesPagedCallable = callableFactory.createPagedCallable(listCustomClassesTransportSettings, settings.listCustomClassesSettings(), clientContext);
        this.getCustomClassCallable = callableFactory.createUnaryCallable(getCustomClassTransportSettings, settings.getCustomClassSettings(), clientContext);
        this.updateCustomClassCallable = callableFactory.createUnaryCallable(updateCustomClassTransportSettings, settings.updateCustomClassSettings(), clientContext);
        this.updateCustomClassOperationCallable = callableFactory.createOperationCallable(updateCustomClassTransportSettings, settings.updateCustomClassOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteCustomClassCallable = callableFactory.createUnaryCallable(deleteCustomClassTransportSettings, settings.deleteCustomClassSettings(), clientContext);
        this.deleteCustomClassOperationCallable = callableFactory.createOperationCallable(deleteCustomClassTransportSettings, settings.deleteCustomClassOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeleteCustomClassCallable = callableFactory.createUnaryCallable(undeleteCustomClassTransportSettings, settings.undeleteCustomClassSettings(), clientContext);
        this.undeleteCustomClassOperationCallable = callableFactory.createOperationCallable(undeleteCustomClassTransportSettings, settings.undeleteCustomClassOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createPhraseSetCallable = callableFactory.createUnaryCallable(createPhraseSetTransportSettings, settings.createPhraseSetSettings(), clientContext);
        this.createPhraseSetOperationCallable = callableFactory.createOperationCallable(createPhraseSetTransportSettings, settings.createPhraseSetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listPhraseSetsCallable = callableFactory.createUnaryCallable(listPhraseSetsTransportSettings, settings.listPhraseSetsSettings(), clientContext);
        this.listPhraseSetsPagedCallable = callableFactory.createPagedCallable(listPhraseSetsTransportSettings, settings.listPhraseSetsSettings(), clientContext);
        this.getPhraseSetCallable = callableFactory.createUnaryCallable(getPhraseSetTransportSettings, settings.getPhraseSetSettings(), clientContext);
        this.updatePhraseSetCallable = callableFactory.createUnaryCallable(updatePhraseSetTransportSettings, settings.updatePhraseSetSettings(), clientContext);
        this.updatePhraseSetOperationCallable = callableFactory.createOperationCallable(updatePhraseSetTransportSettings, settings.updatePhraseSetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deletePhraseSetCallable = callableFactory.createUnaryCallable(deletePhraseSetTransportSettings, settings.deletePhraseSetSettings(), clientContext);
        this.deletePhraseSetOperationCallable = callableFactory.createOperationCallable(deletePhraseSetTransportSettings, settings.deletePhraseSetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeletePhraseSetCallable = callableFactory.createUnaryCallable(undeletePhraseSetTransportSettings, settings.undeletePhraseSetSettings(), clientContext);
        this.undeletePhraseSetOperationCallable = callableFactory.createOperationCallable(undeletePhraseSetTransportSettings, settings.undeletePhraseSetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateRecognizerRequest, Operation> createRecognizerCallable() {
        return this.createRecognizerCallable;
    }

    @Override
    public OperationCallable<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationCallable() {
        return this.createRecognizerOperationCallable;
    }

    @Override
    public UnaryCallable<ListRecognizersRequest, ListRecognizersResponse> listRecognizersCallable() {
        return this.listRecognizersCallable;
    }

    @Override
    public UnaryCallable<ListRecognizersRequest, SpeechClient.ListRecognizersPagedResponse> listRecognizersPagedCallable() {
        return this.listRecognizersPagedCallable;
    }

    @Override
    public UnaryCallable<GetRecognizerRequest, Recognizer> getRecognizerCallable() {
        return this.getRecognizerCallable;
    }

    @Override
    public UnaryCallable<UpdateRecognizerRequest, Operation> updateRecognizerCallable() {
        return this.updateRecognizerCallable;
    }

    @Override
    public OperationCallable<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationCallable() {
        return this.updateRecognizerOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteRecognizerRequest, Operation> deleteRecognizerCallable() {
        return this.deleteRecognizerCallable;
    }

    @Override
    public OperationCallable<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationCallable() {
        return this.deleteRecognizerOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteRecognizerRequest, Operation> undeleteRecognizerCallable() {
        return this.undeleteRecognizerCallable;
    }

    @Override
    public OperationCallable<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationCallable() {
        return this.undeleteRecognizerOperationCallable;
    }

    @Override
    public UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable() {
        return this.recognizeCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.streamingRecognizeCallable;
    }

    @Override
    public UnaryCallable<BatchRecognizeRequest, Operation> batchRecognizeCallable() {
        return this.batchRecognizeCallable;
    }

    @Override
    public OperationCallable<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationCallable() {
        return this.batchRecognizeOperationCallable;
    }

    @Override
    public UnaryCallable<GetConfigRequest, Config> getConfigCallable() {
        return this.getConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateConfigRequest, Config> updateConfigCallable() {
        return this.updateConfigCallable;
    }

    @Override
    public UnaryCallable<CreateCustomClassRequest, Operation> createCustomClassCallable() {
        return this.createCustomClassCallable;
    }

    @Override
    public OperationCallable<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationCallable() {
        return this.createCustomClassOperationCallable;
    }

    @Override
    public UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesCallable() {
        return this.listCustomClassesCallable;
    }

    @Override
    public UnaryCallable<ListCustomClassesRequest, SpeechClient.ListCustomClassesPagedResponse> listCustomClassesPagedCallable() {
        return this.listCustomClassesPagedCallable;
    }

    @Override
    public UnaryCallable<GetCustomClassRequest, CustomClass> getCustomClassCallable() {
        return this.getCustomClassCallable;
    }

    @Override
    public UnaryCallable<UpdateCustomClassRequest, Operation> updateCustomClassCallable() {
        return this.updateCustomClassCallable;
    }

    @Override
    public OperationCallable<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationCallable() {
        return this.updateCustomClassOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteCustomClassRequest, Operation> deleteCustomClassCallable() {
        return this.deleteCustomClassCallable;
    }

    @Override
    public OperationCallable<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationCallable() {
        return this.deleteCustomClassOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteCustomClassRequest, Operation> undeleteCustomClassCallable() {
        return this.undeleteCustomClassCallable;
    }

    @Override
    public OperationCallable<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationCallable() {
        return this.undeleteCustomClassOperationCallable;
    }

    @Override
    public UnaryCallable<CreatePhraseSetRequest, Operation> createPhraseSetCallable() {
        return this.createPhraseSetCallable;
    }

    @Override
    public OperationCallable<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationCallable() {
        return this.createPhraseSetOperationCallable;
    }

    @Override
    public UnaryCallable<ListPhraseSetsRequest, ListPhraseSetsResponse> listPhraseSetsCallable() {
        return this.listPhraseSetsCallable;
    }

    @Override
    public UnaryCallable<ListPhraseSetsRequest, SpeechClient.ListPhraseSetsPagedResponse> listPhraseSetsPagedCallable() {
        return this.listPhraseSetsPagedCallable;
    }

    @Override
    public UnaryCallable<GetPhraseSetRequest, PhraseSet> getPhraseSetCallable() {
        return this.getPhraseSetCallable;
    }

    @Override
    public UnaryCallable<UpdatePhraseSetRequest, Operation> updatePhraseSetCallable() {
        return this.updatePhraseSetCallable;
    }

    @Override
    public OperationCallable<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationCallable() {
        return this.updatePhraseSetOperationCallable;
    }

    @Override
    public UnaryCallable<DeletePhraseSetRequest, Operation> deletePhraseSetCallable() {
        return this.deletePhraseSetCallable;
    }

    @Override
    public OperationCallable<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationCallable() {
        return this.deletePhraseSetOperationCallable;
    }

    @Override
    public UnaryCallable<UndeletePhraseSetRequest, Operation> undeletePhraseSetCallable() {
        return this.undeletePhraseSetCallable;
    }

    @Override
    public OperationCallable<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationCallable() {
        return this.undeletePhraseSetOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, SpeechClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

