/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1.LongRunningRecognizeMetadata;
import com.google.cloud.speech.v1.LongRunningRecognizeRequest;
import com.google.cloud.speech.v1.LongRunningRecognizeResponse;
import com.google.cloud.speech.v1.RecognizeRequest;
import com.google.cloud.speech.v1.RecognizeResponse;
import com.google.cloud.speech.v1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1.stub.GrpcSpeechCallableFactory;
import com.google.cloud.speech.v1.stub.SpeechStub;
import com.google.cloud.speech.v1.stub.SpeechStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSpeechStub
extends SpeechStub {
    private static final MethodDescriptor<RecognizeRequest, RecognizeResponse> recognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Speech/Recognize").setRequestMarshaller(ProtoUtils.marshaller((Message)RecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RecognizeResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<LongRunningRecognizeRequest, Operation> longRunningRecognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Speech/LongRunningRecognize").setRequestMarshaller(ProtoUtils.marshaller((Message)LongRunningRecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.speech.v1.Speech/StreamingRecognize").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingRecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingRecognizeResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable;
    private final UnaryCallable<LongRunningRecognizeRequest, Operation> longRunningRecognizeCallable;
    private final OperationCallable<LongRunningRecognizeRequest, LongRunningRecognizeResponse, LongRunningRecognizeMetadata> longRunningRecognizeOperationCallable;
    private final BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSpeechStub create(SpeechStubSettings settings) throws IOException {
        return new GrpcSpeechStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSpeechStub create(ClientContext clientContext) throws IOException {
        return new GrpcSpeechStub(SpeechStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSpeechStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSpeechStub(SpeechStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSpeechStub(SpeechStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSpeechCallableFactory());
    }

    protected GrpcSpeechStub(SpeechStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings recognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(recognizeMethodDescriptor).build();
        GrpcCallSettings longRunningRecognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(longRunningRecognizeMethodDescriptor).build();
        GrpcCallSettings streamingRecognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingRecognizeMethodDescriptor).build();
        this.recognizeCallable = callableFactory.createUnaryCallable(recognizeTransportSettings, settings.recognizeSettings(), clientContext);
        this.longRunningRecognizeCallable = callableFactory.createUnaryCallable(longRunningRecognizeTransportSettings, settings.longRunningRecognizeSettings(), clientContext);
        this.longRunningRecognizeOperationCallable = callableFactory.createOperationCallable(longRunningRecognizeTransportSettings, settings.longRunningRecognizeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.streamingRecognizeCallable = callableFactory.createBidiStreamingCallable(streamingRecognizeTransportSettings, settings.streamingRecognizeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable() {
        return this.recognizeCallable;
    }

    @Override
    public UnaryCallable<LongRunningRecognizeRequest, Operation> longRunningRecognizeCallable() {
        return this.longRunningRecognizeCallable;
    }

    @Override
    public OperationCallable<LongRunningRecognizeRequest, LongRunningRecognizeResponse, LongRunningRecognizeMetadata> longRunningRecognizeOperationCallable() {
        return this.longRunningRecognizeOperationCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.streamingRecognizeCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

