/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.spi.v1beta1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.FixedChannelProvider;
import com.google.api.gax.grpc.FixedExecutorProvider;
import com.google.api.gax.grpc.OperationCallable;
import com.google.api.gax.grpc.OperationFuture;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.StreamingCallable;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.speech.spi.v1beta1.SpeechSettings;
import com.google.cloud.speech.v1beta1.AsyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.AsyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.RecognitionAudio;
import com.google.cloud.speech.v1beta1.RecognitionConfig;
import com.google.cloud.speech.v1beta1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1beta1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1beta1.SyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SyncRecognizeResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.OperationsSettings;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class SpeechClient
implements AutoCloseable {
    private final SpeechSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final OperationsClient operationsClient;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable;
    private final UnaryCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable;
    private final OperationCallable<AsyncRecognizeRequest, AsyncRecognizeResponse> asyncRecognizeOperationCallable;
    private final StreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable;

    public static final SpeechClient create() throws IOException {
        return SpeechClient.create(SpeechSettings.defaultBuilder().build());
    }

    public static final SpeechClient create(SpeechSettings settings) throws IOException {
        return new SpeechClient(settings);
    }

    protected SpeechClient(SpeechSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        FixedExecutorProvider executorProvider = FixedExecutorProvider.create((ScheduledExecutorService)this.executor);
        FixedChannelProvider channelProvider = FixedChannelProvider.create((ManagedChannel)this.channel);
        OperationsSettings operationsSettings = OperationsSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)executorProvider).setChannelProvider((ChannelProvider)channelProvider).build();
        this.operationsClient = OperationsClient.create((OperationsSettings)operationsSettings);
        this.syncRecognizeCallable = UnaryCallable.create(settings.syncRecognizeSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.asyncRecognizeCallable = UnaryCallable.create((SimpleCallSettings)settings.asyncRecognizeSettings().getInitialCallSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.asyncRecognizeOperationCallable = OperationCallable.create(settings.asyncRecognizeSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor, (OperationsClient)this.operationsClient);
        this.streamingRecognizeCallable = StreamingCallable.create(settings.streamingRecognizeSettings(), (Channel)this.channel);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SpeechClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SpeechClient.this.executor.shutdown();
                }
            });
        }
    }

    public final SpeechSettings getSettings() {
        return this.settings;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final SyncRecognizeResponse syncRecognize(RecognitionConfig config, RecognitionAudio audio) {
        SyncRecognizeRequest request = SyncRecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.syncRecognize(request);
    }

    public final SyncRecognizeResponse syncRecognize(SyncRecognizeRequest request) {
        return (SyncRecognizeResponse)this.syncRecognizeCallable().call((Object)request);
    }

    public final UnaryCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable() {
        return this.syncRecognizeCallable;
    }

    public final OperationFuture<AsyncRecognizeResponse> asyncRecognizeAsync(RecognitionConfig config, RecognitionAudio audio) {
        AsyncRecognizeRequest request = AsyncRecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.asyncRecognizeAsync(request);
    }

    public final OperationFuture<AsyncRecognizeResponse> asyncRecognizeAsync(AsyncRecognizeRequest request) {
        return this.asyncRecognizeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AsyncRecognizeRequest, AsyncRecognizeResponse> asyncRecognizeOperationCallable() {
        return this.asyncRecognizeOperationCallable;
    }

    public final UnaryCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable() {
        return this.asyncRecognizeCallable;
    }

    public final StreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.streamingRecognizeCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

