/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1beta1.AsyncRecognizeMetadata;
import com.google.cloud.speech.v1beta1.AsyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.AsyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.SpeechSettings;
import com.google.cloud.speech.v1beta1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1beta1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1beta1.SyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.stub.SpeechStub;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcSpeechStub
extends SpeechStub {
    private static final MethodDescriptor<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1beta1.Speech/SyncRecognize").setRequestMarshaller(ProtoUtils.marshaller((Message)SyncRecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SyncRecognizeResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AsyncRecognizeRequest, Operation> asyncRecognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1beta1.Speech/AsyncRecognize").setRequestMarshaller(ProtoUtils.marshaller((Message)AsyncRecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.speech.v1beta1.Speech/StreamingRecognize").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingRecognizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingRecognizeResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final UnaryCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable;
    private final UnaryCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable;
    private final OperationCallable<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeOperationCallable;
    private final BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable;

    public static final GrpcSpeechStub create(SpeechSettings settings) throws IOException {
        return new GrpcSpeechStub(settings, ClientContext.create((ClientSettings)settings));
    }

    public static final GrpcSpeechStub create(ClientContext clientContext) throws IOException {
        return new GrpcSpeechStub(SpeechSettings.newBuilder().build(), clientContext);
    }

    protected GrpcSpeechStub(SpeechSettings settings, ClientContext clientContext) throws IOException {
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext);
        GrpcCallSettings syncRecognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(syncRecognizeMethodDescriptor).build();
        GrpcCallSettings asyncRecognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(asyncRecognizeMethodDescriptor).build();
        GrpcCallSettings streamingRecognizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingRecognizeMethodDescriptor).build();
        this.syncRecognizeCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)syncRecognizeTransportSettings, settings.syncRecognizeSettings(), (ClientContext)clientContext);
        this.asyncRecognizeCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)asyncRecognizeTransportSettings, settings.asyncRecognizeSettings(), (ClientContext)clientContext);
        this.asyncRecognizeOperationCallable = GrpcCallableFactory.createOperationCallable((GrpcCallSettings)asyncRecognizeTransportSettings, settings.asyncRecognizeOperationSettings(), (ClientContext)clientContext, (OperationsStub)this.operationsStub);
        this.streamingRecognizeCallable = GrpcCallableFactory.createBidiStreamingCallable((GrpcCallSettings)streamingRecognizeTransportSettings, settings.streamingRecognizeSettings(), (ClientContext)clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable() {
        return this.syncRecognizeCallable;
    }

    @Override
    public OperationCallable<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeOperationCallable() {
        return this.asyncRecognizeOperationCallable;
    }

    @Override
    public UnaryCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable() {
        return this.asyncRecognizeCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.streamingRecognizeCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

