/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1beta1.AsyncRecognizeMetadata;
import com.google.cloud.speech.v1beta1.AsyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.AsyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.SpeechSettings;
import com.google.cloud.speech.v1beta1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1beta1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1beta1.SyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.stub.SpeechStub;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSpeechStub
extends SpeechStub {
    private static final UnaryCallable<SyncRecognizeRequest, SyncRecognizeResponse> directSyncRecognizeCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.speech.v1beta1.Speech/SyncRecognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)SyncRecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)SyncRecognizeResponse.getDefaultInstance())));
    private static final UnaryCallable<AsyncRecognizeRequest, Operation> directAsyncRecognizeCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.speech.v1beta1.Speech/AsyncRecognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AsyncRecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Operation.getDefaultInstance())));
    private static final BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> directStreamingRecognizeCallable = GrpcCallableFactory.createDirectBidiStreamingCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)"google.cloud.speech.v1beta1.Speech/StreamingRecognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingRecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingRecognizeResponse.getDefaultInstance())));
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final UnaryCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable;
    private final UnaryCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable;
    private final OperationCallable<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata, Operation> asyncRecognizeOperationCallable;
    private final BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable;

    public static final GrpcSpeechStub create(SpeechSettings settings) throws IOException {
        return new GrpcSpeechStub(settings, ClientContext.create((ClientSettings)settings));
    }

    public static final GrpcSpeechStub create(ClientContext clientContext) throws IOException {
        return new GrpcSpeechStub(SpeechSettings.newBuilder().build(), clientContext);
    }

    protected GrpcSpeechStub(SpeechSettings settings, ClientContext clientContext) throws IOException {
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext);
        this.syncRecognizeCallable = GrpcCallableFactory.create(directSyncRecognizeCallable, settings.syncRecognizeSettings(), (ClientContext)clientContext);
        this.asyncRecognizeCallable = GrpcCallableFactory.create(directAsyncRecognizeCallable, (SimpleCallSettings)settings.asyncRecognizeSettings().getInitialCallSettings(), (ClientContext)clientContext);
        this.asyncRecognizeOperationCallable = GrpcCallableFactory.create(directAsyncRecognizeCallable, settings.asyncRecognizeSettings(), (ClientContext)clientContext, (OperationsStub)this.operationsStub);
        this.streamingRecognizeCallable = GrpcCallableFactory.create(directStreamingRecognizeCallable, settings.streamingRecognizeSettings(), (ClientContext)clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable() {
        return this.syncRecognizeCallable;
    }

    @Override
    public OperationCallable<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata, Operation> asyncRecognizeOperationCallable() {
        return this.asyncRecognizeOperationCallable;
    }

    @Override
    public UnaryCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable() {
        return this.asyncRecognizeCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.streamingRecognizeCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

