/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1.LongRunningRecognizeMetadata;
import com.google.cloud.speech.v1.LongRunningRecognizeRequest;
import com.google.cloud.speech.v1.LongRunningRecognizeResponse;
import com.google.cloud.speech.v1.RecognizeRequest;
import com.google.cloud.speech.v1.RecognizeResponse;
import com.google.cloud.speech.v1.SpeechSettings;
import com.google.cloud.speech.v1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1.stub.SpeechStub;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSpeechStub
extends SpeechStub {
    private static final UnaryCallable<RecognizeRequest, RecognizeResponse> directRecognizeCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.speech.v1.Speech/Recognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)RecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)RecognizeResponse.getDefaultInstance())));
    private static final UnaryCallable<LongRunningRecognizeRequest, Operation> directLongRunningRecognizeCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.speech.v1.Speech/LongRunningRecognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)LongRunningRecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Operation.getDefaultInstance())));
    private static final StreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> directStreamingRecognizeCallable = GrpcCallableFactory.createDirectStreamingCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)"google.cloud.speech.v1.Speech/StreamingRecognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingRecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingRecognizeResponse.getDefaultInstance())));
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable;
    private final UnaryCallable<LongRunningRecognizeRequest, Operation> longRunningRecognizeCallable;
    private final OperationCallable<LongRunningRecognizeRequest, LongRunningRecognizeResponse, LongRunningRecognizeMetadata, Operation> longRunningRecognizeOperationCallable;
    private final StreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable;

    public static final GrpcSpeechStub create(SpeechSettings settings) throws IOException {
        return new GrpcSpeechStub(settings, ClientContext.create((ClientSettings)settings));
    }

    public static final GrpcSpeechStub create(ClientContext clientContext) throws IOException {
        return new GrpcSpeechStub(SpeechSettings.defaultBuilder().build(), clientContext);
    }

    protected GrpcSpeechStub(SpeechSettings settings, ClientContext clientContext) throws IOException {
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext);
        this.recognizeCallable = GrpcCallableFactory.create(directRecognizeCallable, settings.recognizeSettings(), (ClientContext)clientContext);
        this.longRunningRecognizeCallable = GrpcCallableFactory.create(directLongRunningRecognizeCallable, (SimpleCallSettings)settings.longRunningRecognizeSettings().getInitialCallSettings(), (ClientContext)clientContext);
        this.longRunningRecognizeOperationCallable = GrpcCallableFactory.create(directLongRunningRecognizeCallable, settings.longRunningRecognizeSettings(), (ClientContext)clientContext, (OperationsStub)this.operationsStub);
        this.streamingRecognizeCallable = GrpcCallableFactory.create(directStreamingRecognizeCallable, settings.streamingRecognizeSettings(), (ClientContext)clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable() {
        return this.recognizeCallable;
    }

    @Override
    public OperationCallable<LongRunningRecognizeRequest, LongRunningRecognizeResponse, LongRunningRecognizeMetadata, Operation> longRunningRecognizeOperationCallable() {
        return this.longRunningRecognizeOperationCallable;
    }

    @Override
    public UnaryCallable<LongRunningRecognizeRequest, Operation> longRunningRecognizeCallable() {
        return this.longRunningRecognizeCallable;
    }

    @Override
    public StreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.streamingRecognizeCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

