/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.spi.v1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.OperationCallSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.StreamingCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.cloud.speech.v1beta1.AsyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.AsyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.SpeechGrpc;
import com.google.cloud.speech.v1beta1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1beta1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1beta1.SyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SyncRecognizeResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;
import org.joda.time.Duration;

public class SpeechSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/speech/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final SimpleCallSettings<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings;
    private final OperationCallSettings<AsyncRecognizeRequest, AsyncRecognizeResponse> asyncRecognizeSettings;
    private final StreamingCallSettings<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings;

    public SimpleCallSettings<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings() {
        return this.syncRecognizeSettings;
    }

    public OperationCallSettings<AsyncRecognizeRequest, AsyncRecognizeResponse> asyncRecognizeSettings() {
        return this.asyncRecognizeSettings;
    }

    public StreamingCallSettings<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings() {
        return this.streamingRecognizeSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "speech.googleapis.com:443";
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(SpeechSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, SpeechSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)SpeechSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(SpeechSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SpeechSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.syncRecognizeSettings = settingsBuilder.syncRecognizeSettings().build();
        this.asyncRecognizeSettings = settingsBuilder.asyncRecognizeSettings().build();
        this.streamingRecognizeSettings = settingsBuilder.streamingRecognizeSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings;
        private final OperationCallSettings.Builder<AsyncRecognizeRequest, AsyncRecognizeResponse> asyncRecognizeSettings;
        private final StreamingCallSettings.Builder<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(SpeechSettings.defaultChannelProviderBuilder().build());
            this.syncRecognizeSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SpeechGrpc.METHOD_SYNC_RECOGNIZE);
            this.asyncRecognizeSettings = OperationCallSettings.newBuilder((MethodDescriptor)SpeechGrpc.METHOD_ASYNC_RECOGNIZE, AsyncRecognizeResponse.class);
            this.streamingRecognizeSettings = StreamingCallSettings.newBuilder((MethodDescriptor)SpeechGrpc.METHOD_STREAMING_RECOGNIZE);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.syncRecognizeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.syncRecognizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.asyncRecognizeSettings().getInitialCallSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(SpeechSettings settings) {
            super((ClientSettings)settings);
            this.syncRecognizeSettings = settings.syncRecognizeSettings.toBuilder();
            this.asyncRecognizeSettings = settings.asyncRecognizeSettings.toBuilder();
            this.streamingRecognizeSettings = settings.streamingRecognizeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.syncRecognizeSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings() {
            return this.syncRecognizeSettings;
        }

        public OperationCallSettings.Builder<AsyncRecognizeRequest, AsyncRecognizeResponse> asyncRecognizeSettings() {
            return this.asyncRecognizeSettings;
        }

        public StreamingCallSettings.Builder<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings() {
            return this.streamingRecognizeSettings;
        }

        public SpeechSettings build() throws IOException {
            return new SpeechSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)190000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)190000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

