/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import io.grpc.Metadata;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SpannerMetadataProvider {
    private final Cache<String, Map<String, List<String>>> extraHeadersCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final Map<Metadata.Key<String>, String> headers;
    private final String resourceHeaderKey;
    private static final String ROUTE_TO_LEADER_HEADER_KEY = "x-goog-spanner-route-to-leader";
    private static final String END_TO_END_TRACING_HEADER_KEY = "x-goog-spanner-end-to-end-tracing";
    private static final String AFE_SERVER_TIMING_HEADER_KEY = "x-goog-spanner-enable-afe-server-timing";
    private static final Pattern[] RESOURCE_TOKEN_PATTERNS = new Pattern[]{Pattern.compile("^(?<headerValue>projects/[^/]*/instances/[^/]*/databases/[^/]*)(.*)?"), Pattern.compile("^(?<headerValue>projects/[^/]*/instances/[^/]*)(.*)?")};
    private static final Map<String, List<String>> ROUTE_TO_LEADER_HEADER_MAP = ImmutableMap.of((Object)"x-goog-spanner-route-to-leader", Collections.singletonList("true"));
    private static final Map<String, List<String>> END_TO_END_TRACING_HEADER_MAP = ImmutableMap.of((Object)"x-goog-spanner-end-to-end-tracing", Collections.singletonList("true"));
    private static final Map<String, List<String>> AFE_SERVER_TIMING_HEADER_MAP = ImmutableMap.of((Object)"x-goog-spanner-enable-afe-server-timing", Collections.singletonList("true"));

    private SpannerMetadataProvider(Map<String, String> headers, String resourceHeaderKey) {
        this.resourceHeaderKey = resourceHeaderKey;
        this.headers = this.constructHeadersAsMetadata(headers);
    }

    static SpannerMetadataProvider create(Map<String, String> headers, String resourceHeaderKey) {
        return new SpannerMetadataProvider(headers, resourceHeaderKey);
    }

    Metadata newMetadata(String resourceTokenTemplate, String defaultResourceToken) {
        Metadata metadata = new Metadata();
        for (Map.Entry<Metadata.Key<String>, String> header : this.headers.entrySet()) {
            metadata.put(header.getKey(), (Object)header.getValue());
        }
        metadata.put(Metadata.Key.of((String)this.resourceHeaderKey, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.getResourceHeaderValue(resourceTokenTemplate, defaultResourceToken));
        return metadata;
    }

    Map<String, List<String>> newExtraHeaders(String resourceTokenTemplate, String defaultResourceToken) {
        try {
            return (Map)this.extraHeadersCache.get((Object)((String)MoreObjects.firstNonNull((Object)resourceTokenTemplate, (Object)"")), () -> ImmutableMap.builder().put((Object)this.resourceHeaderKey, Collections.singletonList(this.getResourceHeaderValue(resourceTokenTemplate, defaultResourceToken))).build());
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
        }
    }

    Map<String, List<String>> newRouteToLeaderHeader() {
        return ROUTE_TO_LEADER_HEADER_MAP;
    }

    Map<String, List<String>> newEndToEndTracingHeader() {
        return END_TO_END_TRACING_HEADER_MAP;
    }

    Map<String, List<String>> newAfeServerTimingHeader() {
        return AFE_SERVER_TIMING_HEADER_MAP;
    }

    private Map<Metadata.Key<String>, String> constructHeadersAsMetadata(Map<String, String> headers) {
        ImmutableMap.Builder headersAsMetadataBuilder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            headersAsMetadataBuilder.put((Object)Metadata.Key.of((String)entry.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)entry.getValue());
        }
        return headersAsMetadataBuilder.build();
    }

    private String getResourceHeaderValue(String resourceTokenTemplate, String defaultResourceToken) {
        String resourceToken = defaultResourceToken;
        if (!Strings.isNullOrEmpty((String)resourceTokenTemplate)) {
            for (Pattern pattern : RESOURCE_TOKEN_PATTERNS) {
                Matcher m = pattern.matcher(resourceTokenTemplate);
                if (!m.matches()) continue;
                resourceToken = m.group("headerValue");
                break;
            }
        }
        return resourceToken;
    }
}

