/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

class EncodingInterceptor
implements ClientInterceptor {
    private static final String RESPONSE_ENCODING_KEY_NAME = "x-response-encoding";
    private static final Metadata.Key<String> RESPONSE_ENCODING_KEY = Metadata.Key.of((String)"x-response-encoding", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final String encoding;

    EncodingInterceptor(String encoding) {
        this.encoding = encoding;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(RESPONSE_ENCODING_KEY, (Object)EncodingInterceptor.this.encoding);
                super.start(responseListener, headers);
            }
        };
    }
}

