/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnavailableException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.admin.instance.v1.stub.GrpcInstanceAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import java.time.Duration;

class LocalConnectionChecker {
    LocalConnectionChecker() {
    }

    void checkLocalConnection(ConnectionOptions options) {
        String host;
        String emulatorHost = System.getenv("SPANNER_EMULATOR_HOST");
        String string = host = options.getHost() == null ? emulatorHost : options.getHost();
        if (host.startsWith("https://")) {
            host = host.substring(8);
        }
        if (host.startsWith("http://")) {
            host = host.substring(7);
        }
        if (host != null && host.startsWith("localhost") && options.isUsePlainText()) {
            try {
                InstanceAdminStubSettings.Builder testEmulatorSettings = (InstanceAdminStubSettings.Builder)((InstanceAdminStubSettings.Builder)InstanceAdminStubSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(host).setChannelConfigurator(input -> {
                    input.usePlaintext();
                    return input;
                }).build());
                testEmulatorSettings.listInstanceConfigsSettings().setSimpleTimeoutNoRetriesDuration(Duration.ofSeconds(10L));
                try (GrpcInstanceAdminStub stub = GrpcInstanceAdminStub.create(testEmulatorSettings.build());){
                    stub.listInstanceConfigsCallable().call((Object)ListInstanceConfigsRequest.newBuilder().setParent(String.format("projects/%s", options.getProjectId())).build());
                }
            }
            catch (UnavailableException e) {
                String msg = options.getHost() != null ? String.format("The connection string '%s' contains host '%s', but no running emulator or other server could be found at that address.\nPlease check the connection string and/or that the emulator is running.", options.getUri(), host) : String.format("The environment variable SPANNER_EMULATOR_HOST has been set to '%s', but no running emulator or other server could be found at that address.\nPlease check the environment variable and/or that the emulator is running.", emulatorHost);
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.UNAVAILABLE, msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

