/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ClientSideStatementExecutor;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.spanner.v1.TransactionOptions;
import java.lang.reflect.Method;
import java.util.regex.Matcher;

class ClientSideStatementBeginExecutor
implements ClientSideStatementExecutor {
    private final ClientSideStatementImpl statement;
    private final Method method;
    private final ClientSideStatementValueConverters.IsolationLevelConverter converter;

    ClientSideStatementBeginExecutor(ClientSideStatementImpl statement) throws ClientSideStatementImpl.CompileException {
        try {
            this.statement = statement;
            this.converter = new ClientSideStatementValueConverters.IsolationLevelConverter();
            this.method = ConnectionStatementExecutor.class.getDeclaredMethod(statement.getMethodName(), this.converter.getParameterClass());
        }
        catch (Exception e) {
            throw new ClientSideStatementImpl.CompileException(e, statement);
        }
    }

    @Override
    public StatementResult execute(ConnectionStatementExecutor connection, AbstractStatementParser.ParsedStatement statement) throws Exception {
        return (StatementResult)this.method.invoke((Object)connection, this.getParameterValue(statement.getSql()));
    }

    TransactionOptions.IsolationLevel getParameterValue(String sql) {
        String value;
        Matcher matcher = this.statement.getPattern().matcher(sql);
        if (matcher.find() && matcher.groupCount() >= 1 && (value = matcher.group(1)) != null) {
            TransactionOptions.IsolationLevel res = this.converter.convert(value.trim());
            if (res != null) {
                return res;
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Unknown isolation level: %s", value));
        }
        return null;
    }
}

